/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.util;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.change.impl.ChangeDescriptionImpl;
import org.eclipse.emf.transaction.TransactionChangeDescription;
import org.eclipse.emf.transaction.util.ConditionalRedoCommand;

public class CommandChangeDescription
extends ChangeDescriptionImpl
implements TransactionChangeDescription {
    private boolean isRedone = true;
    private Command command;

    public CommandChangeDescription(Command command) {
        this.command = command;
    }

    public Command chain(Command newCommand) {
        this.command = this.command.chain(newCommand);
        return this.command;
    }

    public boolean canApply() {
        return this.command != null && (this.isRedone ? this.command.canUndo() : this.canRedo(this.command));
    }

    private boolean canRedo(Command cmd) {
        return !(cmd instanceof ConditionalRedoCommand) || ((ConditionalRedoCommand)cmd).canRedo();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void apply() {
        try {
            this.command.undo();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.dispose();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.dispose();
            return;
        }
    }

    public void applyAndReverse() {
        if (this.isRedone) {
            this.command.undo();
            this.isRedone = false;
        } else {
            this.command.redo();
            this.isRedone = true;
        }
    }

    public boolean isEmpty() {
        return false;
    }

    public void dispose() {
        if (this.command != null) {
            this.command.dispose();
            this.command = null;
        }
    }
}

