/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.visualization.GraphMouseListener;
import edu.uci.ics.jung.visualization.PickSupport;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

public class MouseListenerTranslator
extends MouseAdapter {
    private VisualizationViewer vv;
    private GraphMouseListener gel;

    public MouseListenerTranslator(GraphMouseListener gel, VisualizationViewer vv) {
        this.gel = gel;
        this.vv = vv;
    }

    private Vertex getVertex(Point2D point) {
        PickSupport pickSupport = this.vv.getPickSupport();
        Vertex v = null;
        if (pickSupport != null) {
            Point2D p = this.vv.inverseViewTransform(point);
            v = pickSupport.getVertex(p.getX(), p.getY());
        }
        return v;
    }

    public void mouseClicked(MouseEvent e) {
        Vertex v = this.getVertex(e.getPoint());
        if (v != null) {
            this.gel.graphClicked(v, e);
        }
    }

    public void mousePressed(MouseEvent e) {
        Vertex v = this.getVertex(e.getPoint());
        if (v != null) {
            this.gel.graphPressed(v, e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        Vertex v = this.getVertex(e.getPoint());
        if (v != null) {
            this.gel.graphReleased(v, e);
        }
    }
}

