/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;

public class FourPassImageShaper {
    static /* synthetic */ Class class$edu$uci$ics$jung$visualization$FourPassImageShaper;

    public static Shape getShape(String fileName) {
        return FourPassImageShaper.getShape(fileName, Integer.MAX_VALUE);
    }

    public static Shape getShape(String fileName, int max) {
        BufferedImage image = null;
        try {
            image = ImageIO.read((class$edu$uci$ics$jung$visualization$FourPassImageShaper == null ? (class$edu$uci$ics$jung$visualization$FourPassImageShaper = FourPassImageShaper.class$("edu.uci.ics.jung.visualization.FourPassImageShaper")) : class$edu$uci$ics$jung$visualization$FourPassImageShaper).getResource(fileName));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return FourPassImageShaper.getShape(image, max);
    }

    public static Shape getShape(Image image) {
        return FourPassImageShaper.getShape(image, Integer.MAX_VALUE);
    }

    public static Shape getShape(Image image, int max) {
        BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g = bi.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return FourPassImageShaper.getShape(bi, max);
    }

    public static Shape getShape(BufferedImage image, int max) {
        float width = image.getWidth();
        float height = image.getHeight();
        if (width > (float)max || height > (float)max) {
            BufferedImage smaller = new BufferedImage(max, max, 2);
            Graphics2D g = smaller.createGraphics();
            AffineTransform at = AffineTransform.getScaleInstance((float)max / width, (float)max / height);
            AffineTransform back = AffineTransform.getScaleInstance(width / (float)max, height / (float)max);
            Graphics2D g2 = g;
            g2.drawImage(image, at, null);
            g2.dispose();
            return back.createTransformedShape(FourPassImageShaper.getShape(smaller));
        }
        return FourPassImageShaper.getShape(image);
    }

    public static Shape getShape(BufferedImage image) {
        Area area = new Area(FourPassImageShaper.leftEdge(image));
        area.intersect(new Area(FourPassImageShaper.bottomEdge(image)));
        area.intersect(new Area(FourPassImageShaper.rightEdge(image)));
        area.intersect(new Area(FourPassImageShaper.topEdge(image)));
        return area;
    }

    private static Point2D detectLine(Point2D p1, Point2D p2, Point2D p, Line2D line, GeneralPath path) {
        if (p2 == null) {
            p2 = p;
            line.setLine(p1, p2);
        } else if (line.ptLineDistSq(p) < 1.0) {
            p2.setLocation(p);
        } else {
            p1.setLocation(p2);
            p2.setLocation(p);
            line.setLine(p1, p2);
            path.lineTo((float)p1.getX(), (float)p1.getY());
        }
        return p2;
    }

    private static Shape leftEdge(BufferedImage image) {
        GeneralPath path = new GeneralPath();
        Point2D.Float p1 = new Point2D.Float(image.getWidth() - 1, 0.0f);
        Point2D p2 = null;
        Line2D.Float line = new Line2D.Float();
        Point2D.Float p = new Point2D.Float();
        path.moveTo(image.getWidth() - 1, 0.0f);
        for (int i = 0; i < image.getHeight(); ++i) {
            ((Point2D)p).setLocation(image.getWidth() - 1, i);
            for (int j = 0; j < image.getWidth(); ++j) {
                if ((image.getRGB(j, i) & 0xFF000000) == 0) continue;
                ((Point2D)p).setLocation(j, i);
                break;
            }
            p2 = FourPassImageShaper.detectLine(p1, p2, p, line, path);
        }
        ((Point2D)p).setLocation(image.getWidth() - 1, image.getHeight() - 1);
        FourPassImageShaper.detectLine(p1, p2, p, line, path);
        path.closePath();
        return path;
    }

    private static Shape bottomEdge(BufferedImage image) {
        GeneralPath path = new GeneralPath();
        Point2D.Float p1 = new Point2D.Float(0.0f, 0.0f);
        Point2D p2 = null;
        Line2D.Float line = new Line2D.Float();
        Point2D.Float p = new Point2D.Float();
        path.moveTo(0.0f, 0.0f);
        for (int i = 0; i < image.getWidth(); ++i) {
            ((Point2D)p).setLocation(i, 0.0);
            for (int j = image.getHeight() - 1; j >= 0; --j) {
                if ((image.getRGB(i, j) & 0xFF000000) == 0) continue;
                ((Point2D)p).setLocation(i, j);
                break;
            }
            p2 = FourPassImageShaper.detectLine(p1, p2, p, line, path);
        }
        ((Point2D)p).setLocation(image.getWidth() - 1, 0.0);
        FourPassImageShaper.detectLine(p1, p2, p, line, path);
        path.closePath();
        return path;
    }

    private static Shape rightEdge(BufferedImage image) {
        GeneralPath path = new GeneralPath();
        Point2D.Float p1 = new Point2D.Float(0.0f, image.getHeight() - 1);
        Point2D p2 = null;
        Line2D.Float line = new Line2D.Float();
        Point2D.Float p = new Point2D.Float();
        path.moveTo(0.0f, image.getHeight() - 1);
        for (int i = image.getHeight() - 1; i >= 0; --i) {
            ((Point2D)p).setLocation(0.0, i);
            for (int j = image.getWidth() - 1; j >= 0; --j) {
                if ((image.getRGB(j, i) & 0xFF000000) == 0) continue;
                ((Point2D)p).setLocation(j, i);
                break;
            }
            p2 = FourPassImageShaper.detectLine(p1, p2, p, line, path);
        }
        ((Point2D)p).setLocation(0.0, 0.0);
        FourPassImageShaper.detectLine(p1, p2, p, line, path);
        path.closePath();
        return path;
    }

    private static Shape topEdge(BufferedImage image) {
        GeneralPath path = new GeneralPath();
        Point2D.Float p1 = new Point2D.Float(image.getWidth() - 1, image.getHeight() - 1);
        Point2D p2 = null;
        Line2D.Float line = new Line2D.Float();
        Point2D.Float p = new Point2D.Float();
        path.moveTo(image.getWidth() - 1, image.getHeight() - 1);
        for (int i = image.getWidth() - 1; i >= 0; --i) {
            ((Point2D)p).setLocation(i, image.getHeight() - 1);
            for (int j = 0; j < image.getHeight(); ++j) {
                if ((image.getRGB(i, j) & 0xFF000000) == 0) continue;
                ((Point2D)p).setLocation(i, j);
                break;
            }
            p2 = FourPassImageShaper.detectLine(p1, p2, p, line, path);
        }
        ((Point2D)p).setLocation(0.0, image.getHeight() - 1);
        FourPassImageShaper.detectLine(p1, p2, p, line, path);
        path.closePath();
        return path;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

