/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.cluster;

import edu.uci.ics.jung.algorithms.cluster.ClusterSet;
import edu.uci.ics.jung.algorithms.cluster.GraphClusterer;
import edu.uci.ics.jung.algorithms.cluster.WeakComponentClusterer;
import edu.uci.ics.jung.algorithms.importance.BetweennessCentrality;
import edu.uci.ics.jung.algorithms.importance.EdgeRanking;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EdgeBetweennessClusterer
implements GraphClusterer {
    private int mNumEdgesToRemove;
    private List mEdgesRemoved;

    public EdgeBetweennessClusterer(int numEdgesToRemove) {
        this.mNumEdgesToRemove = numEdgesToRemove;
        this.mEdgesRemoved = new ArrayList();
    }

    public ClusterSet extract(ArchetypeGraph g) {
        if (!(g instanceof Graph)) {
            throw new IllegalArgumentException("Argument must be of type Graph.");
        }
        Graph graph = (Graph)g;
        if (this.mNumEdgesToRemove < 0 || this.mNumEdgesToRemove > graph.numEdges()) {
            throw new IllegalArgumentException("Invalid number of edges passed in.");
        }
        this.mEdgesRemoved.clear();
        for (int k = 0; k < this.mNumEdgesToRemove; ++k) {
            BetweennessCentrality bc = new BetweennessCentrality(graph, false);
            bc.setRemoveRankScoresOnFinalize(true);
            bc.evaluate();
            EdgeRanking highestBetweenness = (EdgeRanking)bc.getRankings().get(0);
            this.mEdgesRemoved.add(highestBetweenness.edge.getEqualEdge(graph));
            graph.removeEdge(highestBetweenness.edge);
        }
        WeakComponentClusterer wcSearch = new WeakComponentClusterer();
        ClusterSet clusterSet = wcSearch.extract(graph);
        Iterator iter = this.mEdgesRemoved.iterator();
        while (iter.hasNext()) {
            graph.addEdge((Edge)iter.next());
        }
        return clusterSet;
    }

    public List getEdgesRemoved() {
        return this.mEdgesRemoved;
    }
}

