/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.kent.cs.kmf.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import uk.ac.kent.cs.kmf.util.ILog;
import uk.ac.kent.cs.kmf.util.Naming;
import uk.ac.kent.cs.kmf.xmi.FeatureInfo;
import uk.ac.kent.cs.kmf.xmi.IReaderAdapter;
import uk.ac.kent.cs.kmf.xmi.ObjectInfo;
import uk.ac.kent.cs.kmf.xmi.ReaderAdapter;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Data_Types.Name;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.repository.UmlRepository;

public class UMLReaderAdapter
extends ReaderAdapter
implements IReaderAdapter {
    protected UmlRepository repository;
    protected ILog log;
    protected boolean debug = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public UMLReaderAdapter(UmlRepository r, ILog l) {
        this.repository = r;
        this.log = l;
    }

    public Object createObject(ObjectInfo info) {
        if (info.getIdref() != null) {
            return null;
        }
        String objName = info.getXMIName();
        if (info.getXMIVersion().equals("1.2")) {
            objName = Naming.getUMLPathName(objName);
        }
        if ((objName = Naming.getCleanName(objName)).equals("Collection_")) {
            return new Vector();
        }
        if (objName.equals("List")) {
            return new Vector();
        }
        if (objName.equals("Set_")) {
            return new HashSet();
        }
        Object obj = this.repository.buildElement("uml." + objName);
        if (obj == null) {
            this.log.reportWarning("Cannot create an instance of '" + objName + "'");
        } else if (this.debug) {
            this.log.reportMessage("Create an instance of '" + objName + "'");
        }
        return obj;
    }

    public Object createProperty(FeatureInfo info) {
        String propertyName = Naming.getCleanName(info.getXMIName());
        if (info.getValue() == null) {
            return propertyName;
        }
        if (this.debug) {
            Object object = info.getObject();
            Object value = info.getValue();
            String objStr = "" + object.getClass();
            String valueStr = value instanceof String ? (String)value : "" + value.getClass();
            String message = "Create property '" + propertyName + "' into '" + objStr + "' with value '" + valueStr + "'";
            this.log.reportMessage(message);
        }
        this.setPropertyValue(info.getObject(), propertyName, info.getValue());
        return null;
    }

    public void resolveValue(Object object, Object propertyName, Object value) {
        if (this.debug) {
            String objStr = "" + object.getClass();
            String valueStr = "" + value.getClass();
            String message = "Resolve property '" + propertyName + "' from '" + objStr + "' to '" + valueStr + "'";
            this.log.reportMessage(message);
        }
        this.setPropertyValue(object, (String)propertyName, value);
    }

    void setPropertyValue(Object object, String name, Object value) {
        block37: {
            String propertyName = name;
            if (propertyName.indexOf(".") != -1) {
                propertyName = propertyName.substring(propertyName.lastIndexOf(".") + 1, propertyName.length());
            }
            String getterName = Naming.getGetter(propertyName);
            Method getterMethod = null;
            Class<?> propertyType = null;
            try {
                getterMethod = object.getClass().getMethod(getterName, new Class[0]);
                propertyType = getterMethod.getReturnType();
            }
            catch (Exception e) {
                this.log.reportWarning("Cannot find property '" + getterName + "'", e);
            }
            String setterName = Naming.getSetter(propertyName);
            try {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.util.Collection");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isAssignableFrom(propertyType)) {
                    ((Collection)getterMethod.invoke(object, new Object[0])).add(value);
                    break block37;
                }
                Method setterMethod = object.getClass().getMethod(setterName, propertyType);
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (propertyType == clazz2) {
                    setterMethod.invoke(object, (String)value);
                    break block37;
                }
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("java.lang.StringBuffer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (propertyType == clazz3) {
                    setterMethod.invoke(object, (String)value);
                    break block37;
                }
                Class<?> clazz4 = class$3;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$3 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (propertyType == clazz4) {
                    setterMethod.invoke(object, Boolean.valueOf((String)value));
                    break block37;
                }
                Class<?> clazz5 = class$4;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$4 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (propertyType == clazz5) {
                    setterMethod.invoke(object, Integer.valueOf((String)value));
                    break block37;
                }
                Class<?> clazz6 = class$5;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$5 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (propertyType == clazz6) {
                    setterMethod.invoke(object, Double.valueOf((String)value));
                    break block37;
                }
                Class<?> clazz7 = class$6;
                if (clazz7 == null) {
                    try {
                        clazz7 = class$6 = Class.forName("uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Data_Types.Name");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (propertyType == clazz7) {
                    Name n = (Name)this.repository.buildElement("uml.Foundation.Data_Types.Name");
                    n.setBody_(new String((String)value));
                    setterMethod.invoke(object, n);
                } else if (propertyType.getName().endsWith("Kind")) {
                    Object o = this.getEnum(propertyType, (String)value);
                    setterMethod.invoke(object, o);
                } else {
                    setterMethod.invoke(object, value);
                }
            }
            catch (Exception e) {
                String message = "Cannot invoke mutator '" + propertyName + "(" + propertyType + ")'\n";
                message = String.valueOf(message) + "this = " + object + "\n";
                message = value != null ? String.valueOf(message) + "argument = '" + value.getClass() + "(" + value + ")'" : String.valueOf(message) + "argument = '(null)'";
                this.log.reportWarning(message, e);
            }
        }
    }

    Object getEnum(Class type, String name) {
        String enumerator = name.toUpperCase();
        String enumeration = type.getName();
        enumeration = Naming.getClassName(enumeration);
        try {
            Class<?> enumClass = Class.forName(enumeration);
            Field field = enumClass.getField(enumerator);
            return field.get(null);
        }
        catch (Exception e) {
            this.log.reportWarning("Cannot find field '" + enumerator + "' in enumeration '" + enumeration + "'", e);
            return null;
        }
    }
}

