/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.kent.cs.kmf.util;

import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import uk.ac.kent.cs.kmf.util.ILog;
import uk.ac.kent.cs.kmf.util.JavaFactory;
import uk.ac.kent.cs.kmf.util.Type;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Core.Association;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Core.AssociationEnd;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Core.Attribute;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Core.Classifier;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Core.Constraint;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Core.Feature;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Core.GeneralizableElement;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Core.Generalization;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Core.ModelElement;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Core.Operation;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Core.Parameter;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Data_Types.AggregationKind;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Data_Types.MultiplicityRange;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Data_Types.Name;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Data_Types.OrderingKind;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Data_Types.ParameterDirectionKind;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Data_Types.VisibilityKind;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Extension_Mechanisms.Stereotype;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Model_Management.Model;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Model_Management.Package;

public class Naming {
    protected static Model model;
    protected static String modelName;
    protected static String modelPackage;
    protected static String outDirName;
    protected static String rootOffset;
    protected static String licenceFileName;
    protected static ILog log;
    public static String interfacePrefix;
    public static String interfaceSuffix;
    public static String classPrefix;
    public static String classSuffix;
    public static String collectionInterface;
    public static String listInterface;
    public static String setInterface;
    public static String collectionClass;
    public static String listClass;
    public static String setClass;
    protected static Set keywords;
    protected static Map UMLPath;

    static {
        outDirName = new String();
        rootOffset = new String();
        interfacePrefix = "";
        interfaceSuffix = "";
        classPrefix = "";
        classSuffix = "$Class";
        collectionInterface = "java.util.Collection";
        listInterface = "java.util.List";
        setInterface = "java.util.Set";
        collectionClass = "java.util.Vector";
        listClass = "java.util.Vector";
        setClass = "java.util.LinkedHashSet";
        keywords = new HashSet();
        keywords.add("abstract");
        keywords.add("boolean");
        keywords.add("break");
        keywords.add("byte");
        keywords.add("case");
        keywords.add("catch");
        keywords.add("char");
        keywords.add("class");
        keywords.add("const");
        keywords.add("continue");
        keywords.add("default");
        keywords.add("do");
        keywords.add("double");
        keywords.add("else");
        keywords.add("extends");
        keywords.add("final");
        keywords.add("finally");
        keywords.add("float");
        keywords.add("for");
        keywords.add("goto");
        keywords.add("if");
        keywords.add("implements");
        keywords.add("import");
        keywords.add("instanceof");
        keywords.add("int");
        keywords.add("interface");
        keywords.add("long");
        keywords.add("native");
        keywords.add("new");
        keywords.add("package");
        keywords.add("private");
        keywords.add("protected");
        keywords.add("public");
        keywords.add("return");
        keywords.add("short");
        keywords.add("public");
        keywords.add("static");
        keywords.add("strictfp");
        keywords.add("super");
        keywords.add("switch");
        keywords.add("synchronized");
        keywords.add("this");
        keywords.add("throw");
        keywords.add("throws");
        keywords.add("transient");
        keywords.add("try");
        keywords.add("void");
        keywords.add("volatile");
        keywords.add("while");
        keywords.add("Object");
        keywords.add("Enumeration");
        keywords.add("Integer");
        keywords.add("Boolean");
        keywords.add("Double");
        keywords.add("String");
        keywords.add("Collection");
        keywords.add("Set");
        keywords.add("Class");
        keywords.add("namespace");
        keywords.add("internal");
        UMLPath = new HashMap();
        UMLPath.put("Action", "Behavioral Elements.State Machines");
        UMLPath.put("Guard", "Behavioral Elements.State Machines");
        UMLPath.put("Pseudostate", "Behavioral Elements.State Machines");
        UMLPath.put("State", "Behavioral Elements.State Machines");
        UMLPath.put("StateMachine", "Behavioral Elements.State Machines");
        UMLPath.put("StateVertex", "Behavioral Elements.State Machines");
        UMLPath.put("StubState", "Behavioral Elements.State Machines");
        UMLPath.put("SynchState", "Behavioral Elements.State Machines");
        UMLPath.put("Transition", "Behavioral Elements.State Machines");
        UMLPath.put("CallEvent", "Behavioral Elements.State Machines");
        UMLPath.put("CallEvent", "Behavioral Elements.State Machines");
        UMLPath.put("CompositeState", "Behavioral Elements.State Machines");
        UMLPath.put("Abstraction", "Foundation.Core");
        UMLPath.put("Association", "Foundation.Core");
        UMLPath.put("AssociationClass", "Foundation.Core");
        UMLPath.put("AssociationEnd", "Foundation.Core");
        UMLPath.put("Attribute", "Foundation.Core");
        UMLPath.put("BehavioralFeature", "Foundation.Core");
        UMLPath.put("Bindind", "Foundation.Core");
        UMLPath.put("CallAction", "Foundation.Core");
        UMLPath.put("Class", "Foundation.Core");
        UMLPath.put("Classifier", "Foundation.Core");
        UMLPath.put("Comment", "Foundation.Core");
        UMLPath.put("Component", "Foundation.Core");
        UMLPath.put("Constraint", "Foundation.Core");
        UMLPath.put("DataType", "Foundation.Core");
        UMLPath.put("Dependency", "Foundation.Core");
        UMLPath.put("Element", "Foundation.Core");
        UMLPath.put("EnumLiteral", "Foundation.Core");
        UMLPath.put("Enumeration", "Foundation.Core");
        UMLPath.put("Feature", "Foundation.Core");
        UMLPath.put("Flow", "Foundation.Core");
        UMLPath.put("GeneralizableElement", "Foundation.Core");
        UMLPath.put("Generalization", "Foundation.Core");
        UMLPath.put("Interface", "Foundation.Core");
        UMLPath.put("Method", "Foundation.Core");
        UMLPath.put("ModelElement", "Foundation.Core");
        UMLPath.put("Namespace", "Foundation.Core");
        UMLPath.put("Node", "Foundation.Core");
        UMLPath.put("Operation", "Foundation.Core");
        UMLPath.put("Parameter", "Foundation.Core");
        UMLPath.put("Permission", "Foundation.Core");
        UMLPath.put("PresentationElement", "Foundation.Core");
        UMLPath.put("Primitive", "Foundation.Core");
        UMLPath.put("Relationship", "Foundation.Core");
        UMLPath.put("SendAction", "Foundation.Core");
        UMLPath.put("Signal", "Foundation.Core");
        UMLPath.put("StructuralFeature", "Foundation.Core");
        UMLPath.put("TemplateParameter", "Foundation.Core");
        UMLPath.put("Tie", "Foundation.Core");
        UMLPath.put("Usage", "Foundation.Core");
        UMLPath.put("ActionExpression", "Foundation.Data Types");
        UMLPath.put("AggregationKind", "Foundation.Data Types");
        UMLPath.put("ArgListsExpression", "Foundation.Data Types");
        UMLPath.put("Boolean", "Foundation.Data Types");
        UMLPath.put("BooleanExpression", "Foundation.Data Types");
        UMLPath.put("CallConcurrencyKind", "Foundation.Data Types");
        UMLPath.put("ChangebilityKind", "Foundation.Data Types");
        UMLPath.put("Expression", "Foundation.Data Types");
        UMLPath.put("Geometry", "Foundation.Data Types");
        UMLPath.put("Integer", "Foundation.Data Types");
        UMLPath.put("IterationExpression", "Foundation.Data Types");
        UMLPath.put("LocationReference", "Foundation.Data Types");
        UMLPath.put("MappingExpression", "Foundation.Data Types");
        UMLPath.put("MessageDirectionKind", "Foundation.Data Types");
        UMLPath.put("Multiplicity", "Foundation.Data Types");
        UMLPath.put("MultiplicityRange", "Foundation.Data Types");
        UMLPath.put("Name", "Foundation.Data Types");
        UMLPath.put("ObjectSetExpression", "Foundation.Data Types");
        UMLPath.put("OrderingKind", "Foundation.Data Types");
        UMLPath.put("ParameterDirectionKind", "Foundation.Data Types");
        UMLPath.put("ProcedureExpression", "Foundation.Data Types");
        UMLPath.put("PseudostateKind", "Foundation.Data Types");
        UMLPath.put("ScopeKind", "Foundation.Data Types");
        UMLPath.put("String", "Foundation.Data Types");
        UMLPath.put("Time", "Foundation.Data Types");
        UMLPath.put("TimeExpression", "Foundation.Data Types");
        UMLPath.put("TypeExpression", "Foundation.Data Types");
        UMLPath.put("UnlimitedInteger", "Foundation.Data Types");
        UMLPath.put("VisibilityKind", "Foundation.Data Types");
        UMLPath.put("Stereotype", "Foundation.Extension Mechanisms");
        UMLPath.put("StringArray", "Foundation.Extension Mechanisms");
        UMLPath.put("TagDefinition", "Foundation.Extension Mechanisms");
        UMLPath.put("TaggedValue", "Foundation.Extension Mechanisms");
        UMLPath.put("Model", "Model Management");
        UMLPath.put("Package", "Model Management");
        UMLPath.put("Subsystem", "Model Management");
    }

    public Naming(Model model, String rootOffset, ILog log) {
        Naming.model = model;
        Naming.rootOffset = rootOffset;
        if (rootOffset.length() != 0 && !rootOffset.endsWith(".")) {
            rootOffset = String.valueOf(rootOffset) + ".";
        }
        modelName = Naming.getPackageName((Package)model);
        modelPackage = String.valueOf(rootOffset) + modelName;
    }

    public static Model getModel() {
        return model;
    }

    public static String getName(ModelElement element) {
        Name name = element.getName();
        if (name != null) {
            return name.getBody_();
        }
        if (element instanceof AssociationEnd) {
            StringBuffer nameB = new StringBuffer(Naming.getClassifierName(((AssociationEnd)element).getType()));
            nameB.setCharAt(0, Character.toLowerCase(nameB.charAt(0)));
            String str = new String(nameB);
            return str;
        }
        return "";
    }

    public static String getModelName() {
        return modelName;
    }

    public static String getRootOffset() {
        return rootOffset;
    }

    public static void setRootOffset(String string) {
        rootOffset = string;
    }

    public static String getModelPackage() {
        return modelPackage;
    }

    public static String getPackageName(Package pkg) {
        return Naming.getCleanName(pkg.getName().getBody_());
    }

    public static String getFullPackageName(Package pkg) {
        if (pkg.getNamespace_() == null) {
            return String.valueOf(rootOffset) + Naming.getPackageName(pkg);
        }
        if (pkg.getNamespace_().getName().getBody_().equals("null")) {
            return String.valueOf(rootOffset) + Naming.getPackageName(pkg);
        }
        String pre = Naming.getFullPackageName((Package)pkg.getNamespace_());
        return String.valueOf(pre) + "." + Naming.getPackageName(pkg);
    }

    public static String getClassifierName(Classifier cls) {
        if (cls == null) {
            log.reportError("'null' classifier found");
            return "nullClassifier";
        }
        String name = cls.getName().getBody_();
        if (name.length() >= 1) {
            name = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1, name.length());
        }
        if (Naming.isStereotype((ModelElement)cls, "primitive")) {
            return name;
        }
        if (!name.endsWith("}")) {
            name = Naming.getCleanName(name);
        }
        return name;
    }

    public static String getClassifierName(Classifier cls, Classifier dst) {
        if (cls == null) {
            log.reportError("'null' classifier found");
            return "nullClassifier";
        }
        String name = cls.getName().getBody_();
        if (name.length() >= 1) {
            name = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1, name.length());
        }
        if (Naming.isStereotype((ModelElement)cls, "primitive")) {
            return name;
        }
        if (!name.endsWith("}")) {
            name = Naming.getCleanName(name);
        }
        if (!Naming.inSamePackage(cls, dst)) {
            name = String.valueOf(Naming.getFullPackageName(cls)) + "." + name;
        }
        return name;
    }

    public static String getFullClassifierName(Classifier cls) {
        if (cls == null) {
            log.reportError("'null' classifier found");
            return String.valueOf(rootOffset) + "";
        }
        String name = Naming.getClassifierName(cls);
        if (Naming.isStereotype((ModelElement)cls, "primitive")) {
            return name;
        }
        if (cls.getNamespace_() == null) {
            return String.valueOf(rootOffset) + Naming.getClassifierName(cls);
        }
        if (cls.getNamespace_().getName().getBody_().equals("null")) {
            return String.valueOf(rootOffset) + Naming.getClassifierName(cls);
        }
        String pre = Naming.getFullPackageName((Package)cls.getNamespace_());
        return String.valueOf(pre) + "." + Naming.getClassifierName(cls);
    }

    public static String getFullPackageName(Classifier cls) {
        String name = Naming.getFullClassifierName(cls);
        int pos = name.lastIndexOf(46);
        if (pos != -1) {
            name = name.substring(0, pos);
        }
        return name;
    }

    public static String getInterfaceName(Classifier cls) {
        return String.valueOf(interfacePrefix) + Naming.getClassifierName(cls) + interfaceSuffix;
    }

    public static String getFullInterfaceName(Classifier cls) {
        return String.valueOf(Naming.getFullPackageName(cls)) + "." + Naming.getInterfaceName(cls);
    }

    public static String getClassName(Classifier cls) {
        return String.valueOf(Naming.getClassifierName(cls)) + classSuffix;
    }

    public static String getClassName(Classifier cls, Classifier src) {
        return String.valueOf(Naming.getClassifierName(cls, src)) + classSuffix;
    }

    public static String getClassName(String clsName) {
        return String.valueOf(Naming.getCleanName(clsName)) + classSuffix;
    }

    public static String getFullClassName(Classifier cls) {
        return String.valueOf(Naming.getFullPackageName(cls)) + "." + Naming.getClassName(cls);
    }

    public static String getFactoryInterfaceName(Classifier cls) {
        return String.valueOf(Naming.getClassifierName(cls)) + "$Factory";
    }

    public static String getFullFactoryInterfaceName(Classifier cls) {
        return String.valueOf(Naming.getFullPackageName(cls)) + "." + Naming.getFactoryInterfaceName(cls);
    }

    public static String getFactoryClassName(Classifier cls) {
        return String.valueOf(Naming.getClassifierName(cls)) + "$Factory" + classSuffix;
    }

    public static String getFullFactoryClassName(Classifier cls) {
        return String.valueOf(Naming.getFullPackageName(cls)) + "." + Naming.getFactoryClassName(cls);
    }

    public static String getVisitorInterfaceName(Classifier cls) {
        return String.valueOf(Naming.getClassifierName(cls)) + "$Visitor";
    }

    public static String getFullVisitorInterfaceName(Classifier cls) {
        return String.valueOf(Naming.getFullPackageName(cls)) + "." + Naming.getVisitorInterfaceName(cls);
    }

    public static String getFactoryVisitorInterfaceName(Classifier cls) {
        return String.valueOf(Naming.getFactoryInterfaceName(cls)) + "$Visitor";
    }

    public static String getFullFactoryVisitorInterfaceName(Classifier cls) {
        return String.valueOf(Naming.getFullPackageName(cls)) + "." + Naming.getFactoryVisitorInterfaceName(cls);
    }

    public static String removeOffset(String packageOffset, String interfaceName) {
        String header = null;
        if (packageOffset != null && packageOffset.length() != 0) {
            header = packageOffset;
        }
        if (!packageOffset.endsWith(".")) {
            header = String.valueOf(header) + ".";
        }
        if (header != null && header.length() != 0 && interfaceName.startsWith(header)) {
            interfaceName = interfaceName.substring(header.length(), interfaceName.length());
        }
        return interfaceName;
    }

    public static String getPropertyName(Attribute attrib) {
        String name = attrib.getName().getBody_();
        return Naming.getCleanName(name);
    }

    public static String getPropertyName(AssociationEnd aend) {
        String name = null;
        if (aend.getName() == null) {
            StringBuffer nameB = new StringBuffer(Naming.getClassifierName(aend.getType()));
            nameB.setCharAt(0, Character.toLowerCase(nameB.charAt(0)));
            name = new String(nameB);
        } else {
            name = aend.getName().getBody_();
            if (name.equals("")) {
                StringBuffer nameB = new StringBuffer(Naming.getClassifierName(aend.getType()));
                nameB.setCharAt(0, Character.toLowerCase(nameB.charAt(0)));
                name = new String(nameB);
            }
        }
        return Naming.getCleanName(name);
    }

    public static String getPropertyType(Attribute attrib, Classifier src, Classifier dst) {
        if (attrib.getType() != null) {
            String modelTypeName = attrib.getType().getName().getBody_();
            String javaTypeName = Type.getJavaType(modelTypeName);
            if (!Naming.isCollection(attrib)) {
                if (javaTypeName != null) {
                    return javaTypeName;
                }
                if (!Naming.inSamePackage(src, dst)) {
                    modelTypeName = String.valueOf(Naming.getFullPackageName(src)) + "." + modelTypeName;
                }
                return modelTypeName;
            }
            if (attrib.getMultiplicity() != null) {
                if (attrib.getOrdering() == OrderingKind.Class.ORDERED) {
                    return listInterface;
                }
                return setInterface;
            }
            return javaTypeName;
        }
        log.reportError("The property '" + Naming.getPropertyName(attrib) + "' from '" + Naming.getClassifierName(dst) + "' should have a type");
        return "";
    }

    public static String getPropertyFullType(Attribute attrib, Classifier src) {
        if (attrib.getType() != null) {
            String modelTypeName = attrib.getType().getName().getBody_();
            String javaTypeName = Type.getJavaType(modelTypeName);
            if (!Naming.isCollection(attrib)) {
                if (javaTypeName != null) {
                    return javaTypeName;
                }
                modelTypeName = String.valueOf(Naming.getFullPackageName(attrib.getType())) + "." + modelTypeName;
                return modelTypeName;
            }
            if (attrib.getMultiplicity() != null) {
                if (attrib.getOrdering() == OrderingKind.Class.ORDERED) {
                    return listInterface;
                }
                return setInterface;
            }
            return javaTypeName;
        }
        log.reportError("The property '" + Naming.getPropertyName(attrib) + "' from '" + Naming.getClassifierName(src) + "' should have a type");
        return "";
    }

    public static String getPropertyType(AssociationEnd aend, Classifier src, Classifier dst) {
        if (aend != null) {
            if (!Naming.isCollection(aend)) {
                String typeName = Naming.getClassifierName(aend.getType());
                if (!Naming.inSamePackage(src, dst)) {
                    typeName = String.valueOf(Naming.getFullPackageName(src)) + "." + typeName;
                }
                return typeName;
            }
            if (aend.getOrdering() == OrderingKind.Class.ORDERED) {
                return listInterface;
            }
            return setInterface;
        }
        log.reportError("The property '" + Naming.getPropertyName(aend) + "' from '" + Naming.getClassifierName(dst) + "' should have a type");
        return "";
    }

    public static String getPropertyFullType(AssociationEnd aend, Classifier src) {
        if (aend != null) {
            if (!Naming.isCollection(aend)) {
                String typeName = String.valueOf(Naming.getFullPackageName(src)) + "." + Naming.getClassifierName(aend.getType());
                return typeName;
            }
            if (aend.getOrdering() == OrderingKind.Class.ORDERED) {
                return listInterface;
            }
            return setInterface;
        }
        log.reportError("The property '" + Naming.getPropertyName(aend) + "' from '" + Naming.getClassifierName(src) + "' should have a type");
        return "";
    }

    public static String getPropertyDefaultValue(Attribute attrib) {
        if (attrib.getType() == null) {
            return "null";
        }
        String modelTypeName = Naming.getClassifierName(attrib.getType());
        String javaDefault = JavaFactory.createString(modelTypeName);
        if (javaDefault == null) {
            return "null";
        }
        return javaDefault;
    }

    public static String getPropertyDefaultValue(AssociationEnd aend) {
        if (aend == null) {
            return "null";
        }
        if (Naming.isCollection(aend)) {
            if (aend.getOrdering() == OrderingKind.Class.ORDERED) {
                return "new " + listClass + "()";
            }
            return "new " + setClass + "()";
        }
        return "null";
    }

    public static String getTypeName(Classifier type, Classifier dst) {
        if (type != null) {
            String modelTypeName = type.getName().getBody_();
            String javaTypeName = Type.getJavaType(modelTypeName);
            if (javaTypeName != null) {
                return javaTypeName;
            }
            if (modelTypeName.endsWith("}")) {
                return String.valueOf(Naming.getModelName()) + "Enum";
            }
            if (!Naming.inSamePackage(type, dst)) {
                modelTypeName = String.valueOf(Naming.getFullPackageName(type)) + "." + modelTypeName;
            }
            return modelTypeName;
        }
        return "";
    }

    public static String getFullTypeName(Classifier type) {
        if (type != null) {
            String modelTypeName = Naming.getClassifierName(type);
            String javaTypeName = Type.getJavaType(modelTypeName);
            if (javaTypeName != null) {
                return javaTypeName;
            }
            if (modelTypeName.endsWith("}")) {
                return String.valueOf(Naming.getModelPackage()) + "." + Naming.getModelName() + "Enum";
            }
            modelTypeName = String.valueOf(Naming.getFullPackageName(type)) + "." + modelTypeName;
            return modelTypeName;
        }
        return "";
    }

    public static String getReturnTypeName(Operation op, Classifier dst) {
        Iterator i = op.getParameter().iterator();
        while (i.hasNext()) {
            Parameter p = (Parameter)i.next();
            if (p.getKind() != ParameterDirectionKind.Class.RETURN) continue;
            return Naming.getTypeName(p.getType(), dst);
        }
        return "void";
    }

    public static String getOperationName(Operation op) {
        if (op == null) {
            log.reportError("'null' operation found");
            return "nullOperation";
        }
        String name = op.getName().getBody_();
        return Naming.getCleanName(name);
    }

    public static String getParameterName(Parameter par) {
        if (par == null) {
            log.reportError("'null' parameter found");
            return "nullOperation";
        }
        String name = par.getName().getBody_();
        return Naming.getCleanName(name);
    }

    public static List getParamNames(Operation op) {
        Vector<String> names = new Vector<String>();
        Iterator i = op.getParameter().iterator();
        while (i.hasNext()) {
            Parameter p = (Parameter)i.next();
            if (p.getKind() != ParameterDirectionKind.Class.OUT && p.getKind() != ParameterDirectionKind.Class.INOUT) continue;
            names.add(Naming.getParameterName(p));
        }
        return names;
    }

    public static List getParamQuotedNames(Operation op) {
        Vector<String> names = new Vector<String>();
        Iterator i = op.getParameter().iterator();
        while (i.hasNext()) {
            Parameter p = (Parameter)i.next();
            if (p.getKind() != ParameterDirectionKind.Class.OUT && p.getKind() != ParameterDirectionKind.Class.INOUT) continue;
            names.add("\"" + Naming.getParameterName(p) + "\"");
        }
        return names;
    }

    public static List getParamTypeNames(Operation op, Classifier dst) {
        Vector<String> types = new Vector<String>();
        Iterator i = op.getParameter().iterator();
        while (i.hasNext()) {
            Parameter p = (Parameter)i.next();
            if (p.getKind() != ParameterDirectionKind.Class.OUT && p.getKind() != ParameterDirectionKind.Class.INOUT) continue;
            types.add(Naming.getTypeName(p.getType(), dst));
        }
        return types;
    }

    public static List getParamFullTypeNames(Operation op, Classifier dst) {
        Vector<String> types = new Vector<String>();
        Iterator i = op.getParameter().iterator();
        while (i.hasNext()) {
            Parameter p = (Parameter)i.next();
            if (p.getKind() != ParameterDirectionKind.Class.OUT && p.getKind() != ParameterDirectionKind.Class.INOUT) continue;
            types.add(Naming.getFullTypeName(p.getType()));
        }
        return types;
    }

    public static String getConstraintName(Constraint c) {
        String name = Naming.getCleanName(c.getName().getBody_());
        return "inv_" + name;
    }

    public static List allSuperClasses(GeneralizableElement cls, boolean report) {
        Vector<GeneralizableElement> classes = new Vector<GeneralizableElement>();
        if (cls == null) {
            return classes;
        }
        classes.add(cls);
        int first = 0;
        int last = 1;
        while (first < last) {
            GeneralizableElement crtCls;
            if ((crtCls = (GeneralizableElement)classes.get(first++)) == null) continue;
            Iterator it = crtCls.getGeneralization().iterator();
            while (it.hasNext()) {
                Generalization gen = (Generalization)it.next();
                GeneralizableElement parent = gen.getParent();
                if (parent == null) continue;
                if (!classes.contains(parent)) {
                    classes.add(parent);
                    ++last;
                    continue;
                }
                if (!report) continue;
                log.reportWarning("Multiple inheritance of class '" + Naming.getFullClassifierName((Classifier)parent) + "' in class '" + Naming.getFullClassifierName((Classifier)cls) + "'");
            }
        }
        return classes;
    }

    public static Set getAttributeNames(List classes) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            Classifier cls = (Classifier)it.next();
            Iterator m = cls.getFeature().iterator();
            while (m.hasNext()) {
                Feature f = (Feature)m.next();
                if (!(f instanceof Attribute)) continue;
                Attribute attrib = (Attribute)f;
                String attribName = Naming.getPropertyName(attrib);
                names.add(attribName);
            }
        }
        return names;
    }

    public static Set getAssociationNames(List classes, Set associations) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        Iterator itCls = classes.iterator();
        while (itCls.hasNext()) {
            Classifier cls = (Classifier)itCls.next();
            Iterator itAssoc = associations.iterator();
            while (itAssoc.hasNext()) {
                String assocName;
                Association assoc = (Association)itAssoc.next();
                AssociationEnd aend1 = (AssociationEnd)assoc.getConnection().get(0);
                AssociationEnd aend2 = (AssociationEnd)assoc.getConnection().get(1);
                if (aend1.getType() == cls && Naming.isNavigable(aend2)) {
                    assocName = Naming.getPropertyName(aend2);
                    names.add(assocName);
                }
                if (aend2.getType() != cls || !Naming.isNavigable(aend1)) continue;
                assocName = Naming.getPropertyName(aend1);
                names.add(assocName);
            }
        }
        return names;
    }

    public static String getRootName(String name) {
        int pos = name.indexOf(46);
        if (pos == -1) {
            return name;
        }
        return name.substring(0, pos);
    }

    public static boolean inSamePackage(Classifier src, Classifier dst) {
        if (src == null) {
            return false;
        }
        if (dst == null) {
            return false;
        }
        String srcName = Naming.getFullClassifierName(src);
        String dstName = Naming.getFullClassifierName(dst);
        int srcPos = srcName.lastIndexOf(46);
        int dstPos = dstName.lastIndexOf(46);
        String srcPack = "";
        String dstPack = "";
        if (srcPos != -1) {
            srcPack = srcName.substring(0, srcPos);
        }
        if (dstPos != -1) {
            dstPack = dstName.substring(0, dstPos);
        }
        return srcPack.equals(dstPack);
    }

    public static String toList(List vect, String separator) {
        String res = new String();
        int i = 0;
        while (i < vect.size()) {
            if (i != 0) {
                res = String.valueOf(res) + separator;
            }
            res = String.valueOf(res) + vect.get(i);
            ++i;
        }
        return res;
    }

    public static String toListQuote(List vect, String separator) {
        String res = "";
        int i = 0;
        while (i < vect.size()) {
            if (i != 0) {
                res = String.valueOf(res) + separator;
            }
            res = String.valueOf(res) + "\"" + vect.get(i) + "\"";
            ++i;
        }
        return res;
    }

    public static void putStamp(String clsName, PrintWriter out) {
        out.println("/**");
        out.println(" *");
        out.println(" *  Class " + clsName + ".java");
        Calendar cal = Calendar.getInstance();
        String DATE_FORMAT = "dd MMMMM yyyy HH:mm:ss";
        SimpleDateFormat dateFormatter = new SimpleDateFormat(DATE_FORMAT);
        Date date = cal.getTime();
        out.println(" *");
        out.println(" *  Generated by KMFStudio at " + dateFormatter.format(date));
        out.println(" *  Visit http://www.cs.ukc.ac.uk/kmf");
        out.println(" *");
        out.println(" */");
        out.println();
    }

    protected static String toUpperCaseFirst(String name) {
        if (name.length() >= 1) {
            name = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1, name.length());
        }
        return name;
    }

    public static String getVisitorInterface(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "Visitor";
    }

    public static String getVisitorClass(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "Visitor" + classSuffix;
    }

    public static String getVisitableInterface(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "Visitable";
    }

    public static String getParseAllVisitorInterface(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "ParseAllVisitor";
    }

    public static String getParseAllVisitorClass(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "ParseAllVisitor" + classSuffix;
    }

    public static String getAnalyseAllVisitorInterface(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "AnalyseAllVisitor";
    }

    public static String getAnalyseAllVisitorClass(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "AnalyseAllVisitor" + classSuffix;
    }

    public static String getEvaluateAllVisitorInterface(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "EvaluateAllVisitor";
    }

    public static String getEvaluateAllVisitorClass(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "EvaluateAllVisitor" + classSuffix;
    }

    public static String getFactoryInterface(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "Factory";
    }

    public static String getFactoryClass(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "Factory" + classSuffix;
    }

    public static String getRepositoryInterface(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "Repository";
    }

    public static String getRepositoryClass(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "Repository" + classSuffix;
    }

    public static String getElementInterface(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "Element";
    }

    public static String getElementClass(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "Element" + classSuffix;
    }

    public static String getOCLClass(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "OCLEvaluator" + classSuffix;
    }

    public static String getJTreeVisitorInterface(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "JTreeVisitor";
    }

    public static String getJTreeVisitorClass(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "JTreeVisitor" + classSuffix;
    }

    public static String getHUTNVisitorInterface(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "HUTNVisitor";
    }

    public static String getHUTNVisitorClass(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "HUTNVisitor" + classSuffix;
    }

    public static String getReaderAdapterClass(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "ReaderAdapter" + classSuffix;
    }

    public static String getAdapterFactoryClass(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "FactoryAdapter" + classSuffix;
    }

    public static String getXMIVisitorInterface(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "XMIVisitor";
    }

    public static String getXMIVisitorClass(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "XMIVisitor" + classSuffix;
    }

    public static String getViewEditFrameClass(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "ViewEditFrame" + classSuffix;
    }

    public static String getInvokeMethodClass(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "InvokeMethod" + classSuffix;
    }

    public static String getViewVisitorInterface(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "ViewVisitor";
    }

    public static String getViewVisitorClass(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "ViewVisitor" + classSuffix;
    }

    public static String getEditVisitorInterface(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "EditVisitor";
    }

    public static String getEditVisitorClass(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "EditVisitor" + classSuffix;
    }

    public static String getLifecycleInterface(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "Lifecycle";
    }

    public static String getLifecycleClass(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "Lifecycle" + classSuffix;
    }

    public static String getBrowserInterface(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "Browser";
    }

    public static String getBrowserClass(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "Browser" + classSuffix;
    }

    public static String getStartupInterface(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "Startup";
    }

    public static String getStartupClass(String modelName) {
        return String.valueOf(Naming.toUpperCaseFirst(modelName)) + "Startup" + classSuffix;
    }

    public static boolean isStereotype(ModelElement elem, String kind) {
        if (elem == null) {
            return false;
        }
        Set stereoSet = elem.getStereotype();
        if (stereoSet == null) {
            return false;
        }
        Iterator it = stereoSet.iterator();
        while (it.hasNext()) {
            Stereotype stereo = (Stereotype)it.next();
            Name name = stereo.getName();
            if (name == null) {
                return false;
            }
            if (!name.getBody_().equals(kind)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCollection(AssociationEnd aend) {
        if (aend.getMultiplicity() != null) {
            MultiplicityRange range = (MultiplicityRange)aend.getMultiplicity().getRange().iterator().next();
            int lower = range.getLower();
            int upper = range.getUpper();
            if (upper == -1) {
                return true;
            }
            if (lower == 0 && upper == 1) {
                return false;
            }
            if (lower < upper) {
                return true;
            }
            if (lower == upper && lower > 1) {
                return true;
            }
        }
        return false;
    }

    public static boolean isCollection(Attribute attrib) {
        Iterator i;
        if (attrib.getMultiplicity() != null && (i = attrib.getMultiplicity().getRange().iterator()).hasNext()) {
            MultiplicityRange range = (MultiplicityRange)i.next();
            int lower = range.getLower();
            int upper = range.getUpper();
            if (upper == -1) {
                return true;
            }
            if (lower != 0 || upper != 1) {
                if (lower < upper) {
                    return true;
                }
                if (lower == upper && lower > 1) {
                    return true;
                }
            }
        }
        if (attrib.getType() == null) {
            return false;
        }
        String colls = "Set Sequence Bag MutableSet MutableSequence MutableBag Collection List Set";
        String typeName = attrib.getType().getName().getBody_();
        return colls.indexOf(typeName) != -1;
    }

    public static boolean isAggregate(AssociationEnd aend) {
        return aend.getAggregation() == AggregationKind.Class.AGGREGATE;
    }

    public static boolean isComposite(AssociationEnd aend) {
        return aend.getAggregation() == AggregationKind.Class.COMPOSITE;
    }

    public static boolean isNavigable(AssociationEnd aend) {
        return aend.getIsNavigable();
    }

    public static boolean isPublic(Feature feat) {
        return feat.getVisibility() == VisibilityKind.Class.PUBLIC;
    }

    public static boolean isPrivate(Feature feat) {
        return feat.getVisibility() == VisibilityKind.Class.PRIVATE;
    }

    public static boolean isProtected(Feature feat) {
        return feat.getVisibility() == VisibilityKind.Class.PROTECTED;
    }

    public static boolean isPackage(Feature feat) {
        return feat.getVisibility() == VisibilityKind.Class.PACKAGE;
    }

    public static boolean isKeyword(String name) {
        return keywords.contains(name);
    }

    public static boolean isAlpha(char ch) {
        if ('a' <= ch && ch <= 'z') {
            return true;
        }
        if ('A' <= ch && ch <= 'Z') {
            return true;
        }
        if ('0' <= ch && ch <= '9') {
            return true;
        }
        return ch == '_';
    }

    public static String getCleanName(String name) {
        String res = new String();
        name = name.trim();
        int i = 0;
        while (i < name.length()) {
            char ch = name.charAt(i);
            if (ch != '\t' && ch != '\n' && ch != '\r' && ch != '/') {
                res = Naming.isAlpha(ch) || ch == '.' ? String.valueOf(res) + ch : String.valueOf(res) + '_';
            }
            ++i;
        }
        int pos = res.lastIndexOf(".");
        String lastName = res.substring(pos + 1, res.length());
        if (Naming.isKeyword(lastName)) {
            lastName = String.valueOf(lastName) + "_";
        }
        return String.valueOf(res.substring(0, pos + 1)) + lastName;
    }

    public static String getGetter(String name) {
        if (name.length() == 0) {
            return "get_";
        }
        return "get" + name.substring(0, 1).toUpperCase() + name.substring(1, name.length());
    }

    public static String getSetter(String name) {
        if (name.length() == 0) {
            return "set_";
        }
        return "set" + name.substring(0, 1).toUpperCase() + name.substring(1, name.length());
    }

    public static String getUMLPathName(String name) {
        String pathName = (String)UMLPath.get(name);
        return pathName == null ? name : String.valueOf(pathName) + "." + name;
    }
}

