/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.validation.internal.EMFModelValidationDebugOptions;
import org.eclipse.emf.validation.internal.EMFModelValidationPlugin;
import org.eclipse.emf.validation.internal.EMFModelValidationStatusCodes;
import org.eclipse.emf.validation.internal.service.BatchValidator;
import org.eclipse.emf.validation.internal.service.ConstraintCache;
import org.eclipse.emf.validation.internal.service.IProviderDescriptor;
import org.eclipse.emf.validation.internal.service.IProviderOperation;
import org.eclipse.emf.validation.internal.service.IProviderOperationExecutor;
import org.eclipse.emf.validation.internal.service.LiveValidator;
import org.eclipse.emf.validation.internal.service.ProviderDescriptor;
import org.eclipse.emf.validation.internal.util.Log;
import org.eclipse.emf.validation.internal.util.Trace;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.IValidationListener;
import org.eclipse.emf.validation.service.IValidator;
import org.eclipse.emf.validation.service.ValidationEvent;

public class ModelValidationService {
    private static final ModelValidationService instance;
    private final Collection constraintProviders = new HashSet();
    private boolean xmlConstraintDeclarationsLoaded = false;
    private volatile IValidationListener[] listeners;
    private ConstraintCache constraintCache;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.validation.service.ModelValidationService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        instance = new ModelValidationService();
    }

    private ModelValidationService() {
    }

    public static ModelValidationService getInstance() {
        return instance;
    }

    public IValidator newValidator(EvaluationMode mode) {
        if (!$assertionsDisabled && (mode == null || mode.isNull())) {
            throw new AssertionError();
        }
        IProviderOperationExecutor executor = new IProviderOperationExecutor(){

            public void execute(IProviderOperation op) {
                ModelValidationService.this.execute(op);
            }
        };
        if (mode == EvaluationMode.BATCH) {
            return new BatchValidator(executor);
        }
        if (mode == EvaluationMode.LIVE) {
            return new LiveValidator(executor);
        }
        throw new IllegalArgumentException();
    }

    public synchronized void addValidationListener(IValidationListener listener) {
        if (this.indexOf(listener) < 0) {
            if (this.listeners == null) {
                this.listeners = new IValidationListener[]{listener};
            } else {
                IValidationListener[] newListeners = new IValidationListener[this.listeners.length + 1];
                System.arraycopy(this.listeners, 0, newListeners, 0, this.listeners.length);
                newListeners[this.listeners.length] = listener;
                this.listeners = newListeners;
            }
            if (Trace.shouldTrace(EMFModelValidationDebugOptions.LISTENERS)) {
                Trace.trace(EMFModelValidationDebugOptions.LISTENERS, "Registered listener: " + listener.getClass().getName());
            }
        }
    }

    public synchronized void removeValidationListener(IValidationListener listener) {
        int index = this.indexOf(listener);
        if (index >= 0) {
            IValidationListener[] newListeners = new IValidationListener[this.listeners.length - 1];
            System.arraycopy(this.listeners, 0, newListeners, 0, index);
            System.arraycopy(this.listeners, index + 1, newListeners, index, this.listeners.length - index - 1);
            this.listeners = newListeners;
            if (Trace.shouldTrace(EMFModelValidationDebugOptions.LISTENERS)) {
                Trace.trace(EMFModelValidationDebugOptions.LISTENERS, "Deregistered listener: " + listener.getClass().getName());
            }
        }
    }

    private int indexOf(IValidationListener listener) {
        int result = -1;
        if (this.listeners != null) {
            int i = 0;
            while (i < this.listeners.length) {
                if (this.listeners[i] == listener) {
                    result = i;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public void broadcastValidationEvent(ValidationEvent event) {
        if (this.listeners == null) {
            return;
        }
        IValidationListener[] array = this.listeners;
        int i = 0;
        while (i < array.length) {
            try {
                array[i].validationOccurred(event);
            }
            catch (Exception e) {
                Trace.catching(this.getClass(), "broadcastValidationEvent", e);
                if (Trace.shouldTrace(EMFModelValidationDebugOptions.LISTENERS)) {
                    Trace.trace(EMFModelValidationDebugOptions.LISTENERS, "Uncaught exception in listener: " + array[i].getClass().getName());
                }
                Log.l7dWarning(130, EMFModelValidationStatusCodes.LISTENER_UNCAUGHT_EXCEPTION_MSG, e);
            }
            ++i;
        }
    }

    public void configureListeners(IConfigurationElement[] elements) {
        if (!$assertionsDisabled && elements == null) {
            throw new AssertionError();
        }
        int i = 0;
        while (i < elements.length) {
            if (elements[i].getName().equals("listener")) {
                try {
                    this.addValidationListener(new LazyListener(elements[i]));
                }
                catch (CoreException e) {
                    Trace.catching(this.getClass(), "configureListeners()", e);
                    Log.log(e.getStatus());
                }
            }
            ++i;
        }
    }

    public void configureProviders(IConfigurationElement[] elements) {
        if (!$assertionsDisabled && elements == null) {
            throw new AssertionError();
        }
        this.constraintCache = new ConstraintCache();
        Collection providers = this.getProviders();
        providers.add(this.constraintCache.getDescriptor());
        int i = 0;
        while (i < elements.length) {
            if (elements[i].getName().equals("constraintProvider")) {
                try {
                    ProviderDescriptor descriptor = new ProviderDescriptor(elements[i]);
                    if (descriptor.isCacheEnabled()) {
                        this.constraintCache.addProvider(descriptor);
                        if (Trace.shouldTrace(EMFModelValidationDebugOptions.PROVIDERS)) {
                            Trace.trace(EMFModelValidationDebugOptions.PROVIDERS, "Added provider to cache: " + descriptor);
                        }
                    } else {
                        providers.add(descriptor);
                        if (Trace.shouldTrace(EMFModelValidationDebugOptions.PROVIDERS)) {
                            Trace.trace(EMFModelValidationDebugOptions.PROVIDERS, "Loaded uncacheable provider: " + descriptor);
                        }
                    }
                }
                catch (CoreException e) {
                    Trace.catching(this.getClass(), "configureProviders()", e);
                    Log.log(e.getStatus());
                }
            }
            ++i;
        }
    }

    public void replaceInCache(IModelConstraint oldConstraint, IModelConstraint newConstraint) {
        this.constraintCache.replace(oldConstraint, newConstraint);
    }

    private Collection getProviders() {
        return this.constraintProviders;
    }

    private void execute(IProviderOperation operation) {
        Iterator iter = this.getProviders().iterator();
        while (iter.hasNext()) {
            IProviderDescriptor next = (IProviderDescriptor)iter.next();
            if (!next.provides(operation)) continue;
            try {
                operation.execute(next.getProvider());
            }
            catch (RuntimeException e) {
                Trace.catching(this.getClass(), "execute", e);
                Log.l7dWarning(61, EMFModelValidationStatusCodes.PROVIDER_FAILURE_MSG, e);
                iter.remove();
            }
        }
    }

    public void loadXmlConstraintDeclarations() {
        if (!this.xmlConstraintDeclarationsLoaded) {
            this.xmlConstraintDeclarationsLoaded = true;
            this.loadXmlConstraintDeclarations(this.getProviders());
        }
    }

    private void loadXmlConstraintDeclarations(Collection providers) {
        Iterator iter = providers.iterator();
        while (iter.hasNext()) {
            IProviderDescriptor next = (IProviderDescriptor)iter.next();
            if (next.isXmlProvider()) {
                next.getProvider();
                continue;
            }
            if (!next.isCache()) continue;
            this.loadXmlConstraintDeclarations(((ConstraintCache)next.getProvider()).getProviders());
        }
    }

    public static EClass findClass(String namespaceUri, String className) {
        EClass result = null;
        EPackage epackage = ModelValidationService.findPackage(namespaceUri);
        if (epackage != null) {
            EClassifier classifier = null;
            List packageNames = ModelValidationService.parsePackageNames(className);
            if (packageNames == null) {
                classifier = epackage.getEClassifier(className);
            } else if (ModelValidationService.packageHasName(epackage, packageNames)) {
                className = className.substring(className.lastIndexOf(46) + 1);
                classifier = epackage.getEClassifier(className);
            }
            if (classifier instanceof EClass) {
                result = (EClass)classifier;
            }
        }
        return result;
    }

    private static EPackage findPackage(String namespaceUri) {
        EPackage.Registry registry = EPackage.Registry.INSTANCE;
        Object result = registry.get(namespaceUri);
        if (result instanceof EPackage.Descriptor) {
            result = ((EPackage.Descriptor)result).getEPackage();
        }
        return (EPackage)result;
    }

    private static List parsePackageNames(String qualifiedClassName) {
        ArrayList<String> result = null;
        int end = qualifiedClassName.lastIndexOf(46);
        if (end >= 0) {
            int start;
            result = new ArrayList<String>();
            do {
                start = qualifiedClassName.lastIndexOf(46, end - 1);
                result.add(qualifiedClassName.substring(start + 1, end));
            } while ((end = start) >= 0);
        }
        return result;
    }

    private static boolean packageHasName(EPackage epackage, List name) {
        boolean result = true;
        EPackage pkg = epackage;
        Iterator iter = name.iterator();
        while (result && iter.hasNext() && pkg != null) {
            result = iter.next().equals(pkg.getName());
            pkg = pkg.getESuperPackage();
        }
        result = result && !iter.hasNext() && pkg == null;
        return result;
    }

    private final class LazyListener
    implements IValidationListener {
        private final IConfigurationElement config;
        private List registeredClientContexts = null;
        private IValidationListener validationListener = null;
        private static final String E_CLIENT_CONTEXT = "clientContext";
        private static final String A_CLIENT_CONTEXT_ID = "id";
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.validation.service.ModelValidationService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        LazyListener(IConfigurationElement config) throws CoreException {
            if (!$assertionsDisabled && config == null) {
                throw new AssertionError();
            }
            this.config = config;
        }

        private IValidationListener replaceMe() throws CoreException {
            IValidationListener result = null;
            result = (IValidationListener)this.config.createExecutableExtension("class");
            int index = ModelValidationService.this.indexOf(this);
            ((ModelValidationService)ModelValidationService.this).listeners[index] = result;
            return result;
        }

        public void validationOccurred(ValidationEvent event) {
            if (this.registeredClientContexts == null) {
                IConfigurationElement[] children = this.config.getChildren(E_CLIENT_CONTEXT);
                this.registeredClientContexts = new ArrayList(3);
                int i = 0;
                while (i < children.length) {
                    this.registeredClientContexts.add(children[i].getAttribute(A_CLIENT_CONTEXT_ID));
                    ++i;
                }
            }
            if (this.registeredClientContexts.size() == 0) {
                try {
                    IValidationListener realListener = this.replaceMe();
                    realListener.validationOccurred(event);
                }
                catch (Exception e) {
                    Trace.catching(this.getClass(), "validationOccurred", e);
                    Log.log(4, 130, EMFModelValidationPlugin.getMessage(EMFModelValidationStatusCodes.LISTENER_UNCAUGHT_EXCEPTION_MSG, new Object[]{this.config.getDeclaringExtension().getUniqueIdentifier()}), e);
                    ModelValidationService.this.removeValidationListener(this);
                }
                return;
            }
            Iterator i = this.registeredClientContexts.iterator();
            while (i.hasNext()) {
                String clientContextId = (String)i.next();
                if (!event.getClientContextIds().contains(clientContextId)) continue;
                try {
                    if (this.validationListener == null) {
                        IValidationListener listener;
                        this.validationListener = listener = (IValidationListener)this.config.createExecutableExtension("class");
                    }
                    this.validationListener.validationOccurred(event);
                }
                catch (Exception e) {
                    Trace.catching(this.getClass(), "validationOccurred", e);
                    Log.log(4, 130, EMFModelValidationPlugin.getMessage(EMFModelValidationStatusCodes.LISTENER_UNCAUGHT_EXCEPTION_MSG, new Object[]{this.config.getDeclaringExtension().getUniqueIdentifier()}), e);
                    ModelValidationService.this.removeValidationListener(this);
                }
                return;
            }
        }
    }
}

