/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.service;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.service.AbstractTraversalStrategy;
import org.eclipse.emf.validation.service.ITraversalStrategy;

public interface ITraversalStrategy {
    public void startTraversal(Collection var1, IProgressMonitor var2);

    public boolean hasNext();

    public EObject next();

    public boolean isClientContextChanged();

    public void elementValidated(EObject var1, IStatus var2);

    public static final class Flat
    extends AbstractTraversalStrategy {
        protected int countElements(Collection traversalRoots) {
            return traversalRoots.size();
        }

        protected Iterator createIterator(Collection traversalRoots) {
            return traversalRoots.iterator();
        }
    }

    public static final class Recursive
    extends AbstractTraversalStrategy {
        private Collection roots;
        private boolean contextChanged = true;

        public void startTraversal(Collection traversalRoots, IProgressMonitor progressMonitor) {
            this.roots = this.makeTargetsDisjoint(traversalRoots);
            super.startTraversal(traversalRoots, progressMonitor);
        }

        private Collection getRoots() {
            return this.roots;
        }

        protected int countElements(Collection ignored) {
            return this.countRecursive(this.getRoots());
        }

        private int countRecursive(Collection elements) {
            int result = 0;
            result = elements.size();
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                Object next = iter.next();
                if (!(next instanceof EObject)) continue;
                result += this.countRecursive((Collection)((EObject)next).eContents());
            }
            return result;
        }

        protected Iterator createIterator(Collection ignored) {
            return new EcoreUtil.ContentTreeIterator(this, this.getRoots()){
                private static final long serialVersionUID = -5653134989235663973L;
                final /* synthetic */ Recursive this$1;
                {
                    this.this$1 = recursive;
                    super($anonymous0);
                }

                public Iterator getChildren(Object obj) {
                    if (obj == Recursive.access$0(this.this$1)) {
                        return new Iterator(this){
                            private final Iterator delegate;
                            final /* synthetic */ 1 this$2;
                            {
                                this.this$2 = var1_1;
                                this.delegate = Recursive.access$0(1.access$0(var1_1)).iterator();
                            }

                            public boolean hasNext() {
                                return this.delegate.hasNext();
                            }

                            public Object next() {
                                Recursive.access$1(1.access$0(this.this$2), true);
                                return this.delegate.next();
                            }

                            public void remove() {
                                this.delegate.remove();
                            }
                        };
                    }
                    return super.getChildren(obj);
                }

                public Object next() {
                    Recursive.access$1(this.this$1, false);
                    return super.next();
                }

                static /* synthetic */ Recursive access$0(1 var0) {
                    return var0.this$1;
                }
            };
        }

        public boolean isClientContextChanged() {
            return this.contextChanged;
        }

        private Set makeTargetsDisjoint(Collection objects) {
            HashSet<EObject> result = new HashSet<EObject>();
            Iterator outer = objects.iterator();
            while (outer.hasNext()) {
                EObject outerNext = (EObject)outer.next();
                Iterator inner = result.iterator();
                while (inner.hasNext()) {
                    EObject innerNext = (EObject)inner.next();
                    if (!EcoreUtil.isAncestor((EObject)innerNext, (EObject)outerNext)) continue;
                    outerNext = null;
                    break;
                }
                if (outerNext == null) continue;
                result.add(outerNext);
            }
            return result;
        }

        static /* synthetic */ Collection access$0(Recursive recursive) {
            return recursive.getRoots();
        }

        static /* synthetic */ void access$1(Recursive recursive, boolean bl) {
            recursive.contextChanged = bl;
        }
    }
}

