/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.emfadapter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.internal.EMFModelValidationPlugin;
import org.eclipse.emf.validation.internal.emfadapter.EMFValidationContextAdapter;
import org.eclipse.emf.validation.internal.l10n.ValidationMessages;
import org.eclipse.emf.validation.internal.util.TextUtils;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.IConstraintDescriptor;

public class EMFConstraintAdapter
implements IModelConstraint {
    private static final Map contextMapCache = new WeakHashMap();
    private final IConstraintDescriptor descriptor;
    private final Method validationMethod;
    private final Object[] validationArgs = new Object[2];
    static /* synthetic */ Class class$0;

    public EMFConstraintAdapter(IConstraintDescriptor descriptor, Method validationMethod) {
        this.descriptor = descriptor;
        this.validationMethod = validationMethod;
        this.validationArgs[0] = new EMFValidationContextAdapter();
        this.validationArgs[1] = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus validate(IValidationContext ctx) {
        EMFValidationContextAdapter ctxAdapter = (EMFValidationContextAdapter)((Object)this.validationArgs[0]);
        ctxAdapter.setAdaptedContext(ctx);
        this.validationArgs[1] = EMFConstraintAdapter.getEmfContextFor(ctx);
        try {
            try {
                boolean success = (Boolean)this.validationMethod.invoke((Object)ctx.getTarget(), this.validationArgs);
                IStatus iStatus = success ? ctx.createSuccessStatus() : this.fail(ctxAdapter);
                Object var4_9 = null;
                ctxAdapter.setAdaptedContext(null);
                this.validationArgs[1] = null;
                return iStatus;
            }
            catch (IllegalAccessException e) {
                ctx.disableCurrentConstraint(e);
                IStatus iStatus = this.disabledInfo(ctx, e);
                Object var4_10 = null;
                ctxAdapter.setAdaptedContext(null);
                this.validationArgs[1] = null;
                return iStatus;
            }
            catch (InvocationTargetException e) {
                ctx.disableCurrentConstraint(e);
                IStatus iStatus = this.disabledInfo(ctx, e);
                Object var4_11 = null;
                ctxAdapter.setAdaptedContext(null);
                this.validationArgs[1] = null;
                return iStatus;
            }
        }
        catch (Throwable throwable) {
            Object var4_12 = null;
            ctxAdapter.setAdaptedContext(null);
            this.validationArgs[1] = null;
            throw throwable;
        }
    }

    public IConstraintDescriptor getDescriptor() {
        return this.descriptor;
    }

    private IStatus fail(EMFValidationContextAdapter ctxAdapter) {
        IValidationContext ctx = ctxAdapter.getAdaptedContext();
        ArrayList resultLocus = new ArrayList(ctx.getResultLocus());
        resultLocus.remove(ctx.getTarget());
        Diagnostic status = ctxAdapter.getLastStatus();
        return ctx.createFailureStatus(new Object[]{status == null ? null : status.getMessage(), resultLocus});
    }

    private IStatus disabledInfo(IValidationContext ctx, Throwable e) {
        ConstraintStatus result = new ConstraintStatus(this, ctx.getTarget(), 1, this.getDescriptor().getStatusCode(), EMFModelValidationPlugin.getMessage(ValidationMessages.emfadapter_disabled_WARN_, new Object[]{this.getDescriptor().getName()}), Collections.EMPTY_SET);
        EMFModelValidationPlugin.getPlugin().getLog().log((IStatus)new Status(2, result.getPlugin(), result.getCode(), result.getMessage(), e));
        return result;
    }

    private static Map getEmfContextFor(IValidationContext ctx) {
        HashMap result = (HashMap)contextMapCache.get(ctx);
        if (result == null) {
            result = new HashMap();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.ecore.EValidator$SubstitutionLabelProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            result.put(clazz, SubstitutionProvider.INSTANCE);
            contextMapCache.put(ctx, result);
        }
        return result;
    }

    private static class SubstitutionProvider
    implements EValidator.SubstitutionLabelProvider {
        static final SubstitutionProvider INSTANCE = new SubstitutionProvider();

        private SubstitutionProvider() {
        }

        public String getObjectLabel(EObject eObject) {
            return TextUtils.getText(eObject);
        }

        public String getFeatureLabel(EStructuralFeature eStructuralFeature) {
            return eStructuralFeature.getName();
        }

        public String getValueLabel(EDataType eDataType, Object value) {
            return EcoreUtil.convertToString((EDataType)eDataType, (Object)value);
        }
    }
}

