/*
 * Decompiled with CFR 0.152.
 */
package samples.preview_new_graphdraw.iter;

import edu.uci.ics.jung.graph.Graph;
import java.awt.Dimension;
import samples.preview_new_graphdraw.EdgeRenderer;
import samples.preview_new_graphdraw.StaticLayout;
import samples.preview_new_graphdraw.VertexRenderer;
import samples.preview_new_graphdraw.impl.GraphLayoutPanel;
import samples.preview_new_graphdraw.iter.GraphLayoutPanelUtils;
import samples.preview_new_graphdraw.iter.IterableLayout;
import samples.preview_new_graphdraw.iter.LayoutIterator;
import samples.preview_new_graphdraw.iter.TransformerPipeline;
import samples.preview_new_graphdraw.iter.UpdatableIterableLayout;
import samples.preview_new_graphdraw.iterablelayouts.UnmovingIterableLayout;
import samples.preview_new_graphdraw.transform.FitOnScreenTransformer;
import samples.preview_new_graphdraw.transform.LayoutTransformer;
import samples.preview_new_graphdraw.transform.SlightMarginTransformer;

public class LocalGraphDraw {
    protected GraphLayoutPanel jgp;
    protected IterableLayout layout;
    protected LayoutIterator li;
    protected TransformerPipeline pipeline;
    protected boolean staticAnimation = false;

    public LocalGraphDraw(Graph g, StaticLayout startup, IterableLayout layout, VertexRenderer vr, EdgeRenderer er, Dimension d, boolean prerelax) {
        startup.initializeLocations(d, g);
        this.layout = layout;
        layout.initializeLocationsFromLayout(startup.emit());
        if (prerelax) {
            GraphLayoutPanelUtils.prerelax(500L, layout);
        }
        this.jgp = new GraphLayoutPanel(g, d, vr, er);
        this.pipeline = this.jgp.getPipeline();
        this.addToPipeline(new FitOnScreenTransformer());
        this.addToPipeline(new SlightMarginTransformer());
    }

    public LocalGraphDraw(Graph g, StaticLayout startup, VertexRenderer vr, EdgeRenderer er, Dimension d) {
        this(g, startup, UnmovingIterableLayout.getInstance(), vr, er, d, false);
        this.staticAnimation = true;
    }

    public void addToPipeline(LayoutTransformer lt) {
        this.pipeline.add(lt);
    }

    public GraphLayoutPanel getPanel() {
        return this.jgp;
    }

    public void start() {
        this.li = new LayoutIterator(this.jgp, this.layout);
        if (this.staticAnimation) {
            this.li.setIterationDelay(999999L);
        } else {
            this.li.setIterationDelay(50L);
        }
        this.li.startIterations();
    }

    public void stop() {
        this.li.stopIterations();
    }

    public LayoutIterator getIterator() {
        return this.li;
    }

    public IterableLayout getLayoutSource() {
        return this.li.iterableLayout;
    }

    public void updateGraphTo(Graph g) {
        UpdatableIterableLayout uil = (UpdatableIterableLayout)this.getLayoutSource();
        this.getIterator().stopIterations();
        uil.updateGraphToMatch(g);
        this.jgp.updateGraphToMatch(g);
        this.getIterator().startIterations();
    }
}

