/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.GraphUtils;
import edu.uci.ics.jung.utils.Pair;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.visualization.Layout;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class FadingVertexLayout
implements Layout {
    AffineTransform transform;
    AffineTransform inverse;
    private Dimension currentSize;
    private Layout layout;
    private int fadelevels;
    private Set hiddenNodes;
    private static final String FADINGNODEVIZX = "edu.uci.ics.jung.FadingNodeLayoutKey";
    private Object key = null;

    public Dimension getCurrentSize() {
        return this.layout.getCurrentSize();
    }

    public FadingVertexLayout(int fadelevels, Layout layout) {
        this.fadelevels = fadelevels;
        this.layout = layout;
        this.hiddenNodes = new HashSet();
    }

    public void initialize(Dimension d) {
        this.layout.initialize(d);
        Graph graph = this.layout.getGraph();
        Iterator iter = graph.getVertices().iterator();
        while (iter.hasNext()) {
            ArchetypeVertex vert = (ArchetypeVertex)iter.next();
            vert.addUserDatum(this.getFadingKey(), new FadingVertexLayoutData(), UserData.REMOVE);
        }
    }

    public String getStatus() {
        return this.layout.getStatus();
    }

    public Set getVisibleEdges() {
        return this.layout.getVisibleEdges();
    }

    public Graph getGraph() {
        return this.layout.getGraph();
    }

    public Vertex getVertex(double x, double y) {
        return this.layout.getVertex(x, y);
    }

    public Vertex getVertex(double x, double y, double maxDistance) {
        return this.layout.getVertex(x, y, maxDistance);
    }

    public void advancePositions() {
        this.tick();
        this.layout.advancePositions();
    }

    protected void tick() {
        Graph graph = this.layout.getGraph();
        Iterator iter = graph.getVertices().iterator();
        while (iter.hasNext()) {
            Vertex av = (Vertex)iter.next();
            FadingVertexLayoutData fnvd = (FadingVertexLayoutData)av.getUserDatum(this.getFadingKey());
            if (fnvd.level >= this.fadelevels) continue;
            ++fnvd.level;
            if (!fnvd.isHidden) continue;
            this.moveOutward(av, this.getX(av), this.getY(av), 1.01);
        }
    }

    public Object getFadingKey() {
        if (this.key == null) {
            this.key = new Pair(this, FADINGNODEVIZX);
        }
        return this.key;
    }

    public void applyFilter(Graph g_int) {
        this.layout.applyFilter(g_int);
        Graph graph = this.layout.getGraph();
        Set nowShowingNodes = GraphUtils.getEqualVertices(g_int.getVertices(), graph);
        int newlyShowing = 0;
        int newlyHidden = 0;
        Iterator iter = graph.getVertices().iterator();
        while (iter.hasNext()) {
            FadingVertexLayoutData fnvd;
            ArchetypeVertex vert = (ArchetypeVertex)iter.next();
            if (nowShowingNodes.contains(vert) && this.hiddenNodes.contains(vert)) {
                ++newlyShowing;
                this.hiddenNodes.remove(vert);
                fnvd = (FadingVertexLayoutData)vert.getUserDatum(this.getFadingKey());
                fnvd.isHidden = false;
                fnvd.level = 0;
                this.moveVertexPrettily((Vertex)vert.getEqualVertex(g_int));
                continue;
            }
            if (nowShowingNodes.contains(vert) || this.hiddenNodes.contains(vert)) continue;
            ++newlyHidden;
            this.hiddenNodes.add(vert);
            fnvd = (FadingVertexLayoutData)vert.getUserDatum(this.getFadingKey());
            fnvd.isHidden = true;
            fnvd.level = 0;
        }
    }

    protected void moveVertexPrettily(Vertex vert) {
        Set s = vert.getNeighbors();
        if (s.size() == 0) {
            return;
        }
        double x = 0.0;
        double y = 0.0;
        Iterator iter = s.iterator();
        while (iter.hasNext()) {
            Vertex neighbor = (Vertex)iter.next();
            x += this.layout.getX(neighbor);
            y += this.layout.getY(neighbor);
        }
        this.moveOutward(vert, x /= (double)s.size(), y /= (double)s.size(), 0.9);
    }

    protected void moveOutward(Vertex vert, double x, double y, double speed) {
        x -= (double)(this.currentSize.width / 2);
        y -= (double)(this.currentSize.height / 2);
        x *= speed;
        y *= speed;
        this.forceMove(vert, x += (double)(this.currentSize.width / 2), y += (double)(this.currentSize.height / 2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(Dimension d) {
        if (this.currentSize != null) {
            Dimension dimension = this.currentSize;
            synchronized (dimension) {
                this.currentSize = d;
            }
        } else {
            this.currentSize = d;
        }
        this.layout.resize(d);
    }

    public void restart() {
        this.layout.restart();
    }

    public double getX(Vertex vert) {
        return this.layout.getX(vert);
    }

    public double getY(Vertex vert) {
        return this.layout.getY(vert);
    }

    public Set getVisibleVertices() {
        return this.layout.getGraph().getVertices();
    }

    public int getFadeLevel(Vertex v) {
        return ((FadingVertexLayoutData)v.getUserDatum((Object)this.getFadingKey())).level;
    }

    public boolean isHidden(Vertex v) {
        return ((FadingVertexLayoutData)v.getUserDatum((Object)this.getFadingKey())).isHidden;
    }

    public void lockVertex(Vertex vert) {
        this.layout.lockVertex(vert);
    }

    public void unlockVertex(Vertex vert) {
        this.layout.unlockVertex(vert);
    }

    public boolean isLocked(Vertex v) {
        return this.layout.isLocked(v);
    }

    public void forceMove(Vertex picked, double x, double y) {
        this.layout.forceMove(picked, x, y);
    }

    public int getMaxLevel() {
        return this.fadelevels;
    }

    public boolean isIncremental() {
        return this.layout.isIncremental();
    }

    public boolean incrementsAreDone() {
        return this.layout.incrementsAreDone();
    }

    public Layout getGraphLayout() {
        return this;
    }

    public Point2D getLocation(ArchetypeVertex v) {
        return this.layout.getLocation(v);
    }

    public Iterator getVertexIterator() {
        return this.layout.getVertexIterator();
    }

    public class FadingVertexLayoutData {
        public boolean isHidden = false;
        public int level = 0;
    }
}

