/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.utils;

import edu.uci.ics.jung.algorithms.cluster.ClusterSet;
import edu.uci.ics.jung.algorithms.cluster.WeakComponentClusterer;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.Pair;
import java.util.Iterator;

public class GraphProperties {
    public static boolean isConnected(Graph g) {
        WeakComponentClusterer wc = new WeakComponentClusterer();
        ClusterSet cs = wc.extract(g);
        return cs.size() == 1;
    }

    public static boolean isSimple(Graph g) {
        return !GraphProperties.containsSelfLoops(g) && !GraphProperties.containsParallelEdges(g);
    }

    public static boolean containsSelfLoops(Graph g) {
        Iterator vIt = g.getVertices().iterator();
        while (vIt.hasNext()) {
            Vertex v = (Vertex)vIt.next();
            if (v.findEdge(v) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean containsParallelEdges(Graph g) {
        Iterator eIt = g.getEdges().iterator();
        while (eIt.hasNext()) {
            Vertex anotherEndPoint;
            Edge e = (Edge)eIt.next();
            Pair endpoints = e.getEndpoints();
            Vertex anEndPoint = (Vertex)endpoints.getFirst();
            if (anEndPoint.findEdgeSet(anotherEndPoint = (Vertex)endpoints.getSecond()).size() <= 1) continue;
            return true;
        }
        return false;
    }
}

