/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.predicates;

import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.DirectedEdge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.SparseTree;
import edu.uci.ics.jung.graph.predicates.EdgePredicate;

public class TreePredicate
extends EdgePredicate {
    protected static TreePredicate instance = null;

    public boolean evaluateEdge(ArchetypeEdge e) {
        if (!Graph.DIRECTED_EDGE.evaluate((Object)e)) {
            return false;
        }
        DirectedEdge de = (DirectedEdge)e;
        Vertex dest = de.getDest();
        if (dest.containsUserDatumKey(SparseTree.SPARSE_ROOT_KEY)) {
            return false;
        }
        if (dest.inDegree() > 0) {
            return false;
        }
        Vertex src = de.getSource();
        return src.containsUserDatumKey(SparseTree.IN_TREE_KEY);
    }

    public static TreePredicate getInstance() {
        if (instance == null) {
            instance = new TreePredicate();
        }
        return instance;
    }
}

