/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareNavigator;
import org.eclipse.compare.ICompareNavigator;
import org.eclipse.compare.INavigatable;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.ICache;
import org.eclipse.team.core.ICacheListener;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.ResourceDiffCompareInput;
import org.eclipse.team.internal.ui.mapping.ResourceMarkAsMergedHandler;
import org.eclipse.team.internal.ui.mapping.ResourceMergeHandler;
import org.eclipse.team.internal.ui.synchronize.LocalResourceSaveableComparison;
import org.eclipse.team.ui.mapping.ISynchronizationCompareInput;
import org.eclipse.team.ui.mapping.SaveableComparison;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.Saveable;

public class ModelCompareEditorInput
extends SaveableCompareEditorInput
implements IPropertyChangeListener {
    private static final String IGNORE_WHITSPACE_PAGE_PROPERTY = "org.eclipse.compare.IGNORE_WHITESPACE";
    private final ModelSynchronizeParticipant participant;
    private final ICompareInput input;
    private final ICacheListener contextListener;
    private final ISynchronizePageConfiguration synchronizeConfiguration;
    static /* synthetic */ Class class$0;

    public ModelCompareEditorInput(ModelSynchronizeParticipant participant, ICompareInput input, IWorkbenchPage page, ISynchronizePageConfiguration synchronizeConfiguration) {
        super(ModelCompareEditorInput.createCompareConfiguration(synchronizeConfiguration), page);
        this.synchronizeConfiguration = synchronizeConfiguration;
        Assert.isNotNull((Object)participant);
        Assert.isNotNull((Object)input);
        this.participant = participant;
        this.input = input;
        this.contextListener = new ICacheListener(){

            public void cacheDisposed(ICache cache) {
                ModelCompareEditorInput.this.closeEditor(true);
            }
        };
        this.getCompareConfiguration().addPropertyChangeListener((IPropertyChangeListener)this);
        this.setTitle(NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_title, (Object[])new String[]{input.getName()}));
    }

    private static CompareConfiguration createCompareConfiguration(ISynchronizePageConfiguration pageConfiguration) {
        CompareConfiguration compareConfiguration = new CompareConfiguration();
        Object o = pageConfiguration.getProperty(IGNORE_WHITSPACE_PAGE_PROPERTY);
        if (o != null && (o.equals(Boolean.TRUE) || o.equals(Boolean.FALSE))) {
            compareConfiguration.setProperty("IGNORE_WHITESPACE", o);
        }
        return compareConfiguration;
    }

    protected void contentsCreated() {
        super.contentsCreated();
        this.participant.getContext().getCache().addCacheListener(this.contextListener);
    }

    protected void handleDispose() {
        super.handleDispose();
        this.participant.getContext().getCache().removeCacheListener(this.contextListener);
        this.getCompareConfiguration().removePropertyChangeListener((IPropertyChangeListener)this);
        ICompareNavigator navigator = (ICompareNavigator)this.synchronizeConfiguration.getProperty("org.eclipse.team.ui.P_INPUT_NAVIGATOR");
        if (navigator != null && navigator == super.getNavigator()) {
            this.synchronizeConfiguration.setProperty("org.eclipse.team.ui.P_INPUT_NAVIGATOR", new CompareNavigator(){

                protected INavigatable[] getNavigatables() {
                    return new INavigatable[0];
                }
            });
        }
    }

    protected Saveable createSaveable() {
        ISynchronizationCompareInput mci;
        SaveableComparison compareModel;
        if (this.input instanceof ISynchronizationCompareInput && (compareModel = (mci = (ISynchronizationCompareInput)this.input).getSaveable()) != null) {
            return compareModel;
        }
        return super.createSaveable();
    }

    protected ICompareInput prepareCompareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask(TeamUIMessages.SyncInfoCompareInput_3, 100);
        monitor.setTaskName(TeamUIMessages.SyncInfoCompareInput_3);
        try {
            try {
                ISynchronizationCompareInput adapter = this.asModelCompareInput(this.input);
                if (adapter != null) {
                    adapter.prepareInput(this.getCompareConfiguration(), Policy.subMonitorFor(monitor, 100));
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
        return this.input;
    }

    private ISynchronizationCompareInput asModelCompareInput(ICompareInput input) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.team.ui.mapping.ISynchronizationCompareInput");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ISynchronizationCompareInput)Utils.getAdapter(input, clazz);
    }

    public boolean matches(Object object, ISynchronizeParticipant participant) {
        if (participant == this.participant && this.input instanceof ISynchronizationCompareInput) {
            ISynchronizationCompareInput mci = (ISynchronizationCompareInput)this.input;
            return mci.isCompareInputFor(object);
        }
        return false;
    }

    public String getToolTipText() {
        ISynchronizationCompareInput adapter = this.asModelCompareInput(this.input);
        String fullPath = adapter != null ? adapter.getFullPath() : this.getName();
        return NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_tooltip, (Object[])new String[]{Utils.shortenText(100, this.participant.getName()), fullPath});
    }

    protected void fireInputChange() {
        if (this.input instanceof ResourceDiffCompareInput) {
            ResourceDiffCompareInput rdci = (ResourceDiffCompareInput)this.input;
            rdci.fireChange();
        }
    }

    public void registerContextMenu(MenuManager menu, ISelectionProvider provider) {
        super.registerContextMenu(menu, provider);
        Saveable saveable = this.getSaveable();
        if (saveable instanceof LocalResourceSaveableComparison) {
            menu.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    ModelCompareEditorInput.this.handleMenuAboutToShow(manager);
                }
            });
        }
    }

    protected void handleMenuAboutToShow(IMenuManager manager) {
        StructuredSelection selection = new StructuredSelection((Object)((ResourceDiffCompareInput)this.getCompareInput()).getResource());
        final ResourceMarkAsMergedHandler markAsMergedHandler = new ResourceMarkAsMergedHandler(this.getSynchronizeConfiguration());
        markAsMergedHandler.updateEnablement((IStructuredSelection)selection);
        Action markAsMergedAction = new Action(TeamUIMessages.ModelCompareEditorInput_0){

            public void run() {
                try {
                    markAsMergedHandler.execute(new ExecutionEvent());
                }
                catch (ExecutionException e) {
                    TeamUIPlugin.log(4, e.getMessage(), e);
                }
            }
        };
        Utils.initAction((IAction)markAsMergedAction, "action.markAsMerged.");
        markAsMergedAction.setEnabled(markAsMergedAction.isEnabled());
        final ResourceMergeHandler mergeHandler = new ResourceMergeHandler(this.getSynchronizeConfiguration(), false);
        mergeHandler.updateEnablement((IStructuredSelection)selection);
        Action mergeAction = new Action(TeamUIMessages.ModelCompareEditorInput_1){

            public void run() {
                try {
                    mergeHandler.execute(new ExecutionEvent());
                }
                catch (ExecutionException e) {
                    TeamUIPlugin.log(4, e.getMessage(), e);
                }
            }
        };
        Utils.initAction((IAction)mergeAction, "action.merge.");
        mergeAction.setEnabled(markAsMergedAction.isEnabled());
        final ResourceMergeHandler overwriteHandler = new ResourceMergeHandler(this.getSynchronizeConfiguration(), true);
        overwriteHandler.updateEnablement((IStructuredSelection)selection);
        Action overwriteAction = new Action(TeamUIMessages.ModelCompareEditorInput_2){

            public void run() {
                try {
                    overwriteHandler.execute(new ExecutionEvent());
                }
                catch (ExecutionException e) {
                    TeamUIPlugin.log(4, e.getMessage(), e);
                }
            }
        };
        Utils.initAction((IAction)overwriteAction, "action.overwrite.");
        overwriteAction.setEnabled(markAsMergedAction.isEnabled());
        manager.insertAfter("additions", (IContributionItem)new Separator("merge"));
        manager.insertAfter("merge", (IContributionItem)new Separator("overwrite"));
        manager.insertAfter("merge", (IAction)markAsMergedAction);
        manager.insertAfter("merge", (IAction)mergeAction);
        manager.insertAfter("overwrite", (IAction)overwriteAction);
    }

    protected ISynchronizePageConfiguration getSynchronizeConfiguration() {
        return this.synchronizeConfiguration;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("IGNORE_WHITESPACE")) {
            this.synchronizeConfiguration.setProperty(IGNORE_WHITSPACE_PAGE_PROPERTY, event.getNewValue());
        }
    }

    public boolean belongsTo(Object family) {
        return super.belongsTo(family) || family == this.participant;
    }

    public synchronized ICompareNavigator getNavigator() {
        if (this.isSelectedInSynchronizeView()) {
            ICompareNavigator nav = (ICompareNavigator)this.synchronizeConfiguration.getProperty("org.eclipse.team.ui.P_NAVIGATOR");
            this.synchronizeConfiguration.setProperty("org.eclipse.team.ui.P_INPUT_NAVIGATOR", super.getNavigator());
            return nav;
        }
        return super.getNavigator();
    }

    private boolean isSelectedInSynchronizeView() {
        ISelection s = this.synchronizeConfiguration.getSite().getSelectionProvider().getSelection();
        if (s instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)s;
            Object element = ss.getFirstElement();
            return this.matches(element, this.participant);
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ModelCompareEditorInput) {
            ModelCompareEditorInput other = (ModelCompareEditorInput)((Object)obj);
            return other.input.equals(this.input) && other.participant.equals(this.participant);
        }
        return false;
    }

    public int hashCode() {
        return this.input.hashCode();
    }
}

