/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import com.ibm.icu.text.MessageFormat;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.contentassist.SubjectControlContentAssistant;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.search.internal.core.text.PatternConstructor;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.text.FileSearchPage;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.internal.ui.text.RegExContentAssistProcessor;
import org.eclipse.search.internal.ui.util.ExceptionHandler;
import org.eclipse.search.internal.ui.util.ExtendedDialogWindow;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.text.PositionTracker;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.GlobalBuildAction;
import org.eclipse.ui.contentassist.ContentAssistHandler;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

class ReplaceDialog2
extends ExtendedDialogWindow {
    private static final String SETTINGS_GROUP = "ReplaceDialog2";
    private static final String SETTINGS_REPLACE_WITH = "replace_with";
    private static final int REPLACE = 1025;
    private static final int REPLACE_ALL_IN_FILE = 1026;
    private static final int REPLACE_ALL = 1027;
    private static final int SKIP = 1028;
    private static final int SKIP_FILE = 1029;
    private static final int SKIP_ALL = 1030;
    private Combo fTextField;
    private Button fReplaceWithRegex;
    private Button fReplaceButton;
    private Button fReplaceAllInFileButton;
    private Button fReplaceAllButton;
    private Button fSkipButton;
    private Button fSkipFileButton;
    private List fMarkers;
    private boolean fSkipReadonly = false;
    private IReusableEditor fEditor;
    private FileSearchPage fPage;
    private ContentAssistHandler fReplaceContentAssistHandler;
    private Label fStatusLabel;
    private boolean fSaved = false;

    protected ReplaceDialog2(Shell parentShell, IFile[] entries, FileSearchPage page) {
        super(parentShell);
        Assert.isNotNull((Object)entries);
        Assert.isNotNull((Object)page.getInput());
        this.fPage = page;
        this.fMarkers = new ArrayList();
        this.initializeMarkers(entries);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return SearchPlugin.getDefault().getDialogSettingsSection("DialogBounds_ReplaceDialog2");
    }

    private FileSearchQuery getQuery() {
        return (FileSearchQuery)this.fPage.getInput().getQuery();
    }

    private void initializeMarkers(IFile[] entries) {
        int j = 0;
        while (j < entries.length) {
            IFile entry = entries[j];
            Match[] matches = this.fPage.getDisplayedMatches(entry);
            int i = 0;
            while (i < matches.length) {
                this.fMarkers.add(matches[i]);
                ++i;
            }
            ++j;
        }
    }

    public void create() {
        super.create();
        Shell shell = this.getShell();
        shell.setText(this.getDialogTitle());
        this.gotoCurrentMarker();
        this.enableButtons();
        if (!this.canReplace()) {
            this.statusMessage(true, MessageFormat.format((String)SearchMessages.ReplaceDialog2_nomatches_error, (Object[])new String[]{this.getQuery().getSearchString()}));
        }
    }

    public int open() {
        boolean wasAutobuild = false;
        try {
            wasAutobuild = this.disableAutobuild();
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), this.getDialogTitle(), SearchMessages.ReplaceDialog2_error_disableAutobuild);
        }
        try {
            int n = super.open();
            return n;
        }
        finally {
            if (wasAutobuild) {
                try {
                    this.restoreAutobuild();
                }
                catch (CoreException e1) {
                    ExceptionHandler.handle(e1, this.getShell(), this.getDialogTitle(), SearchMessages.ReplaceDialog2_error_restoreAutobuild);
                    return 1;
                }
            }
        }
    }

    private void restoreAutobuild() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        description.setAutoBuilding(true);
        workspace.setDescription(description);
        if (this.fSaved) {
            new GlobalBuildAction(this.fPage.getSite().getWorkbenchWindow(), 10).run();
        }
    }

    private boolean disableAutobuild() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        boolean autobuild = workspace.isAutoBuilding();
        if (autobuild) {
            IWorkspaceDescription description = workspace.getDescription();
            description.setAutoBuilding(false);
            workspace.setDescription(description);
        }
        return autobuild;
    }

    protected Control createPageArea(Composite parent) {
        String[] previousReplaceWith;
        this.initializeDialogUnits((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.search.replace_dialog_context");
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        result.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.initializeDialogUnits((Control)result);
        FileSearchQuery query = this.getQuery();
        Label label = new Label(result, 0);
        label.setText(SearchMessages.ReplaceDialog_replace_label);
        Text clabel = new Text(result, 2056);
        clabel.setText(query.getSearchString());
        GridData gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        clabel.setLayoutData((Object)gd);
        label = new Label(result, 0);
        label.setText(SearchMessages.ReplaceDialog_with_label);
        this.fTextField = new Combo(result, 4);
        gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        this.fTextField.setLayoutData((Object)gd);
        this.fTextField.setFocus();
        IDialogSettings settings = SearchPlugin.getDefault().getDialogSettings().getSection(SETTINGS_GROUP);
        if (settings != null && (previousReplaceWith = settings.getArray(SETTINGS_REPLACE_WITH)) != null) {
            this.fTextField.setItems(previousReplaceWith);
            this.fTextField.select(0);
        }
        new Label(result, 0);
        this.fReplaceWithRegex = new Button(result, 32);
        this.fReplaceWithRegex.setText(SearchMessages.ReplaceDialog_isRegex_label);
        this.fReplaceWithRegex.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReplaceDialog2.this.setContentAssistsEnablement(ReplaceDialog2.this.fReplaceWithRegex.getSelection());
            }
        });
        if (query.isRegexSearch()) {
            this.fReplaceWithRegex.setSelection(true);
        } else {
            this.fReplaceWithRegex.setSelection(false);
            this.fReplaceWithRegex.setEnabled(false);
        }
        this.fStatusLabel = new Label(result, 0);
        gd = new GridData(768);
        gd.verticalAlignment = 1024;
        gd.horizontalSpan = 2;
        this.fStatusLabel.setLayoutData((Object)gd);
        this.setContentAssistsEnablement(this.fReplaceWithRegex.getSelection());
        ReplaceDialog2.applyDialogFont((Control)result);
        return result;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.fReplaceButton = this.createActionButton(composite, 1025, SearchMessages.ReplaceDialog_replace, true);
        this.fReplaceAllInFileButton = this.createActionButton(composite, 1026, SearchMessages.ReplaceDialog_replaceAllInFile, false);
        Label filler = new Label(composite, 0);
        filler.setLayoutData((Object)new GridData(768));
        this.fReplaceAllButton = this.createActionButton(composite, 1027, SearchMessages.ReplaceDialog_replaceAll, false);
        this.fSkipButton = this.createActionButton(composite, 1028, SearchMessages.ReplaceDialog_skip, false);
        this.fSkipFileButton = this.createActionButton(composite, 1029, SearchMessages.ReplaceDialog_skipFile, false);
        filler = new Label(composite, 0);
        filler.setLayoutData((Object)new GridData(768));
        super.createButtonsForButtonBar(composite);
        layout.numColumns = 4;
        return composite;
    }

    private void enableButtons() {
        this.fSkipButton.setEnabled(this.hasNextMarker());
        this.fSkipFileButton.setEnabled(this.hasNextFile());
        this.fReplaceButton.setEnabled(this.canReplace());
        this.fReplaceAllInFileButton.setEnabled(this.canReplace());
        this.fReplaceAllButton.setEnabled(this.canReplace());
    }

    protected void buttonPressed(int buttonId) {
        block21: {
            if (buttonId == 1) {
                super.buttonPressed(buttonId);
                return;
            }
            final String replaceText = this.fTextField.getText();
            this.statusMessage(false, "");
            try {
                try {
                    switch (buttonId) {
                        case 1028: {
                            this.skip();
                            break;
                        }
                        case 1029: {
                            this.skipFile();
                            break;
                        }
                        case 1025: {
                            this.run(new ReplaceOperation(){

                                protected void doReplace(IProgressMonitor pm) throws BadLocationException, CoreException {
                                    ReplaceDialog2.this.replace(pm, replaceText);
                                }
                            }, (IResource)this.getCurrentMarker().getElement());
                            this.gotoCurrentMarker();
                            break;
                        }
                        case 1026: {
                            this.run(new ReplaceOperation(){

                                protected void doReplace(IProgressMonitor pm) throws BadLocationException, CoreException {
                                    ReplaceDialog2.this.replaceInFile(pm, replaceText);
                                }
                            }, (IResource)this.getCurrentMarker().getElement());
                            this.gotoCurrentMarker();
                            break;
                        }
                        case 1027: {
                            this.run(new ReplaceOperation(){

                                protected void doReplace(IProgressMonitor pm) throws BadLocationException, CoreException {
                                    ReplaceDialog2.this.replaceAll(pm, replaceText);
                                }
                            }, (IResource)ResourcesPlugin.getWorkspace().getRoot());
                            this.gotoCurrentMarker();
                        }
                    }
                }
                catch (InvocationTargetException e) {
                    Throwable targetException = e.getTargetException();
                    if (targetException instanceof PatternSyntaxException) {
                        String format = SearchMessages.ReplaceDialog2_regexError_format;
                        String message = MessageFormat.format((String)format, (Object[])new Object[]{targetException.getLocalizedMessage()});
                        this.statusMessage(true, message);
                    } else {
                        String message = Messages.format(SearchMessages.ReplaceDialog_error_unable_to_replace, ((IFile)this.getCurrentMarker().getElement()).getName());
                        ExceptionHandler.handle(e, this.getParentShell(), this.getDialogTitle(), message);
                    }
                    if (!this.canReplace()) {
                        this.close();
                    } else {
                        this.enableButtons();
                    }
                }
                catch (InterruptedException interruptedException) {
                    block22: {
                        if (this.canReplace()) break block22;
                        this.close();
                        break block21;
                    }
                    this.enableButtons();
                }
            }
            finally {
                if (!this.canReplace()) {
                    this.close();
                } else {
                    this.enableButtons();
                }
            }
        }
    }

    private void run(ReplaceOperation operation, IResource resource) throws InvocationTargetException, InterruptedException {
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        ISchedulingRule rule = ruleFactory.modifyRule(resource);
        PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)this, (IRunnableWithProgress)operation, rule);
    }

    private Match getCurrentMarker() {
        return (Match)this.fMarkers.get(0);
    }

    private void replace(IProgressMonitor pm, String replacementText) throws BadLocationException, CoreException {
        Match marker = this.getCurrentMarker();
        pm.beginTask(SearchMessages.ReplaceDialog_task_replace, 10);
        this.replaceInFile(pm, (IFile)marker.getElement(), replacementText, new Match[]{marker});
    }

    private void replaceInFile(IProgressMonitor pm, String replacementText) throws BadLocationException, CoreException {
        Match firstMarker = this.getCurrentMarker();
        Match[] markers = this.collectMarkers((IFile)firstMarker.getElement());
        pm.beginTask(Messages.format(SearchMessages.ReplaceDialog_task_replaceInFile, ((IFile)firstMarker.getElement()).getFullPath().toOSString()), 4);
        this.replaceInFile(pm, (IFile)firstMarker.getElement(), replacementText, markers);
    }

    private void replaceAll(IProgressMonitor pm, String replacementText) throws BadLocationException, CoreException {
        int resourceCount = this.countResources();
        pm.beginTask(SearchMessages.ReplaceDialog_task_replace_replaceAll, resourceCount);
        try {
            while (this.fMarkers.size() > 0) {
                this.replaceInFile((IProgressMonitor)new SubProgressMonitor(pm, 1, 0), replacementText);
            }
        }
        finally {
            pm.done();
        }
    }

    private void replaceInFile(IProgressMonitor pm, IFile file, String replacementText, Match[] markers) throws BadLocationException, CoreException {
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.doReplaceInFile(pm, file, replacementText, markers);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doReplaceInFile(IProgressMonitor pm, IFile file, String replacementText, Match[] markers) throws BadLocationException, CoreException {
        Pattern pattern = null;
        FileSearchQuery query = this.getQuery();
        if (query.isRegexSearch()) {
            pattern = this.createReplacePattern(query);
        }
        try {
            if (file.isReadOnly()) {
                if (this.fSkipReadonly) {
                    this.skipFile();
                    return;
                }
                int rc = this.askForSkip(file);
                switch (rc) {
                    case 1: {
                        throw new OperationCanceledException();
                    }
                    case 1029: {
                        this.skipFile();
                        return;
                    }
                    case 1030: {
                        this.fSkipReadonly = true;
                        this.skipFile();
                        return;
                    }
                }
            }
            ITextFileBufferManager bm = FileBuffers.getTextFileBufferManager();
            try {
                bm.connect(file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                ITextFileBuffer fb = bm.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
                boolean wasDirty = fb.isDirty();
                IDocument doc = fb.getDocument();
                int i = 0;
                while (i < markers.length) {
                    PositionTracker tracker = InternalSearchUI.getInstance().getPositionTracker();
                    Match match = markers[i];
                    int offset = match.getOffset();
                    int length = match.getLength();
                    Position currentPosition = tracker.getCurrentPosition(match);
                    if (currentPosition != null) {
                        offset = currentPosition.offset;
                        length = currentPosition.length;
                    }
                    String originalText = doc.get(offset, length);
                    String replacementString = this.computeReplacementString(pattern, originalText, replacementText);
                    doc.replace(offset, length, replacementString);
                    this.fMarkers.remove(match);
                    this.fPage.getInput().removeMatch(match);
                    ++i;
                }
                if (wasDirty) return;
                fb.commit((IProgressMonitor)new SubProgressMonitor(pm, 1), true);
                this.fSaved = true;
                return;
            }
            finally {
                bm.disconnect(file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
        }
        finally {
            pm.done();
        }
    }

    private Pattern createReplacePattern(FileSearchQuery query) {
        return PatternConstructor.createPattern(query.getSearchString(), true, true, query.isCaseSensitive(), false);
    }

    private String computeReplacementString(Pattern pattern, String originalText, String replacementText) {
        if (pattern != null) {
            try {
                return pattern.matcher(originalText).replaceFirst(replacementText);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new PatternSyntaxException(ex.getLocalizedMessage(), replacementText, -1);
            }
        }
        return replacementText;
    }

    private int askForSkip(IFile file) {
        boolean showSkip;
        String message = Messages.format(SearchMessages.ReadOnlyDialog_message, file.getFullPath().toOSString());
        String[] buttonLabels = null;
        boolean bl = showSkip = this.countResources() > 1;
        if (showSkip) {
            String skipLabel = SearchMessages.ReadOnlyDialog_skipFile;
            String skipAllLabel = SearchMessages.ReadOnlyDialog_skipAll;
            buttonLabels = new String[]{skipLabel, skipAllLabel, IDialogConstants.CANCEL_LABEL};
        } else {
            buttonLabels = new String[]{IDialogConstants.CANCEL_LABEL};
        }
        MessageDialog msd = new MessageDialog(this.getShell(), this.getShell().getText(), null, message, 1, buttonLabels, 0);
        int rc = msd.open();
        switch (rc) {
            case 0: {
                return showSkip ? 1029 : 1;
            }
            case 1: {
                return 1030;
            }
        }
        return 1;
    }

    private String getDialogTitle() {
        return SearchMessages.ReplaceDialog_dialog_title;
    }

    private void skip() {
        this.fMarkers.remove(0);
        Assert.isTrue((this.fMarkers.size() > 0 ? 1 : 0) != 0);
        this.gotoCurrentMarker();
    }

    private void skipFile() {
        Match currentMarker = this.getCurrentMarker();
        if (currentMarker == null) {
            return;
        }
        IResource currentFile = (IResource)currentMarker.getElement();
        while (this.fMarkers.size() > 0 && this.getCurrentMarker().getElement().equals(currentFile)) {
            this.fMarkers.remove(0);
        }
        this.gotoCurrentMarker();
    }

    private void gotoCurrentMarker() {
        if (this.fMarkers.size() > 0) {
            Match marker = this.getCurrentMarker();
            Control focusControl = this.getShell().getDisplay().getFocusControl();
            try {
                this.selectEntry(marker);
                ITextEditor editor = null;
                editor = NewSearchUI.reuseEditor() ? this.openEditorReuse(marker) : this.openEditorNoReuse(marker);
                Position p = InternalSearchUI.getInstance().getPositionTracker().getCurrentPosition(marker);
                if (p != null) {
                    editor.selectAndReveal(p.getOffset(), p.getLength());
                } else {
                    editor.selectAndReveal(marker.getOffset(), marker.getLength());
                }
                if (focusControl != null && !focusControl.isDisposed()) {
                    focusControl.setFocus();
                }
            }
            catch (PartInitException partInitException) {
                String message = Messages.format(SearchMessages.ReplaceDialog_error_unable_to_open_text_editor, ((IFile)marker.getElement()).getName());
                MessageDialog.openError((Shell)this.getParentShell(), (String)this.getDialogTitle(), (String)message);
            }
        }
    }

    private void selectEntry(Match marker) {
        ISelection sel = this.fPage.getViewer().getSelection();
        if (!(sel instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)sel;
        IFile file = (IFile)marker.getElement();
        if (ss.size() == 1 && file.equals(ss.getFirstElement())) {
            return;
        }
        this.fPage.getViewer().setSelection((ISelection)new StructuredSelection(marker.getElement()));
    }

    private ITextEditor openEditorNoReuse(Match marker) throws PartInitException {
        IFile file = (IFile)marker.getElement();
        IWorkbenchPage activePage = SearchPlugin.getActivePage();
        if (activePage == null) {
            return null;
        }
        ITextEditor textEditor = this.showOpenTextEditor(activePage, file);
        if (textEditor != null) {
            return textEditor;
        }
        return this.openNewTextEditor(file, activePage);
    }

    private ITextEditor openNewTextEditor(IFile file, IWorkbenchPage activePage) throws PartInitException {
        IEditorDescriptor desc = IDE.getDefaultEditor((IFile)file);
        if (desc != null) {
            String editorID = desc.getId();
            if (desc.isInternal()) {
                IEditorPart editor = activePage.openEditor((IEditorInput)new FileEditorInput(file), editorID);
                if (editor instanceof ITextEditor) {
                    if (editor instanceof IReusableEditor) {
                        this.fEditor = (IReusableEditor)editor;
                    }
                    return (ITextEditor)editor;
                }
                activePage.closeEditor(editor, false);
            }
        }
        IEditorPart editor = activePage.openEditor((IEditorInput)new FileEditorInput(file), "org.eclipse.ui.DefaultTextEditor");
        return (ITextEditor)editor;
    }

    private ITextEditor openEditorReuse(Match marker) throws PartInitException {
        boolean showsSameInputType;
        boolean isOpen;
        IWorkbenchPage page = SearchPlugin.getActivePage();
        IFile file = (IFile)marker.getElement();
        if (page == null) {
            return null;
        }
        ITextEditor textEditor = this.showOpenTextEditor(page, file);
        if (textEditor != null) {
            return textEditor;
        }
        String editorId = null;
        IEditorDescriptor desc = IDE.getDefaultEditor((IFile)file);
        if (desc != null && desc.isInternal()) {
            editorId = desc.getId();
        }
        boolean canBeReused = (isOpen = this.isEditorOpen(page, (IEditorPart)this.fEditor)) && !this.fEditor.isDirty() && !this.isPinned((IEditorPart)this.fEditor);
        boolean bl = showsSameInputType = this.fEditor != null && (editorId == null || this.fEditor.getSite().getId().equals(editorId));
        if (canBeReused) {
            if (showsSameInputType) {
                this.fEditor.setInput((IEditorInput)new FileEditorInput(file));
                page.bringToTop((IWorkbenchPart)this.fEditor);
                return (ITextEditor)this.fEditor;
            }
            page.closeEditor((IEditorPart)this.fEditor, false);
            this.fEditor = null;
        }
        return this.openNewTextEditor(file, page);
    }

    private boolean isEditorOpen(IWorkbenchPage page, IEditorPart editor) {
        if (editor != null) {
            IEditorReference[] parts = page.getEditorReferences();
            int i = 0;
            int j = 0;
            while (j < parts.length) {
                if (editor == parts[i++].getEditor(false)) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    private ITextEditor showOpenTextEditor(IWorkbenchPage page, IFile file) {
        IEditorPart editor = page.findEditor((IEditorInput)new FileEditorInput(file));
        if (editor instanceof ITextEditor) {
            page.bringToTop((IWorkbenchPart)editor);
            return (ITextEditor)editor;
        }
        return null;
    }

    private boolean isPinned(IEditorPart editor) {
        if (editor == null) {
            return false;
        }
        IEditorReference[] editorRefs = editor.getEditorSite().getPage().getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            if (editor.equals(editorRefs[i].getEditor(false))) {
                return editorRefs[i].isPinned();
            }
            ++i;
        }
        return false;
    }

    private int countResources() {
        IResource r = null;
        int count = 0;
        Iterator elements = this.fMarkers.iterator();
        while (elements.hasNext()) {
            Match element = (Match)elements.next();
            if (element.getElement().equals(r)) continue;
            ++count;
            r = (IResource)element.getElement();
        }
        return count;
    }

    private Match[] collectMarkers(IFile resource) {
        ArrayList<Match> matching = new ArrayList<Match>();
        int i = 0;
        while (i < this.fMarkers.size()) {
            Match marker = (Match)this.fMarkers.get(i);
            if (!resource.equals(marker.getElement())) break;
            matching.add(marker);
            ++i;
        }
        Match[] markers = new Match[matching.size()];
        return matching.toArray(markers);
    }

    private boolean hasNextMarker() {
        return this.fMarkers.size() > 1;
    }

    private boolean hasNextFile() {
        if (!this.hasNextMarker()) {
            return false;
        }
        IResource currentFile = (IResource)this.getCurrentMarker().getElement();
        int i = 0;
        while (i < this.fMarkers.size()) {
            if (!((Match)this.fMarkers.get(i)).getElement().equals(currentFile)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean canReplace() {
        return this.fMarkers.size() > 0;
    }

    public static SubjectControlContentAssistant createContentAssistant(boolean isFind) {
        SubjectControlContentAssistant contentAssistant = new SubjectControlContentAssistant();
        contentAssistant.setRestoreCompletionProposalSize(SearchPlugin.getDefault().getDialogSettings());
        RegExContentAssistProcessor processor = new RegExContentAssistProcessor(isFind);
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        contentAssistant.setContextInformationPopupOrientation(20);
        contentAssistant.setInformationControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent);
            }
        });
        return contentAssistant;
    }

    private void setContentAssistsEnablement(boolean enable) {
        if (enable) {
            if (this.fReplaceContentAssistHandler == null) {
                this.fReplaceContentAssistHandler = ContentAssistHandler.createHandlerForCombo((Combo)this.fTextField, (SubjectControlContentAssistant)ReplaceDialog2.createContentAssistant(false));
            }
            this.fReplaceContentAssistHandler.setEnabled(true);
        } else {
            if (this.fReplaceContentAssistHandler == null) {
                return;
            }
            this.fReplaceContentAssistHandler.setEnabled(false);
        }
    }

    private void statusMessage(boolean error, String message) {
        this.fStatusLabel.setText(message);
        if (error) {
            this.fStatusLabel.setForeground(JFaceColors.getErrorText((Display)this.fStatusLabel.getDisplay()));
        } else {
            this.fStatusLabel.setForeground(null);
        }
        if (error) {
            this.getShell().getDisplay().beep();
        }
    }

    public boolean close() {
        String[] items = this.fTextField.getItems();
        ArrayList<String> history = new ArrayList<String>();
        history.add(this.fTextField.getText());
        int historySize = Math.min(items.length, 6);
        int i = 0;
        while (i < historySize) {
            String curr = items[i];
            if (!history.contains(curr)) {
                history.add(curr);
            }
            ++i;
        }
        IDialogSettings settings = SearchPlugin.getDefault().getDialogSettings().addNewSection(SETTINGS_GROUP);
        settings.put(SETTINGS_REPLACE_WITH, history.toArray(new String[history.size()]));
        return super.close();
    }

    private static abstract class ReplaceOperation
    implements IRunnableWithProgress {
        private ReplaceOperation() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException {
            try {
                this.doReplace(monitor);
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
        }

        protected abstract void doReplace(IProgressMonitor var1) throws BadLocationException, CoreException, IOException;
    }
}

