/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Comparator;
import java.util.Set;
import org.apache.commons.collections.Bag;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.SortedBag;

public class BagUtils {
    private BagUtils() {
    }

    public static Bag predicatedBag(Bag bag, Predicate predicate) {
        return new PredicatedBag(bag, predicate);
    }

    public static SortedBag predicatedSortedBag(SortedBag sortedBag, Predicate predicate) {
        return new PredicatedSortedBag(sortedBag, predicate);
    }

    public static Bag synchronizedBag(Bag bag) {
        return new SynchronizedBag(bag);
    }

    public static SortedBag synchronizedSortedBag(SortedBag sortedBag) {
        return new SynchronizedSortedBag(sortedBag);
    }

    public static Bag unmodifiableBag(Bag bag) {
        return new UnmodifiableBag(bag);
    }

    public static SortedBag unmodifiableSortedBag(SortedBag sortedBag) {
        return new UnmodifiableSortedBag(sortedBag);
    }

    static class PredicatedBag
    extends CollectionUtils.PredicatedCollection
    implements Bag {
        public PredicatedBag(Bag bag, Predicate predicate) {
            super(bag, predicate);
        }

        public boolean add(Object object, int n) {
            this.validate(object);
            return this.getBag().add(object, n);
        }

        private Bag getBag() {
            return (Bag)this.collection;
        }

        public int getCount(Object object) {
            return this.getBag().getCount(object);
        }

        public boolean remove(Object object, int n) {
            return this.getBag().remove(object, n);
        }

        public Set uniqueSet() {
            return this.getBag().uniqueSet();
        }
    }

    static class PredicatedSortedBag
    extends PredicatedBag
    implements SortedBag {
        public PredicatedSortedBag(SortedBag sortedBag, Predicate predicate) {
            super(sortedBag, predicate);
        }

        public Comparator comparator() {
            return this.getSortedBag().comparator();
        }

        public Object first() {
            return this.getSortedBag().first();
        }

        private SortedBag getSortedBag() {
            return (SortedBag)this.collection;
        }

        public Object last() {
            return this.getSortedBag().last();
        }
    }

    static class SynchronizedBag
    extends CollectionUtils.SynchronizedCollection
    implements Bag {
        public SynchronizedBag(Bag bag) {
            super(bag);
        }

        public synchronized boolean add(Object object, int n) {
            return this.getBag().add(object, n);
        }

        private Bag getBag() {
            return (Bag)this.collection;
        }

        public synchronized int getCount(Object object) {
            return this.getBag().getCount(object);
        }

        public synchronized boolean remove(Object object, int n) {
            return this.getBag().remove(object, n);
        }

        public synchronized Set uniqueSet() {
            return this.getBag().uniqueSet();
        }
    }

    static class SynchronizedSortedBag
    extends SynchronizedBag
    implements SortedBag {
        public SynchronizedSortedBag(SortedBag sortedBag) {
            super(sortedBag);
        }

        public synchronized Comparator comparator() {
            return this.getSortedBag().comparator();
        }

        public synchronized Object first() {
            return this.getSortedBag().first();
        }

        private SortedBag getSortedBag() {
            return (SortedBag)this.collection;
        }

        public synchronized Object last() {
            return this.getSortedBag().last();
        }
    }

    static class UnmodifiableBag
    extends CollectionUtils.UnmodifiableCollection
    implements Bag {
        public UnmodifiableBag(Bag bag) {
            super(bag);
        }

        public boolean add(Object object, int n) {
            throw new UnsupportedOperationException();
        }

        private Bag getBag() {
            return (Bag)this.collection;
        }

        public int getCount(Object object) {
            return ((Bag)this.collection).getCount(object);
        }

        public boolean remove(Object object, int n) {
            throw new UnsupportedOperationException();
        }

        public Set uniqueSet() {
            return ((Bag)this.collection).uniqueSet();
        }
    }

    static class UnmodifiableSortedBag
    extends UnmodifiableBag
    implements SortedBag {
        public UnmodifiableSortedBag(SortedBag sortedBag) {
            super(sortedBag);
        }

        public Comparator comparator() {
            return this.getSortedBag().comparator();
        }

        public Object first() {
            return this.getSortedBag().first();
        }

        private SortedBag getSortedBag() {
            return (SortedBag)this.collection;
        }

        public Object last() {
            return this.getSortedBag().last();
        }
    }
}

