/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.kent.cs.kmf.xmi;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import uk.ac.kent.cs.kmf.xmi.IXMIFile;

public class XMIFile
implements IXMIFile {
    protected String xmiVersion = "1.0";
    protected String encoding = "UTF-8";
    protected boolean printTimestamp = true;
    protected String timestamp;
    protected boolean verified;
    protected Extensions extensions;
    protected Extension extension;
    protected String owner;
    protected String contact;
    protected String longDescription;
    protected String shortDescription;
    protected String exporter = "Kent Modeling Framework [XMI]";
    protected String exporterVersion = "1.0";
    protected String exporterID;
    protected String notice;
    protected List models = new Vector();
    protected List metamodels = new Vector();
    protected List metametamodels = new Vector();
    protected List imports = new Vector();
    protected Difference difference;
    protected Add add;
    protected Delete delete;
    protected Replace replace;
    protected Reference reference;
    protected String fileName;
    protected Vector topObjects = new Vector();

    public XMIFile(String fileName) {
        this.fileName = fileName;
    }

    public boolean hasHeader() {
        return this.hasDocumentation() || this.hasModels() || this.hasMetamodels() || this.hasMetametamodels() || this.hasImports();
    }

    public String getXMIVersion() {
        return this.xmiVersion;
    }

    public void setXMIVersion(String xmiVersion) {
        this.xmiVersion = xmiVersion;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean getPrintTimestamp() {
        return this.printTimestamp;
    }

    public void setPrintTimestamp(boolean printTimestamp) {
        this.printTimestamp = printTimestamp;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public boolean getVerified() {
        return this.verified;
    }

    public void setVerified(boolean verified) {
        this.verified = verified;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Extensions extensions) {
        this.extensions = extensions;
    }

    public Extension getExtension() {
        return this.extension;
    }

    public void setExtension(Extension extension) {
        this.extension = extension;
    }

    public boolean hasDocumentation() {
        return this.owner != null || this.contact != null || this.longDescription != null || this.shortDescription != null || this.exporter != null || this.exporterVersion != null || this.notice != null;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getContact() {
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public String getExporter() {
        return this.exporter;
    }

    public void setExporter(String exporter) {
        this.exporter = exporter;
    }

    public String getExporterVersion() {
        return this.exporterVersion;
    }

    public void setExporterVersion(String exporterVersion) {
        this.exporterVersion = exporterVersion;
    }

    public String getExporterID() {
        return this.exporterID;
    }

    public void setExporterID(String exporterID) {
        this.exporterID = exporterID;
    }

    public String getNotice() {
        return this.notice;
    }

    public void setNotice(String notice) {
        this.notice = notice;
    }

    public boolean hasModels() {
        return this.models.size() != 0;
    }

    public List getModels() {
        return this.models;
    }

    public void addModel(Model model) {
        this.models.add(model);
    }

    public boolean hasMetamodels() {
        return this.metamodels.size() != 0;
    }

    public List getMetamodels() {
        return this.metamodels;
    }

    public void addMetamodel(Metamodel metamodel) {
        this.metamodels.add(metamodel);
    }

    public boolean hasMetametamodels() {
        return this.metametamodels.size() != 0;
    }

    public List getMetametamodels() {
        return this.metametamodels;
    }

    public void addMetametamodel(Metametamodel metametamodel) {
        this.metametamodels.add(metametamodel);
    }

    public boolean hasImports() {
        return this.imports.size() != 0;
    }

    public List getImports() {
        return this.imports;
    }

    public void addImport(Import imp) {
        this.imports.add(imp);
    }

    public Difference getDifference() {
        return this.difference;
    }

    public void setDifference(Difference difference) {
        this.difference = difference;
    }

    public Delete getDelete() {
        return this.delete;
    }

    public void setDelete(Delete delete) {
        this.delete = delete;
    }

    public Add getAdd() {
        return this.add;
    }

    public void setAdd(Add add) {
        this.add = add;
    }

    public Replace getReplace() {
        return this.replace;
    }

    public void setReplace(Replace replace) {
        this.replace = replace;
    }

    public Reference getReference() {
        return this.reference;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public Collection getTopObjects() {
        return this.topObjects;
    }

    public void setTopObjects(Iterator iterator) {
        this.topObjects = new Vector();
        while (iterator.hasNext()) {
            this.topObjects.addElement(iterator.next());
        }
    }

    public void addTopObject(Object obj) {
        if (this.topObjects == null) {
            this.topObjects = new Vector();
        }
        this.topObjects.addElement(obj);
    }

    public static class Extensions {
        protected String extender;

        public Extensions(String extender) {
            this.extender = extender;
        }

        public String getExtender() {
            return this.extender;
        }
    }

    public static class Extension {
        protected String id;
        protected String label;
        protected String uuid;
        protected String href;
        protected String idref;
        protected String extender;
        protected String extenderID;

        public Extension(String id, String label, String uuid, String href, String idref, String extender, String extenderID) {
            this.id = id;
            this.label = label;
            this.uuid = uuid;
            this.href = href;
            this.idref = idref;
            this.extender = extender;
            this.extenderID = extenderID;
        }

        public String getID() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public String getHref() {
            return this.href;
        }

        public String getIDref() {
            return this.idref;
        }

        public String getExtender() {
            return this.extender;
        }

        public String getExtenderID() {
            return this.extenderID;
        }
    }

    public static class Model {
        protected String name;
        protected String version;
        protected String href;
        protected String idref;

        public Model(String name, String version, String href, String idref) {
            this.name = name;
            this.version = version;
            this.href = href;
            this.idref = idref;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getHref() {
            return this.href;
        }

        public String getIDref() {
            return this.idref;
        }
    }

    public static class Metamodel
    extends Model {
        public Metamodel(String name, String version, String href, String idref) {
            super(name, version, href, idref);
        }
    }

    public static class Metametamodel
    extends Model {
        public Metametamodel(String name, String version, String href, String idref) {
            super(name, version, href, idref);
        }
    }

    public static class Import {
        protected String name;
        protected String version;
        protected String href;
        protected String idref;

        public Import(String name, String version, String href, String idref) {
            this.name = name;
            this.version = version;
            this.href = href;
            this.idref = idref;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getHref() {
            return this.href;
        }

        public String getIDref() {
            return this.idref;
        }
    }

    public static class Difference {
        protected String id;
        protected String label;
        protected String uuid;
        protected String href;
        protected String idref;

        public Difference(String id, String label, String uuid, String href, String idref) {
            this.id = id;
            this.label = label;
            this.uuid = uuid;
            this.href = href;
            this.idref = idref;
        }

        public String getID() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public String getHref() {
            return this.href;
        }

        public String getIDref() {
            return this.idref;
        }
    }

    public static class Delete {
        protected String id;
        protected String label;
        protected String uuid;
        protected String href;
        protected String idref;

        public Delete(String id, String label, String uuid, String href, String idref) {
            this.id = id;
            this.label = label;
            this.uuid = uuid;
            this.href = href;
            this.idref = idref;
        }

        public String getID() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public String getHref() {
            return this.href;
        }

        public String getIDref() {
            return this.idref;
        }
    }

    public static class Add {
        protected String id;
        protected String label;
        protected String uuid;
        protected String href;
        protected String idref;
        protected String position;

        public Add(String id, String label, String uuid, String href, String idref, String position) {
            this.id = id;
            this.label = label;
            this.uuid = uuid;
            this.href = href;
            this.idref = idref;
            this.position = position;
        }

        public String getID() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public String getHref() {
            return this.href;
        }

        public String getIDref() {
            return this.idref;
        }

        public String getPosition() {
            return this.position;
        }
    }

    public static class Replace {
        protected String id;
        protected String label;
        protected String uuid;
        protected String href;
        protected String idref;
        protected String position;

        public Replace(String id, String label, String uuid, String href, String idref, String position) {
            this.id = id;
            this.label = label;
            this.uuid = uuid;
            this.href = href;
            this.idref = idref;
            this.position = position;
        }

        public String getID() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public String getHref() {
            return this.href;
        }

        public String getIDref() {
            return this.idref;
        }

        public String getPosition() {
            return this.position;
        }
    }

    public static class Reference {
        protected String id;
        protected String label;
        protected String uuid;

        public Reference(String id, String label, String uuid) {
            this.id = id;
            this.label = label;
            this.uuid = uuid;
        }

        public String getID() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public String getUUID() {
            return this.uuid;
        }
    }
}

