/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.kent.cs.kmf.xmi;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import uk.ac.kent.cs.kmf.util.Type;
import uk.ac.kent.cs.kmf.xmi.IWriterAdapter;
import uk.ac.kent.cs.kmf.xmi.IXMIElement;
import uk.ac.kent.cs.kmf.xmi.IXMIObject;
import uk.ac.kent.cs.kmf.xmi.IXMIProperty;

public class WriterAdapter
implements IWriterAdapter {
    public void indent(PrintWriter out, int indent) {
        int i = 0;
        while (i < indent) {
            out.print("    ");
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String replaceReferences(String s) throws Exception {
        String res = new String();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '<') {
                res = String.valueOf(res) + "&lt;";
            } else if (c == '>') {
                res = String.valueOf(res) + "&gt;";
            } else if (c == '&') {
                res = String.valueOf(res) + "&amp;";
            } else if ('\ud800' <= c && c < '\udc00') {
                int j;
                if (i + 1 >= s.length()) throw new Exception("Invalid reference: " + Integer.toHexString(c) + " ?");
                if (56320 > (j = s.charAt(++i)) || j >= 57344) throw new Exception("Invalid reference: " + Integer.toHexString(c) + " " + Integer.toHexString(j));
                j = (c - 55296 << 10) + j - 56320 + 65536;
                res = String.valueOf(res) + "&#x";
                res = String.valueOf(res) + Integer.toHexString(j);
                res = String.valueOf(res) + ";";
            } else {
                res = String.valueOf(res) + c;
            }
            ++i;
        }
        return res;
    }

    public void printStartElement(PrintWriter out, int indent, String tag, String[] atts, boolean flag) throws Exception {
        this.indent(out, indent);
        out.print("<" + tag);
        if (atts != null) {
            int i = 0;
            while (i < atts.length - 1) {
                if (atts[i + 1] != null) {
                    out.print(" " + atts[i] + "=\"" + this.replaceReferences(atts[i + 1]) + "\"");
                }
                i += 2;
            }
        }
        if (flag) {
            out.print("/");
        }
        out.print(">");
    }

    public void printEndElement(PrintWriter out, int indent, String tag) {
        this.indent(out, indent);
        out.print("</" + tag + ">");
    }

    public void printText(PrintWriter out, int indent, String text) throws Exception {
        this.indent(out, indent);
        out.print(this.replaceReferences(text));
    }

    public void printXMIElement(PrintWriter out, int indent, IXMIElement elem) throws Exception {
        String[] atts = new String[]{};
        if (elem instanceof IXMIObject) {
            IXMIObject obj = (IXMIObject)elem;
            atts = new String[]{"xmi.id", obj.getID(), "xmi.label", obj.getLABEL(), "xmi.href", obj.getHREF(), "xmi.uuid", obj.getUUID()};
            this.printStartElement(out, indent + 1, elem.getXMIName(), atts, false);
            out.println();
            List props = obj.getProperties();
            Iterator i = props.iterator();
            while (i.hasNext()) {
                IXMIElement e = (IXMIElement)i.next();
                this.printXMIElement(out, indent + 1, e);
            }
            this.printEndElement(out, indent + 1, elem.getXMIName());
            out.println();
        } else if (elem instanceof IXMIProperty) {
            IXMIProperty prop = (IXMIProperty)elem;
            if (prop.isBasicType()) {
                atts = new String[]{"xmi.value", prop.getXMIValue().toString()};
                this.printStartElement(out, indent + 1, elem.getXMIName(), atts, true);
                out.println();
            } else if (prop.isObjectType()) {
                this.printStartElement(out, indent + 1, elem.getXMIName(), atts, false);
                out.println();
                IXMIObject value = (IXMIObject)prop.getXMIValue();
                if (value != null) {
                    atts = new String[]{"xmi.idref", value.getID()};
                    this.printStartElement(out, indent + 2, value.getXMIName(), atts, true);
                    out.println();
                }
                this.printEndElement(out, indent + 1, elem.getXMIName());
                out.println();
            } else if (prop.isCollectionType()) {
                this.printStartElement(out, indent + 1, elem.getXMIName(), atts, false);
                out.println();
                List values = prop.getXMIValues();
                Iterator i = values.iterator();
                while (i.hasNext()) {
                    IXMIObject obj = (IXMIObject)i.next();
                    if (obj == null) continue;
                    Object value = obj.getObject();
                    atts = Type.isInstanceofPrimitiveType((Object)value) ? new String[]{"xmi.value", value.toString()} : new String[]{"xmi.idref", obj.getID()};
                    this.printStartElement(out, indent + 2, obj.getXMIName(), atts, true);
                    out.println();
                }
                this.printEndElement(out, indent + 1, elem.getXMIName());
                out.println();
            }
        }
    }
}

