/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.ui.internal.console;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class ConsoleUtil {
    private static Map nameToConsole = new HashMap();
    private static Map nameToDefaultStream = new HashMap();
    private static final String ERROR = "ERROR";
    private static final String INFO = "INFO";
    private static final String WARNING = "WARNING";
    private static final String DEFAULT = "DEFAULT";
    public static final Color DEFAULT_ERROR = new Color(null, 255, 0, 0);
    public static final Color DEFAULT_INFO = new Color(null, 0, 0, 255);
    public static final Color DEFAULT_WARNING = new Color(null, 255, 255, 0);

    public static MessageConsole registerConsole(String name, ImageDescriptor image) {
        if (nameToConsole.get(name) == null) {
            MessageConsole console = new MessageConsole(name, image);
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
            nameToConsole.put(name, console);
        }
        return (MessageConsole)nameToConsole.get(name);
    }

    public static MessageConsole registerConsole(String name) {
        return ConsoleUtil.registerConsole(name, null);
    }

    public static void unregisterConsole(String name) {
        if (nameToConsole.containsKey(name)) {
            ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{(IConsole)nameToConsole.get(name)});
            nameToConsole.remove(name);
            nameToDefaultStream.remove(String.valueOf(name) + ERROR);
            nameToDefaultStream.remove(String.valueOf(name) + INFO);
            nameToDefaultStream.remove(String.valueOf(name) + WARNING);
        }
    }

    private static MessageConsoleStream getDefaultStream(String name, String type) {
        if (nameToDefaultStream.get(String.valueOf(name) + type) == null) {
            MessageConsole console = ConsoleUtil.registerConsole(name);
            MessageConsoleStream defaultStream = console.newMessageStream();
            nameToDefaultStream.put(String.valueOf(name) + type, defaultStream);
        }
        return (MessageConsoleStream)nameToDefaultStream.get(String.valueOf(name) + type);
    }

    public static void printError(String name, String errMsg) {
        MessageConsoleStream defaultStream = ConsoleUtil.getDefaultStream(name, ERROR);
        defaultStream.setColor(DEFAULT_ERROR);
        defaultStream.println(errMsg);
    }

    public static void printInfo(String name, String infoMsg) {
        MessageConsoleStream defaultStream = ConsoleUtil.getDefaultStream(name, INFO);
        defaultStream.setColor(DEFAULT_INFO);
        defaultStream.println(infoMsg);
    }

    public static void printWarning(String name, String warnMsg) {
        MessageConsoleStream defaultStream = ConsoleUtil.getDefaultStream(name, WARNING);
        defaultStream.setColor(DEFAULT_WARNING);
        defaultStream.println(warnMsg);
    }

    public static void println(String name, String msg) {
        MessageConsoleStream defaultStream = ConsoleUtil.getDefaultStream(name, DEFAULT);
        defaultStream.println(msg);
    }

    public static void showConsole(String name) {
        MessageConsole console = ConsoleUtil.registerConsole(name);
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)console);
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)console);
    }
}

