/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.ui.navigator.IExtensionStateModel;

public class WorkingSetRootModeActionGroup
extends ActionGroup {
    private IExtensionStateModel stateModel;
    private StructuredViewer structuredViewer;
    private boolean hasContributedToViewMenu = false;
    private IAction workingSetsAction = null;
    private IAction projectsAction = null;
    private IAction[] actions;
    private int currentSelection;
    private MenuItem[] items;

    public WorkingSetRootModeActionGroup(StructuredViewer aStructuredViewer, IExtensionStateModel aStateModel) {
        this.structuredViewer = aStructuredViewer;
        this.stateModel = aStateModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillActionBars(IActionBars actionBars) {
        WorkingSetRootModeActionGroup workingSetRootModeActionGroup = this;
        synchronized (workingSetRootModeActionGroup) {
            if (!this.hasContributedToViewMenu) {
                this.contributeToViewMenu(actionBars.getMenuManager());
                this.hasContributedToViewMenu = true;
            }
        }
    }

    private void contributeToViewMenu(IMenuManager viewMenu) {
        MenuManager topLevelSubMenu = new MenuManager(WorkbenchNavigatorMessages.WorkingSetRootModeActionGroup_Top_Level_Element_);
        this.addActions((IMenuManager)topLevelSubMenu);
        viewMenu.insertBefore("additions", (IContributionItem)topLevelSubMenu);
    }

    protected void addActions(IMenuManager viewMenu) {
        viewMenu.add((IContributionItem)new Separator());
        this.items = new MenuItem[this.actions.length];
        int i = 0;
        while (i < this.actions.length) {
            final int j = i++;
            viewMenu.add((IContributionItem)new ContributionItem(){

                public void fill(Menu menu, int index) {
                    MenuItem mi;
                    int style = 32;
                    if ((WorkingSetRootModeActionGroup.this.actions[j].getStyle() & 8) != 0) {
                        style = 16;
                    }
                    ((WorkingSetRootModeActionGroup)WorkingSetRootModeActionGroup.this).items[j] = mi = new MenuItem(menu, style, index);
                    mi.setText(WorkingSetRootModeActionGroup.this.actions[j].getText());
                    mi.setSelection(WorkingSetRootModeActionGroup.this.currentSelection == j);
                    mi.addSelectionListener((SelectionListener)new SelectionAdapter(this, j){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ int val$j;
                        {
                            this.this$1 = var1_1;
                            this.val$j = n;
                        }

                        public void widgetSelected(SelectionEvent e) {
                            if (WorkingSetRootModeActionGroup.access$4(1.access$0(this.this$1)) == this.val$j) {
                                WorkingSetRootModeActionGroup.access$3(1.access$0(this.this$1))[WorkingSetRootModeActionGroup.access$4(1.access$0(this.this$1))].setSelection(true);
                                return;
                            }
                            WorkingSetRootModeActionGroup.access$2(1.access$0(this.this$1))[this.val$j].run();
                            WorkingSetRootModeActionGroup.access$3(1.access$0(this.this$1))[WorkingSetRootModeActionGroup.access$4(1.access$0(this.this$1))].setSelection(false);
                            WorkingSetRootModeActionGroup.access$5(1.access$0(this.this$1), this.val$j);
                            WorkingSetRootModeActionGroup.access$3(1.access$0(this.this$1))[WorkingSetRootModeActionGroup.access$4(1.access$0(this.this$1))].setSelection(true);
                        }
                    });
                }

                public boolean isDynamic() {
                    return false;
                }

                static /* synthetic */ WorkingSetRootModeActionGroup access$0(1 var0) {
                    return var0.WorkingSetRootModeActionGroup.this;
                }
            });
        }
    }

    private IAction[] createActions() {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.projectsAction = new TopLevelContentAction(false);
        this.projectsAction.setText(WorkbenchNavigatorMessages.WorkingSetRootModeActionGroup_Project_);
        this.projectsAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_OBJ_PROJECT"));
        this.workingSetsAction = new TopLevelContentAction(true);
        this.workingSetsAction.setText(WorkbenchNavigatorMessages.WorkingSetRootModeActionGroup_Working_Set_);
        this.workingSetsAction.setImageDescriptor(WorkbenchNavigatorPlugin.getDefault().getImageRegistry().getDescriptor("full/obj16/workingsets.gif"));
        return new IAction[]{this.projectsAction, this.workingSetsAction};
    }

    public void setShowTopLevelWorkingSets(boolean showTopLevelWorkingSets) {
        if (this.actions == null) {
            this.actions = this.createActions();
            this.setActions(this.actions, showTopLevelWorkingSets ? 1 : 0);
        }
        this.workingSetsAction.setChecked(showTopLevelWorkingSets);
        this.projectsAction.setChecked(!showTopLevelWorkingSets);
        if (this.items != null) {
            int i = 0;
            while (i < this.items.length) {
                if (this.items[i] != null && this.actions[i] != null) {
                    this.items[i].setSelection(this.actions[i].isChecked());
                }
                ++i;
            }
        }
        if (this.stateModel != null) {
            this.stateModel.setBooleanProperty("org.eclipse.ui.navigator.resources.workingSets.showTopLevelWorkingSets", showTopLevelWorkingSets);
        }
    }

    private void setActions(IAction[] theActions, int selected) {
        this.actions = theActions;
        this.currentSelection = selected;
    }

    public void setStateModel(IExtensionStateModel sStateModel) {
        this.stateModel = sStateModel;
    }

    static /* synthetic */ void access$5(WorkingSetRootModeActionGroup workingSetRootModeActionGroup, int n) {
        workingSetRootModeActionGroup.currentSelection = n;
    }

    private class TopLevelContentAction
    extends Action
    implements IAction {
        private final boolean groupWorkingSets;

        public TopLevelContentAction(boolean toGroupWorkingSets) {
            super("", 8);
            this.groupWorkingSets = toGroupWorkingSets;
        }

        public void run() {
            if (WorkingSetRootModeActionGroup.this.stateModel.getBooleanProperty("org.eclipse.ui.navigator.resources.workingSets.showTopLevelWorkingSets") != this.groupWorkingSets) {
                WorkingSetRootModeActionGroup.this.stateModel.setBooleanProperty("org.eclipse.ui.navigator.resources.workingSets.showTopLevelWorkingSets", this.groupWorkingSets);
                WorkingSetRootModeActionGroup.this.structuredViewer.getControl().setRedraw(false);
                try {
                    WorkingSetRootModeActionGroup.this.structuredViewer.refresh();
                }
                finally {
                    WorkingSetRootModeActionGroup.this.structuredViewer.getControl().setRedraw(true);
                }
            }
        }
    }
}

