/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.actions;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class OpenLaunchDialogAction
extends Action
implements IActionDelegate2,
IWorkbenchWindowActionDelegate {
    private String fIdentifier;

    public OpenLaunchDialogAction(String identifier) {
        this.fIdentifier = identifier;
        LaunchGroupExtension group = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(this.fIdentifier);
        if (group != null) {
            this.setImageDescriptor(group.getImageDescriptor());
            String lbl = group.getLabel();
            String actionLabel = MessageFormat.format((String)ActionMessages.OpenLaunchDialogAction_1, (Object[])new String[]{lbl});
            this.setText(DebugUIPlugin.adjustDBCSAccelerator(actionLabel));
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.open_launch_configuration_action_context");
    }

    public void run() {
        LaunchHistory history = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchHistory(this.fIdentifier);
        ILaunchConfiguration configuration = history.getRecentLaunch();
        StructuredSelection selection = null;
        selection = configuration == null ? new StructuredSelection() : new StructuredSelection((Object)configuration);
        int result = DebugUITools.openLaunchConfigurationDialogOnGroup(DebugUIPlugin.getShell(), (IStructuredSelection)selection, this.fIdentifier);
        this.notifyResult(result == 0);
    }

    public void runWithEvent(IAction action, Event event) {
        this.run();
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IAction action) {
        if (action != null) {
            action.setEnabled(this.existsConfigTypesForMode());
        }
    }

    private boolean existsConfigTypesForMode() {
        ILaunchConfigurationType[] configTypes = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationTypes();
        int i = 0;
        while (i < configTypes.length) {
            ILaunchConfigurationType configType = configTypes[i];
            if (configType.supportsMode(this.getMode())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private String getMode() {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(this.fIdentifier).getMode();
    }
}

