/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.actions;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;

public class LaunchAction
extends Action {
    private ILaunchConfiguration fConfiguration;
    private String fMode;

    public LaunchAction(ILaunchConfiguration configuration, String mode) {
        this.fConfiguration = configuration;
        this.fMode = mode;
        this.setText(configuration.getName());
        this.setImageDescriptor(DebugUITools.getDefaultImageDescriptor(configuration));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.relaunch_history_action_context");
    }

    public void run() {
        DebugUITools.launch(this.fConfiguration, this.fMode);
    }

    public void runWithEvent(Event event) {
        if ((event.stateMask & SWT.MOD1) > 0) {
            StructuredSelection selection = new StructuredSelection((Object)this.fConfiguration);
            String id = DebugUITools.getLaunchGroup(this.fConfiguration, this.fMode).getIdentifier();
            DebugUITools.openLaunchConfigurationDialogOnGroup(DebugUIPlugin.getShell(), (IStructuredSelection)selection, id);
        } else {
            this.run();
        }
    }
}

