/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.console;

import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.IStreamsProxy2;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.console.ConsoleRemoveAllTerminatedAction;
import org.eclipse.debug.internal.ui.views.console.ConsoleRemoveLaunchAction;
import org.eclipse.debug.internal.ui.views.console.ConsoleTerminateAction;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.debug.internal.ui.views.console.ShowStandardErrorAction;
import org.eclipse.debug.internal.ui.views.console.ShowStandardOutAction;
import org.eclipse.debug.internal.ui.views.console.ShowWhenContentChangesAction;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;

public class ProcessConsolePageParticipant
implements IConsolePageParticipant,
IShowInSource,
IShowInTargetList,
IDebugEventSetListener,
IDebugContextListener {
    private ConsoleTerminateAction fTerminate;
    private ConsoleRemoveLaunchAction fRemoveTerminated;
    private ConsoleRemoveAllTerminatedAction fRemoveAllTerminated;
    private ShowWhenContentChangesAction fStdOut;
    private ShowWhenContentChangesAction fStdErr;
    private ProcessConsole fConsole;
    private IPageBookViewPage fPage;
    private IConsoleView fView;
    private EOFHandler fEOFHandler;
    private String fContextId = "org.eclipse.debug.ui.console";
    private IContextActivation fActivatedContext;
    private IHandlerActivation fActivatedHandler;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public void init(IPageBookViewPage page, IConsole console) {
        this.fPage = page;
        this.fConsole = (ProcessConsole)console;
        this.fRemoveTerminated = new ConsoleRemoveLaunchAction(this.fConsole.getProcess().getLaunch());
        this.fRemoveAllTerminated = new ConsoleRemoveAllTerminatedAction();
        this.fTerminate = new ConsoleTerminateAction(this.fConsole);
        this.fStdOut = new ShowStandardOutAction();
        this.fStdErr = new ShowStandardErrorAction();
        this.fView = (IConsoleView)this.fPage.getSite().getPage().findView("org.eclipse.ui.console.ConsoleView");
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        DebugUITools.getDebugContextManager().getContextService(this.fPage.getSite().getWorkbenchWindow()).addDebugContextListener(this);
        IActionBars actionBars = this.fPage.getSite().getActionBars();
        this.configureToolBar(actionBars.getToolBarManager());
        this.fEOFHandler = new EOFHandler();
    }

    public void dispose() {
        this.deactivated();
        DebugUITools.getDebugContextManager().getContextService(this.fPage.getSite().getWorkbenchWindow()).removeDebugContextListener(this);
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        if (this.fRemoveTerminated != null) {
            this.fRemoveTerminated.dispose();
            this.fRemoveTerminated = null;
        }
        if (this.fRemoveAllTerminated != null) {
            this.fRemoveAllTerminated.dispose();
            this.fRemoveAllTerminated = null;
        }
        if (this.fTerminate != null) {
            this.fTerminate.dispose();
            this.fTerminate = null;
        }
        if (this.fStdOut != null) {
            this.fStdOut.dispose();
            this.fStdOut = null;
        }
        if (this.fStdErr != null) {
            this.fStdErr.dispose();
            this.fStdErr = null;
        }
        this.fConsole = null;
    }

    protected void configureToolBar(IToolBarManager mgr) {
        mgr.appendToGroup("launchGroup", (IAction)this.fTerminate);
        mgr.appendToGroup("launchGroup", (IAction)this.fRemoveTerminated);
        mgr.appendToGroup("launchGroup", (IAction)this.fRemoveAllTerminated);
        mgr.appendToGroup("outputGroup", (IAction)this.fStdOut);
        mgr.appendToGroup("outputGroup", (IAction)this.fStdErr);
    }

    public Object getAdapter(Class required) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            return this;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(required)) {
            return this;
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.debug.core.ILaunchConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.equals(required)) {
            ILaunch launch = this.getProcess().getLaunch();
            if (launch != null) {
                return launch.getLaunchConfiguration();
            }
            return null;
        }
        return null;
    }

    public ShowInContext getShowInContext() {
        IProcess process = this.getProcess();
        if (process == null) {
            return null;
        }
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.debug.core.model.IDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IDebugTarget target = (IDebugTarget)process.getAdapter((Class)clazz);
        TreeSelection selection = null;
        selection = target == null ? new TreeSelection(new TreePath(new Object[]{DebugPlugin.getDefault().getLaunchManager(), process.getLaunch(), process})) : new TreeSelection(new TreePath(new Object[]{DebugPlugin.getDefault().getLaunchManager(), target.getLaunch(), target}));
        return new ShowInContext(null, (ISelection)selection);
    }

    public String[] getShowInTargetIds() {
        return new String[]{"org.eclipse.debug.ui.DebugView"};
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getSource().equals(this.getProcess())) {
                Runnable r = new Runnable(){

                    public void run() {
                        if (ProcessConsolePageParticipant.this.fTerminate != null) {
                            ProcessConsolePageParticipant.this.fTerminate.update();
                        }
                    }
                };
                DebugUIPlugin.getStandardDisplay().asyncExec(r);
            }
            ++i;
        }
    }

    protected IProcess getProcess() {
        return this.fConsole != null ? this.fConsole.getProcess() : null;
    }

    public void activated() {
        IPageSite site = this.fPage.getSite();
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IHandlerService handlerService = (IHandlerService)site.getService((Class)clazz);
        Class<?> clazz2 = class$5;
        if (clazz2 == null) {
            try {
                clazz2 = class$5 = Class.forName("org.eclipse.ui.contexts.IContextService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IContextService contextService = (IContextService)site.getService((Class)clazz2);
        this.fActivatedContext = contextService.activateContext(this.fContextId);
        this.fActivatedHandler = handlerService.activateHandler("org.eclipse.debug.ui.commands.eof", (IHandler)this.fEOFHandler);
    }

    public void deactivated() {
        IPageSite site = this.fPage.getSite();
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IHandlerService handlerService = (IHandlerService)site.getService((Class)clazz);
        Class<?> clazz2 = class$5;
        if (clazz2 == null) {
            try {
                clazz2 = class$5 = Class.forName("org.eclipse.ui.contexts.IContextService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IContextService contextService = (IContextService)site.getService((Class)clazz2);
        handlerService.deactivateHandler(this.fActivatedHandler);
        contextService.deactivateContext(this.fActivatedContext);
    }

    public void debugContextChanged(DebugContextEvent event) {
        if ((event.getFlags() & 1) > 0 && this.fView != null && this.getProcess().equals(DebugUITools.getCurrentProcess())) {
            this.fView.display((IConsole)this.fConsole);
        }
    }

    private class EOFHandler
    extends AbstractHandler {
        private EOFHandler() {
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            IStreamsProxy proxy = ProcessConsolePageParticipant.this.getProcess().getStreamsProxy();
            if (proxy instanceof IStreamsProxy2) {
                IStreamsProxy2 proxy2 = (IStreamsProxy2)proxy;
                try {
                    proxy2.closeInputStream();
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }
}

