/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model.provisional;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;

public class PresentationContext
implements IPresentationContext {
    private String fId;
    private ListenerList fListeners = new ListenerList();
    private Map fProperties = new HashMap();

    public PresentationContext(String id) {
        this.fId = id;
    }

    public String[] getColumns() {
        return (String[])this.getProperty("PROPERTY_COLUMNS");
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        if (!this.fListeners.isEmpty()) {
            final PropertyChangeEvent event = new PropertyChangeEvent((Object)this, property, oldValue, newValue);
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                final IPropertyChangeListener listener = (IPropertyChangeListener)listeners[i];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        listener.propertyChange(event);
                    }
                });
                ++i;
            }
        }
    }

    public void setColumns(String[] ids) {
        this.setProperty("PROPERTY_COLUMNS", ids);
    }

    public void dispose() {
        this.fListeners.clear();
        this.fProperties.clear();
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public String getId() {
        return this.fId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String property) {
        Map map = this.fProperties;
        synchronized (map) {
            return this.fProperties.get(property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String property, Object value) {
        Map map = this.fProperties;
        synchronized (map) {
            Object oldValue = this.fProperties.get(property);
            if (!this.isEqual(oldValue, value)) {
                this.fProperties.put(property, value);
                this.firePropertyChange(property, oldValue, value);
            }
        }
    }

    private boolean isEqual(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }
}

