/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.viewers.FindElementDialog;
import org.eclipse.debug.internal.ui.viewers.model.ILabelUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.InternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IUpdate;

public class VirtualFindAction
extends Action
implements IUpdate {
    private InternalTreeModelViewer fViewer;
    private boolean fDone = false;

    public VirtualFindAction(InternalTreeModelViewer viewer) {
        this.setText(ActionMessages.FindAction_0);
        this.setId(String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".FindElementAction");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.find_element_context");
        this.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
        this.fViewer = viewer;
    }

    public void run() {
        this.fDone = false;
        final Object lock = new Object();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.fViewer.getControl().getShell());
        final IProgressMonitor monitor = dialog.getProgressMonitor();
        dialog.setCancelable(true);
        boolean queued = false;
        ILabelUpdateListener listener = new ILabelUpdateListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void labelUpdatesComplete() {
                Object object = lock;
                synchronized (object) {
                    VirtualFindAction.this.fDone = true;
                    lock.notifyAll();
                }
            }

            public void labelUpdatesBegin() {
            }

            public void labelUpdateStarted(ILabelUpdate update) {
            }

            public void labelUpdateComplete(ILabelUpdate update) {
                monitor.worked(1);
            }
        };
        this.fViewer.addLabelUpdateListener(listener);
        queued = this.fViewer.populateVitrualItems();
        if (queued) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(IProgressMonitor m) throws InvocationTargetException, InterruptedException {
                    m.beginTask(DebugUIPlugin.removeAccelerators(VirtualFindAction.this.getText()), -1);
                    Object object = lock;
                    synchronized (object) {
                        if (!VirtualFindAction.this.fDone) {
                            lock.wait();
                        }
                    }
                    m.done();
                }
            };
            try {
                dialog.run(true, true, runnable);
            }
            catch (InvocationTargetException e) {
                DebugUIPlugin.log(e);
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        this.fViewer.removeLabelUpdateListener(listener);
        if (!monitor.isCanceled()) {
            Tree tree = (Tree)this.fViewer.getControl();
            ArrayList items = new ArrayList();
            this.collectItems(items, tree.getItems());
            this.performFind(items);
        }
    }

    private void collectItems(List list, TreeItem[] items) {
        int i = 0;
        while (i < items.length) {
            TreeItem treeItem = items[i];
            list.add(treeItem);
            if (treeItem.getExpanded()) {
                this.collectItems(list, treeItem.getItems());
            }
            ++i;
        }
    }

    protected void performFind(List items) {
        Object[] elements;
        FindElementDialog dialog = new FindElementDialog(this.fViewer.getControl().getShell(), (ILabelProvider)new FindLabelProvider(), items.toArray());
        dialog.setTitle(ActionMessages.FindDialog_3);
        dialog.setMessage(ActionMessages.FindDialog_1);
        if (dialog.open() == 0 && (elements = dialog.getResult()).length == 1) {
            TreeItem item = (TreeItem)elements[0];
            ArrayList<Object> path = new ArrayList<Object>();
            while (item != null) {
                path.add(0, item.getData());
                item = item.getParentItem();
            }
            this.fViewer.setSelection((ISelection)new TreeSelection(new TreePath(path.toArray())));
        }
    }

    public void update() {
        this.setEnabled(this.fViewer.getInput() != null);
    }

    class FindLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            return ((TreeItem)element).getImage();
        }

        public String getText(Object element) {
            return ((TreeItem)element).getText();
        }
    }
}

