/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.preferences;

import com.ibm.icu.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DefaultLabelProvider;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.launchConfigurations.AbstractDebugListSelectionDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationComparator;
import org.eclipse.debug.internal.ui.preferences.DebugPreferencesMessages;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class RunDebugPropertiesPage
extends PropertyPage {
    private Set fDeletedConfigurations = new HashSet();
    private Set fOriginalCandidates;
    private Set fChangedConfigurations = new HashSet();
    private List fTypeCandidates = null;
    private TableViewer fViewer;
    private Button fNewButton = null;
    private Button fEditButton = null;
    private Button fDuplicateButton = null;
    private Button fDeleteButton = null;
    static /* synthetic */ Class class$0;

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.debug.ui.run_debug_resource_property_page");
        this.collectConfigCandidates(this.getResource());
        Composite topComposite = SWTFactory.createComposite(parent, 2, 1, 1808);
        SWTFactory.createWrapLabel(topComposite, DebugPreferencesMessages.DefaultLaunchConfigurationsPropertiesPage_0, 2, 300);
        SWTFactory.createVerticalSpacer(topComposite, 2);
        SWTFactory.createWrapLabel(topComposite, MessageFormat.format((String)DebugPreferencesMessages.DefaultLaunchConfigurationsPropertiesPage_1, (Object[])new String[]{this.getResource().getName()}), 2, 300);
        this.fViewer = this.createViewer(topComposite);
        Composite buttonComp = SWTFactory.createComposite(topComposite, 1, 1, 1040);
        GridLayout layout = (GridLayout)buttonComp.getLayout();
        layout.marginHeight = 0;
        this.fNewButton = SWTFactory.createPushButton(buttonComp, DebugPreferencesMessages.DefaultLaunchConfigurationsPropertiesPage_2, null);
        this.fNewButton.setToolTipText(DebugPreferencesMessages.DefaultLaunchConfigurationsPropertiesPage_3);
        this.fNewButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                RunDebugPropertiesPage.this.handleNew();
            }
        });
        this.fDuplicateButton = SWTFactory.createPushButton(buttonComp, DebugPreferencesMessages.DefaultLaunchConfigurationsPropertiesPage_4, null);
        this.fDuplicateButton.setToolTipText(DebugPreferencesMessages.DefaultLaunchConfigurationsPropertiesPage_5);
        this.fDuplicateButton.setEnabled(false);
        this.fDuplicateButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                RunDebugPropertiesPage.this.handleCopy();
            }
        });
        this.fEditButton = SWTFactory.createPushButton(buttonComp, DebugPreferencesMessages.DefaultLaunchConfigurationsPropertiesPage_6, null);
        this.fEditButton.setToolTipText(DebugPreferencesMessages.DefaultLaunchConfigurationsPropertiesPage_7);
        this.fEditButton.setEnabled(false);
        this.fEditButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                RunDebugPropertiesPage.this.handleEdit();
            }
        });
        this.fDeleteButton = SWTFactory.createPushButton(buttonComp, DebugPreferencesMessages.DefaultLaunchConfigurationsPropertiesPage_8, null);
        this.fDeleteButton.setToolTipText(DebugPreferencesMessages.DefaultLaunchConfigurationsPropertiesPage_9);
        this.fDeleteButton.setEnabled(false);
        this.fDeleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                RunDebugPropertiesPage.this.handleDelete();
            }
        });
        this.fViewer.setSelection((ISelection)new StructuredSelection());
        this.applyDialogFont(topComposite);
        return topComposite;
    }

    protected TableViewer createViewer(Composite parent) {
        TableViewer viewer = new TableViewer(parent, 68354);
        viewer.setLabelProvider((IBaseLabelProvider)new DefaultLabelProvider());
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setComparator((ViewerComparator)new LaunchConfigurationComparator());
        Table builderTable = viewer.getTable();
        GridData tableGridData = new GridData(1808);
        tableGridData.heightHint = 300;
        builderTable.setLayoutData((Object)tableGridData);
        IResource resource = this.getResource();
        viewer.setInput((Object)this.collectConfigCandidates(resource));
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = event.getSelection();
                if (sel instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)sel;
                    boolean empty = ss.isEmpty();
                    int size = ss.size();
                    RunDebugPropertiesPage.this.fEditButton.setEnabled(!empty && size == 1);
                    RunDebugPropertiesPage.this.fDuplicateButton.setEnabled(!empty && size == 1);
                    RunDebugPropertiesPage.this.fDeleteButton.setEnabled(!empty);
                }
            }
        });
        return viewer;
    }

    public void dispose() {
        if (this.fOriginalCandidates != null) {
            this.fOriginalCandidates.clear();
            this.fOriginalCandidates = null;
        }
        if (this.fChangedConfigurations != null) {
            this.fChangedConfigurations.clear();
            this.fChangedConfigurations = null;
        }
        super.dispose();
    }

    protected TableViewer getViewer() {
        return this.fViewer;
    }

    protected LaunchManager getLaunchManager() {
        return (LaunchManager)DebugPlugin.getDefault().getLaunchManager();
    }

    protected List collectTypeCandidates() {
        if (this.fTypeCandidates == null) {
            this.fTypeCandidates = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getApplicableConfigurationTypes(this.getResource());
            Collections.sort(this.fTypeCandidates, new Comparator(){

                public int compare(Object o1, Object o2) {
                    ILaunchConfigurationType t1 = (ILaunchConfigurationType)o1;
                    ILaunchConfigurationType t2 = (ILaunchConfigurationType)o2;
                    return t1.getName().compareTo(t2.getName());
                }
            });
        }
        return this.fTypeCandidates;
    }

    protected Set collectConfigCandidates(IResource resource) {
        if (this.fOriginalCandidates == null) {
            this.fOriginalCandidates = new HashSet();
            try {
                List configs = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getApplicableLaunchConfigurations(resource);
                Iterator iter = configs.iterator();
                while (iter.hasNext()) {
                    this.fOriginalCandidates.add(((ILaunchConfiguration)iter.next()).getWorkingCopy());
                }
            }
            catch (CoreException ce) {
                DebugUIPlugin.log(ce);
            }
        }
        return this.fOriginalCandidates;
    }

    protected IResource getResource() {
        IAdaptable element = this.getElement();
        IResource resource = null;
        if (element instanceof IResource) {
            resource = (IResource)element;
        } else if (element instanceof IAdaptable) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            resource = (IResource)element.getAdapter((Class)clazz);
        }
        return resource;
    }

    public boolean performOk() {
        ILaunchConfigurationWorkingCopy currentConfig;
        Iterator iter = this.fDeletedConfigurations.iterator();
        while (iter.hasNext()) {
            currentConfig = (ILaunchConfigurationWorkingCopy)iter.next();
            try {
                if (currentConfig.getOriginal() == null) continue;
                currentConfig.getOriginal().delete();
            }
            catch (CoreException e) {
                DebugPlugin.logMessage((String)("Problem deleting configuration " + currentConfig.getName()), (Throwable)e);
            }
        }
        iter = this.fChangedConfigurations.iterator();
        while (iter.hasNext()) {
            currentConfig = (ILaunchConfigurationWorkingCopy)iter.next();
            try {
                currentConfig.doSave();
            }
            catch (CoreException e) {
                DebugPlugin.logMessage((String)("Problem saving changes to configuration " + currentConfig.getName()), (Throwable)e);
            }
        }
        return super.performOk();
    }

    protected void performDefaults() {
        this.setErrorMessage(null);
        this.setValid(true);
        this.fOriginalCandidates.clear();
        this.fOriginalCandidates = null;
        this.getViewer().setInput((Object)this.collectConfigCandidates(this.getResource()));
        this.fChangedConfigurations.clear();
        this.fDeletedConfigurations.clear();
        this.fViewer.refresh(true, true);
        super.performDefaults();
    }

    private Set getConfigurationNames() {
        HashSet<String> names = new HashSet<String>();
        Iterator iter = this.fOriginalCandidates.iterator();
        while (iter.hasNext()) {
            names.add(((ILaunchConfiguration)iter.next()).getName());
        }
        iter = this.fChangedConfigurations.iterator();
        while (iter.hasNext()) {
            names.add(((ILaunchConfiguration)iter.next()).getName());
        }
        return names;
    }

    private ILaunchConfigurationWorkingCopy[] getSelectedConfigurations() {
        IStructuredSelection ss = (IStructuredSelection)this.fViewer.getSelection();
        return ss.toList().toArray(new ILaunchConfigurationWorkingCopy[ss.size()]);
    }

    private void handleCopy() {
        ILaunchConfigurationWorkingCopy configuration = this.getSelectedConfigurations()[0];
        try {
            ILaunchConfigurationWorkingCopy copy = configuration.copy(((LaunchManager)DebugPlugin.getDefault().getLaunchManager()).generateUniqueLaunchConfigurationNameFrom(configuration.getName(), this.getConfigurationNames()));
            copy.setAttributes(configuration.getAttributes());
            this.fChangedConfigurations.add(copy);
            this.fViewer.add((Object)copy);
            this.fViewer.setSelection((ISelection)new StructuredSelection((Object)copy));
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    private void handleDelete() {
        Table table = this.fViewer.getTable();
        int[] indices = table.getSelectionIndices();
        Arrays.sort(indices);
        ILaunchConfigurationWorkingCopy[] configurations = this.getSelectedConfigurations();
        int i = 0;
        while (i < configurations.length) {
            this.fDeletedConfigurations.add(configurations[i]);
            this.fChangedConfigurations.remove(configurations[i]);
            this.fViewer.remove((Object)configurations[i]);
            ++i;
        }
        if (indices[0] < table.getItemCount()) {
            this.fViewer.setSelection((ISelection)new StructuredSelection(table.getItem(indices[0]).getData()));
        } else if (table.getItemCount() > 0) {
            this.fViewer.setSelection((ISelection)new StructuredSelection(table.getItem(table.getItemCount() - 1).getData()));
        }
    }

    private void handleEdit() {
        ILaunchConfigurationWorkingCopy config = this.getSelectedConfigurations()[0];
        if (this.edit(config, false) == 0) {
            this.fChangedConfigurations.add(config);
            this.fViewer.refresh((Object)config, true, true);
        }
    }

    private int edit(ILaunchConfigurationWorkingCopy configuration, boolean setDefaults) {
        return DebugUIPlugin.openLaunchConfigurationPropertiesDialog(this.getShell(), (ILaunchConfiguration)configuration, "org.eclipse.debug.ui.launchGroup.run", this.getConfigurationNames(), null, setDefaults);
    }

    private void handleNew() {
        Object[] result;
        final List typeCandidates = this.collectTypeCandidates();
        AbstractDebugListSelectionDialog dialog = new AbstractDebugListSelectionDialog(this.getShell()){

            protected String getDialogSettingsId() {
                return String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".SELECT_CONFIGURATION_TYPE_DIALOG";
            }

            protected Object getViewerInput() {
                return typeCandidates;
            }

            protected String getHelpContextId() {
                return "org.eclipse.debug.ui.select_configuration_type_dialog";
            }

            protected String getViewerLabel() {
                return DebugPreferencesMessages.DefaultLaunchConfigurationsPropertiesPage_12;
            }
        };
        dialog.setTitle(DebugPreferencesMessages.DefaultLaunchConfigurationsPropertiesPage_11);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            ILaunchConfigurationType type = (ILaunchConfigurationType)result[0];
            try {
                ILaunchConfigurationWorkingCopy wc = type.newInstance(null, ((LaunchManager)DebugPlugin.getDefault().getLaunchManager()).generateUniqueLaunchConfigurationNameFrom("New_configuration", this.getConfigurationNames()));
                if (this.edit(wc, true) == 0) {
                    this.fChangedConfigurations.add(wc);
                    this.fViewer.add((Object)wc);
                    this.fViewer.setSelection((ISelection)new StructuredSelection((Object)wc));
                }
            }
            catch (CoreException e) {
                this.setErrorMessage(e.getMessage());
            }
        }
    }
}

