/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.launchConfigurations.AbstractDebugCheckboxSelectionDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SelectLaunchersDialog
extends AbstractDebugCheckboxSelectionDialog {
    private Text fDescriptionText = null;
    private ILaunchDelegate[] fDelegates = null;
    private Button fUseSystemLauncher = null;
    private ILaunchConfigurationWorkingCopy fConfiguration = null;
    private String fLaunchMode = null;

    public SelectLaunchersDialog(Shell parentShell, ILaunchDelegate[] delegates, ILaunchConfigurationWorkingCopy configuration, String launchmode) {
        super(parentShell);
        super.setTitle(LaunchConfigurationsMessages.SelectLaunchersDialog_0);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fDelegates = delegates;
        this.fConfiguration = configuration;
        this.fLaunchMode = launchmode;
    }

    protected Point getInitialSize() {
        IDialogSettings settings = this.getDialogBoundsSettings();
        if (settings != null) {
            try {
                int width = settings.getInt("DIALOG_WIDTH");
                int height = settings.getInt("DIALOG_HEIGHT");
                if (width > 0 & height > 0) {
                    return new Point(width, height);
                }
            }
            catch (NumberFormatException numberFormatException) {
                return new Point(450, 450);
            }
        }
        return new Point(450, 450);
    }

    protected String getDialogSettingsId() {
        return "org.eclipse.debug.ui.SELECT_LAUNCHERS_DIALOG";
    }

    protected String getHelpContextId() {
        return "org.eclipse.debug.ui.select_launchers_dialog";
    }

    protected IBaseLabelProvider getLabelProvider() {
        return new DelegatesLabelProvider();
    }

    protected Object getViewerInput() {
        return this.fDelegates;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(true);
    }

    protected void addCustomHeaderControls(Composite parent) {
        SWTFactory.createWrapLabel(parent, LaunchConfigurationsMessages.SelectLaunchersDialog_2, 1);
        Link link = new Link(parent, 64);
        link.setText(LaunchConfigurationsMessages.SelectLaunchersDialog_4);
        link.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        link.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SWTFactory.showPreferencePage("org.eclipse.debug.ui.LaunchDelegatesPreferencePage");
                if (!SelectLaunchersDialog.this.fUseSystemLauncher.getSelection()) {
                    SelectLaunchersDialog.this.resetDelegate();
                }
            }
        });
        this.fUseSystemLauncher = SWTFactory.createCheckButton(parent, LaunchConfigurationsMessages.SelectLaunchersDialog_1, null, true, 1);
        this.fUseSystemLauncher.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean checked = ((Button)e.widget).getSelection();
                SelectLaunchersDialog.this.getCheckBoxTableViewer().getTable().setEnabled(checked);
                SelectLaunchersDialog.this.resetDelegate();
            }
        });
    }

    protected ILaunchDelegate getSelectedDelegate() {
        Object[] checked = this.getCheckBoxTableViewer().getCheckedElements();
        if (checked.length > 0) {
            return (ILaunchDelegate)checked[0];
        }
        return null;
    }

    protected void okPressed() {
        ILaunchDelegate delegate = null;
        Set modes = this.getCurrentModeSet();
        if (this.fUseSystemLauncher.getSelection()) {
            delegate = this.getSelectedDelegate();
            if (delegate != null) {
                this.fConfiguration.setPreferredLaunchDelegate(modes, delegate.getId());
            }
        } else {
            this.fConfiguration.setPreferredLaunchDelegate(modes, null);
        }
        if (this.fConfiguration.isDirty()) {
            try {
                this.fConfiguration.doSave();
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        super.okPressed();
    }

    private void resetDelegate() {
        if (!this.fUseSystemLauncher.getSelection()) {
            try {
                ILaunchDelegate preferred = this.fConfiguration.getType().getPreferredDelegate(this.getCurrentModeSet());
                CheckboxTableViewer viewer = this.getCheckBoxTableViewer();
                if (preferred != null) {
                    viewer.setSelection((ISelection)new StructuredSelection((Object)preferred));
                    viewer.setCheckedElements(new Object[]{preferred});
                } else {
                    viewer.setSelection((ISelection)new StructuredSelection());
                    viewer.setAllChecked(false);
                }
            }
            catch (CoreException ce) {
                DebugUIPlugin.log(ce);
            }
        }
    }

    protected void addCustomFooterControls(Composite parent) {
        Group group = SWTFactory.createGroup(parent, LaunchConfigurationsMessages.SelectLaunchersDialog_5, 1, 1, 1808);
        this.fDescriptionText = SWTFactory.createText((Composite)group, 72, 1, 1808);
        this.fDescriptionText.setBackground(group.getBackground());
    }

    protected Set getCurrentModeSet() {
        Set<String> modes = new HashSet();
        try {
            modes = this.fConfiguration.getModes();
            modes.add(this.fLaunchMode);
        }
        catch (CoreException ce) {
            DebugUIPlugin.log(ce);
        }
        return modes;
    }

    protected void initializeControls() {
        final CheckboxTableViewer viewer = this.getCheckBoxTableViewer();
        viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                viewer.setCheckedElements(new Object[]{event.getElement()});
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                if (ss != null && !ss.isEmpty()) {
                    SelectLaunchersDialog.this.fDescriptionText.setText(((ILaunchDelegate)ss.getFirstElement()).getDescription());
                } else {
                    SelectLaunchersDialog.this.fDescriptionText.setText("");
                }
            }
        });
        try {
            ILaunchDelegate delegate = this.fConfiguration.getPreferredDelegate(this.getCurrentModeSet());
            boolean custom = delegate != null;
            this.fUseSystemLauncher.setSelection(custom);
            if (custom) {
                viewer.setSelection((ISelection)new StructuredSelection((Object)delegate));
                viewer.setCheckedElements(new Object[]{delegate});
            } else {
                this.resetDelegate();
                this.getCheckBoxTableViewer().getTable().setEnabled(false);
            }
        }
        catch (CoreException ce) {
            DebugUIPlugin.log(ce);
        }
    }

    protected String getViewerLabel() {
        return null;
    }

    class DelegatesLabelProvider
    implements ILabelProvider {
        DelegatesLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ILaunchDelegate) {
                ILaunchDelegate ldp = (ILaunchDelegate)element;
                String name = ldp.getName();
                if (name == null) {
                    name = ldp.getContributorName();
                }
                return name;
            }
            return element.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

