/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DefaultLabelProvider;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

public class LaunchConfigurationSelectionDialog
extends ListDialog {
    private static final String DIALOG_SETTINGS = "org.eclipse.debug.ui.SELECT_LAUNCH_CONFIGURATION_DIALOG";

    public LaunchConfigurationSelectionDialog(Shell parent) {
        super(parent);
        this.setTitle(LaunchConfigurationsMessages.LaunchConfigurationSelectionDialog_0);
        this.setMessage(LaunchConfigurationsMessages.LaunchConfigurationSelectionDialog_1);
        this.setLabelProvider(new DefaultLabelProvider());
        this.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
    }

    protected Control createContents(Composite parent) {
        Composite comp = (Composite)super.createContents(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, "org.eclipse.debug.ui.select_launch_configuration_dialog");
        return comp;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getOkButton().setEnabled(false);
        this.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LaunchConfigurationSelectionDialog.this.getOkButton().setEnabled(!event.getSelection().isEmpty());
            }
        });
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = DebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS);
        }
        return section;
    }

    protected Point getInitialSize() {
        IDialogSettings settings = this.getDialogBoundsSettings();
        if (settings != null) {
            try {
                int width = settings.getInt("DIALOG_WIDTH");
                int height = settings.getInt("DIALOG_HEIGHT");
                if (width > 0 & height > 0) {
                    return new Point(width, height);
                }
            }
            catch (NumberFormatException numberFormatException) {
                return new Point(450, 450);
            }
        }
        return new Point(450, 450);
    }
}

