/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.synthesis;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.oslo.ocl20.OclProcessor;
import org.oslo.ocl20.semantics.OclVisitor;
import org.oslo.ocl20.semantics.bridge.CallAction;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.bridge.DataType;
import org.oslo.ocl20.semantics.bridge.EnumLiteral;
import org.oslo.ocl20.semantics.bridge.Enumeration;
import org.oslo.ocl20.semantics.bridge.Environment;
import org.oslo.ocl20.semantics.bridge.ModelElement;
import org.oslo.ocl20.semantics.bridge.NamedElement;
import org.oslo.ocl20.semantics.bridge.Namespace;
import org.oslo.ocl20.semantics.bridge.OclModelElementType;
import org.oslo.ocl20.semantics.bridge.Operation;
import org.oslo.ocl20.semantics.bridge.Parameter;
import org.oslo.ocl20.semantics.bridge.Primitive;
import org.oslo.ocl20.semantics.bridge.Property;
import org.oslo.ocl20.semantics.bridge.SendAction;
import org.oslo.ocl20.semantics.bridge.Signal;
import org.oslo.ocl20.semantics.bridge.Tag;
import org.oslo.ocl20.semantics.impl.SemanticsVisitorImpl;
import org.oslo.ocl20.semantics.model.contexts.ClassifierContextDecl;
import org.oslo.ocl20.semantics.model.contexts.Constraint;
import org.oslo.ocl20.semantics.model.contexts.ConstraintKind;
import org.oslo.ocl20.semantics.model.contexts.ContextDeclaration;
import org.oslo.ocl20.semantics.model.contexts.DefinedOperation;
import org.oslo.ocl20.semantics.model.contexts.DefinedProperty;
import org.oslo.ocl20.semantics.model.contexts.OperationContextDecl;
import org.oslo.ocl20.semantics.model.contexts.PropertyContextDecl;
import org.oslo.ocl20.semantics.model.expressions.BooleanLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.CollectionItem;
import org.oslo.ocl20.semantics.model.expressions.CollectionKind;
import org.oslo.ocl20.semantics.model.expressions.CollectionLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.CollectionLiteralPart;
import org.oslo.ocl20.semantics.model.expressions.CollectionRange;
import org.oslo.ocl20.semantics.model.expressions.EnumLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.IfExp;
import org.oslo.ocl20.semantics.model.expressions.IntegerLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.IterateExp;
import org.oslo.ocl20.semantics.model.expressions.IteratorExp;
import org.oslo.ocl20.semantics.model.expressions.LetExp;
import org.oslo.ocl20.semantics.model.expressions.OclExpression;
import org.oslo.ocl20.semantics.model.expressions.OclMessageArg;
import org.oslo.ocl20.semantics.model.expressions.OclMessageExp;
import org.oslo.ocl20.semantics.model.expressions.OperationCallExp;
import org.oslo.ocl20.semantics.model.expressions.PropertyCallExp;
import org.oslo.ocl20.semantics.model.expressions.RealLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.StringLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.TupleLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.TypeLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.UndefinedLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.UnspecifiedValueExp;
import org.oslo.ocl20.semantics.model.expressions.VariableDeclaration;
import org.oslo.ocl20.semantics.model.expressions.VariableExp;
import org.oslo.ocl20.semantics.model.types.BagType;
import org.oslo.ocl20.semantics.model.types.BooleanType;
import org.oslo.ocl20.semantics.model.types.CollectionType;
import org.oslo.ocl20.semantics.model.types.IntegerType;
import org.oslo.ocl20.semantics.model.types.OclAnyType;
import org.oslo.ocl20.semantics.model.types.OclMessageType;
import org.oslo.ocl20.semantics.model.types.OrderedSetType;
import org.oslo.ocl20.semantics.model.types.RealType;
import org.oslo.ocl20.semantics.model.types.SequenceType;
import org.oslo.ocl20.semantics.model.types.SetType;
import org.oslo.ocl20.semantics.model.types.StringType;
import org.oslo.ocl20.semantics.model.types.TupleType;
import org.oslo.ocl20.semantics.model.types.VoidType;
import org.oslo.ocl20.standard.lib.OclAny;
import org.oslo.ocl20.standard.lib.OclBag;
import org.oslo.ocl20.standard.lib.OclBoolean;
import org.oslo.ocl20.standard.lib.OclBooleanImpl;
import org.oslo.ocl20.standard.lib.OclCollection;
import org.oslo.ocl20.standard.lib.OclCollectionImpl;
import org.oslo.ocl20.standard.lib.OclEnumeration;
import org.oslo.ocl20.standard.lib.OclInteger;
import org.oslo.ocl20.standard.lib.OclIntegerImpl;
import org.oslo.ocl20.standard.lib.OclOrderedSet;
import org.oslo.ocl20.standard.lib.OclReal;
import org.oslo.ocl20.standard.lib.OclSequence;
import org.oslo.ocl20.standard.lib.OclSet;
import org.oslo.ocl20.standard.lib.OclString;
import org.oslo.ocl20.standard.lib.OclTuple;
import org.oslo.ocl20.standard.lib.OclUndefined;
import org.oslo.ocl20.standard.types.BagTypeImpl;
import org.oslo.ocl20.standard.types.BooleanTypeImpl;
import org.oslo.ocl20.standard.types.CollectionTypeImpl;
import org.oslo.ocl20.standard.types.IntegerTypeImpl;
import org.oslo.ocl20.standard.types.OclAnyTypeImpl;
import org.oslo.ocl20.standard.types.OrderedSetTypeImpl;
import org.oslo.ocl20.standard.types.RealTypeImpl;
import org.oslo.ocl20.standard.types.SequenceTypeImpl;
import org.oslo.ocl20.standard.types.SetTypeImpl;
import org.oslo.ocl20.standard.types.StringTypeImpl;
import org.oslo.ocl20.standard.types.VoidTypeImpl;
import org.oslo.ocl20.synthesis.RuntimeEnvironment;
import uk.ac.kent.cs.kmf.util.ILog;

public class OclEvaluatorVisitorImpl
extends SemanticsVisitorImpl
implements OclVisitor {
    protected OclProcessor processor = null;
    protected static long tempVarCounter = 1L;
    protected static Set basicOclTypes = new LinkedHashSet();
    protected static Map needsWrapMap;
    protected static Map methodNames;
    protected static Map getJavaTypeMap;
    protected static Map getOclTypeMap;
    protected static Map nameMap;
    static int cons;

    static {
        basicOclTypes.add(BooleanType.class);
        basicOclTypes.add(IntegerType.class);
        basicOclTypes.add(RealType.class);
        basicOclTypes.add(StringType.class);
        basicOclTypes.add(CollectionType.class);
        basicOclTypes.add(BagType.class);
        basicOclTypes.add(SetType.class);
        basicOclTypes.add(SequenceType.class);
        basicOclTypes.add(OrderedSetType.class);
        basicOclTypes.add(OclAnyType.class);
        basicOclTypes.add(VoidType.class);
        basicOclTypes.add(BooleanTypeImpl.class);
        basicOclTypes.add(IntegerTypeImpl.class);
        basicOclTypes.add(RealTypeImpl.class);
        basicOclTypes.add(StringTypeImpl.class);
        basicOclTypes.add(CollectionTypeImpl.class);
        basicOclTypes.add(BagTypeImpl.class);
        basicOclTypes.add(SetTypeImpl.class);
        basicOclTypes.add(SequenceTypeImpl.class);
        basicOclTypes.add(OrderedSetTypeImpl.class);
        basicOclTypes.add(OclAnyTypeImpl.class);
        basicOclTypes.add(VoidTypeImpl.class);
        needsWrapMap = new HashMap();
        needsWrapMap.put(OclCollection.class + "-sum", Boolean.TRUE);
        needsWrapMap.put(OclBag.class + "-sum", Boolean.TRUE);
        needsWrapMap.put(OclSet.class + "-sum", Boolean.TRUE);
        needsWrapMap.put(OclSequence.class + "-sum", Boolean.TRUE);
        needsWrapMap.put(OclOrderedSet.class + "-sum", Boolean.TRUE);
        needsWrapMap.put(OclSequence.class + "-at", Boolean.TRUE);
        needsWrapMap.put(OclSequence.class + "-first", Boolean.TRUE);
        needsWrapMap.put(OclSequence.class + "-last", Boolean.TRUE);
        needsWrapMap.put(OclOrderedSet.class + "-at", Boolean.TRUE);
        needsWrapMap.put(OclOrderedSet.class + "-first", Boolean.TRUE);
        needsWrapMap.put(OclOrderedSet.class + "-last", Boolean.TRUE);
        methodNames = new HashMap();
        methodNames.put(BooleanType.class, "Boolean");
        methodNames.put(IntegerType.class, "Integer");
        methodNames.put(RealType.class, "Real");
        methodNames.put(StringType.class, "String");
        methodNames.put(CollectionType.class, "Collection");
        methodNames.put(BagType.class, "Bag");
        methodNames.put(SetType.class, "Set");
        methodNames.put(SequenceType.class, "Sequence");
        methodNames.put(OrderedSetType.class, "OrderedSet");
        methodNames.put(VoidType.class, "Undefined");
        methodNames.put(BooleanTypeImpl.class, "Boolean");
        methodNames.put(IntegerTypeImpl.class, "Integer");
        methodNames.put(RealTypeImpl.class, "Real");
        methodNames.put(StringTypeImpl.class, "String");
        methodNames.put(CollectionTypeImpl.class, "Collection");
        methodNames.put(BagTypeImpl.class, "Bag");
        methodNames.put(SetTypeImpl.class, "Set");
        methodNames.put(SequenceTypeImpl.class, "Sequence");
        methodNames.put(OrderedSetTypeImpl.class, "OrderedSet");
        methodNames.put(VoidTypeImpl.class, "Undefined");
        getJavaTypeMap = new HashMap();
        getJavaTypeMap.put("IOclBoolean", Boolean.class);
        getJavaTypeMap.put("IOclInteger", Integer.class);
        getJavaTypeMap.put("IOclReal", Double.class);
        getJavaTypeMap.put("IOclString", String.class);
        getJavaTypeMap.put("IOclBag", Collection.class);
        getJavaTypeMap.put("IOclSet", Collection.class);
        getJavaTypeMap.put("IOclOrderedSet", Collection.class);
        getJavaTypeMap.put("IOclSequence", Collection.class);
        getJavaTypeMap.put("Classifier", Class.class);
        getJavaTypeMap.put("OclBoolean", Boolean.class);
        getJavaTypeMap.put("OclInteger", Integer.class);
        getJavaTypeMap.put("OclReal", Double.class);
        getJavaTypeMap.put("OclString", String.class);
        getJavaTypeMap.put("OclBag", Collection.class);
        getJavaTypeMap.put("OclSet", Collection.class);
        getJavaTypeMap.put("OclOrderedSet", Collection.class);
        getJavaTypeMap.put("OclSequence", Collection.class);
        getJavaTypeMap.put("OclBooleanImpl", Boolean.class);
        getJavaTypeMap.put("OclIntegerImpl", Integer.class);
        getJavaTypeMap.put("OclRealImpl", Double.class);
        getJavaTypeMap.put("OclStringImpl", String.class);
        getJavaTypeMap.put("OclBagImpl", Collection.class);
        getJavaTypeMap.put("OclSetImpl", Collection.class);
        getJavaTypeMap.put("OclOrderedSetImpl", Collection.class);
        getJavaTypeMap.put("OclSequenceImpl", Collection.class);
        getOclTypeMap = new HashMap();
        getOclTypeMap.put("OclBoolean", OclBoolean.class);
        getOclTypeMap.put("OclInteger", OclInteger.class);
        getOclTypeMap.put("OclReal", OclReal.class);
        getOclTypeMap.put("OclString", OclString.class);
        getOclTypeMap.put("OclBag", OclBag.class);
        getOclTypeMap.put("OclSet", OclSet.class);
        getOclTypeMap.put("OclOrderedSet", OclOrderedSet.class);
        getOclTypeMap.put("OclSequence", OclSequence.class);
        nameMap = new HashMap();
        nameMap.put("=", "equalTo");
        nameMap.put("<>", "notEqualTo");
        nameMap.put("+", "add");
        nameMap.put("-", "subtract");
        nameMap.put("*", "multiply");
        nameMap.put("/", "divide");
        nameMap.put("<", "lessThan");
        nameMap.put(">", "greaterThan");
        nameMap.put("<=", "lessThanOrEqualTo");
        nameMap.put(">=", "greaterThanOrEqualTo");
        cons = 0;
    }

    public OclEvaluatorVisitorImpl(OclProcessor proc) {
        this.processor = proc;
    }

    protected Object getOclObject(String type_name, Object value) throws Exception {
        Object[] valArr;
        Class[] typeArr;
        if (value == null) {
            typeArr = new Class[]{};
            valArr = new Object[]{};
        } else {
            typeArr = new Class[]{value.getClass()};
            valArr = new Object[]{value};
        }
        Method m = this.getMethod(this.processor.getStdLibAdapter(), type_name, typeArr);
        try {
            return m.invoke((Object)this.processor.getStdLibAdapter(), valArr);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Method getMethod(Object source, String operName, Class[] types) throws Exception {
        if (source == null) {
            return null;
        }
        Method method = null;
        try {
            method = source.getClass().getMethod(operName, types);
        }
        catch (Exception exception) {}
        if (method == null) {
            Method[] methods = source.getClass().getMethods();
            int i = 0;
            while (i < methods.length) {
                String methodName = methods[i].getName();
                Class<?>[] argTypes = methods[i].getParameterTypes();
                if (methodName.equals(operName) && types.length == argTypes.length) {
                    boolean found = true;
                    int j = 0;
                    while (j < types.length) {
                        if (!argTypes[j].isAssignableFrom(types[j])) {
                            found = false;
                            break;
                        }
                        ++j;
                    }
                    if (found) {
                        return methods[i];
                    }
                }
                ++i;
            }
        }
        return method;
    }

    protected Method getMethod(String className, String operName, Class[] types) throws Exception {
        return Class.forName(className).getMethod(operName, types);
    }

    public static String newTempVar() {
        return "t" + tempVarCounter++;
    }

    public void resetCounter() {
        tempVarCounter = 1L;
    }

    protected static boolean isBasicOclType(Classifier sourceType) {
        return basicOclTypes.contains(sourceType.getClass());
    }

    protected static boolean needsOclWrapping(Classifier sourceType, String operName) {
        if (OclEvaluatorVisitorImpl.isBasicOclType(sourceType)) {
            return needsWrapMap.get(sourceType.getClass() + "-" + operName) != null;
        }
        return true;
    }

    protected Object wrapJavaObjectAsOclType(Classifier type, Object original) {
        if (original instanceof OclAny) {
            return original;
        }
        if (original instanceof OclCollection) {
            return original;
        }
        if (original instanceof Collection) {
            return this.processor.getStdLibAdapter().Collection((Collection)original);
        }
        if (type instanceof TupleType && original instanceof Map) {
            return this.processor.getStdLibAdapter().Tuple((TupleType)type, (Map)original);
        }
        return this.processor.getStdLibAdapter().OclAny(original);
    }

    protected static String getAdapterMethodName(Classifier type) {
        String methodName = (String)methodNames.get(type.getClass());
        return methodName;
    }

    protected static Class getJavaType(String name, Object value) {
        Class type = (Class)getJavaTypeMap.get(name);
        if (type == null) {
            return value.getClass();
        }
        return type;
    }

    protected static Class getOclType(String name, Object value) {
        Class type = (Class)getOclTypeMap.get(name);
        if (type == null) {
            return value.getClass();
        }
        return type;
    }

    protected static String getFunctionName(Operation op) {
        String name = op.getName();
        Classifier type = op.getReturnType();
        int numParams = op.getOwnedParameter().size();
        if (name.equals("abs") && numParams == 0 && type instanceof IntegerType) {
            return "iabs";
        }
        if (name.equals("-") && numParams == 0) {
            return String.valueOf(type instanceof IntegerType ? "i" : "") + "negate";
        }
        String result = (String)nameMap.get(name);
        if (result == null) {
            return name;
        }
        return result;
    }

    public Object visit(VariableDeclaration host, Object data) {
        RuntimeEnvironment env = (RuntimeEnvironment)((Map)data).get("env");
        String name = host.getName();
        Object initValue = null;
        if (host.getInitExpression() != null) {
            initValue = host.getInitExpression().accept(this, data);
        }
        env.setValue(name, initValue);
        return initValue;
    }

    public Object visit(BooleanLiteralExp host, Object data) {
        RuntimeEnvironment cfr_ignored_0 = (RuntimeEnvironment)((Map)data).get("env");
        return this.processor.getStdLibAdapter().Boolean(host.isBooleanSymbol());
    }

    public Object visit(UndefinedLiteralExp host, Object data) {
        RuntimeEnvironment cfr_ignored_0 = (RuntimeEnvironment)((Map)data).get("env");
        return this.processor.getStdLibAdapter().Undefined();
    }

    public Object visit(TypeLiteralExp host, Object data) {
        RuntimeEnvironment cfr_ignored_0 = (RuntimeEnvironment)((Map)data).get("env");
        return this.processor.getStdLibAdapter().Type(host.getLiteralType());
    }

    public Object visit(IntegerLiteralExp host, Object data) {
        RuntimeEnvironment cfr_ignored_0 = (RuntimeEnvironment)((Map)data).get("env");
        return this.processor.getStdLibAdapter().Integer(host.getIntegerSymbol());
    }

    public Object visit(RealLiteralExp host, Object data) {
        RuntimeEnvironment cfr_ignored_0 = (RuntimeEnvironment)((Map)data).get("env");
        return this.processor.getStdLibAdapter().Real(host.getRealSymbol());
    }

    public Object visit(StringLiteralExp host, Object data) {
        RuntimeEnvironment cfr_ignored_0 = (RuntimeEnvironment)((Map)data).get("env");
        return this.processor.getStdLibAdapter().String(host.getStringSymbol());
    }

    public Object visit(EnumLiteralExp host, Object data) {
        return this.processor.getModelEvaluationAdapter().getEnumLiteralValue(host.getReferredEnumLiteral());
    }

    public Object visit(CollectionLiteralExp host, Object data) {
        RuntimeEnvironment cfr_ignored_0 = (RuntimeEnvironment)((Map)data).get("env");
        String cfr_ignored_1 = (String)((Map)data).get("indent");
        OclCollection result = this.processor.getStdLibAdapter().Bag(host.getType());
        CollectionKind kind = host.getKind();
        if (kind == CollectionKind.BAG_LITERAL) {
            result = this.processor.getStdLibAdapter().Bag(host.getType());
        } else if (kind == CollectionKind.ORDERED_SET_LITERAL) {
            result = this.processor.getStdLibAdapter().OrderedSet(host.getType());
        } else if (kind == CollectionKind.SEQUENCE_LITERAL) {
            result = this.processor.getStdLibAdapter().Sequence(host.getType());
        } else if (kind == CollectionKind.SET_LITERAL) {
            result = this.processor.getStdLibAdapter().Set(host.getType());
        }
        for (CollectionLiteralPart part : host.getParts()) {
            if (part instanceof CollectionItem) {
                OclExpression expPart;
                if (part == null || (expPart = ((CollectionItem)part).getItem()) == null) continue;
                OclAny value = (OclAny)expPart.accept(this, data);
                if (kind == CollectionKind.BAG_LITERAL) {
                    result = result.including(value);
                    continue;
                }
                if (kind == CollectionKind.ORDERED_SET_LITERAL) {
                    result = ((OclOrderedSet)result).including(value);
                    continue;
                }
                if (kind == CollectionKind.SEQUENCE_LITERAL) {
                    result = ((OclSequence)result).including(value);
                    continue;
                }
                if (kind != CollectionKind.SET_LITERAL) continue;
                result = ((OclSet)result).including(value);
                continue;
            }
            OclExpression first = ((CollectionRange)part).getFirst();
            OclExpression last = ((CollectionRange)part).getLast();
            Classifier firstType = first.getType();
            Classifier lastType = last.getType();
            if (!(firstType instanceof IntegerType) || !(lastType instanceof IntegerType)) continue;
            OclInteger firstValue = (OclInteger)first.accept(this, data);
            OclInteger lastValue = (OclInteger)last.accept(this, data);
            int j = ((OclIntegerImpl)firstValue).int_impl();
            while (j <= ((OclIntegerImpl)lastValue).int_impl()) {
                OclInteger value = this.processor.getStdLibAdapter().Integer(j);
                if (kind == CollectionKind.BAG_LITERAL) {
                    result = ((OclBag)result).including(value);
                } else if (kind == CollectionKind.ORDERED_SET_LITERAL) {
                    result = ((OclOrderedSet)result).including(value);
                } else if (kind == CollectionKind.SEQUENCE_LITERAL) {
                    result = ((OclSequence)result).including(value);
                } else if (kind == CollectionKind.SET_LITERAL) {
                    result = ((OclSet)result).including(value);
                }
                ++j;
            }
        }
        return result;
    }

    public Object visit(TupleLiteralExp host, Object data) {
        RuntimeEnvironment cfr_ignored_0 = (RuntimeEnvironment)((Map)data).get("env");
        Vector<Classifier> types = new Vector<Classifier>();
        Vector<String> names = new Vector<String>();
        Vector<Object> values = new Vector<Object>();
        for (VariableDeclaration var : host.getTuplePart()) {
            if (var == null) continue;
            String varName = var.getName();
            Object value = null;
            OclExpression initValue = var.getInitExpression();
            if (initValue != null) {
                value = initValue.accept(this, data);
            }
            types.add(var.getType());
            names.add(varName);
            values.add(value);
        }
        OclTuple result = this.processor.getStdLibAdapter().Tuple((TupleType)host.getType(), values.toArray(new OclAny[0]));
        return result;
    }

    public Object visit(OperationCallExp host, Object data) {
        RuntimeEnvironment env = (RuntimeEnvironment)((Map)data).get("env");
        ILog log = (ILog)((Map)data).get("log");
        Classifier sourceType = host.getSource().getType();
        OclAny source = (OclAny)host.getSource().accept(this, data);
        OclAny oclObj = null;
        oclObj = source instanceof Collection ? this.processor.getStdLibAdapter().Collection((Collection)((Object)source)) : (source instanceof Map ? this.processor.getStdLibAdapter().Tuple(null, (Map)((Object)source)) : this.processor.getStdLibAdapter().OclAny(source));
        Vector<Object> javaArgs = new Vector<Object>();
        Vector<Object> javaTypes = new Vector<Object>();
        Vector<Classifier> oclTypes = new Vector<Classifier>();
        Vector<Object> oclArgs = new Vector<Object>();
        for (OclExpression arg : host.getArguments()) {
            Classifier type = arg.getType();
            Object value = null;
            if (arg != null) {
                value = arg.accept(this, data);
            }
            oclTypes.add(type);
            javaTypes.add(type.getDelegate());
            if (value instanceof OclAny) {
                oclArgs.add(value);
                javaArgs.add(((OclAny)value).asJavaObject());
                continue;
            }
            if (value instanceof OclCollection) {
                oclArgs.add(value);
                javaArgs.add(((OclCollection)value).asJavaObject());
                continue;
            }
            javaArgs.add(value);
            oclArgs.add(this.processor.getStdLibAdapter().OclAny(value));
        }
        Classifier c = (Classifier)source.oclType().asJavaObject();
        Operation oper = c.lookupOperation(host.getReferredOperation().getName(), oclTypes);
        if (oper instanceof DefinedOperation) {
            DefinedOperation op = (DefinedOperation)oper;
            RuntimeEnvironment newEnv = env.newEnvironment();
            newEnv.setValue("self", source);
            EList parameters = op.getOwnedParameter();
            Iterator i = parameters.iterator();
            int iarg = 0;
            while (i.hasNext()) {
                Parameter parameter = (Parameter)i.next();
                String name = parameter.getName();
                Object val = javaArgs.get(iarg);
                ++iarg;
                newEnv.setValue(name, val);
            }
            HashMap<String, RuntimeEnvironment> newData = new HashMap<String, RuntimeEnvironment>();
            newData.put("env", newEnv);
            newData.put("log", (RuntimeEnvironment)log);
            return op.getDefinition().getBodyExpression().accept(this, newData);
        }
        String operName = OclEvaluatorVisitorImpl.getFunctionName(host.getReferredOperation());
        if (operName.equals("_default") && sourceType instanceof VoidType) {
            javaTypes = new Vector();
            oclTypes = new Vector();
        }
        Object result = null;
        Operation declaredOp = this.processor.getTypeFactory().buildOclAnyType().lookupOperation(host.getReferredOperation().getName(), oclTypes);
        if (sourceType instanceof OclAnyType && !(sourceType instanceof OclModelElementType)) {
            result = this.invokeOclLibOperation(sourceType, oclObj, operName, oclTypes, oclArgs, log);
        } else if (sourceType instanceof VoidType) {
            result = this.invokeOclLibOperation(sourceType, oclObj, operName, oclTypes, oclArgs, log);
        } else if (sourceType instanceof CollectionType) {
            OclCollection oclColl = null;
            oclColl = source instanceof OclCollection ? (OclCollection)source : this.processor.getStdLibAdapter().Collection((Collection)((Object)source));
            result = this.invokeOclLibOperation(sourceType, oclColl, operName, oclTypes, oclArgs, log);
        } else if (sourceType instanceof TupleType) {
            result = this.invokeOclLibOperation(sourceType, oclObj, operName, oclTypes, oclArgs, log);
        } else if (declaredOp != null) {
            result = this.invokeOclAnyOperation(sourceType, host.getType(), oclObj, operName, oclTypes, oclArgs);
        } else if (sourceType instanceof Enumeration) {
            result = this.invokeEnumerationOperation(sourceType, (OclEnumeration)oclObj, operName, oclTypes, oclArgs);
        } else {
            Object javaObj = source;
            if (javaObj instanceof OclCollection) {
                javaObj = ((OclCollection)javaObj).asJavaObject();
            }
            if (javaObj instanceof OclTuple) {
                javaObj = ((OclTuple)javaObj).asJavaObject();
            }
            if (javaObj instanceof OclAny) {
                javaObj = ((OclAny)javaObj).asJavaObject();
            }
            result = this.invokeModelOperation(sourceType, host.getType(), javaObj, operName, javaTypes, javaArgs, log);
        }
        if (result == null) {
            return this.processor.getStdLibAdapter().Undefined();
        }
        return this.processor.getStdLibAdapter().OclAny(result);
    }

    protected Object invokeModelOperation(Classifier sourceType, Classifier resultType, Object source, String operName, List javaTypes, List args, ILog log) {
        try {
            return this.processor.getModelEvaluationAdapter().invokeModelOperation(sourceType, resultType, source, operName, javaTypes, args, log);
        }
        catch (Exception exception) {
            Object result = null;
            try {
                Method oper = this.getMethod(source, operName, javaTypes.toArray(new Class[0]));
                if (source != null) {
                    if (oper != null) {
                        result = oper.invoke(source, args.toArray());
                    } else {
                        log.reportError("eval: Operation " + operName + javaTypes + " not found on object " + source);
                    }
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            return this.processor.getStdLibAdapter().OclAny(result);
        }
    }

    protected Object invokeOclLibOperation(Classifier sourceType, Object source, String operName, List oclTypes, List args, ILog log) {
        Object result = null;
        Vector<Class> types = new Vector<Class>();
        for (Classifier c : oclTypes) {
            types.add(c.getImplClass());
        }
        try {
            Method oper = this.getMethod(source, operName, types.toArray(new Class[0]));
            if (source != null) {
                if (oper != null) {
                    result = oper.invoke(source, args.toArray());
                } else {
                    log.reportError("eval: Operation " + operName + types + " not found on object " + source);
                    result = this.processor.getStdLibAdapter().Undefined();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    protected Object invokeEnumerationOperation(Classifier sourceType, OclEnumeration source, String operName, List oclTypes, List args) {
        Object result = null;
        Vector<Class> types = new Vector<Class>();
        for (DataType c : oclTypes) {
            types.add(c.getImplClass());
        }
        try {
            Method oper;
            if (operName.equals("equalTo")) {
                if (sourceType instanceof Enumeration) {
                    result = this.processor.getStdLibAdapter().Boolean(this.processor.getModelEvaluationAdapter().EnumLiteral_equalTo(source, (OclAny)args.get(0)));
                } else if (source != null) {
                    oper = this.getMethod(source, operName, types.toArray(new Class[0]));
                    result = oper.invoke((Object)source, args.toArray());
                }
            } else if (operName.equals("notEqualTo")) {
                if (sourceType instanceof Enumeration) {
                    result = this.processor.getStdLibAdapter().Boolean(!this.processor.getModelEvaluationAdapter().EnumLiteral_equalTo(source, (OclAny)args.get(0)));
                } else if (source != null) {
                    oper = this.getMethod(source, operName, types.toArray(new Class[0]));
                    result = oper.invoke((Object)source, args.toArray());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    protected Object invokeOclAnyOperation(Classifier sourceType, Classifier resultType, Object source, String operName, List oclTypes, List args) {
        Vector<Class> types = new Vector<Class>();
        for (DataType c : oclTypes) {
            types.add(c.getImplClass());
        }
        OclAny oclAnySource = this.processor.getStdLibAdapter().OclAny(source);
        Object result = null;
        try {
            Method meth = this.getMethod(oclAnySource, operName, types.toArray(new Class[0]));
            result = meth.invoke((Object)oclAnySource, args.toArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Object visit(PropertyCallExp host, Object data) {
        RuntimeEnvironment env = (RuntimeEnvironment)((Map)data).get("env");
        ILog log = (ILog)((Map)data).get("log");
        Object result = null;
        Property prop = host.getReferredProperty();
        if (!(prop instanceof EnumLiteral)) {
            OclAny source = null;
            boolean isStatic = false;
            Object javaSource = null;
            if (host.getSource() != null) {
                source = (OclAny)host.getSource().accept(this, data);
            } else {
                isStatic = true;
            }
            if (prop instanceof DefinedProperty) {
                RuntimeEnvironment newEnv = env.newEnvironment();
                newEnv.setValue("self", source);
                HashMap<String, RuntimeEnvironment> newData = new HashMap<String, RuntimeEnvironment>();
                newData.put("env", newEnv);
                newData.put("log", (RuntimeEnvironment)log);
                return ((DefinedProperty)prop).getDefinition().getBodyExpression().accept(this, newData);
            }
            if (!isStatic) {
                if (source == null || source instanceof OclUndefined) {
                    return this.processor.getStdLibAdapter().Undefined();
                }
                if (source instanceof OclTuple) {
                    OclString pname = this.processor.getStdLibAdapter().String(host.getReferredProperty().getName());
                    return ((OclTuple)source).property(pname);
                }
                javaSource = source.asJavaObject();
            }
            try {
                result = this.processor.getModelEvaluationAdapter().getValueForFeauture(javaSource, host.getReferredProperty());
            }
            catch (Exception exception) {}
            if (prop.getType() instanceof CollectionType) {
                if (prop.getType() instanceof OrderedSetType) {
                    return this.processor.getStdLibAdapter().OrderedSet(((OrderedSetType)prop.getType()).getElementType(), result);
                }
                if (prop.getType() instanceof SetType) {
                    return this.processor.getStdLibAdapter().Set(((SetType)prop.getType()).getElementType(), result);
                }
                if (prop.getType() instanceof BagType) {
                    return this.processor.getStdLibAdapter().Bag(((BagType)prop.getType()).getElementType(), result);
                }
                if (prop.getType() instanceof SequenceType) {
                    return this.processor.getStdLibAdapter().Sequence(((SequenceType)prop.getType()).getElementType(), result);
                }
                return this.processor.getStdLibAdapter().Sequence(((CollectionType)prop.getType()).getElementType(), result);
            }
            if (result instanceof Collection) {
                return this.processor.getStdLibAdapter().Collection((Collection)result);
            }
            if (prop != null && prop.getType() instanceof Enumeration) {
                return this.processor.getStdLibAdapter().Enumeration(prop.getType(), result);
            }
            return this.processor.getStdLibAdapter().OclAny(result);
        }
        result = this.processor.getStdLibAdapter().Enumeration(host.getType(), prop.getDelegate());
        return result == null ? this.processor.getStdLibAdapter().Undefined() : result;
    }

    protected Map computeIteratorAttributes(OclExpression source, VariableDeclaration var, Map data) {
        RuntimeEnvironment cfr_ignored_0 = (RuntimeEnvironment)data.get("env");
        if (source == null) {
            return null;
        }
        if (!(source.getType() instanceof CollectionType)) {
            return null;
        }
        String name = null;
        Classifier type = null;
        Object value = null;
        if (var != null) {
            name = var.getName();
            var.getType();
            Classifier elementType = ((CollectionType)source.getType()).getElementType();
            if (type == null) {
                type = elementType;
            }
            if (var.getInitExpression() != null) {
                value = var.getInitExpression().accept(this, data);
            }
        } else {
            name = OclEvaluatorVisitorImpl.newTempVar();
            type = (Classifier)((CollectionType)source.getType()).getElementType().accept(this, data);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("name", name);
        result.put("type", type);
        result.put("value", value);
        return result;
    }

    protected Iterator initIterator(Classifier sourceType, Object sourceValue, ILog log) {
        if (sourceValue instanceof OclUndefined) {
            return null;
        }
        Iterator i = null;
        if (sourceValue instanceof Collection) {
            i = ((Collection)sourceValue).iterator();
        } else if (sourceValue instanceof OclCollection) {
            i = ((Collection)((OclCollectionImpl)sourceValue).getImplementation()).iterator();
        } else {
            return null;
        }
        return i;
    }

    protected OclBoolean exists(IteratorExp host, VariableDeclaration var1, VariableDeclaration var2, OclExpression body, Map data) {
        RuntimeEnvironment env = (RuntimeEnvironment)data.get("env");
        ILog log = (ILog)data.get("log");
        OclExpression source = host.getSource();
        Object sourceValue = source.accept(this, data);
        Classifier sourceType = source.getType();
        Map it1 = this.computeIteratorAttributes(source, var1, data);
        String it1Name = (String)it1.get("name");
        Classifier cfr_ignored_0 = (Classifier)it1.get("type");
        String it1Value = (String)it1.get("value");
        if (var2 != null) {
            this.computeIteratorAttributes(source, var1, data);
            String cfr_ignored_1 = (String)it1.get("name");
            Classifier cfr_ignored_2 = (Classifier)it1.get("type");
            it1.get("value");
        }
        OclBoolean result = this.processor.getStdLibAdapter().Boolean(false);
        Iterator i = this.initIterator(sourceType, sourceValue, log);
        if (i == null) {
            return this.processor.getStdLibAdapter().Undefined();
        }
        RuntimeEnvironment newEnv = env.newEnvironment();
        HashMap<String, RuntimeEnvironment> newData = new HashMap<String, RuntimeEnvironment>();
        newData.putAll(data);
        newData.put("env", newEnv);
        while (i.hasNext()) {
            it1Value = i.next();
            newEnv.setValue(it1Name, it1Value);
            Object bodyValue = body.accept(this, newData);
            result = (OclBoolean)bodyValue;
            if (result instanceof OclUndefined) {
                result = this.processor.getStdLibAdapter().Boolean(false);
                continue;
            }
            if ((OclBooleanImpl)result == OclBooleanImpl.TRUE) break;
        }
        return result;
    }

    protected Object forAll(IteratorExp host, VariableDeclaration var1, VariableDeclaration var2, OclExpression body, Map data) {
        RuntimeEnvironment env = (RuntimeEnvironment)data.get("env");
        ILog log = (ILog)data.get("log");
        OclExpression source = host.getSource();
        Object sourceValue = source.accept(this, data);
        Classifier sourceType = source.getType();
        Map it1 = this.computeIteratorAttributes(source, var1, data);
        String it1Name = (String)it1.get("name");
        Classifier cfr_ignored_0 = (Classifier)it1.get("type");
        String it1Value = (String)it1.get("value");
        if (var2 != null) {
            this.computeIteratorAttributes(source, var1, data);
            String cfr_ignored_1 = (String)it1.get("name");
            Classifier cfr_ignored_2 = (Classifier)it1.get("type");
            it1.get("value");
        }
        OclBoolean result = this.processor.getStdLibAdapter().Boolean(true);
        Iterator i = this.initIterator(sourceType, sourceValue, log);
        if (i == null) {
            return this.processor.getStdLibAdapter().Undefined();
        }
        RuntimeEnvironment newEnv = env.newEnvironment();
        HashMap<String, RuntimeEnvironment> newData = new HashMap<String, RuntimeEnvironment>();
        newData.putAll(data);
        newData.put("env", newEnv);
        while (i.hasNext()) {
            it1Value = i.next();
            newEnv.setValue(it1Name, it1Value);
            Object bodyValue = body.accept(this, newData);
            result = (OclBoolean)bodyValue;
            if (result != OclBooleanImpl.TRUE) break;
        }
        return result;
    }

    protected Object isUnique(IteratorExp host, VariableDeclaration var1, VariableDeclaration var2, OclExpression body, Map data) {
        RuntimeEnvironment env = (RuntimeEnvironment)data.get("env");
        ILog log = (ILog)data.get("log");
        OclExpression source = host.getSource();
        Object sourceValue = source.accept(this, data);
        Classifier sourceType = source.getType();
        Map it1 = this.computeIteratorAttributes(source, var1, data);
        String it1Name = (String)it1.get("name");
        Classifier cfr_ignored_0 = (Classifier)it1.get("type");
        String it1Value = (String)it1.get("value");
        if (var2 != null) {
            this.computeIteratorAttributes(source, var1, data);
            String cfr_ignored_1 = (String)it1.get("name");
            Classifier cfr_ignored_2 = (Classifier)it1.get("type");
            it1.get("value");
        }
        OclBoolean result = this.processor.getStdLibAdapter().Boolean(true);
        OclSet tempSet = this.processor.getStdLibAdapter().Set(host.getType());
        Iterator i = this.initIterator(sourceType, sourceValue, log);
        if (i == null) {
            return this.processor.getStdLibAdapter().Undefined();
        }
        RuntimeEnvironment newEnv = env.newEnvironment();
        HashMap<String, RuntimeEnvironment> newData = new HashMap<String, RuntimeEnvironment>();
        newData.putAll(data);
        newData.put("env", newEnv);
        while (i.hasNext()) {
            it1Value = i.next();
            newEnv.setValue(it1Name, it1Value);
            OclAny bodyValue = (OclAny)body.accept(this, newData);
            OclBoolean found = tempSet.includes(bodyValue);
            tempSet = tempSet.including(bodyValue);
            if (found != OclBooleanImpl.TRUE) continue;
            result = this.processor.getStdLibAdapter().Boolean(false);
            break;
        }
        return result;
    }

    protected Object any(IteratorExp host, VariableDeclaration var1, VariableDeclaration var2, OclExpression body, Map data) {
        RuntimeEnvironment env = (RuntimeEnvironment)data.get("env");
        ILog log = (ILog)data.get("log");
        OclExpression source = host.getSource();
        Object sourceValue = source.accept(this, data);
        Classifier sourceType = source.getType();
        Map it1 = this.computeIteratorAttributes(source, var1, data);
        if (it1 == null) {
            return null;
        }
        String it1Name = (String)it1.get("name");
        Classifier cfr_ignored_0 = (Classifier)it1.get("type");
        String it1Value = (String)it1.get("value");
        if (var2 != null) {
            this.computeIteratorAttributes(source, var1, data);
            String cfr_ignored_1 = (String)it1.get("name");
            Classifier cfr_ignored_2 = (Classifier)it1.get("type");
            it1.get("value");
        }
        Object result = this.processor.getStdLibAdapter().Undefined();
        Iterator i = this.initIterator(sourceType, sourceValue, log);
        if (i == null) {
            return this.processor.getStdLibAdapter().Undefined();
        }
        RuntimeEnvironment newEnv = env.newEnvironment();
        HashMap<String, RuntimeEnvironment> newData = new HashMap<String, RuntimeEnvironment>();
        newData.putAll(data);
        newData.put("env", newEnv);
        while (i.hasNext()) {
            it1Value = i.next();
            newEnv.setValue(it1Name, it1Value);
            Object bodyValue = body.accept(this, newData);
            if (bodyValue instanceof OclUndefined || (OclBoolean)bodyValue != OclBooleanImpl.TRUE) continue;
            result = it1Value;
            break;
        }
        return result;
    }

    protected Object one(IteratorExp host, VariableDeclaration var1, VariableDeclaration var2, OclExpression body, Map data) {
        RuntimeEnvironment env = (RuntimeEnvironment)data.get("env");
        ILog log = (ILog)data.get("log");
        OclExpression source = host.getSource();
        Object sourceValue = source.accept(this, data);
        Classifier sourceType = source.getType();
        Map it1 = this.computeIteratorAttributes(source, var1, data);
        String it1Name = (String)it1.get("name");
        Classifier cfr_ignored_0 = (Classifier)it1.get("type");
        String it1Value = (String)it1.get("value");
        if (var2 != null) {
            this.computeIteratorAttributes(source, var1, data);
            String cfr_ignored_1 = (String)it1.get("name");
            Classifier cfr_ignored_2 = (Classifier)it1.get("type");
            it1.get("value");
        }
        OclBoolean result = this.processor.getStdLibAdapter().Boolean(false);
        this.processor.getStdLibAdapter().Set(host.getType());
        Iterator i = this.initIterator(sourceType, sourceValue, log);
        if (i == null) {
            return this.processor.getStdLibAdapter().Undefined();
        }
        RuntimeEnvironment newEnv = env.newEnvironment();
        HashMap<String, RuntimeEnvironment> newData = new HashMap<String, RuntimeEnvironment>();
        newData.putAll(data);
        newData.put("env", newEnv);
        int counter = 0;
        while (i.hasNext()) {
            it1Value = i.next();
            newEnv.setValue(it1Name, it1Value);
            Object bodyValue = body.accept(this, newData);
            if ((OclBoolean)bodyValue != OclBooleanImpl.TRUE) continue;
            if (++counter == 1) {
                result = this.processor.getStdLibAdapter().Boolean(true);
            }
            if (counter <= 1) continue;
            result = this.processor.getStdLibAdapter().Boolean(false);
            break;
        }
        return result;
    }

    protected Object collect(IteratorExp host, VariableDeclaration var1, VariableDeclaration var2, OclExpression body, Map data) {
        RuntimeEnvironment cfr_ignored_0 = (RuntimeEnvironment)data.get("env");
        Object result = this.collectNested(host, var1, var2, body, data);
        if (result instanceof OclUndefined) {
            return result;
        }
        Classifier hostType = host.getType();
        if (hostType instanceof BagType) {
            result = ((OclBag)result).flatten();
        } else if (hostType instanceof OrderedSetType) {
            result = ((OclOrderedSet)result).flatten();
        } else if (hostType instanceof SetType) {
            result = ((OclSet)result).flatten();
        } else if (hostType instanceof SequenceType) {
            result = ((OclSequence)result).flatten();
        }
        return result;
    }

    protected OclCollection initCollection(CollectionType type) {
        OclCollection result = null;
        Classifier eT = type.getElementType();
        if (type instanceof BagType) {
            result = this.processor.getStdLibAdapter().Bag(eT);
        } else if (type instanceof OrderedSetType) {
            result = this.processor.getStdLibAdapter().OrderedSet(eT);
        } else if (type instanceof SetType) {
            result = this.processor.getStdLibAdapter().Set(eT);
        } else if (type instanceof SequenceType) {
            result = this.processor.getStdLibAdapter().Sequence(eT);
        }
        return result;
    }

    protected Object select(IteratorExp host, VariableDeclaration var1, VariableDeclaration var2, OclExpression body, Map data) {
        RuntimeEnvironment env = (RuntimeEnvironment)data.get("env");
        ILog log = (ILog)data.get("log");
        OclExpression source = host.getSource();
        Object sourceValue = source.accept(this, data);
        Classifier sourceType = source.getType();
        Map it1 = this.computeIteratorAttributes(source, var1, data);
        if (it1 == null) {
            return null;
        }
        String it1Name = (String)it1.get("name");
        Classifier cfr_ignored_0 = (Classifier)it1.get("type");
        OclAny it1Value = (OclAny)it1.get("value");
        if (var2 != null) {
            this.computeIteratorAttributes(source, var1, data);
            String cfr_ignored_1 = (String)it1.get("name");
            Classifier cfr_ignored_2 = (Classifier)it1.get("type");
            OclAny cfr_ignored_3 = (OclAny)it1.get("value");
        }
        Classifier hostType = host.getType();
        OclCollection result = this.initCollection((CollectionType)hostType);
        Iterator i = this.initIterator(sourceType, sourceValue, log);
        if (i == null) {
            return this.processor.getStdLibAdapter().Undefined();
        }
        RuntimeEnvironment newEnv = env.newEnvironment();
        HashMap<String, RuntimeEnvironment> newData = new HashMap<String, RuntimeEnvironment>();
        newData.putAll(data);
        newData.put("env", newEnv);
        while (i.hasNext()) {
            it1Value = this.processor.getStdLibAdapter().OclAny(i.next());
            newEnv.setValue(it1Name, it1Value);
            Object obj = body.accept(this, newData);
            OclBoolean bodyValue = (OclBoolean)obj;
            if (bodyValue instanceof OclUndefined || bodyValue != OclBooleanImpl.TRUE) continue;
            if (hostType instanceof BagType) {
                result = ((OclBag)result).including(it1Value);
                continue;
            }
            if (hostType instanceof OrderedSetType) {
                if (((Collection)result.asJavaObject()).contains(it1Value)) continue;
                result = ((OclOrderedSet)result).including(it1Value);
                continue;
            }
            if (hostType instanceof SetType) {
                result = ((OclSet)result).including(it1Value);
                continue;
            }
            if (!(hostType instanceof SequenceType)) continue;
            result = ((OclSequence)result).including(it1Value);
        }
        return result;
    }

    protected Object reject(IteratorExp host, VariableDeclaration var1, VariableDeclaration var2, OclExpression body, Map data) {
        RuntimeEnvironment env = (RuntimeEnvironment)data.get("env");
        ILog log = (ILog)data.get("log");
        OclExpression source = host.getSource();
        Object sourceValue = source.accept(this, data);
        Classifier sourceType = source.getType();
        Map it1 = this.computeIteratorAttributes(source, var1, data);
        String it1Name = (String)it1.get("name");
        Classifier cfr_ignored_0 = (Classifier)it1.get("type");
        OclAny it1Value = (OclAny)it1.get("value");
        if (var2 != null) {
            this.computeIteratorAttributes(source, var1, data);
            String cfr_ignored_1 = (String)it1.get("name");
            Classifier cfr_ignored_2 = (Classifier)it1.get("type");
            OclAny cfr_ignored_3 = (OclAny)it1.get("value");
        }
        Classifier hostType = host.getType();
        OclCollection result = this.initCollection((CollectionType)hostType);
        Iterator i = this.initIterator(sourceType, sourceValue, log);
        if (i == null) {
            return this.processor.getStdLibAdapter().Undefined();
        }
        RuntimeEnvironment newEnv = env.newEnvironment();
        HashMap<String, RuntimeEnvironment> newData = new HashMap<String, RuntimeEnvironment>();
        newData.putAll(data);
        newData.put("env", newEnv);
        while (i.hasNext()) {
            it1Value = this.processor.getStdLibAdapter().OclAny(i.next());
            newEnv.setValue(it1Name, it1Value);
            Object bodyValue = body.accept(this, newData);
            if ((OclBoolean)bodyValue == OclBooleanImpl.TRUE) continue;
            if (hostType instanceof BagType) {
                result = ((OclBag)result).including(it1Value);
                continue;
            }
            if (hostType instanceof OrderedSetType) {
                if (((Collection)result.asJavaObject()).contains(it1Value)) continue;
                result = ((OclOrderedSet)result).including(it1Value);
                continue;
            }
            if (hostType instanceof SetType) {
                result = ((OclSet)result).including(it1Value);
                continue;
            }
            if (!(hostType instanceof SequenceType)) continue;
            result = ((OclSequence)result).including(it1Value);
        }
        return result;
    }

    protected Object collectNested(IteratorExp host, VariableDeclaration var1, VariableDeclaration var2, OclExpression body, Map data) {
        RuntimeEnvironment env = (RuntimeEnvironment)data.get("env");
        ILog log = (ILog)data.get("log");
        OclExpression source = host.getSource();
        Object sourceValue = source.accept(this, data);
        Classifier sourceType = source.getType();
        Map it1 = this.computeIteratorAttributes(source, var1, data);
        String it1Name = (String)it1.get("name");
        Classifier cfr_ignored_0 = (Classifier)it1.get("type");
        OclAny it1Value = (OclAny)it1.get("value");
        if (var2 != null) {
            this.computeIteratorAttributes(source, var1, data);
            String cfr_ignored_1 = (String)it1.get("name");
            Classifier cfr_ignored_2 = (Classifier)it1.get("type");
            it1.get("value");
        }
        Classifier hostType = host.getType();
        OclCollection result = this.initCollection((CollectionType)hostType);
        Iterator i = this.initIterator(sourceType, sourceValue, log);
        if (i == null) {
            return this.processor.getStdLibAdapter().Undefined();
        }
        RuntimeEnvironment newEnv = env.newEnvironment();
        HashMap<String, RuntimeEnvironment> newData = new HashMap<String, RuntimeEnvironment>();
        newData.putAll(data);
        newData.put("env", newEnv);
        while (i.hasNext()) {
            it1Value = this.processor.getStdLibAdapter().OclAny(i.next());
            newEnv.setValue(it1Name, it1Value);
            OclAny bodyValue = this.processor.getStdLibAdapter().OclAny(body.accept(this, newData));
            if (hostType instanceof BagType) {
                result = ((OclBag)result).including(bodyValue);
                continue;
            }
            if (hostType instanceof OrderedSetType) {
                if (((Collection)result.asJavaObject()).contains(it1Value)) continue;
                result = ((OclOrderedSet)result).including(bodyValue);
                continue;
            }
            if (hostType instanceof SetType) {
                result = ((OclSet)result).including(bodyValue);
                continue;
            }
            if (!(hostType instanceof SequenceType)) continue;
            result = ((OclSequence)result).including(bodyValue);
        }
        return result;
    }

    protected Object sortedBy(IteratorExp host, VariableDeclaration var1, VariableDeclaration var2, OclExpression body, Map data) {
        RuntimeEnvironment env = (RuntimeEnvironment)data.get("env");
        ILog log = (ILog)data.get("log");
        OclExpression source = host.getSource();
        Object sourceValue = source.accept(this, data);
        Classifier sourceType = source.getType();
        Classifier bodyType = body.getType();
        Operation gtop = null;
        gtop = bodyType instanceof OclModelElementType ? bodyType.lookupOperation("greaterThan", Arrays.asList(bodyType)) : bodyType.lookupOperation(">", Arrays.asList(bodyType));
        if (gtop == null) {
            log.reportError("'sortedBy' is only suppoted for body expression types that support a '>' ('greaterThan') operation. Got body type - " + body.getType());
            return null;
        }
        Map it1 = this.computeIteratorAttributes(source, var1, data);
        String it1Name = (String)it1.get("name");
        Classifier cfr_ignored_0 = (Classifier)it1.get("type");
        Object it1Value = (String)it1.get("value");
        if (var2 != null) {
            this.computeIteratorAttributes(source, var1, data);
            String cfr_ignored_1 = (String)it1.get("name");
            Classifier cfr_ignored_2 = (Classifier)it1.get("type");
            it1.get("value");
        }
        new Vector();
        Iterator i = this.initIterator(sourceType, sourceValue, log);
        if (i == null) {
            return this.processor.getStdLibAdapter().Undefined();
        }
        RuntimeEnvironment newEnv = env.newEnvironment();
        HashMap<String, RuntimeEnvironment> newData = new HashMap<String, RuntimeEnvironment>();
        newData.putAll(data);
        newData.put("env", newEnv);
        Vector<Object> bodyList = new Vector<Object>();
        Vector<Object> itemList = new Vector<Object>();
        while (i.hasNext()) {
            it1Value = this.processor.getStdLibAdapter().OclAny(i.next());
            newEnv.setValue(it1Name, it1Value);
            Object bodyValue = body.accept(this, newData);
            bodyList.add(this.wrapJavaObjectAsOclType(body.getType(), bodyValue));
            itemList.add(it1Value);
        }
        boolean ordered = true;
        do {
            ordered = true;
            int k = 0;
            while (k < itemList.size() - 1) {
                Object k1 = bodyList.get(k);
                Object k2 = bodyList.get(k + 1);
                Object obj = null;
                try {
                    if (k1 instanceof OclUndefined) {
                        obj = this.processor.getStdLibAdapter().Boolean(false);
                    } else {
                        Method greaterThanMethod = this.getGreaterThanMethod(k1, k2, log);
                        obj = greaterThanMethod.invoke(k1, k2);
                    }
                }
                catch (Exception exception) {
                    log.reportError("Proplem executing greaterThan method on object - " + k1);
                    return null;
                }
                boolean gt = false;
                if (obj instanceof Boolean) {
                    gt = (Boolean)obj;
                }
                if (obj instanceof OclBoolean && !(obj instanceof OclUndefined)) {
                    boolean bl = gt = (OclBoolean)obj == OclBooleanImpl.TRUE;
                }
                if (gt) {
                    Object temp = k1;
                    bodyList.set(k, k2);
                    bodyList.set(k + 1, temp);
                    temp = itemList.get(k);
                    itemList.set(k, itemList.get(k + 1));
                    itemList.set(k + 1, temp);
                    ordered = false;
                }
                ++k;
            }
        } while (!ordered);
        OclCollection result = null;
        CollectionType hostType = (CollectionType)host.getType();
        Classifier eT = hostType.getElementType();
        if (hostType instanceof BagType) {
            result = this.processor.getStdLibAdapter().Sequence(eT, itemList);
        } else if (hostType instanceof OrderedSetType) {
            result = this.processor.getStdLibAdapter().OrderedSet(eT, itemList);
        } else if (hostType instanceof SetType) {
            result = this.processor.getStdLibAdapter().OrderedSet(eT, itemList);
        } else if (hostType instanceof SequenceType) {
            result = this.processor.getStdLibAdapter().Sequence(eT, itemList);
        }
        return result;
    }

    Method getGreaterThanMethod(Object o, Object p, ILog log) {
        Method greaterThanMethod = null;
        Class<?> c = null;
        try {
            c = p.getClass();
            greaterThanMethod = this.getMethod(o, "greaterThan", new Class[]{c});
            if (greaterThanMethod == null) {
                log.reportError("Proplem finding greaterThan method on class - " + c);
            }
        }
        catch (Exception exception) {
            log.reportError("Proplem finding greaterThan method on class - " + c);
            return null;
        }
        return greaterThanMethod;
    }

    public Object visit(IteratorExp host, Object data) {
        RuntimeEnvironment cfr_ignored_0 = (RuntimeEnvironment)((Map)data).get("env");
        String cfr_ignored_1 = (String)((Map)data).get("indent");
        String name = host.getName();
        VariableDeclaration var1 = null;
        if (host.getIterators().size() >= 1) {
            var1 = (VariableDeclaration)host.getIterators().toArray()[0];
        }
        VariableDeclaration var2 = null;
        if (host.getIterators().size() >= 2) {
            var2 = (VariableDeclaration)host.getIterators().toArray()[1];
        }
        OclExpression body = host.getBody();
        Object result = null;
        if (name.equals("exists")) {
            result = this.exists(host, var1, var2, body, (Map)data);
        } else if (name.equals("forAll")) {
            result = this.forAll(host, var1, var2, body, (Map)data);
        } else if (name.equals("isUnique")) {
            result = this.isUnique(host, var1, var2, body, (Map)data);
        } else if (name.equals("any")) {
            result = this.any(host, var1, var2, body, (Map)data);
        } else if (name.equals("one")) {
            result = this.one(host, var1, var2, body, (Map)data);
        } else if (name.equals("collect")) {
            result = this.collect(host, var1, var2, body, (Map)data);
        } else if (name.equals("select")) {
            result = this.select(host, var1, var2, body, (Map)data);
        } else if (name.equals("reject")) {
            result = this.reject(host, var1, var2, body, (Map)data);
        } else if (name.equals("collectNested")) {
            result = this.collectNested(host, var1, var2, body, (Map)data);
        } else if (name.equals("sortedBy")) {
            result = this.sortedBy(host, var1, var2, body, (Map)data);
        }
        return this.processor.getStdLibAdapter().OclAny(result);
    }

    protected Object iterate(OclExpression source, VariableDeclaration var1, VariableDeclaration var2, OclExpression body, Map data) {
        RuntimeEnvironment env = (RuntimeEnvironment)data.get("env");
        ILog log = (ILog)data.get("log");
        Object sourceValue = source.accept(this, data);
        Classifier sourceType = source.getType();
        String it1Name = null;
        Classifier it1Type = null;
        Object it1Value = null;
        if (var1 != null) {
            it1Name = var1.getName();
            it1Type = var1.getType();
            if (it1Type == null) {
                it1Type = ((CollectionType)source.getType()).getElementType();
            }
            if (var1.getInitExpression() != null) {
                it1Value = var1.getInitExpression().accept(this, data);
            }
        } else {
            it1Name = "i1";
            it1Type = ((CollectionType)source.getType()).getElementType();
        }
        String accName = null;
        Object accValue = null;
        if (var2 != null) {
            accName = var2.getName();
            var2.getType();
            accValue = var2.getInitExpression().accept(this, data);
        }
        Iterator i = null;
        i = this.initIterator(sourceType, sourceValue, log);
        if (i == null) {
            return this.processor.getStdLibAdapter().Undefined();
        }
        RuntimeEnvironment newEnv = env.newEnvironment();
        HashMap<String, RuntimeEnvironment> newData = new HashMap<String, RuntimeEnvironment>();
        newData.putAll(data);
        newData.put("env", newEnv);
        while (i.hasNext()) {
            Object bodyValue;
            it1Value = this.processor.getStdLibAdapter().OclAny(i.next());
            newEnv.setValue(it1Name, it1Value);
            newEnv.setValue(accName, accValue);
            accValue = bodyValue = body.accept(this, newData);
        }
        return accValue;
    }

    public Object visit(IterateExp host, Object data) {
        RuntimeEnvironment cfr_ignored_0 = (RuntimeEnvironment)((Map)data).get("env");
        String cfr_ignored_1 = (String)((Map)data).get("indent");
        OclExpression source = host.getSource();
        VariableDeclaration var1 = null;
        if (host.getIterators() != null && host.getIterators().size() > 0) {
            var1 = (VariableDeclaration)host.getIterators().toArray()[0];
        }
        VariableDeclaration var2 = host.getResult();
        OclExpression body = host.getBody();
        return this.iterate(source, var1, var2, body, (Map)data);
    }

    public Object visit(VariableExp host, Object data) {
        RuntimeEnvironment env = (RuntimeEnvironment)((Map)data).get("env");
        Object result = null;
        if (host.getReferredVariable() != null) {
            result = env.getValue(host.getReferredVariable().getName());
            Classifier type = host.getType();
            result = this.wrapJavaObjectAsOclType(type, result);
        }
        return result;
    }

    public Object visit(IfExp host, Object data) {
        RuntimeEnvironment cfr_ignored_0 = (RuntimeEnvironment)((Map)data).get("env");
        Object condition = host.getCondition().accept(this, data);
        Object result = null;
        if (condition instanceof OclUndefined) {
            return condition;
        }
        if (condition instanceof OclBoolean) {
            result = (OclBooleanImpl)condition == OclBooleanImpl.TRUE ? host.getThenExpression().accept(this, data) : host.getElseExpression().accept(this, data);
        }
        return result;
    }

    public Object visit(LetExp host, Object data) {
        RuntimeEnvironment env = (RuntimeEnvironment)((Map)data).get("env");
        ILog log = (ILog)((Map)data).get("log");
        HashMap<String, RuntimeEnvironment> newMap = new HashMap<String, RuntimeEnvironment>();
        env = env.newEnvironment();
        newMap.put("env", env);
        newMap.put("log", (RuntimeEnvironment)log);
        VariableDeclaration var = host.getVariable();
        if (var != null) {
            var.accept(this, newMap);
        }
        Object result = null;
        if (host.getIn() != null) {
            result = host.getIn().accept(this, newMap);
        }
        return result;
    }

    public Object visit(OclMessageExp host, Object data) {
        return null;
    }

    public Object visit(OclMessageArg host, Object data) {
        return null;
    }

    public Object visit(UnspecifiedValueExp host, Object data) {
        return null;
    }

    public Object visit(OclAnyType host, Object data) {
        return "OclAny";
    }

    public Object visit(DataType host, Object data) {
        return "OclAny";
    }

    public Object visit(Primitive host, Object data) {
        return "OclAny";
    }

    public Object visit(BooleanType host, Object data) {
        return "OclBoolean";
    }

    public Object visit(IntegerType host, Object data) {
        return "OclInteger";
    }

    public Object visit(RealType host, Object data) {
        return "OclReal";
    }

    public Object visit(StringType host, Object data) {
        return "OclString";
    }

    public Object visit(TupleType host, Object data) {
        return "OclTuple";
    }

    public Object visit(CollectionType host, Object data) {
        return "OclCollection";
    }

    public Object visit(SequenceType host, Object data) {
        return "OclSequence";
    }

    public Object visit(OrderedSetType host, Object data) {
        return "OclOrderedSet";
    }

    public Object visit(SetType host, Object data) {
        return "OclSet";
    }

    public Object visit(BagType host, Object data) {
        return "OclBag";
    }

    public Object visit(OclModelElementType host, Object data) {
        return host.getName();
    }

    public Object visit(OclMessageType host, Object data) {
        return "OclMessageType";
    }

    public Object visit(VoidType host, Object data) {
        return host.toString();
    }

    public Object visit(Property host, Object data) {
        return null;
    }

    public Object visit(CollectionKind host, Object data) {
        return null;
    }

    public Object visit(CollectionRange host, Object data) {
        return null;
    }

    public Object visit(CollectionLiteralPart host, Object data) {
        return null;
    }

    public Object visit(CollectionItem host, Object data) {
        return null;
    }

    public Object visit(ContextDeclaration host, Object data) {
        return null;
    }

    public Object visit(OperationContextDecl host, Object data) {
        return null;
    }

    public Object visit(PropertyContextDecl host, Object data) {
        return null;
    }

    public String getConName(Constraint con) {
        String n = con.getName();
        if (n == null || n.equals("")) {
            return "inv$" + cons++;
        }
        return n;
    }

    public Object visit(ClassifierContextDecl host, Object data) {
        ILog log = (ILog)((Map)data).get("log");
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Constraint con : host.getConstraint()) {
            String name = this.getConName(con);
            if (con.getKind() != ConstraintKind.INV_LITERAL) continue;
            OclExpression exp = con.getBodyExpression();
            if (exp != null) {
                RuntimeEnvironment renv = (RuntimeEnvironment)((Map)data).get("env");
                boolean selfIsDefined = true;
                Object initialSelf = renv.getValue("self");
                if (initialSelf instanceof OclAny) {
                    if (this.processor.getStdLibAdapter().Undefined().oclIsUndefined() == OclBooleanImpl.TRUE) {
                        selfIsDefined = false;
                    }
                } else if (initialSelf instanceof OclCollection && this.processor.getStdLibAdapter().Undefined().oclIsUndefined() == OclBooleanImpl.TRUE) {
                    selfIsDefined = false;
                }
                if (((ClassifierContextDecl)con.getContext()).getReferredClassifier().conformsTo(this.processor.getTypeFactory().buildVoidType()).booleanValue() || selfIsDefined) {
                    result.put(name, exp.accept(this, data));
                    continue;
                }
                if (!exp.getType().conformsTo(this.processor.getTypeFactory().buildBooleanType()).booleanValue()) {
                    log.reportError("A constraint must evaluate to OclBoolean. Current body type is " + exp.getType());
                    result.put(name, this.processor.getStdLibAdapter().Undefined());
                    return result;
                }
                OclSet allAsSet = this.processor.getModelEvaluationAdapter().OclType_allInstances(this.processor.getStdLibAdapter().Type(((ClassifierContextDecl)con.getContext()).getReferredClassifier()));
                OclSequence allAsSequence = allAsSet.asSequence();
                int size = ((OclIntegerImpl)allAsSequence.size()).int_impl();
                OclBoolean retValue = this.processor.getStdLibAdapter().Boolean(true);
                int i = 0;
                while (i < size) {
                    renv.setValue("self", allAsSequence.at(this.processor.getStdLibAdapter().Integer(i + 1)));
                    OclBoolean tempValue = (OclBoolean)exp.accept(this, data);
                    retValue = retValue.and(tempValue);
                    ++i;
                }
                result.put(name, retValue);
                continue;
            }
            result.put(name, this.processor.getStdLibAdapter().Undefined());
        }
        return result;
    }

    public Object visit(SendAction host, Object data) {
        return null;
    }

    public Object visit(ModelElement host, Object data) {
        return null;
    }

    public Object visit(EnumLiteral host, Object data) {
        return null;
    }

    public Object visit(CallAction host, Object data) {
        return null;
    }

    public Object visit(Signal host, Object data) {
        return null;
    }

    public Object visit(Namespace host, Object data) {
        return null;
    }

    public Object visit(Environment host, Object data) {
        return null;
    }

    public Object visit(Classifier host, Object data) {
        return "Classifier";
    }

    public Object visit(Enumeration host, Object data) {
        return host.getName();
    }

    public Object visit(NamedElement host, Object data) {
        return null;
    }

    public Object visit(Operation host, Object data) {
        return null;
    }

    public Object visit(Tag host, Object data) {
        return null;
    }

    public Object visit(Constraint host, Object data) {
        return null;
    }
}

