/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.syntax.parser;

import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.oslo.ocl20.syntax.ast.AstFactory;
import org.oslo.ocl20.syntax.ast.contexts.ClassifierContextDeclAS;
import org.oslo.ocl20.syntax.ast.contexts.ConstraintAS;
import org.oslo.ocl20.syntax.ast.contexts.ConstraintKindAS;
import org.oslo.ocl20.syntax.ast.contexts.ContextsFactory;
import org.oslo.ocl20.syntax.ast.contexts.OperationAS;
import org.oslo.ocl20.syntax.ast.contexts.OperationContextDeclAS;
import org.oslo.ocl20.syntax.ast.contexts.PackageDeclarationAS;
import org.oslo.ocl20.syntax.ast.contexts.PropertyContextDeclAS;
import org.oslo.ocl20.syntax.ast.contexts.VariableDeclarationAS;
import org.oslo.ocl20.syntax.ast.expressions.AndExpAS;
import org.oslo.ocl20.syntax.ast.expressions.ArrowSelectionExpAS;
import org.oslo.ocl20.syntax.ast.expressions.AssociationCallExpAS;
import org.oslo.ocl20.syntax.ast.expressions.BooleanLiteralExpAS;
import org.oslo.ocl20.syntax.ast.expressions.CallExpAS;
import org.oslo.ocl20.syntax.ast.expressions.CollectionItemAS;
import org.oslo.ocl20.syntax.ast.expressions.CollectionKindAS;
import org.oslo.ocl20.syntax.ast.expressions.CollectionLiteralExpAS;
import org.oslo.ocl20.syntax.ast.expressions.CollectionRangeAS;
import org.oslo.ocl20.syntax.ast.expressions.DotSelectionExpAS;
import org.oslo.ocl20.syntax.ast.expressions.EnumLiteralExpAS;
import org.oslo.ocl20.syntax.ast.expressions.ExpressionsFactory;
import org.oslo.ocl20.syntax.ast.expressions.IfExpAS;
import org.oslo.ocl20.syntax.ast.expressions.ImpliesExpAS;
import org.oslo.ocl20.syntax.ast.expressions.IntegerLiteralExpAS;
import org.oslo.ocl20.syntax.ast.expressions.IterateExpAS;
import org.oslo.ocl20.syntax.ast.expressions.IteratorExpAS;
import org.oslo.ocl20.syntax.ast.expressions.LetExpAS;
import org.oslo.ocl20.syntax.ast.expressions.LoopExpAS;
import org.oslo.ocl20.syntax.ast.expressions.NotExpAS;
import org.oslo.ocl20.syntax.ast.expressions.OclExpressionAS;
import org.oslo.ocl20.syntax.ast.expressions.OclMessageArgAS;
import org.oslo.ocl20.syntax.ast.expressions.OclMessageExpAS;
import org.oslo.ocl20.syntax.ast.expressions.OclMessageKindAS;
import org.oslo.ocl20.syntax.ast.expressions.OperationCallExpAS;
import org.oslo.ocl20.syntax.ast.expressions.OrExpAS;
import org.oslo.ocl20.syntax.ast.expressions.PathNameExpAS;
import org.oslo.ocl20.syntax.ast.expressions.RealLiteralExpAS;
import org.oslo.ocl20.syntax.ast.expressions.StringLiteralExpAS;
import org.oslo.ocl20.syntax.ast.expressions.TupleLiteralExpAS;
import org.oslo.ocl20.syntax.ast.expressions.XorExpAS;
import org.oslo.ocl20.syntax.ast.types.ClassifierAS;
import org.oslo.ocl20.syntax.ast.types.CollectionTypeAS;
import org.oslo.ocl20.syntax.ast.types.TupleTypeAS;
import org.oslo.ocl20.syntax.ast.types.TypeAS;
import org.oslo.ocl20.syntax.ast.types.TypesFactory;
import uk.ac.kent.cs.kmf.util.ILog;

public class ASTBuilder {
    protected ILog log;
    protected AstFactory factory = AstFactory.eINSTANCE;

    public ASTBuilder(ILog log) {
        this.log = log;
    }

    public PackageDeclarationAS buildPackageDeclaration(List path, List contextDecls) {
        PackageDeclarationAS result = ContextsFactory.eINSTANCE.createPackageDeclarationAS();
        result.getPathName().addAll((Collection)path);
        result.getContextDecls().addAll((Collection)contextDecls);
        return result;
    }

    public PropertyContextDeclAS buildPropertyContextDeclaration(List path, String name, TypeAS type, List constraints) {
        PropertyContextDeclAS res = ContextsFactory.eINSTANCE.createPropertyContextDeclAS();
        res.getPathName().addAll((Collection)path);
        res.setName(name);
        res.setType(type);
        res.getConstraints().addAll((Collection)constraints);
        return res;
    }

    public ClassifierContextDeclAS buildClassifierContextDeclaration(TypeAS t, List constraints) {
        ClassifierContextDeclAS res = ContextsFactory.eINSTANCE.createClassifierContextDeclAS();
        res.setType(t);
        res.getConstraints().addAll((Collection)constraints);
        return res;
    }

    public ClassifierContextDeclAS buildClassifierContextDeclaration(List path, List constraints) {
        ClassifierContextDeclAS res = ContextsFactory.eINSTANCE.createClassifierContextDeclAS();
        res.getPathName().addAll((Collection)path);
        res.getConstraints().addAll((Collection)constraints);
        return res;
    }

    public OperationContextDeclAS buildOperationContextDeclaration(OperationAS oper, List constraints) {
        OperationContextDeclAS result = ContextsFactory.eINSTANCE.createOperationContextDeclAS();
        result.setOperation(oper);
        result.getConstraints().addAll((Collection)constraints);
        return result;
    }

    public OperationAS buildOperation(List path, String name, List params, TypeAS type) {
        OperationAS oper = ContextsFactory.eINSTANCE.createOperationAS();
        oper.getPathName().addAll((Collection)path);
        oper.setName(name);
        oper.getParameters().addAll((Collection)params);
        oper.setType(type);
        return oper;
    }

    public ConstraintAS buildConstraint(ConstraintKindAS kind, String name, OclExpressionAS body, Object varOrOper) {
        ConstraintAS cons = ContextsFactory.eINSTANCE.createConstraintAS();
        cons.setKind(kind);
        cons.setName(name);
        cons.setBodyExpression(body);
        if (varOrOper instanceof VariableDeclarationAS) {
            cons.setDefVariable((VariableDeclarationAS)varOrOper);
        } else if (varOrOper instanceof OperationAS) {
            cons.setDefOperation((OperationAS)varOrOper);
        }
        return cons;
    }

    public VariableDeclarationAS buildVariableDeclaration(String name, TypeAS type, OclExpressionAS init) {
        VariableDeclarationAS var = ContextsFactory.eINSTANCE.createVariableDeclarationAS();
        var.setName(name);
        var.setType(type);
        var.setInitExp(init);
        return var;
    }

    public ClassifierAS buildPathNameType(List path) {
        ClassifierAS type = TypesFactory.eINSTANCE.createClassifierAS();
        type.setPathName(path);
        return type;
    }

    public CollectionTypeAS buildCollectionType(CollectionKindAS kind, TypeAS elementType) {
        CollectionTypeAS type = null;
        if (kind == CollectionKindAS.BAG_LITERAL) {
            type = TypesFactory.eINSTANCE.createBagTypeAS();
            type.setElementType(elementType);
        } else if (kind == CollectionKindAS.COLLECTION_LITERAL) {
            type = TypesFactory.eINSTANCE.createCollectionTypeAS();
            type.setElementType(elementType);
        } else if (kind == CollectionKindAS.SEQUENCE_LITERAL) {
            type = TypesFactory.eINSTANCE.createSequenceTypeAS();
            type.setElementType(elementType);
        } else if (kind == CollectionKindAS.SET_LITERAL) {
            type = TypesFactory.eINSTANCE.createSetTypeAS();
            type.setElementType(elementType);
        } else if (kind == CollectionKindAS.ORDERED_SET_LITERAL) {
            type = TypesFactory.eINSTANCE.createOrderedSetTypeAS();
            type.setElementType(elementType);
        } else {
            type = null;
        }
        return type;
    }

    public TupleTypeAS buildTupleType(List varList) {
        TupleTypeAS type = TypesFactory.eINSTANCE.createTupleTypeAS();
        type.getVariableDeclarationList().addAll((Collection)varList);
        return type;
    }

    public PathNameExpAS buildPathNameExp(List path, Boolean isMarkedPre) {
        PathNameExpAS res = ExpressionsFactory.eINSTANCE.createPathNameExpAS();
        res.getPathName().addAll((Collection)path);
        res.setIsMarkedPre(isMarkedPre);
        return res;
    }

    public DotSelectionExpAS buildDotSelectionExp(OclExpressionAS exp, String name, Boolean isMarkedPre) {
        DotSelectionExpAS res = ExpressionsFactory.eINSTANCE.createDotSelectionExpAS();
        res.setSource(exp);
        res.setName(name);
        res.setIsMarkedPre(isMarkedPre);
        exp.setParent(res);
        return res;
    }

    public ArrowSelectionExpAS buildArrowSelectionExp(OclExpressionAS exp, String name) {
        ArrowSelectionExpAS res = ExpressionsFactory.eINSTANCE.createArrowSelectionExpAS();
        res.setSource(exp);
        res.setName(name);
        exp.setParent(res);
        return res;
    }

    public OclExpressionAS buildOperationCallExp(String name, OclExpressionAS left, OclExpressionAS right) {
        DotSelectionExpAS source = ExpressionsFactory.eINSTANCE.createDotSelectionExpAS();
        source.setSource(left);
        source.setName(name);
        OperationCallExpAS res = ExpressionsFactory.eINSTANCE.createOperationCallExpAS();
        res.setSource(source);
        res.getArguments().addAll(new Vector());
        if (right != null) {
            res.getArguments().add((Object)right);
        }
        left.setParent(res);
        return res;
    }

    public CallExpAS buildOperationCallExp(OclExpressionAS exp, List arguments) {
        OperationCallExpAS res = ExpressionsFactory.eINSTANCE.createOperationCallExpAS();
        res.setSource(exp);
        res.getArguments().addAll((Collection)arguments);
        exp.setParent(res);
        return res;
    }

    public LoopExpAS buildIteratorCallExp(OclExpressionAS srcArrowExp1, List varList, OclExpressionAS exp2) {
        IteratorExpAS res = ExpressionsFactory.eINSTANCE.createIteratorExpAS();
        res.setSource(srcArrowExp1);
        res.getIterator().addAll((Collection)varList);
        res.setBody(exp2);
        srcArrowExp1.setParent(res);
        return res;
    }

    public CallExpAS buildAssociationCallExp(OclExpressionAS exp, List arguments, Boolean isMarkedPre) {
        AssociationCallExpAS res = ExpressionsFactory.eINSTANCE.createAssociationCallExpAS();
        res.setSource(exp);
        res.getArguments().addAll((Collection)arguments);
        res.setIsMarkedPre(isMarkedPre);
        exp.setParent(res);
        return res;
    }

    public OclExpressionAS buildIterateExp(OclExpressionAS source, VariableDeclarationAS iterator, VariableDeclarationAS result, OclExpressionAS body) {
        IterateExpAS res = ExpressionsFactory.eINSTANCE.createIterateExpAS();
        res.setSource(source);
        res.setName("iterate");
        Vector<VariableDeclarationAS> x = new Vector<VariableDeclarationAS>();
        x.add(iterator);
        res.getIterator().addAll(x);
        res.setResult(result);
        res.setBody(body);
        source.setParent(res);
        return res;
    }

    public OclExpressionAS buildNotExp(OclExpressionAS left) {
        NotExpAS res = ExpressionsFactory.eINSTANCE.createNotExpAS();
        res.setLeftOperand(left);
        left.setParent(res);
        return res;
    }

    public OclExpressionAS buildOrExp(OclExpressionAS left, OclExpressionAS right) {
        OrExpAS res = ExpressionsFactory.eINSTANCE.createOrExpAS();
        res.setLeftOperand(left);
        res.setRightOperand(right);
        left.setParent(res);
        return res;
    }

    public OclExpressionAS buildAndExp(OclExpressionAS left, OclExpressionAS right) {
        AndExpAS res = ExpressionsFactory.eINSTANCE.createAndExpAS();
        res.setLeftOperand(left);
        res.setRightOperand(right);
        left.setParent(res);
        return res;
    }

    public OclExpressionAS buildXorExp(OclExpressionAS left, OclExpressionAS right) {
        XorExpAS res = ExpressionsFactory.eINSTANCE.createXorExpAS();
        res.setLeftOperand(left);
        res.setRightOperand(right);
        left.setParent(res);
        return res;
    }

    public OclExpressionAS buildImpliesExp(OclExpressionAS left, OclExpressionAS right) {
        ImpliesExpAS res = ExpressionsFactory.eINSTANCE.createImpliesExpAS();
        res.setLeftOperand(left);
        res.setRightOperand(right);
        left.setParent(res);
        return res;
    }

    public OclExpressionAS buildOclMessageExp(OclMessageKindAS kind, OclExpressionAS target, String name, List arguments) {
        OclMessageExpAS res = ExpressionsFactory.eINSTANCE.createOclMessageExpAS();
        res.setKind(kind);
        res.setName(name);
        res.setTarget(target);
        res.getArguments().addAll((Collection)arguments);
        target.setParent(res);
        return res;
    }

    public OclMessageArgAS buildOclMessageArg(OclExpressionAS exp, TypeAS type) {
        OclMessageArgAS arg = ExpressionsFactory.eINSTANCE.createOclMessageArgAS();
        arg.setExpression(exp);
        arg.setType(type);
        return arg;
    }

    public IfExpAS buildIfExp(OclExpressionAS condition, OclExpressionAS thenExp, OclExpressionAS elseExp) {
        IfExpAS res = ExpressionsFactory.eINSTANCE.createIfExpAS();
        res.setCondition(condition);
        res.setThenExpression(thenExp);
        res.setElseExpression(elseExp);
        return res;
    }

    public LetExpAS buildLetExp(List variables, OclExpressionAS exp) {
        LetExpAS res = ExpressionsFactory.eINSTANCE.createLetExpAS();
        res.getVariables().addAll((Collection)variables);
        res.setIn(exp);
        return res;
    }

    public EnumLiteralExpAS buildEnumLiteralExp(List path) {
        EnumLiteralExpAS exp = ExpressionsFactory.eINSTANCE.createEnumLiteralExpAS();
        exp.getPathName().addAll((Collection)path);
        return exp;
    }

    public CollectionLiteralExpAS buildCollectionLiteralExp(CollectionKindAS kind, List parts) {
        CollectionLiteralExpAS exp = ExpressionsFactory.eINSTANCE.createCollectionLiteralExpAS();
        exp.setKind(kind);
        exp.getCollectionParts().addAll((Collection)parts);
        return exp;
    }

    public CollectionItemAS buildCollectionItem(OclExpressionAS exp) {
        CollectionItemAS item = ExpressionsFactory.eINSTANCE.createCollectionItemAS();
        item.setItem(exp);
        return item;
    }

    public CollectionRangeAS buildCollectionRange(OclExpressionAS first, OclExpressionAS last) {
        CollectionRangeAS exp = ExpressionsFactory.eINSTANCE.createCollectionRangeAS();
        exp.setFirst(first);
        exp.setLast(last);
        return exp;
    }

    public BooleanLiteralExpAS buildBooleanLiteralExp(String value) {
        BooleanLiteralExpAS exp = ExpressionsFactory.eINSTANCE.createBooleanLiteralExpAS();
        if (value != null && !value.equals("undefined")) {
            exp.setValue(Boolean.valueOf(value));
        } else {
            exp.setValue(null);
        }
        return exp;
    }

    public IntegerLiteralExpAS buildIntegerLiteralExp(String value) {
        IntegerLiteralExpAS exp = ExpressionsFactory.eINSTANCE.createIntegerLiteralExpAS();
        exp.setValue(Integer.valueOf(value));
        return exp;
    }

    public RealLiteralExpAS buildRealLiteralExp(String value) {
        RealLiteralExpAS exp = ExpressionsFactory.eINSTANCE.createRealLiteralExpAS();
        exp.setValue(Double.valueOf(value));
        return exp;
    }

    public StringLiteralExpAS buildStringLiteralExp(String value) {
        StringLiteralExpAS exp = ExpressionsFactory.eINSTANCE.createStringLiteralExpAS();
        exp.setValue(value.substring(1, value.length() - 1));
        return exp;
    }

    public TupleLiteralExpAS buildTupleLiteralExp(List seq) {
        TupleLiteralExpAS exp = ExpressionsFactory.eINSTANCE.createTupleLiteralExpAS();
        exp.getTupleParts().addAll((Collection)seq);
        return exp;
    }
}

