/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.standard.lib;

import org.oslo.ocl20.semantics.model.types.IntegerType;
import org.oslo.ocl20.standard.lib.OclAny;
import org.oslo.ocl20.standard.lib.OclBoolean;
import org.oslo.ocl20.standard.lib.OclInteger;
import org.oslo.ocl20.standard.lib.OclReal;
import org.oslo.ocl20.standard.lib.OclRealImpl;
import org.oslo.ocl20.standard.lib.OclType;
import org.oslo.ocl20.standard.lib.OclVisitor;
import org.oslo.ocl20.standard.lib.StdLibAdapter;

public class OclIntegerImpl
extends OclRealImpl
implements OclInteger {
    int _int_impl;

    public OclIntegerImpl(int i, StdLibAdapter adapter) {
        super(i, adapter);
        this._int_impl = i;
    }

    public int int_impl() {
        return this._int_impl;
    }

    public OclType oclType() {
        IntegerType type = this.adapter.getProcessor().getTypeFactory().buildIntegerType();
        return this.adapter.Type(type);
    }

    public OclBoolean equalTo(OclInteger i2) {
        return super.equalTo(i2);
    }

    public OclInteger inegate() {
        return this.adapter.Integer(this.int_impl() * -1);
    }

    public OclInteger add(OclInteger i2) {
        return this.adapter.Integer(this.int_impl() + ((OclIntegerImpl)i2).int_impl());
    }

    public OclInteger subtract(OclInteger i2) {
        return this.adapter.Integer(this.int_impl() - ((OclIntegerImpl)i2).int_impl());
    }

    public OclInteger multiply(OclInteger i2) {
        return this.adapter.Integer(this.int_impl() * ((OclIntegerImpl)i2).int_impl());
    }

    public OclReal divide(OclInteger i2) {
        if (((OclIntegerImpl)i2).int_impl() == 0) {
            return this.adapter.Undefined();
        }
        return this.adapter.Real(this.implementation() / ((OclIntegerImpl)i2).implementation());
    }

    public OclInteger iabs() {
        return this.adapter.Integer(Math.abs(this.int_impl()));
    }

    public OclInteger div(OclInteger i2) {
        if (((OclIntegerImpl)i2).int_impl() == 0) {
            return this.adapter.Undefined();
        }
        return this.adapter.Integer(this.int_impl() / ((OclIntegerImpl)i2).int_impl());
    }

    public OclInteger mod(OclInteger i2) {
        if (((OclIntegerImpl)i2).int_impl() == 0) {
            return this.adapter.Undefined();
        }
        return this.adapter.Integer(this.int_impl() % ((OclIntegerImpl)i2).int_impl());
    }

    public OclInteger max(OclInteger i2) {
        return this.adapter.Integer(Math.max(this.int_impl(), ((OclIntegerImpl)i2).int_impl()));
    }

    public OclInteger min(OclInteger i2) {
        return this.adapter.Integer(Math.min(this.int_impl(), ((OclIntegerImpl)i2).int_impl()));
    }

    public OclBoolean equalTo(OclAny i2) {
        if (!(i2 instanceof OclReal)) {
            return this.adapter.Boolean(false);
        }
        return super.equalTo((OclReal)i2);
    }

    public Object asJavaObject() {
        return new Integer(this.int_impl());
    }

    public Object accept(OclVisitor v, Object obj) {
        return v.visit(this, obj);
    }

    public String toString() {
        return String.valueOf(this.int_impl());
    }

    public int hashCode() {
        return this.int_impl();
    }

    public Object clone() {
        return this.adapter.Integer(this.int_impl());
    }
}

