/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.standard.lib;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.model.types.BagType;
import org.oslo.ocl20.standard.lib.OclAny;
import org.oslo.ocl20.standard.lib.OclBag;
import org.oslo.ocl20.standard.lib.OclBoolean;
import org.oslo.ocl20.standard.lib.OclBooleanImpl;
import org.oslo.ocl20.standard.lib.OclCollectionImpl;
import org.oslo.ocl20.standard.lib.OclInteger;
import org.oslo.ocl20.standard.lib.OclOrderedSet;
import org.oslo.ocl20.standard.lib.OclOrderedSetImpl;
import org.oslo.ocl20.standard.lib.OclSequence;
import org.oslo.ocl20.standard.lib.OclSet;
import org.oslo.ocl20.standard.lib.OclSetImpl;
import org.oslo.ocl20.standard.lib.OclType;
import org.oslo.ocl20.standard.lib.OclUndefined;
import org.oslo.ocl20.standard.lib.OclVisitor;
import org.oslo.ocl20.standard.lib.StdLibAdapter;

public class OclBagImpl
extends OclCollectionImpl
implements OclBag {
    Collection _implementation;

    public OclBagImpl(Classifier eT, Object[] array, StdLibAdapter adapter) {
        super(eT, adapter);
        this._implementation = new Vector(Arrays.asList(array));
    }

    public OclType oclType() {
        BagType type = this.adapter.getProcessor().getTypeFactory().buildBagType(super.getElementType());
        return this.adapter.Type(type);
    }

    protected Collection implementation() {
        return this._implementation;
    }

    protected Collection bag_impl() {
        return this._implementation;
    }

    public OclBoolean equalTo(OclBag bag2) {
        Collection this_bag = this.implementation();
        Collection b2 = ((OclBagImpl)bag2).implementation();
        if (this_bag.size() != b2.size()) {
            return this.adapter.Boolean(false);
        }
        Collection b = this.implementation();
        for (OclAny ob : b) {
            if ((OclBooleanImpl)this.count(ob).equalTo(bag2.count(ob)) == OclBooleanImpl.TRUE) continue;
            return this.adapter.Boolean(false);
        }
        return this.adapter.Boolean(true);
    }

    public OclBoolean notEqualTo(OclBag bag2) {
        return this.equalTo(bag2).not();
    }

    public OclBag union(OclBag bag2) {
        OclBagImpl b = (OclBagImpl)this.adapter.Bag(this.getElementType(), this.implementation());
        b.implementation().addAll(((OclBagImpl)bag2).implementation());
        return b;
    }

    public OclBag union(OclSet set) {
        OclBagImpl b = (OclBagImpl)this.adapter.Bag(this.getElementType(), this.implementation());
        if (set instanceof OclOrderedSetImpl) {
            b.implementation().addAll(((OclOrderedSetImpl)set).orderedset_impl());
        } else {
            b.implementation().addAll(((OclSetImpl)set).set_impl());
        }
        return b;
    }

    public OclBag union(OclOrderedSet set) {
        OclBagImpl b = (OclBagImpl)this.adapter.Bag(this.getElementType(), this.implementation());
        b.implementation().addAll(((OclOrderedSetImpl)set).orderedset_impl());
        return b;
    }

    public OclBag intersection(OclBag bag2) {
        OclBag b = this.adapter.Bag(this.getElementType());
        Vector b1 = new Vector((Collection)this.getImplementation());
        Vector b2 = new Vector((Collection)bag2.getImplementation());
        Iterator i1 = b1.iterator();
        while (i1.hasNext()) {
            OclAny o = (OclAny)i1.next();
            if ((OclBooleanImpl)bag2.includes(o) != OclBooleanImpl.TRUE) continue;
            b = b.including(o);
            i1.remove();
            b2.remove(o);
        }
        for (OclAny o : b2) {
            if ((OclBooleanImpl)this.includes(o) != OclBooleanImpl.TRUE) continue;
            b = b.including(o);
        }
        return b;
    }

    public OclSet intersection(OclSet set) {
        return this.intersection(set.asBag()).asSet();
    }

    public OclOrderedSet intersection(OclOrderedSet set) {
        return this.intersection(set.asOrderedSet());
    }

    public OclBag including(OclAny object) {
        OclBagImpl b = (OclBagImpl)this.adapter.Bag(this.getElementType(), this.implementation());
        if (object instanceof OclUndefined) {
            return b;
        }
        ((Collection)b.getImplementation()).add(object);
        return b;
    }

    public OclBag excluding(OclAny object) {
        OclBagImpl b = (OclBagImpl)this.adapter.Bag(this.getElementType(), this.implementation());
        Vector<OclAny> v = new Vector<OclAny>();
        v.add(object);
        b.implementation().removeAll(v);
        return b;
    }

    public OclInteger count(OclAny object) {
        return super.count(object);
    }

    public OclBag flatten() {
        OclBag flat = this.adapter.Bag(this.getElementType());
        for (OclAny elem : this._implementation) {
            flat = elem instanceof OclBag ? flat.union((OclBag)elem) : (elem instanceof OclSet ? flat.union((OclSet)elem) : (elem instanceof OclSequence ? flat.union(((OclSequence)elem).asBag()) : flat.including(elem)));
        }
        return flat;
    }

    public Object accept(OclVisitor v, Object obj) {
        return v.visit(this, obj);
    }

    public String toString() {
        String str = "Bag { ";
        Iterator i = this._implementation.iterator();
        while (i.hasNext()) {
            str = String.valueOf(str) + i.next();
            if (!i.hasNext()) continue;
            str = String.valueOf(str) + ", ";
        }
        return String.valueOf(str) + " }";
    }

    public Object clone() {
        return this.adapter.Bag(this.getElementType(), this.implementation());
    }

    public boolean equals(Object o) {
        if (o instanceof OclBag) {
            OclBoolean b = this.equalTo((OclBag)o);
            return (OclBooleanImpl)b == OclBooleanImpl.TRUE;
        }
        return false;
    }

    public Object asJavaObject() {
        Vector jObj = new Vector();
        for (Object o : this._implementation) {
            if (o instanceof OclAny) {
                o = ((OclAny)o).asJavaObject();
            }
            jObj.add(o);
        }
        return Collections.unmodifiableCollection(jObj);
    }
}

