/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.semantics.bridge.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.oslo.ocl20.OclProcessor;
import org.oslo.ocl20.semantics.OclVisitor;
import org.oslo.ocl20.semantics.bridge.BridgePackage;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.bridge.Environment;
import org.oslo.ocl20.semantics.bridge.ModelElement;
import org.oslo.ocl20.semantics.bridge.Operation;
import org.oslo.ocl20.semantics.bridge.Parameter;
import org.oslo.ocl20.semantics.bridge.Property;
import org.oslo.ocl20.semantics.bridge.Signal;
import org.oslo.ocl20.semantics.bridge.impl.NamespaceImpl;
import org.oslo.ocl20.semantics.factories.TypeFactory;
import org.oslo.ocl20.semantics.model.types.CollectionType;
import org.oslo.ocl20.semantics.model.types.OclAnyType;
import org.oslo.ocl20.standard.lib.OclType;

public class ClassifierImpl
extends NamespaceImpl
implements Classifier {
    protected EList operations;
    protected static final OclProcessor PROCESSOR_EDEFAULT = null;
    protected OclProcessor processor = PROCESSOR_EDEFAULT;
    protected EList properties;

    protected ClassifierImpl() {
    }

    protected EClass eStaticClass() {
        return BridgePackage.Literals.CLASSIFIER;
    }

    public EList getOperations() {
        if (this.operations == null) {
            this.operations = new EDataTypeUniqueEList(Object.class, (InternalEObject)this, 3);
        }
        return this.operations;
    }

    public OclProcessor getProcessor() {
        return this.processor;
    }

    public void setProcessor(OclProcessor newProcessor) {
        OclProcessor oldProcessor = this.processor;
        this.processor = newProcessor;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldProcessor, (Object)this.processor));
        }
    }

    public EList getProperties() {
        if (this.properties == null) {
            this.properties = new EObjectResolvingEList(Property.class, (InternalEObject)this, 5);
        }
        return this.properties;
    }

    public Property lookupProperty(String name) {
        Property pr = this.localLookupProperty(name);
        if (pr != null) {
            return pr;
        }
        for (Classifier c : this.getAllSuperTypes()) {
            Property p = c.localLookupProperty(name);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    public Operation lookupOperation(String name, List types) {
        Operation op = this.lookupCachedOp(name, types);
        return op;
    }

    public Signal lookupSignal(String name, List types) {
        return null;
    }

    public Boolean conformsTo(Classifier c) {
        if (this.equals(c)) {
            return Boolean.TRUE;
        }
        if (c.getClass() == OclAnyType.class && !(this instanceof CollectionType)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Object getDelegate() {
        return Class.class;
    }

    public Class getImplClass() {
        return OclType.class;
    }

    public Property localLookupProperty(String name) {
        for (Property p : this.getProperties()) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public List getAllSuperTypes() {
        Vector<Classifier> result = new Vector<Classifier>();
        List x = this.getSuperTypes();
        result.addAll(x);
        for (Classifier c : x) {
            for (Classifier st : c.getAllSuperTypes()) {
                if (result.contains(st)) continue;
                result.add(st);
            }
        }
        return result;
    }

    public void createOperations(TypeFactory typeFactory) {
    }

    public void addProperty(Property prop) {
        this.getProperties().add((Object)prop);
    }

    public void addOperation(Operation operation) {
        this.getOperations().add((Object)operation);
    }

    public ModelElement lookupOwnedElement(String name) {
        return null;
    }

    public Operation lookupCachedOp(String name, List types) {
        for (Operation op : this.getOperations()) {
            String opName = op.getName();
            if (!opName.equals(name)) continue;
            EList parameters = op.getOwnedParameter();
            ArrayList<Classifier> parameterTypes = new ArrayList<Classifier>(parameters.size());
            for (Parameter parameter : parameters) {
                parameterTypes.add(parameter.getType());
            }
            if (!this.typesConform(parameterTypes, types)) continue;
            return op;
        }
        for (Classifier c : this.getSuperTypes()) {
            Operation p = c.lookupOperation(name, types);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    public List getSuperTypes() {
        return new Vector();
    }

    public boolean typesConform(List paramTypes, List argTypes) {
        if (paramTypes == null) {
            paramTypes = new Vector();
        }
        if (argTypes == null) {
            argTypes = new Vector();
        }
        if (paramTypes.size() != argTypes.size()) {
            return false;
        }
        int i = 0;
        while (i < paramTypes.size()) {
            Classifier paramType = (Classifier)paramTypes.get(i);
            Classifier argType = (Classifier)argTypes.get(i);
            if (argType == null) {
                return false;
            }
            if (argType.conformsTo(paramType) == Boolean.FALSE) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Environment getEnvironmentWithoutParents() {
        Environment env = this.getProcessor().getBridgeFactory().buildEnvironment();
        Environment result = env.addNamespace(this);
        result.setParent(null);
        return result;
    }

    public Environment getEnvironmentWithParents() {
        if (this.getNamespace() == null) {
            return null;
        }
        Environment result = this.getEnvironmentWithoutParents();
        result.setParent(this.getNamespace().getEnvironmentWithParents());
        return result;
    }

    public Object accept(OclVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getOperations();
            }
            case 4: {
                return this.getProcessor();
            }
            case 5: {
                return this.getProperties();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.getOperations().clear();
                this.getOperations().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setProcessor((OclProcessor)newValue);
                return;
            }
            case 5: {
                this.getProperties().clear();
                this.getProperties().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.getOperations().clear();
                return;
            }
            case 4: {
                this.setProcessor(PROCESSOR_EDEFAULT);
                return;
            }
            case 5: {
                this.getProperties().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return this.operations != null && !this.operations.isEmpty();
            }
            case 4: {
                return PROCESSOR_EDEFAULT == null ? this.processor != null : !PROCESSOR_EDEFAULT.equals(this.processor);
            }
            case 5: {
                return this.properties != null && !this.properties.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (operations: ");
        result.append(this.operations);
        result.append(", processor: ");
        result.append(this.processor);
        result.append(')');
        return result.toString();
    }
}

