/*
 * Decompiled with CFR 0.152.
 */
package org.oslo.ocl20.semantics.analyser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java_cup.runtime.ComplexSymbolFactory;
import java_cup.runtime.Symbol;
import org.eclipse.emf.common.util.EList;
import org.oslo.ocl20.OclProcessor;
import org.oslo.ocl20.semantics.SemanticsVisitable;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.bridge.EnumLiteral;
import org.oslo.ocl20.semantics.bridge.Enumeration;
import org.oslo.ocl20.semantics.bridge.Environment;
import org.oslo.ocl20.semantics.bridge.ModelElement;
import org.oslo.ocl20.semantics.bridge.NamedElement;
import org.oslo.ocl20.semantics.bridge.Namespace;
import org.oslo.ocl20.semantics.bridge.OclModelElementType;
import org.oslo.ocl20.semantics.bridge.Operation;
import org.oslo.ocl20.semantics.bridge.Primitive;
import org.oslo.ocl20.semantics.bridge.Property;
import org.oslo.ocl20.semantics.model.contexts.ClassifierContextDecl;
import org.oslo.ocl20.semantics.model.contexts.Constraint;
import org.oslo.ocl20.semantics.model.contexts.ConstraintKind;
import org.oslo.ocl20.semantics.model.contexts.ContextsFactory;
import org.oslo.ocl20.semantics.model.contexts.DefinedOperation;
import org.oslo.ocl20.semantics.model.contexts.DefinedProperty;
import org.oslo.ocl20.semantics.model.contexts.OperationContextDecl;
import org.oslo.ocl20.semantics.model.contexts.PropertyContextDecl;
import org.oslo.ocl20.semantics.model.expressions.BooleanLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.CallExp;
import org.oslo.ocl20.semantics.model.expressions.CollectionItem;
import org.oslo.ocl20.semantics.model.expressions.CollectionKind;
import org.oslo.ocl20.semantics.model.expressions.CollectionLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.CollectionLiteralPart;
import org.oslo.ocl20.semantics.model.expressions.CollectionRange;
import org.oslo.ocl20.semantics.model.expressions.EnumLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.ExpressionsFactory;
import org.oslo.ocl20.semantics.model.expressions.IfExp;
import org.oslo.ocl20.semantics.model.expressions.IntegerLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.IterateExp;
import org.oslo.ocl20.semantics.model.expressions.IteratorExp;
import org.oslo.ocl20.semantics.model.expressions.LetExp;
import org.oslo.ocl20.semantics.model.expressions.OclExpression;
import org.oslo.ocl20.semantics.model.expressions.OperationCallExp;
import org.oslo.ocl20.semantics.model.expressions.PropertyCallExp;
import org.oslo.ocl20.semantics.model.expressions.RealLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.StringLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.TupleLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.TypeLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.UndefinedLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.VariableDeclaration;
import org.oslo.ocl20.semantics.model.expressions.VariableExp;
import org.oslo.ocl20.semantics.model.types.BagType;
import org.oslo.ocl20.semantics.model.types.BooleanType;
import org.oslo.ocl20.semantics.model.types.CollectionType;
import org.oslo.ocl20.semantics.model.types.OrderedSetType;
import org.oslo.ocl20.semantics.model.types.SequenceType;
import org.oslo.ocl20.semantics.model.types.SetType;
import org.oslo.ocl20.semantics.model.types.TupleType;
import org.oslo.ocl20.semantics.model.types.TypeType;
import org.oslo.ocl20.semantics.model.types.VoidType;
import org.oslo.ocl20.syntax.ast.Visitable;
import org.oslo.ocl20.syntax.ast.Visitor;
import org.oslo.ocl20.syntax.ast.contexts.ClassifierContextDeclAS;
import org.oslo.ocl20.syntax.ast.contexts.ConstraintAS;
import org.oslo.ocl20.syntax.ast.contexts.ConstraintKindAS;
import org.oslo.ocl20.syntax.ast.contexts.ContextDeclarationAS;
import org.oslo.ocl20.syntax.ast.contexts.OperationAS;
import org.oslo.ocl20.syntax.ast.contexts.OperationContextDeclAS;
import org.oslo.ocl20.syntax.ast.contexts.PackageDeclarationAS;
import org.oslo.ocl20.syntax.ast.contexts.PropertyContextDeclAS;
import org.oslo.ocl20.syntax.ast.contexts.VariableDeclarationAS;
import org.oslo.ocl20.syntax.ast.expressions.AndExpAS;
import org.oslo.ocl20.syntax.ast.expressions.ArrowSelectionExpAS;
import org.oslo.ocl20.syntax.ast.expressions.AssociationCallExpAS;
import org.oslo.ocl20.syntax.ast.expressions.BooleanLiteralExpAS;
import org.oslo.ocl20.syntax.ast.expressions.CallExpAS;
import org.oslo.ocl20.syntax.ast.expressions.CollectionItemAS;
import org.oslo.ocl20.syntax.ast.expressions.CollectionKindAS;
import org.oslo.ocl20.syntax.ast.expressions.CollectionLiteralExpAS;
import org.oslo.ocl20.syntax.ast.expressions.CollectionLiteralPartAS;
import org.oslo.ocl20.syntax.ast.expressions.CollectionRangeAS;
import org.oslo.ocl20.syntax.ast.expressions.DotSelectionExpAS;
import org.oslo.ocl20.syntax.ast.expressions.EnumLiteralExpAS;
import org.oslo.ocl20.syntax.ast.expressions.IfExpAS;
import org.oslo.ocl20.syntax.ast.expressions.ImpliesExpAS;
import org.oslo.ocl20.syntax.ast.expressions.IntegerLiteralExpAS;
import org.oslo.ocl20.syntax.ast.expressions.IterateExpAS;
import org.oslo.ocl20.syntax.ast.expressions.IteratorExpAS;
import org.oslo.ocl20.syntax.ast.expressions.LetExpAS;
import org.oslo.ocl20.syntax.ast.expressions.NotExpAS;
import org.oslo.ocl20.syntax.ast.expressions.OclExpressionAS;
import org.oslo.ocl20.syntax.ast.expressions.OclMessageArgAS;
import org.oslo.ocl20.syntax.ast.expressions.OclMessageExpAS;
import org.oslo.ocl20.syntax.ast.expressions.OclMessageKindAS;
import org.oslo.ocl20.syntax.ast.expressions.OperationCallExpAS;
import org.oslo.ocl20.syntax.ast.expressions.OrExpAS;
import org.oslo.ocl20.syntax.ast.expressions.PathNameExpAS;
import org.oslo.ocl20.syntax.ast.expressions.RealLiteralExpAS;
import org.oslo.ocl20.syntax.ast.expressions.SelectionExpAS;
import org.oslo.ocl20.syntax.ast.expressions.StringLiteralExpAS;
import org.oslo.ocl20.syntax.ast.expressions.TupleLiteralExpAS;
import org.oslo.ocl20.syntax.ast.expressions.XorExpAS;
import org.oslo.ocl20.syntax.ast.impl.VisitorImpl;
import org.oslo.ocl20.syntax.ast.qvt.DomainAS;
import org.oslo.ocl20.syntax.ast.qvt.KeyDeclarationAS;
import org.oslo.ocl20.syntax.ast.qvt.ModelDeclarationAS;
import org.oslo.ocl20.syntax.ast.qvt.ObjectTemplateAS;
import org.oslo.ocl20.syntax.ast.qvt.ParameterDeclarationAS;
import org.oslo.ocl20.syntax.ast.qvt.PrimitiveDomainAS;
import org.oslo.ocl20.syntax.ast.qvt.PropertyTemplateAS;
import org.oslo.ocl20.syntax.ast.qvt.QueryAS;
import org.oslo.ocl20.syntax.ast.qvt.RelationAS;
import org.oslo.ocl20.syntax.ast.qvt.TopLevelAS;
import org.oslo.ocl20.syntax.ast.qvt.TransformationAS;
import org.oslo.ocl20.syntax.ast.types.BagTypeAS;
import org.oslo.ocl20.syntax.ast.types.ClassifierAS;
import org.oslo.ocl20.syntax.ast.types.CollectionTypeAS;
import org.oslo.ocl20.syntax.ast.types.OrderedSetTypeAS;
import org.oslo.ocl20.syntax.ast.types.SequenceTypeAS;
import org.oslo.ocl20.syntax.ast.types.SetTypeAS;
import org.oslo.ocl20.syntax.ast.types.TupleTypeAS;
import org.oslo.ocl20.syntax.parser.ErrorManager;
import org.oslo.ocl20.synthesis.CreationHelper;
import uk.ac.kent.cs.kmf.util.ILog;

public class OclSemanticAnalyserVisitorImpl
extends VisitorImpl
implements Visitor {
    protected Map astMap;
    protected Map mapCstToAst;
    protected static Map symbolMap;
    ContextsFactory contextsFactory = ContextsFactory.eINSTANCE;
    ExpressionsFactory expressionsFactory = ExpressionsFactory.eINSTANCE;
    protected boolean DEBUG = false;
    protected OclProcessor processor = null;
    static long counter;

    static {
        counter = 0L;
    }

    public Object visit(Visitable host, Object data) {
        throw new RuntimeException("OclSemanticAnalyserVisitorImpl.visit(Visitable,Object) should never be called!");
    }

    public Object visit(OclExpressionAS host, Object data) {
        Object o = null;
        return o;
    }

    public Object visit(ContextDeclarationAS host, Object data) {
        Object o = null;
        return o;
    }

    public OclSemanticAnalyserVisitorImpl(OclProcessor proc) {
        this.processor = proc;
    }

    protected String newName() {
        return "_tempIt" + counter++;
    }

    public Object visit(PackageDeclarationAS host, Object data) {
        ((Map)data).put("action", "declare defs");
        for (ContextDeclarationAS asContext : host.getContextDecls()) {
            asContext.accept(this, data);
        }
        ((Map)data).put("action", null);
        Vector<Object> semContexts = new Vector<Object>();
        for (ContextDeclarationAS asContext : host.getContextDecls()) {
            semContexts.add(asContext.accept(this, data));
        }
        return semContexts;
    }

    public Object visit(ClassifierContextDeclAS host, Object data) {
        Classifier contextCls;
        Environment env = (Environment)((Map)data).get("env");
        Environment newEnv = null;
        ILog log = (ILog)((Map)data).get("log");
        ClassifierContextDecl semContext = this.contextsFactory.createClassifierContextDecl();
        if (host.getType() == null) {
            host.getPathName();
            log.reportError("Context type is null - " + host + ". Returning null.");
            contextCls = this.processor.getTypeFactory().buildVoidType();
        } else {
            TypeLiteralExp tle = (TypeLiteralExp)host.getType().accept(this, data);
            contextCls = tle.getLiteralType();
        }
        semContext.setReferredClassifier(contextCls);
        newEnv = env.addVariableDeclaration("self", contextCls, Boolean.TRUE);
        Vector<Object> semConstraints = new Vector<Object>();
        Iterator i = host.getConstraints().iterator();
        HashMap<String, Object> newData = new HashMap<String, Object>();
        newData.putAll((Map)data);
        newData.put("env", newEnv);
        newData.put("context", semContext);
        while (i.hasNext()) {
            ConstraintAS asConstraint = (ConstraintAS)i.next();
            semConstraints.add(asConstraint.accept(this, newData));
        }
        semContext.getConstraint().clear();
        semContext.getConstraint().addAll(semConstraints);
        return semContext;
    }

    public Object visit(PropertyContextDeclAS host, Object data) {
        Iterator i;
        Environment env = (Environment)((Map)data).get("env");
        ILog log = (ILog)((Map)data).get("log");
        PropertyContextDecl semContext = CreationHelper.createPropertyContextDecl();
        semContext.setReferredNamespace((Namespace)env.lookupPathName((List)host.getPathName()));
        EList pathName = host.getPathName();
        String name = host.getName();
        pathName.add(name);
        ModelElement element = env.lookupPathName((List)pathName);
        if (element instanceof Property) {
            Property property = (Property)element;
            semContext.setReferredProperty((Property)element);
            if (host.getType() != null) {
                TypeLiteralExp tle = (TypeLiteralExp)host.getType().accept(this, data);
                property.setType(tle.getLiteralType());
            }
        } else {
            String pathNameStr = new String();
            i = host.getPathName().iterator();
            while (i.hasNext()) {
                pathNameStr = String.valueOf(pathNameStr) + (String)i.next();
                if (!i.hasNext()) continue;
                pathNameStr = String.valueOf(pathNameStr) + ".";
            }
            ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: Unknown property '" + pathName + "'");
        }
        Vector<Object> semConstraints = new Vector<Object>();
        i = host.getConstraints().iterator();
        HashMap<String, PropertyContextDecl> newData = new HashMap<String, PropertyContextDecl>();
        newData.putAll((Map)data);
        if (element instanceof Property) {
            newData.put("context", semContext);
        }
        while (i.hasNext()) {
            ConstraintAS asConstraint = (ConstraintAS)i.next();
            semConstraints.add(asConstraint.accept(this, newData));
        }
        semContext.getConstraint().clear();
        semContext.getConstraint().addAll(semConstraints);
        return semContext;
    }

    public Object visit(OperationContextDeclAS host, Object data) {
        Environment env = (Environment)((Map)data).get("env");
        ILog cfr_ignored_0 = (ILog)((Map)data).get("log");
        OperationContextDecl semContext = this.contextsFactory.createOperationContextDecl();
        semContext.setReferredNamespace((Namespace)env.lookupPathName((List)host.getOperation().getPathName()));
        if (host.getOperation() != null) {
            semContext.setReferredOperation((Operation)host.getOperation().accept(this, data));
        }
        Vector<Object> semConstraints = new Vector<Object>();
        Iterator i = host.getConstraints().iterator();
        HashMap<String, OperationContextDecl> newData = new HashMap<String, OperationContextDecl>();
        newData.putAll((Map)data);
        newData.put("context", semContext);
        while (i.hasNext()) {
            ConstraintAS asConstraint = (ConstraintAS)i.next();
            semConstraints.add(asConstraint.accept(this, newData));
        }
        semContext.getConstraint().clear();
        semContext.getConstraint().addAll(semConstraints);
        return semContext;
    }

    public Object visit(VariableDeclarationAS host, Object data) {
        Environment cfr_ignored_0 = (Environment)((Map)data).get("env");
        ILog log = (ILog)((Map)data).get("log");
        VariableDeclaration semVar = this.expressionsFactory.createVariableDeclaration();
        this.putAst(host, semVar);
        semVar.setName(host.getName());
        if (host.getType() != null) {
            TypeLiteralExp tle = (TypeLiteralExp)host.getType().accept(this, data);
            semVar.setType(tle.getLiteralType());
        } else {
            semVar.setType(null);
        }
        if (host.getInitExp() != null) {
            OclExpression initExp = (OclExpression)host.getInitExp().accept(this, data);
            if (initExp == null) {
                ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: Problem analysing expression - " + host.getInitExp());
                return null;
            }
            if (semVar.getType() == null) {
                semVar.setType(initExp.getType());
            } else {
                Classifier varType = semVar.getType();
                Classifier initType = initExp.getType();
                if (!initType.conformsTo(varType).booleanValue()) {
                    ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: Non-conforming types '" + varType + "' and '" + initType + "' in variable declaration.");
                }
                if (varType instanceof TypeType && ((TypeType)varType).getClassifier() == null) {
                    semVar.setType(initExp.getType());
                }
            }
            semVar.setInitExpression(initExp);
        }
        return semVar;
    }

    public Object visit(OperationAS host, Object data) {
        Vector<Object> semParameters = new Vector<Object>();
        for (VariableDeclarationAS asVar : host.getParameters()) {
            semParameters.add(asVar.accept(this, data));
        }
        Operation semOper = this.processor.getBridgeFactory().buildOperation(null, host.getName(), null);
        return semOper;
    }

    public Object visit(ConstraintAS host, Object data) {
        Environment env = (Environment)((Map)data).get("env");
        ILog log = (ILog)((Map)data).get("log");
        String action = (String)((Map)data).get("action");
        ClassifierContextDecl context = (ClassifierContextDecl)((Map)data).get("context");
        ConstraintKind consKind = (ConstraintKind)((Object)this.visit(host.getKind(), data));
        Constraint semCons = this.contextsFactory.createConstraint();
        semCons.setName(host.getName());
        semCons.setContext(context);
        semCons.setKind(consKind);
        if (consKind == ConstraintKind.BODY_LITERAL) {
            semCons = this.contextsFactory.createConstraint();
            if (host.getDefOperation() != null) {
                semCons.setDefOperation((Operation)host.getDefOperation().accept(this, data));
            }
        } else if (consKind == ConstraintKind.DEF_LITERAL) {
            VariableDeclarationAS defVar = host.getDefVariable();
            if (defVar != null) {
                Classifier type = this.processor.getTypeFactory().buildOclAnyType();
                if (defVar.getType() != null) {
                    TypeLiteralExp tle = (TypeLiteralExp)defVar.getType().accept(this, data);
                    type = tle.getLiteralType();
                } else {
                    OclExpression exp = (OclExpression)defVar.getInitExp().accept(this, data);
                    type = exp.getType();
                }
                Classifier selfType = context.getReferredClassifier();
                Property prop = selfType.lookupProperty(defVar.getName());
                if (action != null && action.equals("declare defs")) {
                    prop = CreationHelper.createDefinedProperty(defVar.getName(), type, null);
                    selfType.addProperty(prop);
                } else {
                    semCons.setDefProperty(prop);
                    semCons.setName(prop.getName());
                    if (prop instanceof DefinedProperty) {
                        ((DefinedProperty)prop).setDefinition(semCons);
                    } else {
                        log.reportError("Error: Trying to 'def' property " + prop.getName() + " on class " + selfType + "\n" + "property already defined in the model");
                    }
                    if (prop == null) {
                        log.reportError("Code Error: Property " + prop.getName() + " on class " + selfType + "\n" + "doesn't exist. visit ConstraintAS with action set to 'define property' first.");
                    }
                }
            } else {
                OperationAS defOp = host.getDefOperation();
                if (defOp != null) {
                    Classifier type = this.processor.getTypeFactory().buildOclAnyType();
                    if (defOp.getType() != null) {
                        TypeLiteralExp tle = (TypeLiteralExp)defOp.getType().accept(this, data);
                        type = tle.getLiteralType();
                    }
                    Vector<String> pNames = new Vector<String>();
                    Vector<Classifier> pTypes = new Vector<Classifier>();
                    if (defOp.getParameters() != null) {
                        EList params = defOp.getParameters();
                        for (VariableDeclarationAS varDec : params) {
                            VariableDeclaration var = (VariableDeclaration)varDec.accept(this, data);
                            pNames.add(var.getName());
                            pTypes.add(var.getType());
                        }
                    }
                    Classifier selfType = context.getReferredClassifier();
                    Operation op = selfType.lookupOperation(defOp.getName(), pTypes);
                    if (action != null && action.equals("declare defs")) {
                        op = CreationHelper.createDefinedOperation(defOp.getName(), type, pTypes, pNames, null);
                        selfType.addOperation(op);
                    } else {
                        semCons.setDefOperation(op);
                        semCons.setName(op.getName());
                        int i_p = 0;
                        while (i_p < pNames.size()) {
                            String name = (String)pNames.get(i_p);
                            Classifier clsf = (Classifier)pTypes.get(i_p);
                            env = env.addVariableDeclaration(name, clsf, Boolean.TRUE);
                            ++i_p;
                        }
                        ((Map)data).put("env", env);
                        if (op instanceof DefinedOperation) {
                            ((DefinedOperation)op).setDefinition(semCons);
                        } else {
                            log.reportError("Error: Trying to 'def' operation " + op.getName() + " on class " + selfType + "\n" + "operation already defined in the model");
                        }
                        if (op == null) {
                            log.reportError("Code Error: Operation " + op.getName() + " on class " + selfType + "\n" + "doesn't exist. visit ConstraintAS with action set to 'define defs' first.");
                        }
                    }
                }
            }
        } else if (consKind != ConstraintKind.DERIVE_LITERAL && consKind != ConstraintKind.INIT_LITERAL && consKind != ConstraintKind.INV_LITERAL && consKind != ConstraintKind.PRE_LITERAL) {
        }
        if (action == null) {
            Object val = host.getBodyExpression().accept(this, data);
            semCons.setBodyExpression((OclExpression)val);
        }
        return semCons;
    }

    public Object visit(ConstraintKindAS host, Object data) {
        ConstraintKind kind = null;
        if (host == ConstraintKindAS.BODY_LITERAL) {
            kind = ConstraintKind.BODY_LITERAL;
        } else if (host == ConstraintKindAS.DEF_LITERAL) {
            kind = ConstraintKind.DEF_LITERAL;
        } else if (host == ConstraintKindAS.DERIVE_LITERAL) {
            kind = ConstraintKind.DERIVE_LITERAL;
        } else if (host == ConstraintKindAS.INIT_LITERAL) {
            kind = ConstraintKind.INIT_LITERAL;
        } else if (host == ConstraintKindAS.INV_LITERAL) {
            kind = ConstraintKind.INV_LITERAL;
        } else if (host == ConstraintKindAS.PRE_LITERAL) {
            kind = ConstraintKind.PRE_LITERAL;
        } else if (host == ConstraintKindAS.POST_LITERAL) {
            kind = ConstraintKind.POST_LITERAL;
        }
        return kind;
    }

    public Object visit(BooleanLiteralExpAS host, Object data) {
        if (host.getValue() == null) {
            UndefinedLiteralExp result = this.expressionsFactory.createUndefinedLiteralExp();
            result.setType(this.processor.getTypeFactory().buildVoidType());
            result.setIsMarkedPre(host.getIsMarkedPre() != null && host.getIsMarkedPre() != false);
            return result;
        }
        BooleanLiteralExp result = this.expressionsFactory.createBooleanLiteralExp();
        this.putAst(host, result);
        result.setBooleanSymbol(host.getValue());
        result.setType(this.processor.getTypeFactory().buildBooleanType());
        result.setIsMarkedPre(host.getIsMarkedPre() != null && host.getIsMarkedPre() != false);
        return result;
    }

    public Object visit(IntegerLiteralExpAS host, Object data) {
        IntegerLiteralExp result = this.expressionsFactory.createIntegerLiteralExp();
        this.putAst(host, result);
        result.setIntegerSymbol(host.getValue());
        result.setType(this.processor.getTypeFactory().buildIntegerType());
        result.setIsMarkedPre(host.getIsMarkedPre() != null && host.getIsMarkedPre() != false);
        return result;
    }

    public Object visit(RealLiteralExpAS host, Object data) {
        RealLiteralExp result = this.expressionsFactory.createRealLiteralExp();
        this.putAst(host, result);
        result.setRealSymbol(host.getValue());
        result.setType(this.processor.getTypeFactory().buildRealType());
        result.setIsMarkedPre(host.getIsMarkedPre() != null && host.getIsMarkedPre() != false);
        return result;
    }

    public Object visit(StringLiteralExpAS host, Object data) {
        StringLiteralExp result = this.expressionsFactory.createStringLiteralExp();
        this.putAst(host, result);
        result.setStringSymbol(host.getValue().replaceAll("''", "'"));
        result.setType(this.processor.getTypeFactory().buildStringType());
        result.setIsMarkedPre(host.getIsMarkedPre() != null && host.getIsMarkedPre() != null && host.getIsMarkedPre() != false);
        return result;
    }

    public Object visit(EnumLiteralExpAS host, Object data) {
        Environment env = (Environment)((Map)data).get("env");
        ILog cfr_ignored_0 = (ILog)((Map)data).get("log");
        List pathName = host.getPathName().subList(0, host.getPathName().size() - 1);
        String enumName = (String)host.getPathName().get(host.getPathName().size() - 1);
        Classifier type = (Classifier)env.lookupPathName(pathName);
        EnumLiteralExp result = this.expressionsFactory.createEnumLiteralExp();
        this.putAst(host, result);
        result.setType(type);
        result.setName(enumName);
        result.setReferredEnumLiteral(((Enumeration)type).lookupEnumLiteral(enumName));
        result.setIsMarkedPre(host.getIsMarkedPre() != null && host.getIsMarkedPre() != false);
        return result;
    }

    public Object visit(CollectionLiteralExpAS host, Object data) {
        Environment cfr_ignored_0 = (Environment)((Map)data).get("env");
        ILog log = (ILog)((Map)data).get("log");
        Iterator i = host.getCollectionParts().iterator();
        Classifier elementType = this.processor.getTypeFactory().buildVoidType();
        while (i.hasNext()) {
            Object o = i.next();
            CollectionLiteralPart crtElement = (CollectionLiteralPart)((CollectionLiteralPartAS)o).accept(this, data);
            Classifier crtElementType = crtElement.getType();
            Classifier tempType = this.checkTypes(elementType, crtElementType);
            if (tempType == null) {
                ErrorManager.reportWarning(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: Non-conforming types '" + elementType + "' and '" + crtElementType + "' in collection literal.");
                elementType = this.processor.getTypeFactory().buildOclAnyType();
                break;
            }
            elementType = tempType;
        }
        CollectionType type = null;
        CollectionKindAS kind = host.getKind();
        type = kind == CollectionKindAS.BAG_LITERAL ? this.processor.getTypeFactory().buildBagType(elementType) : (kind == CollectionKindAS.SET_LITERAL ? this.processor.getTypeFactory().buildSetType(elementType) : (kind == CollectionKindAS.ORDERED_SET_LITERAL ? this.processor.getTypeFactory().buildOrderedSetType(elementType) : (kind == CollectionKindAS.SEQUENCE_LITERAL ? this.processor.getTypeFactory().buildSequenceType(elementType) : this.processor.getTypeFactory().buildCollectionType(elementType))));
        type.setElementType(elementType);
        Vector<Object> colParts = new Vector<Object>();
        i = host.getCollectionParts().iterator();
        while (i.hasNext()) {
            colParts.add(((CollectionLiteralPartAS)i.next()).accept(this, data));
        }
        CollectionLiteralExp result = this.expressionsFactory.createCollectionLiteralExp();
        this.putAst(host, result);
        result.setKind((CollectionKind)((Object)this.visit(host.getKind(), data)));
        result.getParts().clear();
        result.getParts().addAll(colParts);
        result.setType(type);
        result.setIsMarkedPre(host.getIsMarkedPre() != null && host.getIsMarkedPre() != false);
        return result;
    }

    public Object visit(CollectionKindAS host, Object data) {
        CollectionKind kind = null;
        if (host == CollectionKindAS.COLLECTION_LITERAL) {
            kind = CollectionKind.COLLECTION_LITERAL;
        } else if (host == CollectionKindAS.BAG_LITERAL) {
            kind = CollectionKind.BAG_LITERAL;
        } else if (host == CollectionKindAS.SET_LITERAL) {
            kind = CollectionKind.SET_LITERAL;
        } else if (host == CollectionKindAS.SEQUENCE_LITERAL) {
            kind = CollectionKind.SEQUENCE_LITERAL;
        } else if (host == CollectionKindAS.ORDERED_SET_LITERAL) {
            kind = CollectionKind.ORDERED_SET_LITERAL;
        }
        return kind;
    }

    public Object visit(CollectionItemAS host, Object data) {
        CollectionItem result = this.expressionsFactory.createCollectionItem();
        result.setItem((OclExpression)host.getItem().accept(this, data));
        result.setType(result.getItem().getType());
        return result;
    }

    public Object visit(CollectionRangeAS host, Object data) {
        Environment cfr_ignored_0 = (Environment)((Map)data).get("env");
        ILog log = (ILog)((Map)data).get("log");
        Classifier type = null;
        OclExpression firstExp = (OclExpression)host.getFirst().accept(this, data);
        Classifier firstType = firstExp.getType();
        OclExpression lastExp = (OclExpression)host.getLast().accept(this, data);
        Classifier lastType = lastExp.getType();
        type = this.checkTypes(firstType, lastType);
        if (type == null) {
            ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: Non-conforming types '" + firstType + "' and '" + lastType + "' in collection range.");
            type = this.processor.getTypeFactory().buildVoidType();
        }
        CollectionRange result = this.expressionsFactory.createCollectionRange();
        result.setType(type);
        result.setFirst(firstExp);
        result.setLast(lastExp);
        return result;
    }

    public Object visit(TupleLiteralExpAS host, Object data) {
        TupleType type = this.processor.getTypeFactory().buildTupleType(new String[0], new Classifier[0]);
        Vector<VariableDeclaration> semTupleParts = new Vector<VariableDeclaration>();
        for (VariableDeclarationAS varDeclAS : host.getTupleParts()) {
            VariableDeclaration varDecl = this.expressionsFactory.createVariableDeclaration();
            varDecl.setName(varDeclAS.getName());
            Classifier varType = null;
            if (varDeclAS.getType() != null) {
                TypeLiteralExp tle = (TypeLiteralExp)varDeclAS.getType().accept(this, data);
                varType = tle.getLiteralType();
            }
            OclExpression init = null;
            if (varDeclAS.getInitExp() != null) {
                init = (OclExpression)varDeclAS.getInitExp().accept(this, data);
                if (varType == null) {
                    varType = init.getType();
                }
            }
            varDecl.setInitExpression(init);
            if (varType == null) {
                varDecl.setType(this.processor.getTypeFactory().buildOclAnyType());
            } else {
                varDecl.setType(varType);
            }
            semTupleParts.add(varDecl);
        }
        type.getPartType().clear();
        type.getPartType().addAll(semTupleParts);
        TupleLiteralExp result = this.expressionsFactory.createTupleLiteralExp();
        result.getTuplePart().clear();
        result.getTuplePart().addAll(semTupleParts);
        result.setType(type);
        result.setIsMarkedPre(host.getIsMarkedPre() != null && host.getIsMarkedPre() != false);
        return result;
    }

    protected String getString(List pathName) {
        String res = new String();
        Iterator i = pathName.iterator();
        while (i.hasNext()) {
            res = String.valueOf(res) + (String)i.next();
            if (!i.hasNext()) continue;
            res = String.valueOf(res) + "::";
        }
        return res;
    }

    protected boolean isPartOfCall(OclExpressionAS host) {
        OclExpressionAS parent = host.getParent();
        return parent != null && parent instanceof CallExpAS;
    }

    public Object visit(PathNameExpAS host, Object data) {
        Environment env = (Environment)((Map)data).get("env");
        ILog log = (ILog)((Map)data).get("log");
        OclExpression result = null;
        Classifier type = null;
        EList pathName = host.getPathName();
        String pathNameStr = this.getString((List)pathName);
        if (pathName.size() == 1) {
            ModelElement element = env.lookup(pathNameStr);
            if (element instanceof VariableDeclaration) {
                type = ((VariableDeclaration)element).getType();
                VariableDeclaration semVarDecl = (VariableDeclaration)element;
                result = this.expressionsFactory.createVariableExp();
                this.putAst(host, result);
                ((VariableExp)result).setReferredVariable(semVarDecl);
                result.setType(type);
            } else if (element != null && element instanceof Classifier) {
                if (host.getParent() != null) {
                    String operation = host.getParent().toString();
                    if ((operation = operation.substring(pathNameStr.length() + 1)).equals("allInstances")) {
                        type = (Classifier)element;
                        result = CreationHelper.createTypeLiteralExp(pathNameStr, Boolean.FALSE, (Classifier)element);
                        result.setType(type);
                    } else {
                        type = this.processor.getTypeFactory().buildTypeType((Classifier)element);
                        result = CreationHelper.createTypeLiteralExp(pathNameStr, Boolean.FALSE, (Classifier)element);
                        this.putAst(host, result);
                        result.setType(type);
                    }
                } else {
                    type = this.processor.getTypeFactory().buildTypeType((Classifier)element);
                    result = CreationHelper.createTypeLiteralExp(pathNameStr, Boolean.FALSE, (Classifier)element);
                    this.putAst(host, result);
                    result.setType(type);
                }
            } else {
                NamedElement entry = env.lookupImplicitSourceForProperty(pathNameStr);
                Property prop = env.lookupImplicitProperty(pathNameStr);
                PropertyCallExp propCall = this.expressionsFactory.createPropertyCallExp();
                this.putAst(host, propCall);
                result = propCall;
                propCall.setReferredProperty(prop);
                if (entry != null) {
                    VariableExp sourceExp = this.expressionsFactory.createVariableExp();
                    this.putAst(host, sourceExp);
                    sourceExp.setReferredVariable((VariableDeclaration)entry.getReferredElement());
                    sourceExp.setType(((VariableDeclaration)entry.getReferredElement()).getType());
                    propCall.setSource(sourceExp);
                    type = prop.getType();
                } else {
                    type = this.processor.getTypeFactory().buildVoidType();
                    ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: Unknown property or variable or pathName '" + pathNameStr + "'");
                }
                propCall.setType(type);
            }
        } else {
            ModelElement element = env.lookupPathName((List)pathName);
            if (element instanceof EnumLiteral) {
                result = this.expressionsFactory.createEnumLiteralExp();
                this.putAst(host, result);
                result.setReferredEnumLiteral((EnumLiteral)element);
                type = ((EnumLiteral)element).getEnumeration();
                result.setType(type);
                if (((EnumLiteral)element).getDelegate() == null) {
                    ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: Unknown Enumeration Literal");
                }
            } else if (element instanceof Property) {
                type = ((Property)element).getType();
                result = this.expressionsFactory.createPropertyCallExp();
                this.putAst(host, result);
                ((PropertyCallExp)result).setReferredProperty((Property)element);
                result.setType(type);
            } else if (element instanceof Classifier || (element = env.lookupPathName(this.cutPrecedingUnderscore((List)pathName))) instanceof Classifier) {
                type = this.processor.getTypeFactory().buildTypeType((Classifier)element);
                result = CreationHelper.createTypeLiteralExp(((Classifier)element).toString(), Boolean.FALSE, (Classifier)element);
                this.putAst(host, result);
                result.setType(type);
            } else {
                ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: Unknown pathname '" + pathNameStr + "'");
                type = this.processor.getTypeFactory().buildVoidType();
            }
        }
        return result;
    }

    public Object visit(DotSelectionExpAS host, Object data) {
        Environment cfr_ignored_0 = (Environment)((Map)data).get("env");
        ILog log = (ILog)((Map)data).get("log");
        CallExp result = null;
        Classifier type = null;
        OclExpressionAS source = host.getSource();
        OclExpression semSource = (OclExpression)source.accept(this, data);
        if (semSource != null) {
            Classifier sourceType = semSource.getType();
            if (sourceType instanceof CollectionType) {
                Classifier elementType = ((CollectionType)sourceType).getElementType();
                Property property = elementType.lookupProperty(host.getName());
                if (property != null) {
                    IteratorExp itExp = this.expressionsFactory.createIteratorExp();
                    result = itExp;
                    itExp.setIsMarkedPre(host.getIsMarkedPre() != null && host.getIsMarkedPre() != false);
                    itExp.setName("collect");
                    itExp.setSource(semSource);
                    VariableDeclaration it = this.expressionsFactory.createVariableDeclaration();
                    it.setName(this.newName());
                    it.setType(elementType);
                    itExp.getIterators().add((Object)it);
                    PropertyCallExp propCall = this.expressionsFactory.createPropertyCallExp();
                    this.putAst(host, propCall);
                    VariableExp propSource = this.expressionsFactory.createVariableExp();
                    this.putAst(source, propSource);
                    propSource.setReferredVariable(it);
                    propSource.setType(it.getType());
                    propCall.setSource(propSource);
                    propCall.setReferredProperty(property);
                    itExp.setBody(propCall);
                    Classifier propertyType = property.getType();
                    propCall.setType(propertyType);
                    if (propertyType instanceof CollectionType) {
                        type = this.baseElementType(propertyType);
                    } else if (propertyType instanceof Classifier) {
                        type = propertyType;
                    }
                    Operation op = sourceType.lookupOperation("collect", Arrays.asList(propertyType));
                    if (op != null) {
                        type = op.getReturnType();
                        itExp.setType(type);
                    } else {
                        ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: No operation " + sourceType + "->collect(" + propertyType + ")");
                    }
                } else {
                    ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: Unknown property '" + host.getName() + "' on '" + elementType + "'");
                }
            } else if (sourceType instanceof Classifier) {
                Property property = sourceType.lookupProperty(host.getName());
                if (property != null) {
                    PropertyCallExp propCall = this.expressionsFactory.createPropertyCallExp();
                    this.putAst(host, propCall);
                    result = propCall;
                    propCall.setIsMarkedPre(host.getIsMarkedPre() != null && host.getIsMarkedPre() != false);
                    propCall.setSource(semSource);
                    propCall.setReferredProperty(property);
                    Classifier propertyType = property.getType();
                    type = propertyType;
                    propCall.setType(type);
                } else {
                    ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: Unknown property '" + host.getName() + "' on '" + sourceType + "'");
                }
            }
            if (result == null) {
                VoidType propertyType;
                PropertyCallExp propCall = this.expressionsFactory.createPropertyCallExp();
                this.putAst(host, propCall);
                result = propCall;
                propCall.setIsMarkedPre(host.getIsMarkedPre() != null && host.getIsMarkedPre() != false);
                propCall.setSource(semSource);
                type = propertyType = this.processor.getTypeFactory().buildVoidType();
                propCall.setType(type);
            }
        } else {
            ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: Left hand side of '.' operator is undefined");
        }
        return result;
    }

    public Classifier baseElementType(Classifier t) {
        if (t instanceof CollectionType) {
            return this.baseElementType(((CollectionType)t).getElementType());
        }
        return t;
    }

    public Object visit(ArrowSelectionExpAS host, Object data) {
        Environment cfr_ignored_0 = (Environment)((Map)data).get("env");
        ILog cfr_ignored_1 = (ILog)((Map)data).get("log");
        return this.visit(host.getSource(), data);
    }

    protected static boolean isIteratorOperation(CollectionType type, String name) {
        String collection = "*exists*forAll*isUnique*any*one*collect*collectNested*";
        String bag = "*select*reject*collectNested*sortedBy*";
        String set = "*select*reject*collectNested*sortedBy*";
        String sequence = "*select*reject*collectNested*sortedBy*";
        String orderedSet = "*select*reject*collectNested*sortedBy*";
        String x = "*" + name + "*";
        if (type instanceof BagType) {
            return collection.indexOf(x) != -1 || bag.indexOf(x) != -1;
        }
        if (type instanceof OrderedSetType) {
            return collection.indexOf(x) != -1 || orderedSet.indexOf(x) != -1;
        }
        if (type instanceof SequenceType) {
            return collection.indexOf(x) != -1 || sequence.indexOf(x) != -1;
        }
        if (type instanceof SetType) {
            return collection.indexOf(x) != -1 || set.indexOf(x) != -1;
        }
        if (type instanceof CollectionType) {
            return collection.indexOf(x) != -1;
        }
        return false;
    }

    public Object visit(OperationCallExpAS host, Object data) {
        Environment env = (Environment)((Map)data).get("env");
        ILog log = (ILog)((Map)data).get("log");
        OclExpression result = null;
        Classifier type = null;
        Vector<Classifier> types = new Vector<Classifier>();
        Vector<OclExpression> args = new Vector<OclExpression>();
        for (OclExpressionAS pExp : host.getArguments()) {
            OclExpression paramExp = (OclExpression)pExp.accept(this, data);
            if (paramExp == null) {
                log.reportError("Problem evaluating expression : " + pExp);
                return null;
            }
            Classifier paramType = paramExp.getType();
            args.add(paramExp);
            types.add(paramType);
        }
        Operation oper = null;
        OclExpressionAS source = host.getSource();
        if (source instanceof PathNameExpAS) {
            OperationCallExp callExp = this.expressionsFactory.createOperationCallExp();
            this.putAst(host, callExp);
            result = callExp;
            EList pathName = ((PathNameExpAS)source).getPathName();
            String pathNameStr = this.getString((List)pathName);
            if (pathName.size() == 1) {
                oper = env.lookupImplicitOperation(pathNameStr, types);
                NamedElement entry = env.lookupImplicitSourceForOperation(pathNameStr, types);
                if (entry != null) {
                    VariableExp sourceExp = this.expressionsFactory.createVariableExp();
                    this.putAst(source, sourceExp);
                    sourceExp.setReferredVariable((VariableDeclaration)entry.getReferredElement());
                    sourceExp.setType(((VariableDeclaration)entry.getReferredElement()).getType());
                    callExp.setSource(sourceExp);
                }
                callExp.setReferredOperation(oper);
                callExp.getArguments().clear();
                callExp.getArguments().addAll(args);
            } else {
                oper = env.lookupPathName((List)pathName, types);
                callExp.setSource(null);
                callExp.setReferredOperation(oper);
                callExp.getArguments().clear();
                callExp.getArguments().addAll(args);
            }
            if (oper != null) {
                type = oper.getReturnType();
                if ("collect collectNested".indexOf(pathNameStr) != -1 && type instanceof CollectionType && types.size() != 0) {
                    ((CollectionType)type).setElementType((Classifier)types.get(0));
                }
            } else {
                ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: Unknown operation '" + pathNameStr + "' or type mismatch between parameters and arguments");
            }
        } else if (source instanceof ArrowSelectionExpAS) {
            OclExpressionAS realSource = ((ArrowSelectionExpAS)source).getSource();
            OclExpression semRealSource = (OclExpression)realSource.accept(this, data);
            if (semRealSource == null) {
                log.reportError("Proplem analysing expression - " + realSource);
                return null;
            }
            String name = ((ArrowSelectionExpAS)source).getName();
            Classifier realSourceType = semRealSource.getType();
            if (!(realSourceType instanceof CollectionType)) {
                CollectionItem colItem = this.expressionsFactory.createCollectionItem();
                this.putAst(realSource, colItem);
                colItem.setItem(semRealSource);
                semRealSource = this.expressionsFactory.createCollectionLiteralExp();
                this.putAst(realSource, semRealSource);
                realSourceType = this.processor.getTypeFactory().buildSetType(realSourceType);
                semRealSource.setType(realSourceType);
                ((CollectionLiteralExp)semRealSource).setKind(CollectionKind.SET_LITERAL);
                ((CollectionLiteralExp)semRealSource).getParts().add((Object)colItem);
            }
            if (realSourceType instanceof CollectionType && OclSemanticAnalyserVisitorImpl.isIteratorOperation((CollectionType)realSourceType, name)) {
                IteratorExp itExp = this.expressionsFactory.createIteratorExp();
                result = itExp;
                itExp.setName(name);
                VariableDeclaration it = this.expressionsFactory.createVariableDeclaration();
                Classifier elementType = ((CollectionType)realSourceType).getElementType();
                it.setType(elementType);
                itExp.getIterators().add((Object)it);
                itExp.setSource(semRealSource);
                itExp.setName(name);
                if (args != null && args.size() > 0) {
                    itExp.setBody((OclExpression)args.get(0));
                }
                oper = realSourceType.lookupOperation(name, types);
            } else {
                OperationCallExp callExp = this.expressionsFactory.createOperationCallExp();
                this.putAst(host, callExp);
                result = callExp;
                callExp.setSource(semRealSource);
                callExp.getArguments().clear();
                callExp.getArguments().addAll(args);
                oper = realSourceType.lookupOperation(name, types);
                callExp.setReferredOperation(oper);
            }
            if (oper != null) {
                type = oper.getReturnType();
                if (type instanceof TypeType) {
                    type = ((TypeType)type).getClassifier();
                }
                if ("collect collectNested".indexOf(name) != -1 && type instanceof CollectionType && types.size() != 0) {
                    ((CollectionType)type).setElementType((Classifier)types.get(0));
                }
            } else {
                ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: Unknown operation '" + name + "(" + types + ")' in type '" + realSourceType + "' or type mismatch between parameters and arguments");
            }
        } else if (source instanceof DotSelectionExpAS) {
            String name = ((SelectionExpAS)source).getName();
            OclExpressionAS realSource = ((SelectionExpAS)source).getSource();
            OclExpression semRealSource = (OclExpression)realSource.accept(this, data);
            if (semRealSource == null) {
                ErrorManager.reportError(log, null, "SA: Problem analysing expression : " + realSource);
                return null;
            }
            Classifier realSourceType = semRealSource.getType();
            oper = realSourceType == null ? null : realSourceType.lookupOperation(name, types);
            OperationCallExp callExp = this.expressionsFactory.createOperationCallExp();
            this.putAst(host, callExp);
            callExp.setSource(semRealSource);
            callExp.getArguments().clear();
            callExp.getArguments().addAll(args);
            callExp.setReferredOperation(oper);
            result = callExp;
            if (oper == null && realSourceType instanceof CollectionType) {
                IteratorExp itExp = this.expressionsFactory.createIteratorExp();
                result = itExp;
                VariableDeclaration it = this.expressionsFactory.createVariableDeclaration();
                Classifier elementType = ((CollectionType)realSourceType).getElementType();
                it.setType(elementType);
                itExp.getIterators().add((Object)it);
                itExp.setSource(semRealSource);
                itExp.setName(name);
                OperationCallExp body = this.expressionsFactory.createOperationCallExp();
                VariableExp bodySource = this.expressionsFactory.createVariableExp();
                this.putAst(source, bodySource);
                bodySource.setReferredVariable(it);
                bodySource.setType(it.getType());
                body.setSource(bodySource);
                body.getArguments().clear();
                body.getArguments().addAll(args);
                oper = elementType.lookupOperation(name, types);
                body.setReferredOperation(oper);
            }
            if (oper != null) {
                if ("=".equals(oper.getName()) || "<>".equals(oper.getName())) {
                    Classifier paramType = (Classifier)types.get(0);
                    if (realSourceType == null || paramType == null || !paramType.conformsTo(realSourceType).booleanValue() && !realSourceType.conformsTo(paramType).booleanValue()) {
                        ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "Instances of types '" + paramType + "' and '" + realSourceType + "' cannot be compared");
                    }
                }
                if ((type = oper.getReturnType()) instanceof TypeType) {
                    type = ((TypeType)type).getClassifier();
                }
                if ("collect collectNested".indexOf(name) != -1 && type instanceof CollectionType && types.size() != 0) {
                    ((CollectionType)type).setElementType((Classifier)types.get(0));
                }
            } else {
                ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: Unknown operation '" + name + types + "' in '" + realSourceType + "' or type mismatch between parameters and arguments");
            }
        }
        result.setType(type);
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Object visit(AssociationCallExpAS host, Object data) {
        void var5_9;
        Environment env = (Environment)((Map)data).get("env");
        ILog log = (ILog)((Map)data).get("log");
        Object var5_5 = null;
        Classifier type = null;
        Vector<Object> semQuals = new Vector<Object>();
        for (OclExpressionAS arg : host.getArguments()) {
            semQuals.add(arg.accept(this, data));
        }
        OclExpressionAS source = host.getSource();
        if (source instanceof PathNameExpAS) {
            PropertyCallExp propCall;
            PropertyCallExp propertyCallExp = propCall = this.expressionsFactory.createPropertyCallExp();
            propCall.getQualifiers().clear();
            propCall.getQualifiers().addAll(semQuals);
            String name = this.getString((List)((PathNameExpAS)((Object)host)).getPathName());
            Property prop = env.lookupImplicitProperty(name);
            propCall.setReferredProperty(prop);
            NamedElement entry = env.lookupImplicitSourceForProperty(name);
            if (entry != null) {
                VariableExp sourceExp = this.expressionsFactory.createVariableExp();
                this.putAst(source, sourceExp);
                sourceExp.setReferredVariable((VariableDeclaration)entry.getReferredElement());
                sourceExp.setType(((VariableDeclaration)entry.getReferredElement()).getType());
                propCall.setSource(sourceExp);
            }
            type = prop.getType();
        } else if (source instanceof DotSelectionExpAS) {
            OclExpressionAS realSource = ((DotSelectionExpAS)source).getSource();
            OclExpression realSemSource = (OclExpression)realSource.accept(this, data);
            Classifier realSourceType = realSemSource.getType();
            if (realSourceType instanceof CollectionType) {
                IteratorExp itExp;
                String name;
                Classifier elementType = ((CollectionType)realSourceType).getElementType();
                Property property = elementType.lookupProperty(name = ((DotSelectionExpAS)source).getName());
                if (property == null) {
                    ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: Unknown property '" + name + "' on type '" + elementType + "'. Returning null.");
                    return null;
                }
                IteratorExp iteratorExp = itExp = this.expressionsFactory.createIteratorExp();
                itExp.setIsMarkedPre(host.getIsMarkedPre() != null && host.getIsMarkedPre() != false);
                itExp.setSource(realSemSource);
                itExp.setName("collect");
                VariableDeclaration it = this.expressionsFactory.createVariableDeclaration();
                it.setName(this.newName());
                it.setType(elementType);
                itExp.getIterators().add((Object)it);
                PropertyCallExp propCall = this.expressionsFactory.createPropertyCallExp();
                VariableExp propSource = this.expressionsFactory.createVariableExp();
                this.putAst(source, propSource);
                propSource.setReferredVariable(it);
                propSource.setType(it.getType());
                propCall.setSource(propSource);
                propCall.setReferredProperty(property);
                itExp.setBody(propCall);
                Classifier propertyType = property.getType();
                propCall.setType(propertyType);
                if (propertyType instanceof CollectionType) {
                    type = ((CollectionType)propertyType).getElementType();
                } else if (propertyType instanceof Classifier) {
                    type = propertyType;
                }
                type = realSourceType instanceof BagType ? this.processor.getTypeFactory().buildBagType(type) : (realSourceType instanceof OrderedSetType ? this.processor.getTypeFactory().buildOrderedSetType(type) : (realSourceType instanceof SetType ? this.processor.getTypeFactory().buildBagType(type) : this.processor.getTypeFactory().buildSequenceType(type)));
                itExp.setType(type);
            } else {
                PropertyCallExp propCall;
                PropertyCallExp propertyCallExp = propCall = this.expressionsFactory.createPropertyCallExp();
                propCall.getQualifiers().clear();
                propCall.getQualifiers().addAll(semQuals);
                String name = this.getString((List)((PathNameExpAS)((Object)host)).getPathName());
                Property prop = realSourceType.lookupProperty(name);
                propCall.setReferredProperty(prop);
                propCall.setSource(realSemSource);
                type = prop.getType();
            }
        }
        var5_9.setType(type);
        return var5_9;
    }

    public Object visit(IteratorExpAS host, Object data) {
        Environment env = (Environment)((Map)data).get("env");
        ILog log = (ILog)((Map)data).get("log");
        IteratorExp result = this.expressionsFactory.createIteratorExp();
        this.putAst(host, result);
        Classifier type = null;
        OclExpressionAS source = host.getSource();
        if (source instanceof SelectionExpAS) {
            OclExpressionAS realSource = ((SelectionExpAS)source).getSource();
            OclExpression semRealSource = (OclExpression)realSource.accept(this, data);
            if (semRealSource == null) {
                ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: Problem analysing expression - " + realSource);
                return null;
            }
            Classifier sourceType = semRealSource.getType();
            if (sourceType != null) {
                if (sourceType instanceof OclModelElementType || sourceType instanceof Primitive) {
                    sourceType = this.processor.getTypeFactory().buildSetType(sourceType);
                }
                if (sourceType instanceof CollectionType) {
                    Classifier elementType = ((CollectionType)sourceType).getElementType();
                    if (host.getSource() instanceof ArrowSelectionExpAS) {
                        String name = ((ArrowSelectionExpAS)host.getSource()).getName();
                        Environment env1 = env.nestedEnvironment();
                        Vector<VariableDeclaration> iteratorVars = new Vector<VariableDeclaration>();
                        for (VariableDeclarationAS varAs : host.getIterator()) {
                            VariableDeclaration var = (VariableDeclaration)varAs.accept(this, data);
                            Classifier varType = var.getType();
                            if (varType == null || varType instanceof VoidType) {
                                varType = elementType;
                                var.setType(elementType);
                            }
                            iteratorVars.add(var);
                            env1 = env1.addVariableDeclaration(var, Boolean.FALSE);
                        }
                        HashMap<String, Environment> data1 = new HashMap<String, Environment>();
                        data1.putAll((Map)data);
                        data1.put("env", env1);
                        OclExpressionAS bodyAS = host.getBody();
                        OclExpression body = (OclExpression)bodyAS.accept(this, data1);
                        if (body == null) {
                            log.reportError("Problem analysing body expression - " + bodyAS);
                            return null;
                        }
                        Classifier bodyType = body.getType();
                        Classifier var1Type = ((VariableDeclaration)iteratorVars.get(0)).getType();
                        Vector<Classifier> types = new Vector<Classifier>();
                        types.add(var1Type);
                        types.add(bodyType);
                        if (!elementType.conformsTo(var1Type).booleanValue()) {
                            ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: Element type '" + elementType + "' does not conform to iterator type '" + var1Type + "'.");
                        }
                        Operation oper = ((CollectionType)sourceType).lookupOperation(name, types);
                        result.setSource(semRealSource);
                        result.setName(name);
                        result.getIterators().clear();
                        result.getIterators().addAll(new HashSet(iteratorVars));
                        result.setBody(body);
                        if (oper != null) {
                            type = oper.getReturnType();
                        } else {
                            ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: Unknown iterator '" + sourceType + "->" + name + types + "' or type mismatch between parameters and arguments");
                        }
                    } else if (host.getSource() instanceof DotSelectionExpAS) {
                        ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: '->' selection is expected before operation '" + ((DotSelectionExpAS)host.getSource()).getName() + "'");
                    } else {
                        ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: '->' selection is expected");
                    }
                } else {
                    ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: Left hand side of '->' operator should be a collection type");
                }
            } else {
                ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: Left hand side of '->' operator has a wrong type");
            }
        }
        result.setType(type);
        return result;
    }

    public Object visit(IterateExpAS host, Object data) {
        Classifier varType;
        Environment env = (Environment)((Map)data).get("env");
        ILog log = (ILog)((Map)data).get("log");
        IterateExp result = this.expressionsFactory.createIterateExp();
        this.putAst(host, result);
        result.setIsMarkedPre(host.getIsMarkedPre() != null && host.getIsMarkedPre() != false);
        OclExpression source = (OclExpression)host.getSource().accept(this, data);
        if (!(source.getType() instanceof CollectionType)) {
            ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: Source of 'iterate' must be a collection. Returning null.");
            return null;
        }
        Classifier elementType = ((CollectionType)source.getType()).getElementType();
        result.setSource(source);
        Environment env1 = env.nestedEnvironment();
        Vector<VariableDeclaration> iteratorVars = new Vector<VariableDeclaration>();
        for (VariableDeclarationAS varAs : host.getIterator()) {
            VariableDeclaration var = (VariableDeclaration)varAs.accept(this, data);
            varType = var.getType();
            if (varType == null || varType instanceof VoidType) {
                varType = elementType;
                var.setType(elementType);
            }
            iteratorVars.add(var);
            env1 = env1.addVariableDeclaration(var, Boolean.FALSE);
        }
        result.getIterators().clear();
        result.getIterators().addAll(new HashSet());
        result.getIterators().add((Object)((VariableDeclaration)iteratorVars.get(0)));
        VariableDeclaration var = (VariableDeclaration)host.getResult().accept(this, data);
        env1 = env1.addVariableDeclaration(var, Boolean.FALSE);
        result.setResult(var);
        HashMap<String, Environment> data1 = new HashMap<String, Environment>();
        data1.putAll((Map)data);
        data1.put("env", env1);
        data = data1;
        result.setBody((OclExpression)host.getBody().accept(this, data));
        varType = result.getBody().getType();
        if (varType == null) {
            varType = this.processor.getTypeFactory().buildOclAnyType();
        }
        result.setType(varType);
        return result;
    }

    public Object visit(NotExpAS host, Object data) {
        String opName = "not";
        Environment cfr_ignored_0 = (Environment)((Map)data).get("env");
        ILog log = (ILog)((Map)data).get("log");
        OperationCallExp opExp = this.expressionsFactory.createOperationCallExp();
        this.putAst(host, opExp);
        Classifier type = null;
        OclExpression leftExp = (OclExpression)host.getLeftOperand().accept(this, data);
        type = leftExp.getType();
        if (type == null || !(type instanceof BooleanType)) {
            ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: The 'not' method is not defined for the type '" + type + "'");
            type = this.processor.getTypeFactory().buildBooleanType();
        }
        opExp.setSource(leftExp);
        opExp.setName(opName);
        opExp.setReferredOperation(type.lookupOperation(opName, new ArrayList()));
        opExp.setType(type);
        leftExp.setAppliedProperty(opExp);
        return opExp;
    }

    public Object visit(AndExpAS host, Object data) {
        String opName = "and";
        Environment cfr_ignored_0 = (Environment)((Map)data).get("env");
        ILog log = (ILog)((Map)data).get("log");
        OperationCallExp opExp = this.expressionsFactory.createOperationCallExp();
        this.putAst(host, opExp);
        OclExpression leftExp = (OclExpression)host.getLeftOperand().accept(this, data);
        Classifier leftType = leftExp.getType();
        OclExpression rightExp = (OclExpression)host.getRightOperand().accept(this, data);
        Classifier rightType = rightExp.getType();
        if (!(leftType instanceof BooleanType)) {
            ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: The 'and' method is not defined for the type '" + leftType + "'");
        } else if (!(rightType instanceof BooleanType)) {
            ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: The 'and' method is not defined for the argument type '" + rightType + "'");
        }
        opExp.setSource(leftExp);
        opExp.setName(opName);
        ArrayList<Classifier> argumentTypes = new ArrayList<Classifier>();
        ArrayList<OclExpression> arguments = new ArrayList<OclExpression>();
        arguments.add(rightExp);
        argumentTypes.add(rightType);
        opExp.setReferredOperation(leftType.lookupOperation(opName, argumentTypes));
        opExp.setType(rightType);
        opExp.getArguments().clear();
        opExp.getArguments().addAll(arguments);
        leftExp.setAppliedProperty(opExp);
        return opExp;
    }

    public Object visit(OrExpAS host, Object data) {
        String opName = "or";
        Environment cfr_ignored_0 = (Environment)((Map)data).get("env");
        ILog log = (ILog)((Map)data).get("log");
        OperationCallExp opExp = this.expressionsFactory.createOperationCallExp();
        this.putAst(host, opExp);
        OclExpression leftExp = (OclExpression)host.getLeftOperand().accept(this, data);
        Classifier leftType = leftExp.getType();
        OclExpression rightExp = (OclExpression)host.getRightOperand().accept(this, data);
        Classifier rightType = rightExp.getType();
        if (!(leftType instanceof BooleanType)) {
            ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: The 'or' method is not defined for the type '" + leftType + "'");
        } else if (!(rightType instanceof BooleanType)) {
            ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: The 'or' method is not defined for the argument type '" + rightType + "'");
        }
        opExp.setSource(leftExp);
        opExp.setName(opName);
        ArrayList<Classifier> argumentTypes = new ArrayList<Classifier>();
        ArrayList<OclExpression> arguments = new ArrayList<OclExpression>();
        arguments.add(rightExp);
        argumentTypes.add(rightType);
        opExp.setReferredOperation(leftType.lookupOperation(opName, argumentTypes));
        opExp.setType(rightType);
        opExp.getArguments().clear();
        opExp.getArguments().addAll(arguments);
        leftExp.setAppliedProperty(opExp);
        return opExp;
    }

    public Object visit(XorExpAS host, Object data) {
        String opName = "xor";
        Environment cfr_ignored_0 = (Environment)((Map)data).get("env");
        ILog log = (ILog)((Map)data).get("log");
        OperationCallExp opExp = this.expressionsFactory.createOperationCallExp();
        this.putAst(host, opExp);
        OclExpression leftExp = (OclExpression)host.getLeftOperand().accept(this, data);
        Classifier leftType = leftExp.getType();
        OclExpression rightExp = (OclExpression)host.getRightOperand().accept(this, data);
        Classifier rightType = rightExp.getType();
        if (!(leftType instanceof BooleanType)) {
            ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: The 'xor' method is not defined for the type '" + leftType + "'");
        } else if (!(rightType instanceof BooleanType)) {
            ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: The 'xor' method is not defined for the argument type '" + rightType + "'");
        }
        opExp.setSource(leftExp);
        opExp.setName(opName);
        ArrayList<Classifier> argumentTypes = new ArrayList<Classifier>();
        ArrayList<OclExpression> arguments = new ArrayList<OclExpression>();
        arguments.add(rightExp);
        argumentTypes.add(rightType);
        opExp.setReferredOperation(leftType.lookupOperation(opName, argumentTypes));
        opExp.setType(rightType);
        opExp.getArguments().clear();
        opExp.getArguments().addAll(arguments);
        leftExp.setAppliedProperty(opExp);
        return opExp;
    }

    public Object visit(ImpliesExpAS host, Object data) {
        String opName = "implies";
        Environment cfr_ignored_0 = (Environment)((Map)data).get("env");
        ILog log = (ILog)((Map)data).get("log");
        OperationCallExp opExp = this.expressionsFactory.createOperationCallExp();
        this.putAst(host, opExp);
        OclExpression leftExp = (OclExpression)host.getLeftOperand().accept(this, data);
        Classifier leftType = leftExp.getType();
        OclExpression rightExp = (OclExpression)host.getRightOperand().accept(this, data);
        Classifier rightType = rightExp.getType();
        if (!(leftType instanceof BooleanType)) {
            ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: The 'implies' method is not defined for the type '" + leftType + "'");
        } else if (!(rightType instanceof BooleanType)) {
            ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: The 'implies' method is not defined for the argument type '" + rightType + "'");
        }
        opExp.setSource(leftExp);
        opExp.setName(opName);
        ArrayList<Classifier> argumentTypes = new ArrayList<Classifier>();
        ArrayList<OclExpression> arguments = new ArrayList<OclExpression>();
        arguments.add(rightExp);
        argumentTypes.add(rightType);
        opExp.setReferredOperation(leftType.lookupOperation(opName, argumentTypes));
        opExp.setType(rightType);
        opExp.getArguments().clear();
        opExp.getArguments().addAll(arguments);
        leftExp.setAppliedProperty(opExp);
        return opExp;
    }

    public Object visit(IfExpAS host, Object data) {
        OclExpression elseExp;
        Classifier elseType;
        OclExpression thenExp;
        Classifier thenType;
        Environment cfr_ignored_0 = (Environment)((Map)data).get("env");
        ILog log = (ILog)((Map)data).get("log");
        IfExp result = this.expressionsFactory.createIfExp();
        this.putAst(host, result);
        Classifier type = null;
        OclExpression condExp = (OclExpression)host.getCondition().accept(this, data);
        Classifier condType = condExp.getType();
        if (!(condType instanceof BooleanType)) {
            ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: The condition of 'if' must be boolean");
            type = this.processor.getTypeFactory().buildBooleanType();
        }
        if ((type = this.checkTypes(thenType = (thenExp = (OclExpression)host.getThenExpression().accept(this, data)).getType(), elseType = (elseExp = (OclExpression)host.getElseExpression().accept(this, data)).getType())) == null) {
            ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: Different types for branches - if " + condType + " then " + thenType + " else " + elseType + " endif");
        }
        result.setCondition(condExp);
        result.setThenExpression(thenExp);
        result.setElseExpression(elseExp);
        result.setType(type);
        return result;
    }

    public Object visit(LetExpAS host, Object data) {
        LetExp result;
        Environment env = (Environment)((Map)data).get("env");
        ILog log = (ILog)((Map)data).get("log");
        LetExp lastLetExp = result = this.expressionsFactory.createLetExp();
        Iterator i = host.getVariables().iterator();
        Vector<LetExp> letExps = new Vector<LetExp>();
        letExps.add(lastLetExp);
        while (i.hasNext()) {
            VariableDeclarationAS varDeclAS = (VariableDeclarationAS)i.next();
            ((Map)data).put("env", env);
            VariableDeclaration semVarDecl = (VariableDeclaration)varDeclAS.accept(this, data);
            if (semVarDecl == null) {
                ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: Problem analysing expression - " + varDeclAS);
                return null;
            }
            env = env.addVariableDeclaration(varDeclAS.getName(), semVarDecl.getType(), new Boolean(false));
            lastLetExp.setVariable(semVarDecl);
            lastLetExp.setIsMarkedPre(host.getIsMarkedPre() != null && host.getIsMarkedPre() != false);
            if (!i.hasNext()) continue;
            LetExp nextLetExp = this.expressionsFactory.createLetExp();
            lastLetExp.setIn(nextLetExp);
            lastLetExp = nextLetExp;
            letExps.add(lastLetExp);
        }
        HashMap<String, Object> newData = new HashMap<String, Object>();
        newData.put("log", log);
        newData.put("env", env);
        OclExpression cfr_ignored_0 = (OclExpression)host.getIn().accept(this, newData);
        lastLetExp.setIn((OclExpression)host.getIn().accept(this, newData));
        Classifier inType = lastLetExp.getIn().getType();
        for (LetExp letExp : letExps) {
            letExp.setType(inType);
        }
        return result;
    }

    public Object visit(OclMessageExpAS host, Object data) {
        return null;
    }

    public Object visit(OclMessageArgAS host, Object data) {
        return null;
    }

    public Object visit(CollectionTypeAS host, Object data) {
        TypeLiteralExp tle = (TypeLiteralExp)host.getElementType().accept(this, data);
        Classifier subType = tle.getLiteralType();
        CollectionType litType = this.processor.getTypeFactory().buildCollectionType(subType);
        TypeType type = this.processor.getTypeFactory().buildTypeType(litType);
        TypeLiteralExp result = CreationHelper.createTypeLiteralExp("Set", Boolean.FALSE, litType);
        result.setType(type);
        return result;
    }

    public Object visit(BagTypeAS host, Object data) {
        TypeLiteralExp tle = (TypeLiteralExp)host.getElementType().accept(this, data);
        Classifier subType = tle.getLiteralType();
        BagType litType = this.processor.getTypeFactory().buildBagType(subType);
        TypeType type = this.processor.getTypeFactory().buildTypeType(litType);
        TypeLiteralExp result = CreationHelper.createTypeLiteralExp("Set", Boolean.FALSE, litType);
        result.setType(type);
        return result;
    }

    public Object visit(SetTypeAS host, Object data) {
        TypeLiteralExp tle = (TypeLiteralExp)host.getElementType().accept(this, data);
        Classifier subType = tle.getLiteralType();
        SetType litType = this.processor.getTypeFactory().buildSetType(subType);
        TypeType type = this.processor.getTypeFactory().buildTypeType(litType);
        TypeLiteralExp result = CreationHelper.createTypeLiteralExp("Set", Boolean.FALSE, litType);
        result.setType(type);
        return result;
    }

    public Object visit(OrderedSetTypeAS host, Object data) {
        TypeLiteralExp tle = (TypeLiteralExp)host.getElementType().accept(this, data);
        Classifier subType = tle.getLiteralType();
        OrderedSetType litType = this.processor.getTypeFactory().buildOrderedSetType(subType);
        TypeType type = this.processor.getTypeFactory().buildTypeType(litType);
        TypeLiteralExp result = CreationHelper.createTypeLiteralExp("Set", Boolean.FALSE, litType);
        result.setType(type);
        return result;
    }

    public Object visit(SequenceTypeAS host, Object data) {
        TypeLiteralExp tle = (TypeLiteralExp)host.getElementType().accept(this, data);
        Classifier subType = tle.getLiteralType();
        SequenceType litType = this.processor.getTypeFactory().buildSequenceType(subType);
        TypeType type = this.processor.getTypeFactory().buildTypeType(litType);
        TypeLiteralExp result = CreationHelper.createTypeLiteralExp("Set", Boolean.FALSE, litType);
        result.setType(type);
        return result;
    }

    public Object visit(TupleTypeAS host, Object data) {
        TupleType litType = this.processor.getTypeFactory().buildTupleType(new String[0], new Classifier[0]);
        for (VariableDeclarationAS varDeclAS : host.getVariableDeclarationList()) {
            VariableDeclaration varDecl = this.expressionsFactory.createVariableDeclaration();
            varDecl.setName(varDeclAS.getName());
            TypeLiteralExp tle = (TypeLiteralExp)varDeclAS.getType().accept(this, data);
            Classifier varType = tle.getLiteralType();
            if (varType == null) {
                varType = this.processor.getTypeFactory().buildOclAnyType();
            }
            varDecl.setType(varType);
            litType.getPartType().add((Object)varDecl);
        }
        TypeType type = this.processor.getTypeFactory().buildTypeType(litType);
        TypeLiteralExp result = CreationHelper.createTypeLiteralExp("Tuple", Boolean.FALSE, litType);
        result.setType(type);
        return result;
    }

    public List cutPrecedingUnderscore(List pathName) {
        ArrayList<String> result = new ArrayList<String>();
        if (pathName != null) {
            int i = 0;
            while (i < pathName.size()) {
                if (pathName.get(i) instanceof String) {
                    String s = (String)pathName.get(i);
                    if (s.startsWith("_")) {
                        result.add(s.substring(1));
                    } else {
                        result.add(s);
                    }
                }
                ++i;
            }
        }
        return result;
    }

    public Object visit(ClassifierAS host, Object data) {
        Environment env = (Environment)((Map)data).get("env");
        ILog log = (ILog)((Map)data).get("log");
        List pathName = host.getPathName();
        ModelElement element = env.lookupPathName(pathName);
        if (element instanceof Classifier || (element = env.lookupPathName(this.cutPrecedingUnderscore(pathName))) instanceof Classifier) {
            Classifier litType = (Classifier)element;
            TypeType type = this.processor.getTypeFactory().buildTypeType(litType);
            TypeLiteralExp result = CreationHelper.createTypeLiteralExp(litType.toString(), Boolean.FALSE, litType);
            result.setType(type);
            return result;
        }
        String typeStr = "";
        int i = 0;
        while (i < pathName.size()) {
            if (i != 0) {
                typeStr = String.valueOf(typeStr) + "::";
            }
            typeStr = String.valueOf(typeStr) + pathName.get(i);
            ++i;
        }
        ErrorManager.reportError(log, OclSemanticAnalyserVisitorImpl.getSymbol(host), "SA: Unknown classifier '" + typeStr + "'.");
        return CreationHelper.createTypeLiteralExp("VoidType", Boolean.FALSE, this.processor.getTypeFactory().buildVoidType());
    }

    public Object visit(OclMessageKindAS host, Object data) {
        return null;
    }

    public Classifier checkTypes(Classifier t1, Classifier t2) {
        Classifier type = null;
        if (t1.conformsTo(t2).booleanValue()) {
            type = t2;
        } else if (t2.conformsTo(t1).booleanValue()) {
            type = t1;
        }
        return type;
    }

    public static void clearSymbolMap() {
        symbolMap = null;
    }

    public static void putSymbol(Symbol result) {
        if (symbolMap == null) {
            symbolMap = new HashMap();
        }
        if (result.value != null && symbolMap.get(result.value) == null) {
            symbolMap.put(result.value, result);
        }
    }

    protected static Object getSymbol(Visitable host) {
        if (symbolMap == null) {
            return null;
        }
        Symbol symbol = (Symbol)symbolMap.get(host);
        return symbol;
    }

    protected void putAst(Visitable cst, SemanticsVisitable ast) {
        if (this.astMap == null) {
            this.astMap = new HashMap();
        }
        this.astMap.put(ast, OclSemanticAnalyserVisitorImpl.getSymbol(cst));
        if (this.mapCstToAst == null) {
            this.mapCstToAst = new HashMap();
        }
        this.mapCstToAst.put(cst, ast);
    }

    protected SemanticsVisitable getAstFromCst(Visitable cst) {
        if (this.mapCstToAst == null) {
            this.mapCstToAst = new HashMap();
        }
        return (SemanticsVisitable)this.mapCstToAst.get(cst);
    }

    protected Symbol getSymbol(SemanticsVisitable host) {
        if (this.astMap == null) {
            return null;
        }
        Object symbol = this.astMap.get(host);
        if (symbol == null && host.eContainer() instanceof SemanticsVisitable) {
            symbol = this.getSymbol((SemanticsVisitable)host.eContainer());
        }
        return (Symbol)symbol;
    }

    public static int getBeginColumn(Symbol sym2) {
        if (sym2 instanceof ComplexSymbolFactory.ComplexSymbol) {
            ComplexSymbolFactory.ComplexSymbol csym = (ComplexSymbolFactory.ComplexSymbol)sym2;
            return csym.getLeft().getColumn();
        }
        return OclSemanticAnalyserVisitorImpl.getEndColumn(sym2);
    }

    public static int getBeginLine(Symbol sym2) {
        if (sym2 instanceof ComplexSymbolFactory.ComplexSymbol) {
            ComplexSymbolFactory.ComplexSymbol csym = (ComplexSymbolFactory.ComplexSymbol)sym2;
            return csym.getLeft().getLine();
        }
        return OclSemanticAnalyserVisitorImpl.getEndLine(sym2);
    }

    public static int getEndColumn(Symbol sym2) {
        if (sym2 instanceof ComplexSymbolFactory.ComplexSymbol) {
            ComplexSymbolFactory.ComplexSymbol csym = (ComplexSymbolFactory.ComplexSymbol)sym2;
            return csym.getRight().getColumn();
        }
        return sym2 == null ? 0 : sym2.right + 1;
    }

    public static int getEndLine(Symbol sym2) {
        if (sym2 instanceof ComplexSymbolFactory.ComplexSymbol) {
            ComplexSymbolFactory.ComplexSymbol csym = (ComplexSymbolFactory.ComplexSymbol)sym2;
            return csym.getRight().getLine();
        }
        return sym2 == null ? 0 : sym2.left + 1;
    }

    public int getBeginColumn(SemanticsVisitable host) {
        return OclSemanticAnalyserVisitorImpl.getBeginColumn(this.getSymbol(host));
    }

    public int getBeginLine(SemanticsVisitable host) {
        return OclSemanticAnalyserVisitorImpl.getBeginLine(this.getSymbol(host));
    }

    public int getEndColumn(SemanticsVisitable host) {
        return OclSemanticAnalyserVisitorImpl.getEndColumn(this.getSymbol(host));
    }

    public int getEndLine(SemanticsVisitable host) {
        return OclSemanticAnalyserVisitorImpl.getEndLine(this.getSymbol(host));
    }

    public Map getAstMap() {
        return this.astMap;
    }

    public void setAstMap(Map value) {
        this.astMap = value;
    }

    public void clearAstMap() {
        this.astMap = null;
        this.mapCstToAst = null;
    }

    public Object visit(TopLevelAS host, Object data) {
        return null;
    }

    public Object visit(TransformationAS host, Object data) {
        return null;
    }

    public Object visit(ModelDeclarationAS host, Object data) {
        return null;
    }

    public Object visit(KeyDeclarationAS host, Object data) {
        return null;
    }

    public Object visit(QueryAS host, Object data) {
        return null;
    }

    public Object visit(ParameterDeclarationAS host, Object data) {
        return null;
    }

    public Object visit(RelationAS host, Object data) {
        return null;
    }

    public Object visit(PrimitiveDomainAS host, Object data) {
        return null;
    }

    public Object visit(DomainAS host, Object data) {
        return null;
    }

    public Object visit(ObjectTemplateAS host, Object data) {
        return null;
    }

    public Object visit(PropertyTemplateAS host, Object data) {
        return null;
    }

    public Object visit(org.oslo.ocl20.syntax.ast.qvt.VariableDeclarationAS host, Object data) {
        return null;
    }
}

