/*
 * Decompiled with CFR 0.152.
 */
package de.ikv.medini.qvt.execution.debug.stackframe;

import de.ikv.medini.qvt.QvtProcessorImpl;
import de.ikv.medini.qvt.execution.QvtSemanticTask;
import de.ikv.medini.qvt.execution.debug.QVTSourcePosition;
import de.ikv.medini.qvt.execution.debug.stackframe.QVTStackFrameVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.oslo.ocl20.semantics.model.expressions.VariableDeclaration;

public class QVTDebugStackFrame {
    private List variables = new ArrayList();
    private String name;
    private String pseudoCode;
    private QVTSourcePosition sourcePosition;

    public QVTDebugStackFrame(QvtSemanticTask task) {
        QvtProcessorImpl processor = task.getQvtProcessor();
        this.sourcePosition = task.currentSourcePosition();
        this.name = task.getRelation().getName();
        this.pseudoCode = task.currentWhenClause() != null ? processor.getPseudoCodeForWhenClause(task.currentClause()) : processor.getPseudoCodeForWhereClause(task.currentClause());
        new HashMap();
        EList templateVariables = task.getRelation().getVariable();
        for (VariableDeclaration currentVariableDeclaration : templateVariables) {
            this.variables.add(new QVTStackFrameVariable(this, currentVariableDeclaration.getName(), task, task.getCurrentBindingNumber()));
        }
    }

    public List getVariables() {
        return this.variables;
    }

    public String toString() {
        return String.valueOf(this.sourcePosition.getFile()) + "|" + this.sourcePosition.getLine() + "|" + this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getPseudoCode() {
        return this.pseudoCode;
    }

    public boolean hasPseudoCode() {
        return this.pseudoCode != null && !"".equals(this.pseudoCode);
    }

    public QVTSourcePosition getSourcePosition() {
        return this.sourcePosition;
    }
}

