/*
 * Decompiled with CFR 0.152.
 */
package de.ikv.medini.qvt.execution.debug;

import de.ikv.medini.qvt.QvtProcessorImpl;
import de.ikv.medini.qvt.execution.QvtSemanticTask;
import de.ikv.medini.qvt.execution.debug.IDebugAdapter;
import de.ikv.medini.qvt.execution.debug.QVTDebugPosition;
import de.ikv.medini.qvt.execution.debug.events.QVTDebugEvent;
import de.ikv.medini.qvt.execution.debug.events.QVTDebugEventStarted;
import de.ikv.medini.qvt.execution.debug.events.QVTDebugEventSuspended;
import de.ikv.medini.qvt.execution.debug.events.QVTDebugEventSuspendedBreakpointCause;
import de.ikv.medini.qvt.execution.debug.events.QVTDebugEventSuspendedStepCause;
import de.ikv.medini.qvt.execution.debug.events.QVTDebugEventTerminated;
import de.ikv.medini.qvt.execution.debug.replies.QVTDebugReply;
import de.ikv.medini.qvt.execution.debug.requests.QVTDebugRequest;
import de.ikv.medini.qvt.execution.debug.stackframe.QVTDebugStackFrame;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class DebugAdapterImpl
implements IDebugAdapter {
    private QvtProcessorImpl processor;
    private Set breakpoints = new HashSet();
    private LinkedList requestQueue = new LinkedList();
    private LinkedList eventQueue = new LinkedList();
    private boolean suspended;
    private boolean terminated = false;
    private QvtSemanticTask taskToStepOver;
    private QvtSemanticTask taskToStepIntoFrom;
    private QVTDebugPosition lastDebugPosition;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerEvent(QVTDebugEvent event) {
        LinkedList linkedList = this.eventQueue;
        synchronized (linkedList) {
            this.eventQueue.add(event);
            this.eventQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QVTDebugEvent dequeueEvent() throws InterruptedException {
        LinkedList linkedList = this.eventQueue;
        synchronized (linkedList) {
            while (this.eventQueue.isEmpty() && !this.terminated) {
                this.eventQueue.wait();
            }
            if (!this.eventQueue.isEmpty()) {
                QVTDebugEvent result = (QVTDebugEvent)this.eventQueue.remove(0);
                this.eventQueue.notifyAll();
                return result;
            }
            return null;
        }
    }

    public Set getBreakpoints() {
        return this.breakpoints;
    }

    public void doDebugWork() {
        QvtSemanticTask task = this.getSuspendedTask();
        if (task != null) {
            if (!this.suspended && this.taskToStepIntoFrom != null && task.getWaitingTasks().contains(this.taskToStepIntoFrom)) {
                this.suspended = true;
                this.triggerEvent(new QVTDebugEventSuspended(new QVTDebugEventSuspendedStepCause()));
            } else if (!(this.suspended || this.taskToStepOver == null || this.taskToStepOver != task && this.taskToStepOver.isComputing())) {
                if (!task.currentDebugPosition().equals(this.lastDebugPosition)) {
                    this.suspended = true;
                    this.triggerEvent(new QVTDebugEventSuspended(new QVTDebugEventSuspendedStepCause()));
                }
            } else if (!this.suspended && this.breakpoints.contains(task.currentSourcePosition()) && !task.currentDebugPosition().equals(this.lastDebugPosition)) {
                this.suspended = true;
                this.triggerEvent(new QVTDebugEventSuspended(new QVTDebugEventSuspendedBreakpointCause(new QVTDebugStackFrame(task))));
            }
        }
        this.readNextRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readNextRequest() {
        boolean processedRequest = false;
        do {
            processedRequest = false;
            QVTDebugRequest request = null;
            LinkedList linkedList = this.requestQueue;
            synchronized (linkedList) {
                if (this.suspended) {
                    while (this.requestQueue.isEmpty()) {
                        try {
                            this.requestQueue.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (!this.requestQueue.isEmpty()) {
                    request = (QVTDebugRequest)this.requestQueue.get(0);
                    if (this.requestQueue.size() >= 2) {
                        System.out.print("[" + this.requestQueue.size() + " pending requests!]");
                    }
                    try {
                        request.handleRequest(this);
                    }
                    finally {
                        this.requestQueue.remove(0);
                        this.requestQueue.notifyAll();
                    }
                    processedRequest = true;
                }
            }
            if (!processedRequest || request.getEvent() == null) continue;
            this.triggerEvent(request.getEvent());
        } while (processedRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForNoEvents() {
        LinkedList linkedList = this.eventQueue;
        synchronized (linkedList) {
            try {
                while (!this.eventQueue.isEmpty()) {
                    this.eventQueue.wait();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForProcessedRequest(QVTDebugRequest request) {
        LinkedList linkedList = this.requestQueue;
        synchronized (linkedList) {
            try {
                while (request.getReply() != null) {
                    this.requestQueue.wait();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QVTDebugReply sendRequest(QVTDebugRequest request) throws InterruptedException {
        LinkedList linkedList = this.requestQueue;
        synchronized (linkedList) {
            this.requestQueue.add(0, request);
            this.requestQueue.notifyAll();
            while (request.getReply() == null) {
                this.requestQueue.wait();
            }
            QVTDebugReply result = request.getReply();
            request.setReply(null);
            this.requestQueue.notifyAll();
            return result;
        }
    }

    public void resume(boolean resumeStepOver, boolean resumeStepReturn, boolean resumeStepInto, boolean resumeSilent) {
        this.suspended = false;
        if (!resumeSilent) {
            this.taskToStepOver = null;
            this.taskToStepIntoFrom = null;
            if (resumeStepOver) {
                this.taskToStepOver = this.getSuspendedTask();
            }
            if (resumeStepReturn) {
                this.taskToStepOver = this.getSuspendedTask().getCallerTask();
            }
            if (resumeStepInto) {
                this.taskToStepIntoFrom = this.getSuspendedTask();
                this.taskToStepOver = this.getSuspendedTask();
            }
            if (this.getSuspendedTask() != null) {
                this.lastDebugPosition = this.getSuspendedTask().currentDebugPosition();
            }
        }
    }

    public void suspend() {
        this.suspended = true;
    }

    public QvtSemanticTask getSuspendedTask() {
        return this.processor.getQvtEvaluator().getThreadPool().getCurrentComputedTask();
    }

    public void beforeComputingNextTask() {
        if (this.taskToStepOver != null) {
            this.taskToStepOver.bringToFront();
        }
    }

    public QvtProcessorImpl getQvtProcessor() {
        return this.processor;
    }

    public void setQvtProcessor(QvtProcessorImpl processor) {
        this.processor = processor;
    }

    public void startTransformation() {
        this.suspended = !this.getQvtProcessor().isPropertySet("initiallyResume");
        this.terminated = false;
        this.triggerEvent(new QVTDebugEventStarted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTransformation() {
        this.triggerEvent(new QVTDebugEventTerminated());
        LinkedList linkedList = this.eventQueue;
        synchronized (linkedList) {
            this.terminated = true;
            this.eventQueue.notifyAll();
        }
    }
}

