/*
 * Decompiled with CFR 0.152.
 */
package de.ikv.medini.qvt.execution;

import de.ikv.medini.qvt.QVTDirectedValidation;
import de.ikv.medini.qvt.QVTSuitableKey;
import de.ikv.medini.qvt.QvtEvaluatorVisitorImpl;
import de.ikv.medini.qvt.QvtProcessorImpl;
import de.ikv.medini.qvt.Trace;
import de.ikv.medini.qvt.execution.QvtOptimizedSemanticBindingIterator;
import de.ikv.medini.qvt.execution.QvtSemanticAnalyserThreadPool;
import de.ikv.medini.qvt.execution.debug.QVTDebugPosition;
import de.ikv.medini.qvt.execution.debug.QVTSourcePosition;
import de.ikv.medini.qvt.model.qvtbase.Transformation;
import de.ikv.medini.qvt.model.qvtbase.TypedModel;
import de.ikv.medini.qvt.model.qvtrelation.Key;
import de.ikv.medini.qvt.model.qvtrelation.Relation;
import de.ikv.medini.qvt.model.qvtrelation.RelationDomain;
import de.ikv.medini.qvt.model.qvttemplate.ObjectTemplateExp;
import de.ikv.medini.qvt.model.qvttemplate.PropertyTemplateItem;
import de.ikv.medini.qvt.util.QvtSemanticTaskDebugInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.oslo.ocl20.semantics.SemanticsVisitable;
import org.oslo.ocl20.semantics.bridge.Enumeration;
import org.oslo.ocl20.semantics.bridge.OclModelElementType;
import org.oslo.ocl20.semantics.bridge.Property;
import org.oslo.ocl20.semantics.model.expressions.OclExpression;
import org.oslo.ocl20.semantics.model.expressions.OperationCallExp;
import org.oslo.ocl20.semantics.model.expressions.StringLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.VariableDeclaration;
import org.oslo.ocl20.semantics.model.expressions.VariableExp;
import org.oslo.ocl20.semantics.model.types.BagType;
import org.oslo.ocl20.semantics.model.types.CollectionType;
import org.oslo.ocl20.semantics.model.types.OrderedSetType;
import org.oslo.ocl20.semantics.model.types.SequenceType;
import org.oslo.ocl20.semantics.model.types.SetType;
import org.oslo.ocl20.standard.lib.OclAny;
import org.oslo.ocl20.standard.lib.OclAnyModelElement;
import org.oslo.ocl20.standard.lib.OclBoolean;
import org.oslo.ocl20.standard.lib.OclBooleanImpl;
import org.oslo.ocl20.standard.lib.OclCollection;
import org.oslo.ocl20.standard.lib.OclSet;
import org.oslo.ocl20.standard.lib.OclString;
import org.oslo.ocl20.standard.lib.OclUndefined;
import org.oslo.ocl20.synthesis.RuntimeEnvironment;

public class QvtSemanticTask
implements Runnable {
    private static final boolean useOptimizedBindingIterator = true;
    static boolean requireExecutedTaskToCompleteForWaitingTasks = true;
    private QvtEvaluatorVisitorImpl qvtEvaluatorVisitorImpl;
    private Relation relation;
    private Trace trace;
    private TypedModel targetModel;
    private int hashCode;
    private Iterator qvtSemanticBindingIterator;
    private RuntimeEnvironment currentRuntimeEnvironment;
    private QvtSemanticTask waitingForTask;
    private int instructionPointer = 0;
    private boolean shallBeExecuted = false;
    private boolean executed = false;
    private boolean failed = false;
    private QvtSemanticTaskDebugInfo qvtSemanticTaskDebugInfo = new QvtSemanticTaskDebugInfo();
    private ArrayList waitingTasks = null;
    private RelationDomain initializeRelationDomain;
    private List initialTraceArguments;

    public QvtSemanticTask(Relation relation, List arguments, TypedModel targetModel, QvtEvaluatorVisitorImpl qvtEvaluatorVisitorImpl) {
        this.relation = relation;
        this.qvtEvaluatorVisitorImpl = qvtEvaluatorVisitorImpl;
        this.trace = new Trace(relation, arguments);
        this.targetModel = targetModel;
    }

    public QvtProcessorImpl getQvtProcessor() {
        return this.qvtEvaluatorVisitorImpl.getQvtProcessor();
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed(boolean failed) {
        if (failed && this.executed) {
            throw new RuntimeException("Already executed task cannot be set to be failed");
        }
        if (this.failed != failed) {
            this.failed = failed;
            if (!failed) {
                this.qvtSemanticBindingIterator = null;
            }
            this.qvtEvaluatorVisitorImpl.getThreadPool().checkWaitingTasksForWork(this, !failed);
        }
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public boolean isExecutedForWaitingTasks() {
        return this.isExecuted() && (!requireExecutedTaskToCompleteForWaitingTasks || !this.hasWorkToDo());
    }

    public void setExecuted(boolean executed) {
        if (this.failed && executed) {
            throw new RuntimeException("Already failed task cannot be set to be executed");
        }
        this.executed = executed;
        if (this.areTargetDomainValuesUndefined()) {
            throw new RuntimeException("areTargetDomainValuesUndefined()=true for executed tuple for relation " + this.relation.getName() + "!");
        }
    }

    public boolean isShallBeExecuted() {
        return this.shallBeExecuted;
    }

    public void setShallBeExecuted(boolean shallBeExecuted) {
        this.shallBeExecuted = shallBeExecuted;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null) {
            if (obj instanceof QvtSemanticTask) {
                return this.trace.equals(((QvtSemanticTask)obj).trace);
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.trace.hashCodeInDirection(this.targetModel);
        }
        return this.hashCode;
    }

    public synchronized void executeTask() {
        if (!this.hasWorkToDo()) {
            return;
        }
        this.setWaitingForTask(null);
        if (this.qvtSemanticBindingIterator == null) {
            this.initializeSemanticBindingIterator();
        }
        while (this.currentRuntimeEnvironment != null || this.qvtSemanticBindingIterator.hasNext()) {
            if (this.currentRuntimeEnvironment == null) {
                this.initializeRuntimeEnvironment();
            }
            HashMap<String, TypedModel> data = new HashMap<String, TypedModel>();
            data.put("qvtDirection", this.targetModel);
            Object executionResult = this.executeRelation(this.relation, data);
            if (executionResult instanceof QvtSemanticTask) {
                QvtSemanticTask taskToWaitFor = (QvtSemanticTask)executionResult;
                this.setWaitingForTask(taskToWaitFor);
                return;
            }
            if (executionResult == OclBooleanImpl.TRUE) {
                if (!this.isExecuted()) {
                    this.setExecuted(true);
                }
                ++this.qvtSemanticTaskDebugInfo.succussfullBindings;
            } else if (executionResult == OclBooleanImpl.FALSE && !this.qvtSemanticBindingIterator.hasNext() && !this.isExecuted()) {
                this.setFailed(true);
                ++this.qvtSemanticTaskDebugInfo.unsuccussfullBindings;
            }
            this.currentRuntimeEnvironment = null;
        }
    }

    private void initializeRuntimeEnvironment() {
        this.currentRuntimeEnvironment = (RuntimeEnvironment)this.qvtSemanticBindingIterator.next();
        this.instructionPointer = 0;
        EList domains = this.relation.getDomain();
        Iterator iter = domains.iterator();
        Iterator iterArgs = (this.getQvtProcessor().isParsingMode() ? this.initialTraceArguments : this.trace.getArguments()).iterator();
        while (iter.hasNext()) {
            this.initializeRelationDomain = (RelationDomain)iter.next();
            Object relationDomainValue = iterArgs.next();
            if (this.getQvtProcessor().getDebugAdapter() != null && Trace.isDefined((OclAny)relationDomainValue)) {
                this.getQvtProcessor().getDebugAdapter().doDebugWork();
            }
            if (!Trace.isDefined((OclAny)relationDomainValue)) continue;
            Object oldValue = this.currentRuntimeEnvironment.getValue(this.initializeRelationDomain.getRootVariable().getName());
            if (Trace.isDefined((OclAny)oldValue) && !relationDomainValue.equals(oldValue)) {
                throw new RuntimeException("Domain variable " + this.initializeRelationDomain.getRootVariable().getName() + " of relation " + this.relation.getName() + " cannot be assigned two different values. Ensure that arguments of relation calls to this relation pass only one value for this variable!");
            }
            this.currentRuntimeEnvironment.setValue(this.initializeRelationDomain.getRootVariable().getName(), relationDomainValue);
        }
        this.initializeRelationDomain = null;
    }

    private void initializeSemanticBindingIterator() {
        if (this.getQvtProcessor().isParsingMode()) {
            this.initialTraceArguments = new ArrayList(this.trace.getArguments());
        }
        Iterator iter = this.relation.getDomain().iterator();
        Iterator iterArgs = this.trace.getArguments().iterator();
        while (iter.hasNext()) {
            RelationDomain relationDomain = (RelationDomain)iter.next();
            Object relationDomainValue = iterArgs.next();
            if (relationDomain.getPattern() == null || this.relation.isIsTopLevel() || !QvtProcessorImpl.respectCheckOnlyFlag() || !relationDomain.isIsCheckable() || relationDomainValue instanceof OclAny && !Trace.isUndefined((OclAny)relationDomainValue)) continue;
            this.setFailed(true);
            this.qvtSemanticBindingIterator = new ArrayList().iterator();
            return;
        }
        HashMap data = new HashMap();
        HashMap rootValues = new HashMap();
        Iterator iter2 = this.relation.getDomain().iterator();
        Iterator iterArgs2 = this.trace.getArguments().iterator();
        while (iter2.hasNext()) {
            RelationDomain relationDomain = (RelationDomain)iter2.next();
            Object relationDomainValue = iterArgs2.next();
            if (relationDomain.getPattern() == null) continue;
            rootValues.put(relationDomain.getPattern().getTemplateExpression(), relationDomainValue);
        }
        List templatesToIterate = this.qvtEvaluatorVisitorImpl.getQvtEvaluatorHelper().collectAllNestedObjectTemplatesOfRelationExcludingTargetDomain(this.relation, this.targetModel, data);
        this.qvtSemanticBindingIterator = new QvtOptimizedSemanticBindingIterator(templatesToIterate, this.qvtEvaluatorVisitorImpl.getQvtProcessor(), rootValues);
        if (!this.qvtSemanticBindingIterator.hasNext()) {
            if (this.qvtSemanticTaskDebugInfo.failedClause == null) {
                this.qvtSemanticTaskDebugInfo.failedClause = this.relation;
            }
            this.setFailed(true);
        }
    }

    public boolean hasWorkToDo() {
        if (!this.isShallBeExecuted()) {
            return false;
        }
        if (this.qvtSemanticBindingIterator == null) {
            return true;
        }
        if (this.getWaitingForTask() != null) {
            if (this.getWaitingForTask().isExecutedForWaitingTasks()) {
                return true;
            }
            return this.getWaitingForTask().isFailed();
        }
        return this.qvtSemanticBindingIterator.hasNext();
    }

    public boolean isComputing() {
        return this.currentRuntimeEnvironment != null;
    }

    private Object executeRelation(Relation host, Object data) {
        boolean processedAllWhereClauses;
        boolean processedAllWhenClauses;
        this.qvtSemanticTaskDebugInfo.failedClause = null;
        ((Map)data).put("env", this.currentRuntimeEnvironment);
        ((Map)data).put("localExecutionMode", "when");
        boolean result = true;
        SemanticsVisitable[] orderedWhenClausesArray = this.getOrderedWhenClauseArrayForRelation(this.relation);
        boolean processedAllWhenClausesBefore = this.instructionPointer >= orderedWhenClausesArray.length;
        Object answerWhen = this.evaluateWhenClause((Map)data, orderedWhenClausesArray);
        if (answerWhen != null) {
            return answerWhen;
        }
        boolean bl = processedAllWhenClauses = this.instructionPointer >= orderedWhenClausesArray.length;
        if (processedAllWhenClauses && !processedAllWhenClausesBefore || this.instructionPointer == 0 && orderedWhenClausesArray.length == 0) {
            this.createModelElements(host, (Map)data);
        }
        ((Map)data).put("localExecutionMode", "where");
        List orderedWhereClauses = this.getQvtProcessor().getWhereClausesFor(this.relation);
        Object answerWhere = this.evaluateWhereClause((Map)data, orderedWhenClausesArray, orderedWhereClauses, host);
        if (answerWhere != null) {
            return answerWhere;
        }
        boolean bl2 = processedAllWhereClauses = this.instructionPointer >= orderedWhereClauses.size() + orderedWhenClausesArray.length;
        if (processedAllWhereClauses) {
            if (!this.tryRepopulate(host)) {
                throw new RuntimeException("Not all domain variables are bound though binding was succussful for relation " + host.getName() + "!");
            }
            this.trace.addBindingFrom(this.currentRuntimeEnvironment, this.qvtEvaluatorVisitorImpl.getQvtEvaluatorHelper(), data);
        }
        return this.getQvtProcessor().getStdLibAdapter().Boolean(result);
    }

    public boolean hasProcessedAllClauses() {
        return this.instructionPointer >= this.getQvtProcessor().getWhenClausesFor(this.relation).size() + this.getQvtProcessor().getWhereClausesFor(this.relation).size();
    }

    public SemanticsVisitable currentClause() {
        if (this.currentWhenClause() != null) {
            return this.currentWhenClause();
        }
        int whereInstructionPointer = this.instructionPointer - this.getQvtProcessor().getWhenClausesFor(this.relation).size();
        if (whereInstructionPointer < this.getQvtProcessor().getWhereClausesFor(this.relation).size()) {
            return (SemanticsVisitable)this.getQvtProcessor().getWhereClausesFor(this.relation).get(whereInstructionPointer);
        }
        return null;
    }

    public SemanticsVisitable currentWhenClause() {
        if (this.initializeRelationDomain != null) {
            return this.initializeRelationDomain;
        }
        if (this.instructionPointer < this.getQvtProcessor().getWhenClausesFor(this.relation).size()) {
            return (SemanticsVisitable)this.getQvtProcessor().getWhenClausesFor(this.relation).get(this.instructionPointer);
        }
        return null;
    }

    private SemanticsVisitable[] getOrderedWhenClauseArrayForRelation(Relation relation) {
        List orderedWhenClauses = this.getQvtProcessor().getWhenClausesFor(relation);
        return orderedWhenClauses.toArray(new SemanticsVisitable[orderedWhenClauses.size()]);
    }

    private Object evaluateWhereClause(Map data, SemanticsVisitable[] orderedWhenClausesArray, List orderedWhereClauses, Relation host) {
        SemanticsVisitable[] orderedWhereClausesArray = orderedWhereClauses.toArray(new SemanticsVisitable[orderedWhereClauses.size()]);
        while (this.instructionPointer < orderedWhereClausesArray.length + orderedWhenClausesArray.length) {
            Object answer;
            SemanticsVisitable semanticsVisitable = orderedWhereClausesArray[this.instructionPointer - orderedWhenClausesArray.length];
            if (this.getQvtProcessor().getDebugAdapter() != null) {
                this.getQvtProcessor().getDebugAdapter().doDebugWork();
            }
            if (semanticsVisitable instanceof ObjectTemplateExp) {
                ObjectTemplateExp template = (ObjectTemplateExp)semanticsVisitable;
                answer = this.createOrBindObjectTemplate(template, host, data);
                if (answer != null) {
                    return answer;
                }
            } else if (semanticsVisitable instanceof PropertyTemplateItem) {
                PropertyTemplateItem propertyTemplateItem = (PropertyTemplateItem)semanticsVisitable;
                answer = this.evaluateTargetDomainPropertyTemplate(propertyTemplateItem, data);
                if (answer != null) {
                    return answer;
                }
            } else if (semanticsVisitable instanceof OclExpression) {
                OclExpression oclExpression = (OclExpression)semanticsVisitable;
                answer = this.evaluateWhereClauseOclExpression(oclExpression, data);
                if (answer != null) {
                    return answer;
                }
            } else {
                throw new RuntimeException("unknown resolvable");
            }
            ++this.instructionPointer;
        }
        return null;
    }

    private Object evaluateWhenClause(Map data, SemanticsVisitable[] orderedWhenClausesArray) {
        while (this.instructionPointer < orderedWhenClausesArray.length) {
            Object answer;
            SemanticsVisitable semanticsVisitable = orderedWhenClausesArray[this.instructionPointer];
            if (this.getQvtProcessor().getDebugAdapter() != null) {
                this.getQvtProcessor().getDebugAdapter().doDebugWork();
            }
            if (semanticsVisitable instanceof PropertyTemplateItem) {
                PropertyTemplateItem propertyTemplateItem = (PropertyTemplateItem)semanticsVisitable;
                answer = this.evaluateSourceDomainPropertyTemplate(propertyTemplateItem, data);
                if (this.getQvtProcessor().getStdLibAdapter().Boolean(false).equals(answer)) {
                    return answer;
                }
            } else if (semanticsVisitable instanceof OclExpression) {
                OclExpression oclExpression = (OclExpression)semanticsVisitable;
                answer = this.evaluateWhenClauseOclExpression(oclExpression, data);
                if (answer != null) {
                    return answer;
                }
            } else {
                throw new RuntimeException("Not supported yet!");
            }
            ++this.instructionPointer;
        }
        return null;
    }

    private Object evaluateWhereClauseOclExpression(OclExpression oclExpression, Map data) {
        VariableExp sourceVariableExp;
        VariableDeclaration sourceVariableDeclaration;
        OperationCallExp operationCallExp;
        boolean hadBeenVarAssignment = false;
        if (oclExpression instanceof OperationCallExp && (operationCallExp = (OperationCallExp)oclExpression).getReferredOperation().getName().equals("=") && operationCallExp.getSource() instanceof VariableExp && Trace.isUndefined((OclAny)this.currentRuntimeEnvironment.getValue((sourceVariableDeclaration = (sourceVariableExp = (VariableExp)operationCallExp.getSource()).getReferredVariable()).getName()))) {
            hadBeenVarAssignment = true;
            OclAny varValue = (OclAny)((OclExpression)operationCallExp.getArguments().get(0)).accept(this.qvtEvaluatorVisitorImpl, data);
            this.currentRuntimeEnvironment.setValue(sourceVariableDeclaration.getName(), varValue);
        }
        if (hadBeenVarAssignment) {
            return null;
        }
        this.currentRuntimeEnvironment.setValue("SemTask", null);
        Object currentResult = oclExpression.accept(this.qvtEvaluatorVisitorImpl, data);
        QvtSemanticTask taskToWaitFor = (QvtSemanticTask)this.currentRuntimeEnvironment.getValue("SemTask");
        this.currentRuntimeEnvironment.setValue("SemTask", null);
        if (!(currentResult instanceof OclAny)) {
            throw new RuntimeException("Unexpected Object " + currentResult);
        }
        OclAny oclExpressionResult = (OclAny)currentResult;
        if (oclExpressionResult instanceof OclUndefined) {
            if (taskToWaitFor != null) {
                return taskToWaitFor;
            }
            throw new RuntimeException("The OCL expression at " + this.getQvtProcessor().getAnalyser().getMessage("", oclExpression) + " evaluated to an undefined value! Rewrite this OCL expression to only return True or False!");
        }
        if (oclExpressionResult instanceof OclBoolean) {
            if (OclBooleanImpl.FALSE.equals(oclExpressionResult)) {
                this.qvtSemanticTaskDebugInfo.failedClause = oclExpression;
                if (this.getQvtProcessor().requireAssertWhereClause(oclExpression)) {
                    throw new RuntimeException("The OCL expression at " + this.getQvtProcessor().getAnalyser().getMessage("", oclExpression) + " evaluated to false! This is not allowed for where-clauses! Rewrite this OCL expression to only return True!" + (this.getQvtProcessor().isBindingClause(oclExpression) ? " Note that since this clause binds variables, it is required to evaluate to true." : ""));
                }
                return null;
            }
        } else {
            throw new RuntimeException("Unexpected Object " + oclExpressionResult);
        }
        return null;
    }

    private Object evaluateTargetDomainPropertyTemplate(PropertyTemplateItem propertyTemplateItem, Map data) {
        OclExpression valueExp = propertyTemplateItem.getValue();
        VariableDeclaration targetVariable = propertyTemplateItem.getObjContainer().getBindsTo();
        Object targetValue = this.currentRuntimeEnvironment.getValue(targetVariable.getName());
        Property prop = propertyTemplateItem.getReferredProperty();
        OclAny oclValue = (OclAny)valueExp.accept(this.qvtEvaluatorVisitorImpl, data);
        if (this.overwriteTargetValue((OclAnyModelElement)targetValue)) {
            boolean matched;
            Object oldValue = this.getQvtProcessor().getModelEvaluationAdapter().getValueForFeauture(((OclAnyModelElement)targetValue).asJavaObject(), prop);
            if (oldValue instanceof Collection && !(oclValue.asJavaObject() instanceof Collection)) {
                matched = ((Collection)oldValue).contains(oclValue.asJavaObject());
            } else {
                boolean bl = matched = oldValue == oclValue.asJavaObject() || oldValue != null && oldValue.equals(oclValue.asJavaObject());
            }
            if (!matched) {
                if (this.getQvtProcessor().isParsingMode()) {
                    return OclBooleanImpl.FALSE;
                }
                this.getQvtProcessor().getQvtModelManipulationAdaper().setOrAddValueForFeauture((OclAnyModelElement)targetValue, prop, oclValue);
                if (this.getQvtProcessor().logTasks()) {
                    QvtSemanticAnalyserThreadPool.getLogger().print("(Set feature " + prop.getName() + ")");
                }
                ++QvtSemanticTaskDebugInfo.setOrAddValueForFeautureCount;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createModelElements(Relation host, Map data) {
        Object object = this.qvtEvaluatorVisitorImpl.getTraces();
        synchronized (object) {
            if (!this.getQvtProcessor().isRandomMode() && !this.getQvtProcessor().isParsingMode()) {
                Trace.bindVariablesByTrace(this.qvtEvaluatorVisitorImpl.getOldTraces(), host, this.currentRuntimeEnvironment, this.targetModel, this.qvtEvaluatorVisitorImpl.getQvtEvaluatorHelper(), this.getQvtProcessor(), data);
            }
        }
    }

    private boolean tryRepopulate(Relation host) {
        ArrayList<Object> argValues = new ArrayList<Object>();
        for (RelationDomain currentRelationDomain : host.getDomain()) {
            VariableDeclaration currentVar = currentRelationDomain.getRootVariable();
            OclAny varValue = (OclAny)this.currentRuntimeEnvironment.getValue(currentVar.getName());
            if (Trace.isUndefined(varValue)) {
                return false;
            }
            argValues.add(this.currentRuntimeEnvironment.getValue(currentRelationDomain.getRootVariable().getName()));
        }
        this.trace.repopulateArguments(argValues);
        this.qvtEvaluatorVisitorImpl.addTrace(this.trace);
        return true;
    }

    private Object createOrBindObjectTemplate(ObjectTemplateExp template, Relation host, Map data) {
        OclAny varValueBykey;
        VariableDeclaration currentTargetVar = template.getBindsTo();
        OclAny varValue = (OclAny)this.currentRuntimeEnvironment.getValue(currentTargetVar.getName());
        if (Trace.isUndefined(varValue)) {
            varValue = this.findByKey(template, data, false);
            if (Trace.isUndefined(varValue)) {
                if (this.getQvtProcessor().isParsingMode()) {
                    return OclBooleanImpl.FALSE;
                }
                varValue = this.getQvtProcessor().getQvtModelManipulationAdaper().createOclAnyModelElement((OclModelElementType)currentTargetVar.getType(), this.targetModel);
                if (this.getQvtProcessor().logTasks()) {
                    QvtSemanticAnalyserThreadPool.getLogger().print("(Created instance of class " + currentTargetVar.getType().getName() + ")");
                }
                ++QvtSemanticTaskDebugInfo.createOclAnyModelElementCount;
                this.getQvtProcessor().isPropertySet("inPlaceInOneTransformation");
            }
            this.currentRuntimeEnvironment.setValue(currentTargetVar.getName(), varValue);
            this.tryRepopulate(host);
        } else if (this.getQvtProcessor().logTasks() && Trace.isDefined(varValueBykey = this.findByKey(template, data, true)) && !varValueBykey.equals(varValue)) {
            QvtSemanticAnalyserThreadPool.getLogger().print("(WARNING: Trace-bound value differs from key-bound value for variable " + currentTargetVar.getName() + " of relation " + host.getName() + ")");
        }
        return null;
    }

    private OclAny findByKey(ObjectTemplateExp template, Map data, boolean forLogging) {
        List suitableKeys = QVTDirectedValidation.findSuitableKeys(template, this.getQvtProcessor());
        for (QVTSuitableKey suitableKey : suitableKeys) {
            Collection candidates;
            Key key = suitableKey.getKey();
            if (suitableKey.getUseOppositeProperty()) {
                PropertyTemplateItem propertyTemplateItem = (PropertyTemplateItem)template.eContainer();
                VariableDeclaration parentVar = propertyTemplateItem.getObjContainer().getBindsTo();
                OclAny sourceValue = (OclAny)this.currentRuntimeEnvironment.getValue(parentVar.getName());
                candidates = QVTDirectedValidation.getValueList(sourceValue, propertyTemplateItem.getReferredProperty(), this.getQvtProcessor());
            } else {
                OclSet currentAllInstances = this.getQvtProcessor().getModelEvaluationAdapter().OclType_allInstances(this.getQvtProcessor().getStdLibAdapter().Type(template.getType()), this.getQvtProcessor().getModelsForDirection(this.relation.getTransformation(), this.targetModel));
                candidates = (Collection)currentAllInstances.getImplementation();
            }
            VariableDeclaration currentTargetVar = template.getBindsTo();
            ArrayList<OclAny> matchedCandidates = new ArrayList<OclAny>();
            Iterator iterator = candidates.iterator();
            while (iterator.hasNext()) {
                OclAny candidate = this.assureOclAny(iterator.next());
                OclAny oldValue = (OclAny)this.currentRuntimeEnvironment.getValue(currentTargetVar.getName());
                this.currentRuntimeEnvironment.setValue(currentTargetVar.getName(), candidate);
                try {
                    if (this.matchCandidate(candidate, key, template, data)) {
                        matchedCandidates.add(candidate);
                    }
                }
                finally {
                    this.currentRuntimeEnvironment.setValue(currentTargetVar.getName(), oldValue);
                }
                if (!this.getQvtProcessor().logTasks() && !matchedCandidates.isEmpty()) break;
            }
            if (matchedCandidates.isEmpty()) continue;
            if (this.getQvtProcessor().logTasks()) {
                QvtSemanticAnalyserThreadPool.getLogger().print("(" + (forLogging ? "Would be able to bind" : "Bound") + " instance of class " + key.getIdentifies().getName() + " for variable " + currentTargetVar.getName() + " by key for type " + key.getIdentifies().getName() + ")");
                if (matchedCandidates.size() >= 2) {
                    QvtSemanticAnalyserThreadPool.getLogger().print("(WARNING: Last key found " + matchedCandidates.size() + " matching instances!)");
                }
            }
            return (OclAny)matchedCandidates.get(0);
        }
        return null;
    }

    private boolean matchCandidate(OclAny candidate, Key key, ObjectTemplateExp template, Map data) {
        for (Property prop : key.getPart()) {
            PropertyTemplateItem propertyTemplateItem = QVTDirectedValidation.getPropertyTemplateItemFor(template, prop);
            if (propertyTemplateItem == null || this.matchPropertyTemplateItem(propertyTemplateItem, candidate, false, data)) continue;
            return false;
        }
        return true;
    }

    private OclAny assureOclAny(Object candidate) {
        if (candidate instanceof OclAny) {
            return (OclAny)candidate;
        }
        return this.getQvtProcessor().getStdLibAdapter().OclAny(candidate);
    }

    private Object evaluateWhenClauseOclExpression(OclExpression oclExpression, Map data) {
        VariableExp sourceVariableExp;
        VariableDeclaration sourceVariableDeclaration;
        OperationCallExp operationCallExp;
        boolean hadBeenVarAssignment = false;
        if (oclExpression instanceof OperationCallExp && (operationCallExp = (OperationCallExp)oclExpression).getReferredOperation().getName().equals("=") && operationCallExp.getSource() instanceof VariableExp && Trace.isUndefined((OclAny)this.currentRuntimeEnvironment.getValue((sourceVariableDeclaration = (sourceVariableExp = (VariableExp)operationCallExp.getSource()).getReferredVariable()).getName()))) {
            hadBeenVarAssignment = true;
            OclAny varValue = (OclAny)((OclExpression)operationCallExp.getArguments().get(0)).accept(this.qvtEvaluatorVisitorImpl, data);
            this.currentRuntimeEnvironment.setValue(sourceVariableDeclaration.getName(), varValue);
        }
        if (hadBeenVarAssignment) {
            return null;
        }
        this.currentRuntimeEnvironment.setValue("SemTask", null);
        Object currentResult = oclExpression.accept(this.qvtEvaluatorVisitorImpl, data);
        QvtSemanticTask taskToWaitFor = (QvtSemanticTask)this.currentRuntimeEnvironment.getValue("SemTask");
        this.currentRuntimeEnvironment.setValue("SemTask", null);
        if (!(currentResult instanceof OclAny)) {
            throw new RuntimeException("Unexpected Object " + currentResult);
        }
        OclAny oclExpressionResult = (OclAny)currentResult;
        if (oclExpressionResult instanceof OclUndefined) {
            if (taskToWaitFor != null) {
                return taskToWaitFor;
            }
            throw new RuntimeException("The OCL expression  at " + this.getQvtProcessor().getAnalyser().getMessage("", oclExpression) + " evaluated to an undefined value! Rewrite this OCL expression to only return True or False!");
        }
        if (oclExpressionResult instanceof OclBoolean) {
            if (OclBooleanImpl.FALSE.equals(oclExpressionResult)) {
                this.qvtSemanticTaskDebugInfo.failedClause = oclExpression;
                return this.getQvtProcessor().getStdLibAdapter().Boolean(false);
            }
        } else {
            throw new RuntimeException("Unexpected Object " + oclExpressionResult);
        }
        return null;
    }

    private Object evaluateSourceDomainPropertyTemplate(PropertyTemplateItem propertyTemplateItem, Map data) {
        VariableDeclaration sourceVariable = propertyTemplateItem.getObjContainer().getBindsTo();
        Object sourceValue = this.currentRuntimeEnvironment.getValue(sourceVariable.getName());
        if (!this.matchPropertyTemplateItem(propertyTemplateItem, sourceValue, true, data)) {
            return this.getQvtProcessor().getStdLibAdapter().Boolean(false);
        }
        return null;
    }

    public static OclAny getPropertyValueOf(Property prop, Object sourceValue, QvtProcessorImpl processor) {
        if (sourceValue instanceof OclAnyModelElement) {
            sourceValue = ((OclAnyModelElement)sourceValue).asJavaObject();
        }
        Object javaValue = processor.getModelEvaluationAdapter().getValueForFeauture(sourceValue, prop);
        OclAny oclValue = null;
        oclValue = prop.getType() instanceof CollectionType ? (prop.getType() instanceof OrderedSetType ? processor.getStdLibAdapter().OrderedSet(((OrderedSetType)prop.getType()).getElementType(), javaValue) : (prop.getType() instanceof SetType ? processor.getStdLibAdapter().Set(((SetType)prop.getType()).getElementType(), javaValue) : (prop.getType() instanceof BagType ? processor.getStdLibAdapter().Bag(((BagType)prop.getType()).getElementType(), javaValue) : (prop.getType() instanceof SequenceType ? processor.getStdLibAdapter().Sequence(((SequenceType)prop.getType()).getElementType(), javaValue) : processor.getStdLibAdapter().Sequence(((CollectionType)prop.getType()).getElementType(), javaValue))))) : (javaValue instanceof Collection ? processor.getStdLibAdapter().Collection((Collection)javaValue) : (prop != null && prop.getType() instanceof Enumeration ? processor.getStdLibAdapter().Enumeration(prop.getType(), javaValue) : processor.getStdLibAdapter().OclAny(javaValue)));
        return oclValue;
    }

    private boolean matchPropertyTemplateItem(PropertyTemplateItem propertyTemplateItem, Object sourceValue, boolean allowBind, Map data) {
        VariableExp variablevalueExp;
        Object varValue;
        Property prop = propertyTemplateItem.getReferredProperty();
        OclAny oclValue = QvtSemanticTask.getPropertyValueOf(prop, sourceValue, this.getQvtProcessor());
        boolean varDef = false;
        OclExpression valueExp = propertyTemplateItem.getValue();
        if (allowBind && valueExp instanceof VariableExp && Trace.isUndefined((OclAny)(varValue = this.currentRuntimeEnvironment.getValue((variablevalueExp = (VariableExp)valueExp).getReferredVariable().getName())))) {
            varDef = true;
            this.currentRuntimeEnvironment.setValue(variablevalueExp.getReferredVariable().getName(), oclValue);
        }
        if (!varDef) {
            OclAny expectedValue = (OclAny)valueExp.accept(this.qvtEvaluatorVisitorImpl, data);
            if (allowBind && expectedValue instanceof OclUndefined && this.canBindConcatVars(oclValue, propertyTemplateItem.getValue()) && !(expectedValue = (OclAny)valueExp.accept(this.qvtEvaluatorVisitorImpl, data)).equals(oclValue)) {
                throw new RuntimeException("Error occured when matching string " + oclValue.toString());
            }
            if (prop.getType() instanceof CollectionType) {
                if (((OclCollection)oclValue).includes(expectedValue) != OclBooleanImpl.TRUE) {
                    this.qvtSemanticTaskDebugInfo.failedClause = propertyTemplateItem;
                    return false;
                }
            } else if (!expectedValue.equals(oclValue)) {
                this.qvtSemanticTaskDebugInfo.failedClause = propertyTemplateItem;
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canBindConcatVars(OclAny oclValue, OclExpression pattern) {
        ArrayList matchParts = new ArrayList();
        if (!(oclValue.asJavaObject() instanceof String) || !QVTDirectedValidation.hasStringMatching(matchParts, pattern, this.getQvtProcessor())) {
            return false;
        }
        String toMatch = (String)oclValue.asJavaObject();
        int fromIndex = 0;
        Iterator iter = matchParts.iterator();
        while (iter.hasNext()) {
            String str;
            Object matchPart = iter.next();
            if (matchPart instanceof VariableDeclaration && Trace.isUndefined((OclAny)this.currentRuntimeEnvironment.getValue(((VariableDeclaration)matchPart).getName()))) {
                int endIndex;
                VariableDeclaration var = (VariableDeclaration)matchPart;
                int beginIndex = fromIndex;
                if (iter.hasNext()) {
                    StringLiteralExp s = (StringLiteralExp)iter.next();
                    String str2 = s.getStringSymbol();
                    if (iter.hasNext()) {
                        endIndex = toMatch.indexOf(str2, fromIndex);
                    } else {
                        endIndex = toMatch.substring(fromIndex).lastIndexOf(str2);
                        if (endIndex != -1) {
                            endIndex += fromIndex;
                        }
                    }
                    if (endIndex == -1) {
                        return false;
                    }
                    fromIndex = endIndex + str2.length();
                } else {
                    fromIndex = endIndex = toMatch.length();
                }
                String javaValue = toMatch.substring(beginIndex, endIndex);
                this.currentRuntimeEnvironment.setValue(var.getName(), this.getQvtProcessor().getStdLibAdapter().OclAny(javaValue));
                continue;
            }
            if (matchPart instanceof VariableDeclaration) {
                Object varValue = this.currentRuntimeEnvironment.getValue(((VariableDeclaration)matchPart).getName());
                if (!(varValue instanceof OclString)) return false;
                str = (String)((OclString)varValue).asJavaObject();
            } else {
                str = ((StringLiteralExp)matchPart).getStringSymbol();
            }
            if (!toMatch.substring(fromIndex).startsWith(str)) {
                return false;
            }
            fromIndex += str.length();
        }
        return fromIndex >= toMatch.length();
    }

    public void run() {
        this.executeTask();
    }

    public QvtSemanticTask getWaitingForTask() {
        return this.waitingForTask;
    }

    public void setWaitingForTask(QvtSemanticTask waitingForTask) {
        if (this.waitingForTask != waitingForTask) {
            if (this.waitingForTask != null) {
                this.waitingForTask.waitingTasks.remove(this);
            }
            this.waitingForTask = waitingForTask;
            if (this.waitingForTask != null) {
                if (this.waitingForTask.waitingTasks == null) {
                    this.waitingForTask.waitingTasks = new ArrayList();
                }
                this.waitingForTask.waitingTasks.add(this);
            }
        }
    }

    public Relation getRelation() {
        return this.relation;
    }

    public Trace getTrace() {
        return this.trace;
    }

    private boolean overwriteTargetValue(OclAnyModelElement target) {
        return true;
    }

    public boolean equalsOnSourceDomains(QvtSemanticTask qvtSemanticTask) {
        return this.trace.equalsOnSourceDomains(qvtSemanticTask.trace, this.targetModel);
    }

    public boolean areTargetDomainValuesUndefined() {
        return this.trace.areDomainValuesUndefinedInDirection(this.targetModel);
    }

    public QvtSemanticTaskDebugInfo getDebugInfo() {
        return this.qvtSemanticTaskDebugInfo;
    }

    public boolean hasWaitingTasks() {
        return this.waitingTasks != null && this.waitingTasks.size() >= 1;
    }

    public Iterator getWaitingTasksIterator() {
        return this.waitingTasks == null ? new ArrayList().iterator() : this.waitingTasks.iterator();
    }

    public List getWaitingTasks() {
        return this.waitingTasks == null ? new ArrayList() : this.waitingTasks;
    }

    public TypedModel getTargetModel() {
        return this.targetModel;
    }

    public OclAny getValueFor(int bindingNumber, String name) {
        if (bindingNumber < this.trace.getBindings().size()) {
            Map binding = (Map)this.trace.getBindings().get(bindingNumber);
            return (OclAny)binding.get(name);
        }
        return (OclAny)this.currentRuntimeEnvironment.getValue(name);
    }

    public void setValueFor(int bindingNumber, String name, OclAny value) {
        if (bindingNumber >= this.trace.getBindings().size()) {
            this.currentRuntimeEnvironment.setValue(name, value);
        }
    }

    public int currentLine() {
        if (this.currentClause() != null) {
            return this.getQvtProcessor().getAnalyser().getBeginLine(this.currentClause());
        }
        return -1;
    }

    public QvtSemanticTask getCallerTask() {
        Iterator it = this.getWaitingTasksIterator();
        if (it.hasNext()) {
            QvtSemanticTask waitingTask = (QvtSemanticTask)it.next();
            return waitingTask;
        }
        return null;
    }

    public void bringToFront() {
        this.qvtEvaluatorVisitorImpl.getThreadPool().bringToFront(this);
    }

    public QVTDebugPosition currentDebugPosition() {
        return new QVTDebugPosition(this, this.getCurrentBindingNumber(), this.currentSourcePosition());
    }

    public QVTSourcePosition currentSourcePosition() {
        return new QVTSourcePosition(this.getQvtProcessor().getTransformationPath(this.getTransformation()), this.currentLine());
    }

    private Transformation getTransformation() {
        return this.relation.getTransformation();
    }

    public int getCurrentBindingNumber() {
        return this.getTrace().getBindings().size();
    }
}

