/*
 * Decompiled with CFR 0.152.
 */
package de.ikv.medini.qvt;

import de.ikv.medini.qvt.QVTEvaluatorHelper;
import de.ikv.medini.qvt.QvtProcessorImpl;
import de.ikv.medini.qvt.execution.QvtSemanticAnalyserThreadPool;
import de.ikv.medini.qvt.model.qvtbase.TypedModel;
import de.ikv.medini.qvt.model.qvtrelation.Relation;
import de.ikv.medini.qvt.model.qvtrelation.RelationDomain;
import de.ikv.medini.qvt.model.qvttemplate.ObjectTemplateExp;
import de.ikv.medini.qvt.model.qvttemplate.PropertyTemplateItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.oslo.ocl20.semantics.bridge.Property;
import org.oslo.ocl20.semantics.model.expressions.VariableDeclaration;
import org.oslo.ocl20.standard.lib.OclAny;
import org.oslo.ocl20.standard.lib.OclAnyModelElement;
import org.oslo.ocl20.standard.lib.OclBooleanImpl;
import org.oslo.ocl20.standard.lib.OclUndefined;
import org.oslo.ocl20.synthesis.RuntimeEnvironment;

public class Trace {
    private static boolean enforcePrimaryKey = false;
    int hashCode = 0;
    Relation relation;
    List arguments;
    List bindings = new ArrayList();
    private long modificationTime = 0L;
    private ArrayList mediniIdentifiersOfBindings;

    public void putMediniIdentifiersOfBindings(String mediniIdentifier) {
        if (this.mediniIdentifiersOfBindings == null) {
            this.mediniIdentifiersOfBindings = new ArrayList();
        }
        this.mediniIdentifiersOfBindings.add(mediniIdentifier);
    }

    public String getMediniIdentifiersOfBinding(Map binding) {
        try {
            return (String)this.mediniIdentifiersOfBindings.get(this.bindings.indexOf(binding));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Trace(Relation relation, List arguments) {
        this.relation = relation;
        this.arguments = new ArrayList(arguments);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Trace) {
            Trace trace = (Trace)object;
            if (!this.relation.getName().equals(trace.relation.getName())) {
                return false;
            }
            Iterator iterToCompareTo = trace.arguments.iterator();
            for (OclAny currentArgument : this.arguments) {
                OclAny currentArgumentToCompareTo = (OclAny)iterToCompareTo.next();
                if (!(Trace.isUndefined(currentArgument) || Trace.isUndefined(currentArgumentToCompareTo) ? !Trace.isUndefined(currentArgument) || !Trace.isUndefined(currentArgumentToCompareTo) : currentArgument.equalTo(currentArgumentToCompareTo) == OclBooleanImpl.FALSE)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isUndefined(OclAny value) {
        return value == null || value instanceof OclUndefined;
    }

    public static boolean isDefined(OclAny value) {
        return !Trace.isUndefined(value);
    }

    public static boolean areAllUndefined(Collection values) {
        for (OclAny element : values) {
            if (Trace.isUndefined(element)) continue;
            return false;
        }
        return true;
    }

    public static Collection removeUndefined(Collection values) {
        ArrayList<OclAny> result = new ArrayList<OclAny>();
        for (OclAny element : values) {
            if (!Trace.isDefined(element)) continue;
            result.add(element);
        }
        return result;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.relation.hashCode();
            for (OclAny currentArg : this.arguments) {
                if (currentArg == null) continue;
                this.hashCode ^= currentArg.hashCode();
            }
            if (this.hashCode == 0) {
                this.hashCode = 1;
            }
        }
        return this.hashCode;
    }

    public boolean equalsInDirection(Trace trace, TypedModel direction) {
        if (this.sourceDomainsArePrimaryKey()) {
            return this.equalsOnSourceDomains(trace, direction);
        }
        return this.equals(trace);
    }

    public boolean equalsOnSourceDomains(Trace trace, TypedModel targetModel) {
        if (trace == null) {
            return false;
        }
        if (!this.relation.getName().equals(trace.relation.getName())) {
            return false;
        }
        Iterator iterToCompareTo = trace.arguments.iterator();
        EList domains = this.relation.getDomain();
        Iterator domainIter = domains.iterator();
        for (OclAny currentArgument : this.arguments) {
            RelationDomain currentRelationDomain = (RelationDomain)domainIter.next();
            OclAny currentArgumentToCompareTo = (OclAny)iterToCompareTo.next();
            if (targetModel.equals(currentRelationDomain.getTypedModel()) || !(Trace.isUndefined(currentArgument) || Trace.isUndefined(currentArgumentToCompareTo) ? !Trace.isUndefined(currentArgument) || !Trace.isUndefined(currentArgumentToCompareTo) : currentArgument.equalTo(currentArgumentToCompareTo) == OclBooleanImpl.FALSE)) continue;
            return false;
        }
        return true;
    }

    public boolean sourceDomainsArePrimaryKey() {
        if (enforcePrimaryKey) {
            return true;
        }
        return this.relation.isIsTopLevel();
    }

    public int hashCodeInDirection(TypedModel direction) {
        int hashCodeInDirection = this.relation.hashCode();
        EList domains = this.relation.getDomain();
        Iterator domainIter = domains.iterator();
        for (OclAny currentArg : this.arguments) {
            RelationDomain currentRelationDomain = (RelationDomain)domainIter.next();
            if (direction.equals(currentRelationDomain.getTypedModel())) continue;
            hashCodeInDirection ^= currentArg.hashCode();
        }
        if (hashCodeInDirection == 0) {
            hashCodeInDirection = 1;
        }
        return hashCodeInDirection;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(this.relation.getName()) + "(");
        buffer.append(this.arguments.toString());
        buffer.append(")");
        return buffer.toString();
    }

    public List getArguments() {
        return this.arguments;
    }

    public List getBindings() {
        return this.bindings;
    }

    public void addBindingFrom(RuntimeEnvironment runtimeEnvironment, QVTEvaluatorHelper qvtEvaluatorHelper, Object data) {
        HashMap<String, Object> binding = new HashMap<String, Object>();
        List templateVariables = QVTEvaluatorHelper.collectAllTemplateVariablesOfRelation(this.relation, data);
        for (VariableDeclaration currentVariableDeclaration : templateVariables) {
            binding.put(currentVariableDeclaration.getName(), runtimeEnvironment.getValue(currentVariableDeclaration.getName()));
        }
        this.getBindings().add(binding);
    }

    public void addBinding(Map binding) {
        this.getBindings().add(binding);
    }

    public static Trace findTrace(Collection traces, Relation relation, List arguments, TypedModel direction) {
        Trace referenceTrace = new Trace(relation, arguments);
        for (Trace currentTrace : traces) {
            if (!referenceTrace.equalsInDirection(currentTrace, direction)) continue;
            return currentTrace;
        }
        for (Trace currentTrace : traces) {
            if (!referenceTrace.equalsOnSourceDomains(currentTrace, direction)) continue;
            return currentTrace;
        }
        return null;
    }

    public static void allocateMediniIdentifiers(Collection sourceTraces, Collection targetTraces, TypedModel direction, boolean overwrite) {
        for (Trace currentTargetTrace : targetTraces) {
            Trace currentSourceTrace;
            if (currentTargetTrace.hasBindingMediniIdentifiers() && !overwrite || (currentSourceTrace = Trace.findTrace(sourceTraces, currentTargetTrace.getRelation(), currentTargetTrace.getArguments(), direction)) == null) continue;
            currentTargetTrace.assignMediniIdentifiersOfBindings(currentSourceTrace);
        }
    }

    private void assignMediniIdentifiersOfBindings(Trace trace) {
        this.mediniIdentifiersOfBindings = trace.mediniIdentifiersOfBindings;
    }

    private boolean hasBindingMediniIdentifiers() {
        return this.mediniIdentifiersOfBindings != null;
    }

    public static Trace bindVariablesByTrace(Collection oldTraces, Relation relation, RuntimeEnvironment env, TypedModel direction, QVTEvaluatorHelper qvtEvaluatorHelper, QvtProcessorImpl qvtProcessorImpl, Object data) {
        ArrayList<OclAny> argValues = new ArrayList<OclAny>();
        EList domains = relation.getDomain();
        for (RelationDomain currentRelationDomain : domains) {
            OclAny value = (OclAny)env.getValue(currentRelationDomain.getRootVariable().getName());
            if (!direction.equals(currentRelationDomain.getTypedModel()) && value == null) {
                throw new RuntimeException("invalid state");
            }
            argValues.add(value);
        }
        Trace currentTrace = Trace.findTrace(oldTraces, relation, argValues, direction);
        if (currentTrace != null) {
            boolean isValidBinding;
            List bindings = currentTrace.getBindings();
            List boudVariables = qvtEvaluatorHelper.collectAllTemplateVariablesOfRelationExcludingTargetDomain(relation, direction, data);
            for (Map currentBinding : bindings) {
                List targetTemplates;
                isValidBinding = true;
                isValidBinding = Trace.checkBindingForVariables(boudVariables, currentBinding, env, false);
                if (!isValidBinding || !(isValidBinding = Trace.checkBindingForVariables(targetTemplates = qvtEvaluatorHelper.collectAllTemplateVariablesOfRelationInDirection(relation, direction, data), currentBinding, env, true))) continue;
                Trace.bindVariablesFromBinding(targetTemplates, currentBinding, env, qvtProcessorImpl);
                return currentTrace;
            }
            if (bindings.iterator().hasNext()) {
                Map currentBinding = (Map)bindings.iterator().next();
                List targetRootVariables = qvtEvaluatorHelper.collectAllDomainRootVariablesOfRelationInDirection(relation, direction);
                isValidBinding = Trace.checkBindingForVariables(targetRootVariables, currentBinding, env, true);
                if (isValidBinding) {
                    Trace.bindVariablesFromBinding(targetRootVariables, currentBinding, env, qvtProcessorImpl);
                    return currentTrace;
                }
            }
        }
        return null;
    }

    private static void bindVariablesFromBinding(List variableDeclarations, Map binding, RuntimeEnvironment env, QvtProcessorImpl qvtProcessorImpl) {
        for (VariableDeclaration currentVariableDeclaration : variableDeclarations) {
            OclAny oldValue = (OclAny)binding.get(currentVariableDeclaration.getName());
            OclAny targetValue = qvtProcessorImpl.getQvtModelManipulationAdaper().findElementInTarget(oldValue);
            if (targetValue == null || targetValue instanceof OclUndefined) continue;
            env.setValue(currentVariableDeclaration.getName(), targetValue);
        }
    }

    private static boolean checkBindingForVariables(List variableDeclarations, Map binding, RuntimeEnvironment env, boolean allowUndefined) {
        for (VariableDeclaration currentVariableDeclaration : variableDeclarations) {
            OclAny val1 = (OclAny)binding.get(currentVariableDeclaration.getName());
            OclAny val2 = (OclAny)env.getValue(currentVariableDeclaration.getName());
            if (!(!Trace.isUndefined(val1) && !Trace.isUndefined(val2) ? val1.equalTo(val2) != OclBooleanImpl.TRUE : !allowUndefined)) continue;
            return false;
        }
        return true;
    }

    public static void cleanupTraces(Collection newTraces, Collection oldTraces, TypedModel direction, QVTEvaluatorHelper qvtEvaluatorHelper, QvtProcessorImpl qvtProcessor, Object data) {
        Trace.enforceDeletion(newTraces, oldTraces, direction, qvtEvaluatorHelper, qvtProcessor, data);
        Trace.resetObsoleteValuesSetByPreviousTransformation(newTraces, oldTraces, direction, qvtProcessor, qvtEvaluatorHelper, data);
    }

    private static void resetObsoleteValuesSetByPreviousTransformation(Collection newTraces, Collection oldTraces, TypedModel direction, QvtProcessorImpl qvtProcessor, QVTEvaluatorHelper qvtEvaluatorHelper, Object data) {
        for (Trace currentOldTrace : oldTraces) {
            Trace currentNewTrace = Trace.findTrace(newTraces, currentOldTrace.getRelation(), currentOldTrace.getArguments(), direction);
            if (currentNewTrace == null) continue;
            Trace.resetObsoleteValuesSetByPreviousTransformation(currentNewTrace, currentOldTrace, direction, qvtProcessor, qvtEvaluatorHelper, data);
        }
    }

    private static void resetObsoleteValuesSetByPreviousTransformation(Trace newTrace, Trace oldTrace, TypedModel direction, QvtProcessorImpl qvtProcessor, QVTEvaluatorHelper qvtEvaluatorHelper, Object data) {
        List targetTemplateVariables = qvtEvaluatorHelper.collectAllTemplateVariablesOfRelationInDirection(oldTrace.getRelation(), direction, data);
        List targetRootVariables = qvtEvaluatorHelper.collectAllDomainRootVariablesOfRelationInDirection(oldTrace.getRelation(), direction);
        for (VariableDeclaration variableDeclaration : targetTemplateVariables) {
            Collection currentNewBindingValues;
            Collection currentOldBindingValues;
            Collection oldValuesNotInNewValues;
            PropertyTemplateItem propertyTemplateItem;
            ObjectTemplateExp targetModelElementObjectTemplate;
            String targetModelElementBindingVariable;
            Collection targetModelElements;
            ObjectTemplateExp currentVariableObjectTemplate;
            String currentVariable = variableDeclaration.getName();
            if (Trace.isRootVariable(targetRootVariables, currentVariable) || (currentVariableObjectTemplate = qvtEvaluatorHelper.getNestedObjectTemplateBindingToVariable(newTrace.getRelation(), direction, data, currentVariable)) == null || (targetModelElements = Trace.findBindingValues(newTrace, targetModelElementBindingVariable = (targetModelElementObjectTemplate = (ObjectTemplateExp)(propertyTemplateItem = (PropertyTemplateItem)currentVariableObjectTemplate.eContainer()).eContainer()).getBindsTo().getName())) == null || targetModelElements.isEmpty() || (oldValuesNotInNewValues = Trace.getOldValuesNotInNewValues(currentOldBindingValues = Trace.removeUndefined(Trace.findBindingValues(oldTrace, currentVariable)), currentNewBindingValues = Trace.removeUndefined(Trace.findBindingValues(newTrace, currentVariable)), qvtProcessor)).isEmpty()) continue;
            Property property = propertyTemplateItem.getReferredProperty();
            qvtProcessor.getQvtModelManipulationAdaper().unsetOrRemoveValuesForFeature((OclAnyModelElement)targetModelElements.iterator().next(), property, oldValuesNotInNewValues);
        }
    }

    private static boolean isRootVariable(List domainRootVariables, String bindingVariable) {
        for (VariableDeclaration currentRootVariable : domainRootVariables) {
            if (!bindingVariable.equals(currentRootVariable.getName())) continue;
            return true;
        }
        return false;
    }

    private static Collection getOldValuesNotInNewValues(Collection oldValues, Collection newValues, QvtProcessorImpl qvtProcessor) {
        ArrayList<OclAny> result = new ArrayList<OclAny>();
        for (Object currentOldValue : oldValues) {
            if (newValues.contains(currentOldValue)) continue;
            if (currentOldValue instanceof OclAnyModelElement) {
                OclAny elementInTarget = qvtProcessor.getQvtModelManipulationAdaper().findElementInTarget((OclAnyModelElement)currentOldValue);
                if (elementInTarget == null) continue;
                result.add(elementInTarget);
                continue;
            }
            result.add((OclAny)currentOldValue);
        }
        return result;
    }

    private static void enforceDeletion(Collection newTraces, Collection oldTraces, TypedModel direction, QVTEvaluatorHelper qvtEvaluatorHelper, QvtProcessorImpl qvtProcessor, Object data) {
        ArrayList allOldVarDecls = qvtProcessor.logTasks() ? new ArrayList() : null;
        Collection allOldElements = Trace.collectAllReferedElementsInDirection(oldTraces, direction, qvtEvaluatorHelper, data, allOldVarDecls);
        Collection allNewElements = Trace.collectAllReferedElementsInDirection(newTraces, direction, qvtEvaluatorHelper, data, null);
        Iterator iterDecls = allOldVarDecls == null ? null : allOldVarDecls.iterator();
        for (OclAny currentOldElement : allOldElements) {
            VariableDeclaration currentOldVarDecl = iterDecls == null ? null : (VariableDeclaration)iterDecls.next();
            OclAny currentOldElementInTargetModel = qvtProcessor.getQvtModelManipulationAdaper().findElementInTarget(currentOldElement);
            if (currentOldElementInTargetModel == null || allNewElements.contains(currentOldElementInTargetModel)) continue;
            qvtProcessor.getQvtModelManipulationAdaper().deleteElementInTarget(currentOldElementInTargetModel);
            if (currentOldVarDecl == null || currentOldElementInTargetModel instanceof OclUndefined || !(currentOldVarDecl.eContainer() instanceof Relation)) continue;
            QvtSemanticAnalyserThreadPool.getLogger().println("Delete " + currentOldElementInTargetModel + " which was bound in an old trace by " + ((Relation)currentOldVarDecl.eContainer()).getName() + "." + currentOldVarDecl.getName());
        }
    }

    public static Collection collectAllReferedElementsInDirection(Collection traces, TypedModel direction, QVTEvaluatorHelper qvtEvaluatorHelper, Object data, Collection variableDeclarations) {
        ArrayList result = new ArrayList();
        for (Trace currentTrace : traces) {
            Relation currentTraceRelation = currentTrace.getRelation();
            List templateVariables = qvtEvaluatorHelper.collectAllTemplateVariablesOfRelationInDirection(currentTraceRelation, direction, data);
            List bindings = currentTrace.getBindings();
            for (Map currentBindings : bindings) {
                for (VariableDeclaration currentTemplateVariableDeclaration : templateVariables) {
                    result.add(currentBindings.get(currentTemplateVariableDeclaration.getName()));
                    if (variableDeclarations == null) continue;
                    variableDeclarations.add(currentTemplateVariableDeclaration);
                }
            }
        }
        return result;
    }

    public static Collection findBindingValues(Trace trace, String bindingVariable) {
        ArrayList result = new ArrayList();
        List bindings = trace.getBindings();
        for (Map currentBindings : bindings) {
            if (!currentBindings.containsKey(bindingVariable)) continue;
            result.add(currentBindings.get(bindingVariable));
        }
        return result;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public void setModificationTime(long modificationTime) {
        this.modificationTime = modificationTime;
    }

    public boolean areDomainValuesUndefinedInDirection(TypedModel direction) {
        EList domains = this.relation.getDomain();
        Iterator domainIter = domains.iterator();
        for (OclAny currentArgument : this.arguments) {
            RelationDomain currentRelationDomain = (RelationDomain)domainIter.next();
            if (!direction.equals(currentRelationDomain.getTypedModel()) || !Trace.isUndefined(currentArgument)) continue;
            return true;
        }
        return false;
    }

    public void repopulateArguments(List argValues) {
        this.getArguments().clear();
        this.getArguments().addAll(argValues);
        this.hashCode = 0;
    }
}

