/*
 * Decompiled with CFR 0.152.
 */
package de.ikv.medini.qvt;

import de.ikv.medini.qvt.QVTDirectedValidation;
import de.ikv.medini.qvt.QvtEvaluatorImpl;
import de.ikv.medini.qvt.QvtModelManipulationAdapter;
import de.ikv.medini.qvt.QvtSemanticAnalyserImpl;
import de.ikv.medini.qvt.QvtSerializingVisitorImpl;
import de.ikv.medini.qvt.QvtTraceAdapter;
import de.ikv.medini.qvt.Trace;
import de.ikv.medini.qvt.execution.Query;
import de.ikv.medini.qvt.execution.QueryImpl;
import de.ikv.medini.qvt.execution.QvtSemanticAnalyserThreadPool;
import de.ikv.medini.qvt.execution.debug.DebugAdapterImpl;
import de.ikv.medini.qvt.execution.debug.IDebugAdapter;
import de.ikv.medini.qvt.execution.debug.QVTExitDebugSessionException;
import de.ikv.medini.qvt.model.qvtbase.Rule;
import de.ikv.medini.qvt.model.qvtbase.Transformation;
import de.ikv.medini.qvt.model.qvtbase.TypedModel;
import de.ikv.medini.qvt.model.qvtrelation.Relation;
import de.ikv.medini.qvt.model.qvtrelation.RelationCallExp;
import de.ikv.medini.qvt.model.qvttemplate.ObjectTemplateExp;
import de.ikv.medini.qvt.model.qvttemplate.PropertyTemplateItem;
import de.ikv.medini.qvt.syntax.parser.QvtParser;
import de.ikv.medini.qvt.syntax.parser.QvtParserImpl;
import de.ikv.medini.qvt.util.QvtSemanticTaskDebugInfo;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.oslo.ocl20.OclProcessorImpl;
import org.oslo.ocl20.semantics.SemanticsVisitable;
import org.oslo.ocl20.semantics.bridge.Environment;
import org.oslo.ocl20.semantics.bridge.Property;
import org.oslo.ocl20.semantics.model.contexts.ContextDeclaration;
import org.oslo.ocl20.semantics.model.expressions.VariableDeclaration;
import org.oslo.ocl20.semantics.model.types.CollectionType;
import org.oslo.ocl20.syntax.ast.qvt.ModelDeclarationAS;
import org.oslo.ocl20.syntax.ast.qvt.TopLevelAS;
import org.oslo.ocl20.syntax.ast.qvt.TransformationAS;
import org.oslo.ocl20.syntax.parser.ErrorManager;
import org.oslo.ocl20.synthesis.RuntimeEnvironment;
import uk.ac.kent.cs.kmf.util.ILog;

public abstract class QvtProcessorImpl
extends OclProcessorImpl {
    private Map transformationToPath;
    private static final boolean requireBindingWhereClausesToBeTrue = true;
    private QvtParser qvtParser;
    private Properties properties = new Properties();
    private int targetModelIndex = -1;
    private boolean debugMode = false;
    private Map relationToOrderedWhenClausesMap;
    private Map relationToOrderedWhereClausesMap;
    private Map callerToCalled;
    private Set allCalledRelations;
    private String direction;
    private QvtTraceAdapter qvtTraceAdapter;
    private HashMap bindingClauses;
    private IDebugAdapter debugAdapter;
    private TypedModel targetTypedModel;
    private List contextDeclarations;
    private boolean randomMode;
    private int randomSize;
    private boolean parsingMode;
    private boolean cleanMode;

    public QvtProcessorImpl(ILog log) {
        super(log);
        this.qvtParser = new QvtParserImpl();
    }

    public TopLevelAS parseQvt(String qvtScript) {
        return this.parseQvt(qvtScript, this.getLog(), false);
    }

    public TopLevelAS parseQvt(String qvtScript, ILog log) {
        return this.parseQvt(qvtScript, log, false);
    }

    public TopLevelAS parseQvt(String qvtScript, ILog log, boolean debug) {
        log.resetErrors();
        TopLevelAS pd = this.getQvtParser().parse(new StringReader(qvtScript), log, debug);
        if (log.hasErrors()) {
            return null;
        }
        return pd;
    }

    public TopLevelAS parseQvt(Reader qvtScriptReader) {
        return this.parseQvt(qvtScriptReader, this.getLog());
    }

    public TopLevelAS parseQvt(Reader qvtScriptReader, ILog log) {
        TopLevelAS pd = this.getQvtParser().parse(qvtScriptReader, log, this.getDebug());
        return pd;
    }

    public QvtParser getQvtParser() {
        return this.qvtParser;
    }

    public List analyseQvt(TopLevelAS topLevelAS) {
        return this.analyseQvt(topLevelAS, this.getLog());
    }

    public List analyseQvt(TopLevelAS topLevelAS, ILog log) {
        Environment env = this.environment();
        return this.analyseQvt(topLevelAS, env, log);
    }

    public List analyseQvt(TopLevelAS topLevelAS, Environment environment, ILog log) {
        if (topLevelAS == null) {
            ErrorManager.reportInfo(log, null, "Cannot perform semantic analysis before syntax errors are resolved");
            return new ArrayList();
        }
        if (environment == null) {
            environment = this.environment();
        }
        this.callerToCalled = new HashMap();
        this.allCalledRelations = new HashSet();
        List contextDecls = this.getAnalyserQvT().analyseQvt(topLevelAS, environment, log, this.getDebug());
        Transformation mainTransformation = null;
        for (Transformation transformation : contextDecls) {
            if (mainTransformation == null) {
                mainTransformation = transformation;
            }
            for (Relation relation : transformation.getRule()) {
                if (relation.isIsTopLevel() || this.allCalledRelations.contains(relation) || !mainTransformation.getRule().contains((Object)relation)) continue;
                ErrorManager.reportWarning(log, this.getAnalyserQvT().getSymbol(relation), "Relation '" + relation.getName() + "' is never called.");
            }
        }
        return contextDecls;
    }

    public QvtSemanticAnalyserImpl getAnalyserQvT() {
        return (QvtSemanticAnalyserImpl)this.getAnalyser();
    }

    public List analyseQvt(String qvtScript) {
        return this.analyseQvt(qvtScript, this.getLog());
    }

    public List analyseQvt(String qvtScript, ILog log) {
        TopLevelAS topLevelAS = this.parseQvt(qvtScript, log);
        return this.analyseQvt(topLevelAS, log);
    }

    public List analyseQvt(Reader qvtScriptReader) {
        return this.analyseQvt(qvtScriptReader, this.getLog());
    }

    public List analyseQvt(Reader qvtScriptReader, ILog log) {
        TopLevelAS topLevelAS = this.parseQvt(qvtScriptReader, log);
        if (this.debugMode) {
            QvtSemanticAnalyserThreadPool.getLogger().println("QVT script Signature:" + QvtProcessorImpl.analyzeQVTInputAndOutputList(topLevelAS));
        }
        return this.analyseQvt(topLevelAS, log);
    }

    public List analyseQvt(String qvtScript, Environment environment, ILog log) {
        TopLevelAS topLevelAS = this.parseQvt(qvtScript, log);
        return this.analyseQvt(topLevelAS, environment, log);
    }

    public List analyseQvt(Reader qvtScriptReader, Environment environment, ILog log) {
        TopLevelAS topLevelAS = this.parseQvt(qvtScriptReader, log);
        return this.analyseQvt(topLevelAS, environment, log);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection evaluateQVT(Reader qvtScriptReader, String transformationName, boolean enforce, String direction, Object[] models, Collection oldTraces, ILog log) {
        this.transformationToPath = new HashMap();
        this.debugMode = Boolean.parseBoolean(this.properties.getProperty("debug", "false"));
        if (this.getDebugAdapter() != null) {
            this.getDebugAdapter().startTransformation();
        }
        try {
            try {
                Transformation transformation;
                Date dateBeforeAnalysis = null;
                if (this.debugMode) {
                    QvtSemanticAnalyserThreadPool.getLogger().println("(Start QVT transformation)");
                    dateBeforeAnalysis = new Date();
                }
                this.setDirection(direction);
                this.contextDeclarations = this.analyseQvt(qvtScriptReader, log);
                if (this.debugMode) {
                    QvtSemanticAnalyserThreadPool.getLogger().println("(QVT parsing and analysing done in " + (new Date().getTime() - dateBeforeAnalysis.getTime()) + " ms )");
                }
                if (this.contextDeclarations == null) throw new RuntimeException("Could not analyse QVT script. Aborting evaluation!");
                if (log.hasErrors()) {
                    throw new RuntimeException("Could not analyse QVT script. Aborting evaluation!");
                }
                Iterator contextDeclarationsIterator = this.contextDeclarations.iterator();
                do {
                    if (!contextDeclarationsIterator.hasNext()) {
                        throw new RuntimeException("No transformation with name '" + transformationName + "' found.");
                    }
                    transformation = (Transformation)contextDeclarationsIterator.next();
                    if (transformationName != null) continue;
                    transformationName = transformation.getName();
                } while (!transformation.getName().equals(transformationName));
                Collection collection = this.evaluate(transformation, this.contextDeclarations, enforce, oldTraces, log, dateBeforeAnalysis);
                return collection;
            }
            finally {
                if (this.getDebugAdapter() != null) {
                    this.getDebugAdapter().stopTransformation();
                }
            }
        }
        catch (QVTExitDebugSessionException qVTExitDebugSessionException) {
            return new ArrayList();
        }
    }

    protected Collection evaluate(Transformation transformation, List contextDeclarations, boolean enforce, Collection oldTraces, ILog log, Date dateBeforeAnalysis) {
        QvtTraceAdapter localQvtTraceAdapter = this.getQvtTraceAdapter();
        if (localQvtTraceAdapter != null) {
            Date dateBeforeEvaluation = null;
            if (this.debugMode) {
                dateBeforeEvaluation = new Date();
            }
            localQvtTraceAdapter.setQvtProcessor(this);
            localQvtTraceAdapter.setTransormation(transformation);
            localQvtTraceAdapter.setAllTransormations(contextDeclarations);
            oldTraces = localQvtTraceAdapter.loadTraces();
            if (this.debugMode) {
                QvtSemanticAnalyserThreadPool.getLogger().println("(QVT loading traces done in " + (new Date().getTime() - dateBeforeEvaluation.getTime()) + " ms )");
            }
        } else {
            oldTraces = new ArrayList();
        }
        this.computeDirectionAndOrderWhenAndWhereClauses(transformation, contextDeclarations, this.direction, log);
        if (log.hasErrors()) {
            throw new RuntimeException("Could not directional analyse QVT script. Aborting evaluation!");
        }
        Collection result = this.evaluateQVT(transformation, enforce, this.targetTypedModel, this.runtimeEnvironment(), oldTraces, log);
        if (this.debugMode) {
            QvtSemanticAnalyserThreadPool.getLogger().println("(QVT evaluateQVT() terminated after " + (new Date().getTime() - dateBeforeAnalysis.getTime()) + " ms )");
        }
        if (localQvtTraceAdapter != null) {
            if (this.debugMode) {
                QvtSemanticAnalyserThreadPool.getLogger().println("Allocate IDs");
            }
            Trace.allocateMediniIdentifiers(oldTraces, result, this.targetTypedModel, false);
            localQvtTraceAdapter.storeTraces(result);
        }
        if (this.debugMode) {
            QvtSemanticAnalyserThreadPool.getLogger().println("(QVT transformation done in " + (new Date().getTime() - dateBeforeAnalysis.getTime()) + " ms )");
            QvtSemanticAnalyserThreadPool.getLogger().println();
        }
        return result;
    }

    protected Collection evaluateQVT(Transformation transformation, boolean enforce, TypedModel targetTypedModel, RuntimeEnvironment environment, Collection oldTraces, ILog log) {
        if (this.isPropertySet("inPlace")) {
            do {
                oldTraces = this.getQvtEvaluator().evaluateQvt(transformation, enforce, targetTypedModel, this.runtimeEnvironment(), oldTraces, log);
            } while (QvtSemanticTaskDebugInfo.createOclAnyModelElementCount >= 1 || QvtSemanticTaskDebugInfo.setOrAddValueForFeautureCount >= 1);
            return oldTraces;
        }
        return this.getQvtEvaluator().evaluateQvt(transformation, enforce, targetTypedModel, this.runtimeEnvironment(), oldTraces, log);
    }

    public int getTotalModificationCount() {
        return QvtSemanticTaskDebugInfo.getTotalModificationCount();
    }

    public void computeDirectionAndOrderWhenAndWhereClauses(Transformation transformation, List allTransformations, String direction, ILog log) {
        EList modelParameter;
        this.parsingMode = this.isPropertySet("parse");
        this.cleanMode = this.isPropertySet("clean") || this.parsingMode;
        this.randomSize = Integer.parseInt(this.getProperty("randomize", "0"));
        this.randomMode = this.randomSize >= 1;
        this.relationToOrderedWhenClausesMap = new HashMap();
        this.relationToOrderedWhereClausesMap = new HashMap();
        this.bindingClauses = new HashMap();
        if (direction == null) {
            new RuntimeException("Internal error: The execution direction cannot be null");
        }
        if ((modelParameter = transformation.getModelParameter()).size() != this.models.size()) {
            new RuntimeException("Error: " + this.models.size() + " models are passed, but the transformation " + transformation.getFullName("::") + " requires " + modelParameter.size() + " models!");
        }
        this.targetTypedModel = this.getTargetTypedModel(transformation, direction);
        if (this.targetTypedModel == null) {
            throw new RuntimeException("Internal error: Direction not found! '" + direction + "' is not a parameter of the transformation '" + transformation.getFullName("::") + "'.");
        }
        for (Transformation currentTransformation : allTransformations) {
            this.orderWhenAndWhereClauses(currentTransformation, this.targetTypedModel, log);
        }
    }

    private void orderWhenAndWhereClauses(Transformation transformation, TypedModel targetTypedModel, ILog log) {
        EList rules = transformation.getRule();
        for (Rule rule : rules) {
            if (!(rule instanceof Relation)) continue;
            Relation relation = (Relation)rule;
            this.orderWhenAndWhereClauses(relation, targetTypedModel, log);
        }
    }

    public void orderWhenAndWhereClauses(Relation relation, TypedModel targetTypedModel, ILog log) {
        ArrayList currentlyResolvedVariables = new ArrayList();
        ArrayList whenClauses = new ArrayList();
        this.setCleanMode(true);
        List orderedWhenClauses = QVTDirectedValidation.computeOrderedWhenClauses(relation, targetTypedModel, currentlyResolvedVariables, new HashMap(), this, log, whenClauses);
        if (!whenClauses.isEmpty()) {
            this.setCleanMode(false);
            currentlyResolvedVariables = new ArrayList();
            whenClauses = new ArrayList();
            orderedWhenClauses = QVTDirectedValidation.computeOrderedWhenClauses(relation, targetTypedModel, currentlyResolvedVariables, new HashMap(), this, log, whenClauses);
        }
        for (SemanticsVisitable clause : whenClauses) {
            String unresolvedVar = QVTDirectedValidation.getUnresolvedVar(clause, currentlyResolvedVariables, new HashMap(), this);
            ErrorManager.reportError(log, this.getAnalyser().getSymbol(clause), "when clause of relation '" + relation.getName() + "' could not be resolved" + unresolvedVar + "!");
        }
        this.relationToOrderedWhenClausesMap.put(relation, orderedWhenClauses);
        List orderedWhereClauses = QVTDirectedValidation.computeOrderedWhereClauses(relation, targetTypedModel, currentlyResolvedVariables, new HashMap(), this, log);
        this.relationToOrderedWhereClausesMap.put(relation, orderedWhereClauses);
    }

    private TypedModel getTargetTypedModel(Transformation transformation, String direction) {
        EList modelParameter = transformation.getModelParameter();
        int localTargetModelIndex = 0;
        for (TypedModel currentTypedModel : modelParameter) {
            if (direction.equals(currentTypedModel.getName())) {
                this.setTargetModelIndex(localTargetModelIndex);
                return currentTypedModel;
            }
            ++localTargetModelIndex;
        }
        this.setTargetModelIndex(-1);
        return null;
    }

    public Collection getModelsForDirection(Transformation transformation, TypedModel direction) {
        EList modelParameter = transformation.getModelParameter();
        int localTargetModelIndex = 0;
        for (TypedModel currentTypedModel : modelParameter) {
            if (direction.equals(currentTypedModel)) {
                return (Collection)this.models.get(localTargetModelIndex);
            }
            ++localTargetModelIndex;
        }
        return null;
    }

    public QvtTraceAdapter getQvtTraceAdapter() {
        block11: {
            if (this.qvtTraceAdapter != null) {
                return this.qvtTraceAdapter;
            }
            if (this.isPropertySet("traces")) {
                return null;
            }
            if (this.getProperty("traceAdapter") != null) break block11;
            return null;
        }
        try {
            Class<?> traceAdapterClass = Class.forName(this.getProperty("traceAdapter"));
            this.qvtTraceAdapter = (QvtTraceAdapter)traceAdapterClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.qvtTraceAdapter.setQvtProcessor(this);
            return this.qvtTraceAdapter;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (SecurityException securityException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return null;
    }

    protected void setQvtTraceAdapater(QvtTraceAdapter qvtTraceAdapter) {
        this.qvtTraceAdapter = qvtTraceAdapter;
    }

    public QvtEvaluatorImpl getQvtEvaluator() {
        return (QvtEvaluatorImpl)this.getEvaluator();
    }

    public abstract QvtModelManipulationAdapter getQvtModelManipulationAdaper();

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public void resetProperty(String name) {
        this.properties.remove(name);
    }

    public String getProperty(String name) {
        return (String)this.properties.get(name);
    }

    public String getProperty(String name, String defaultValue) {
        return this.properties.getProperty(name, defaultValue);
    }

    public boolean isPropertySet(String name) {
        return Boolean.parseBoolean(this.properties.getProperty(name, "false"));
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Object getTargetModel() throws RuntimeException {
        if (this.getTargetModelIndex() <= -1) {
            throw new RuntimeException("getTargetModel() was called without a target model being set!");
        }
        return ((Collection)this.models.get(this.getTargetModelIndex())).iterator().next();
    }

    public void setTargetModelIndex(int targetModelIndex) {
        this.targetModelIndex = targetModelIndex;
    }

    private int getTargetModelIndex() {
        return this.targetModelIndex;
    }

    public String getDirection() {
        return this.direction;
    }

    protected final void setDirection(String direction) {
        this.direction = direction;
    }

    public List getWhenClausesFor(Relation relation) {
        return (List)this.relationToOrderedWhenClausesMap.get(relation);
    }

    public List getWhereClausesFor(Relation relation) {
        return (List)this.relationToOrderedWhereClausesMap.get(relation);
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void reportRelationCall(Relation callerRelation, Relation calledRelation) {
        if (this.callerToCalled == null) {
            return;
        }
        HashSet<Relation> calledRelations = (HashSet<Relation>)this.callerToCalled.get(callerRelation);
        if (calledRelations == null) {
            calledRelations = new HashSet<Relation>();
            this.callerToCalled.put(callerRelation, calledRelations);
        }
        calledRelations.add(calledRelation);
        this.allCalledRelations.add(calledRelation);
    }

    public boolean isRelationCalled(Relation relation) {
        return this.allCalledRelations != null && this.allCalledRelations.contains(relation);
    }

    public static Object[] analyzeQVTInputAndOutput(TopLevelAS topLevelAS) {
        return QvtProcessorImpl.recursiveListToArray(QvtProcessorImpl.analyzeQVTInputAndOutputList(topLevelAS));
    }

    private static Object[] recursiveListToArray(List list) {
        Object[] result = list.toArray(new Object[list.size()]);
        int i = 0;
        while (i < result.length) {
            if (result[i] instanceof List) {
                result[i] = QvtProcessorImpl.recursiveListToArray((List)result[i]);
            }
            ++i;
        }
        return result;
    }

    public static List analyzeQVTInputAndOutputList(TopLevelAS topLevelAS) {
        ArrayList transformations = new ArrayList();
        for (TransformationAS transformation : topLevelAS.getTransformations()) {
            ArrayList directions = new ArrayList();
            for (ModelDeclarationAS modelDeclarationAS : transformation.getModelDeclarations()) {
                String direction = modelDeclarationAS.getModelId();
                ArrayList metaModelIDs = new ArrayList();
                Iterator metaModels = modelDeclarationAS.getMetaModelIds().iterator();
                while (metaModels.hasNext()) {
                    metaModelIDs.add(metaModels.next());
                }
                ArrayList<Object> level4 = new ArrayList<Object>();
                level4.add(direction);
                level4.add(metaModelIDs);
                directions.add(level4);
            }
            ArrayList<Object> level2 = new ArrayList<Object>();
            level2.add(transformation.getName());
            level2.add(directions);
            transformations.add(level2);
        }
        return transformations;
    }

    public boolean isBindingClause(SemanticsVisitable clause) {
        return this.bindingClauses.get(clause) != null;
    }

    public List getBoundVariablesByClause(SemanticsVisitable clause) {
        List result = (List)this.bindingClauses.get(clause);
        if (result != null) {
            return result;
        }
        return new ArrayList();
    }

    public void markAsBindingClause(SemanticsVisitable clause, List varDecls) {
        this.bindingClauses.put(clause, varDecls);
    }

    public void markAsBindingClause(SemanticsVisitable clause, VariableDeclaration varDecl) {
        ArrayList<VariableDeclaration> varDecls = new ArrayList<VariableDeclaration>();
        varDecls.add(varDecl);
        this.bindingClauses.put(clause, varDecls);
    }

    public boolean logTasks() {
        return this.isDebugMode() && this.isPropertySet("debugTasks");
    }

    public boolean requireAssertWhereClause(SemanticsVisitable clause) {
        return this.isBindingClause(clause) || !(clause instanceof RelationCallExp);
    }

    public synchronized IDebugAdapter getDebugAdapter() {
        if (this.isPropertySet("eclipseDebug")) {
            if (this.debugAdapter == null) {
                try {
                    Class<?> debugAdapterClass = Class.forName(this.getProperty("debugAdapter", DebugAdapterImpl.class.getName()));
                    this.debugAdapter = (IDebugAdapter)debugAdapterClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                this.debugAdapter.setQvtProcessor(this);
                if (this.getProperty("transformationPath") == null) {
                    throw new RuntimeException("The QVT engine property 'transformationPath' must be set when using the QVT debugger!");
                }
            }
            return this.debugAdapter;
        }
        return null;
    }

    public String getPseudoCodeForWhereClause(SemanticsVisitable whereClause) {
        String s = "";
        List varDecls = this.getBoundVariablesByClause(whereClause);
        if (whereClause instanceof ObjectTemplateExp) {
            Relation relation;
            ObjectTemplateExp template = (ObjectTemplateExp)whereClause;
            VariableDeclaration var = template.getBindsTo();
            String bindBy = "TRACE";
            if (!QVTDirectedValidation.findSuitableKeys(template, this).isEmpty()) {
                bindBy = String.valueOf(bindBy) + " OR KEY";
            }
            if ((relation = QVTDirectedValidation.getRelationOf(template)) != null && !relation.isIsTopLevel() && !(template.eContainer() instanceof PropertyTemplateItem)) {
                bindBy = "TUPLE OR " + bindBy;
            }
            s = String.valueOf(s) + var.getName() + " := BIND BY " + bindBy + " OR CREATE " + var.getType().getName();
        } else if (whereClause instanceof PropertyTemplateItem) {
            PropertyTemplateItem propTemplate = (PropertyTemplateItem)whereClause;
            Property prop = propTemplate.getReferredProperty();
            String LHS = String.valueOf(propTemplate.getObjContainer().getBindsTo().getName()) + "." + prop.getName();
            if (!varDecls.isEmpty()) {
                s = String.valueOf(s) + LHS + " := " + QvtSerializingVisitorImpl.getStringRepresentation(propTemplate.getValue(), varDecls);
            } else if (propTemplate.getValue() instanceof ObjectTemplateExp) {
                ObjectTemplateExp valueTemplate = (ObjectTemplateExp)propTemplate.getValue();
                s = prop.getType() instanceof CollectionType ? String.valueOf(s) + LHS + " += " + valueTemplate.getBindsTo().getName() : String.valueOf(s) + LHS + " := " + valueTemplate.getBindsTo().getName();
            } else {
                s = String.valueOf(s) + LHS + " := " + QvtSerializingVisitorImpl.getStringRepresentation(propTemplate.getValue(), varDecls);
            }
        } else {
            s = this.requireAssertWhereClause(whereClause) ? String.valueOf(s) + "ASSERT " + QvtSerializingVisitorImpl.getStringRepresentation(whereClause, varDecls) : String.valueOf(s) + QvtSerializingVisitorImpl.getStringRepresentation(whereClause, varDecls);
        }
        return s;
    }

    public String getPseudoCodeForWhenClause(SemanticsVisitable whenClause) {
        String s = "";
        List varDecls = this.getBoundVariablesByClause(whenClause);
        if (whenClause instanceof ObjectTemplateExp) {
            ObjectTemplateExp template = (ObjectTemplateExp)whenClause;
            s = String.valueOf(s) + template.getBindsTo().getName() + " := BIND BY TUPLE";
        } else if (whenClause instanceof PropertyTemplateItem) {
            PropertyTemplateItem propTemplate = (PropertyTemplateItem)whenClause;
            Property prop = propTemplate.getReferredProperty();
            String LHS = String.valueOf(propTemplate.getObjContainer().getBindsTo().getName()) + "." + prop.getName();
            if (!varDecls.isEmpty()) {
                s = String.valueOf(s) + LHS + " = " + QvtSerializingVisitorImpl.getStringRepresentation(propTemplate.getValue(), varDecls);
            } else if (propTemplate.getValue() instanceof ObjectTemplateExp) {
                ObjectTemplateExp valueTemplate = (ObjectTemplateExp)propTemplate.getValue();
                s = prop.getType() instanceof CollectionType ? String.valueOf(s) + valueTemplate.getBindsTo().getName() + " " + '\u2208' + " " + LHS : String.valueOf(s) + LHS + " = " + valueTemplate.getBindsTo().getName();
            } else {
                s = String.valueOf(s) + LHS + " = " + QvtSerializingVisitorImpl.getStringRepresentation(propTemplate.getValue(), varDecls);
            }
        } else {
            s = String.valueOf(s) + QvtSerializingVisitorImpl.getStringRepresentation(whenClause, varDecls);
        }
        return s;
    }

    public String getTransformationPath(Transformation transformation) {
        return (String)this.transformationToPath.get(transformation);
    }

    public void recordTransformationPath(Transformation transformation, String pathOfTransformation) {
        if (this.transformationToPath != null) {
            this.transformationToPath.put(transformation, pathOfTransformation);
        }
    }

    public Object saveSemanticStateInformation() {
        return this.getAnalyserQvT().getAstMap();
    }

    public void restoreSemanticStateInformation(Object stateInfo) {
        this.getAnalyserQvT().setAstMap((Map)stateInfo);
    }

    public TypedModel getTargetTypedModel() {
        return this.targetTypedModel;
    }

    public SemanticsVisitable getClauseAt(int line, Relation relation) {
        if (relation == null) {
            return null;
        }
        ArrayList breakpointableNodes = new ArrayList();
        breakpointableNodes.addAll(this.getWhenClausesFor(relation));
        breakpointableNodes.addAll(this.getWhereClausesFor(relation));
        breakpointableNodes.addAll(QVTDirectedValidation.collectAllDomainsExcludingDirection(relation, this.getTargetTypedModel()));
        for (SemanticsVisitable clause : breakpointableNodes) {
            if (this.getAnalyser().getBeginLine(clause) != line) continue;
            return clause;
        }
        return null;
    }

    public List getContextDeclarations() {
        return this.contextDeclarations;
    }

    public Query createQuery(String body, String contextClass) {
        this.setLineDelta(-1);
        try {
            Environment env = this.environment();
            List result = this.analyse("context " + contextClass + " inv:\n" + body, this.getLog());
            if (result != null && !result.isEmpty() && result.get(0) instanceof ContextDeclaration) {
                QueryImpl queryImpl = new QueryImpl(env, (ContextDeclaration)result.get(0), null, this);
                return queryImpl;
            }
            return null;
        }
        finally {
            this.setLineDelta(0);
        }
    }

    public boolean isRandomMode() {
        return this.randomMode;
    }

    public boolean hasRandomResidual() {
        return this.randomSize > QvtSemanticTaskDebugInfo.createOclAnyModelElementCount;
    }

    public boolean isParsingMode() {
        return this.parsingMode;
    }

    public boolean isCleanMode() {
        return this.cleanMode;
    }

    public void setCleanMode(boolean cleanMode) {
        this.cleanMode = cleanMode;
    }

    public static boolean respectCheckOnlyFlag() {
        return true;
    }
}

