/*
 * Decompiled with CFR 0.152.
 */
package de.ikv.medini.qvt;

import de.ikv.medini.qvt.QVTDirectedValidation;
import de.ikv.medini.qvt.QVTEvaluatorHelper;
import de.ikv.medini.qvt.QvtProcessorImpl;
import de.ikv.medini.qvt.Trace;
import de.ikv.medini.qvt.execution.QvtSemanticAnalyserThreadPool;
import de.ikv.medini.qvt.execution.QvtSemanticTask;
import de.ikv.medini.qvt.model.qvtbase.Domain;
import de.ikv.medini.qvt.model.qvtbase.Function;
import de.ikv.medini.qvt.model.qvtbase.FunctionParameter;
import de.ikv.medini.qvt.model.qvtbase.Pattern;
import de.ikv.medini.qvt.model.qvtbase.Predicate;
import de.ikv.medini.qvt.model.qvtbase.Rule;
import de.ikv.medini.qvt.model.qvtbase.TypedModel;
import de.ikv.medini.qvt.model.qvtrelation.DomainPattern;
import de.ikv.medini.qvt.model.qvtrelation.Key;
import de.ikv.medini.qvt.model.qvtrelation.Relation;
import de.ikv.medini.qvt.model.qvtrelation.RelationCallExp;
import de.ikv.medini.qvt.model.qvtrelation.RelationDomain;
import de.ikv.medini.qvt.model.qvtrelation.RelationImplementation;
import de.ikv.medini.qvt.model.qvtrelation.RelationalTransformation;
import de.ikv.medini.qvt.model.qvttemplate.ObjectTemplateExp;
import de.ikv.medini.qvt.model.qvttemplate.PropertyTemplateItem;
import de.ikv.medini.qvt.qvt.QvtVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.bridge.Property;
import org.oslo.ocl20.semantics.bridge.Tag;
import org.oslo.ocl20.semantics.model.contexts.Constraint;
import org.oslo.ocl20.semantics.model.expressions.OclExpression;
import org.oslo.ocl20.semantics.model.expressions.OperationCallExp;
import org.oslo.ocl20.semantics.model.expressions.VariableDeclaration;
import org.oslo.ocl20.semantics.model.expressions.VariableExp;
import org.oslo.ocl20.standard.lib.OclAny;
import org.oslo.ocl20.standard.lib.OclAnyModelElement;
import org.oslo.ocl20.standard.lib.OclBooleanImpl;
import org.oslo.ocl20.standard.lib.OclIntegerImpl;
import org.oslo.ocl20.standard.lib.OclSet;
import org.oslo.ocl20.standard.lib.OclUndefined;
import org.oslo.ocl20.standard.lib.OclUndefinedImpl;
import org.oslo.ocl20.synthesis.OclEvaluatorVisitorImpl;
import org.oslo.ocl20.synthesis.RuntimeEnvironment;
import org.oslo.ocl20.synthesis.RuntimeEnvironmentImpl;

public class QvtEvaluatorVisitorImpl
extends OclEvaluatorVisitorImpl
implements QvtVisitor {
    private static boolean enableExtendedWhereClauseEvaluation = true;
    private QVTEvaluatorHelper qvtEvaluatorHelper;
    private List relationBindingItemList = new ArrayList();
    private Set traces = new HashSet();
    private List tracesOrdered;
    private Collection oldTraces = new HashSet();
    private QvtSemanticAnalyserThreadPool qvtSemanticAnalyserThreadPool;

    public QvtEvaluatorVisitorImpl(QvtProcessorImpl qvtProcessor) {
        super(qvtProcessor);
        this.qvtEvaluatorHelper = new QVTEvaluatorHelper(this);
    }

    public Object visit(RelationalTransformation host, Object data) {
        this.qvtSemanticAnalyserThreadPool = new QvtSemanticAnalyserThreadPool(this.getQvtProcessor(), 0, host, data);
        TypedModel targetModel = (TypedModel)((Map)data).get("qvtDirection");
        this.traces = new HashSet();
        this.tracesOrdered = new ArrayList();
        this.oldTraces = (Collection)((Map)data).get("oldTracesList");
        EList rules = host.getRule();
        if (!this.getQvtProcessor().isRandomMode()) {
            for (Rule rule : rules) {
                if (!(rule instanceof Relation)) {
                    throw new RuntimeException("Internal error: All rules in a relational transformation must be relations");
                }
                Relation relation = (Relation)rule;
                if (!relation.isIsTopLevel()) continue;
                int count = this.qvtSemanticAnalyserThreadPool.getTaskCount();
                this.executeToplevelRelation((Relation)rule, targetModel, data);
                if (!this.getQvtProcessor().isDebugMode()) continue;
                int count2 = this.qvtSemanticAnalyserThreadPool.getTaskCount();
                QvtSemanticAnalyserThreadPool.getLogger().println("(Relation '" + relation.getName() + "' initially has " + (count2 - count) + " tuple(s) to evaluate)");
            }
        }
        this.qvtSemanticAnalyserThreadPool.complete();
        if (this.getQvtProcessor().isRandomMode()) {
            for (Trace element : this.oldTraces) {
                this.addTrace(element);
            }
        } else if (this.getQvtProcessor().isParsingMode()) {
            this.deleteMatchedElements(this.traces, targetModel, data);
            this.traces.clear();
            this.tracesOrdered.clear();
        } else {
            Trace.cleanupTraces(this.traces, this.oldTraces, targetModel, this.qvtEvaluatorHelper, this.getQvtProcessor(), data);
        }
        return this.tracesOrdered;
    }

    private void deleteMatchedElements(Set traces, TypedModel targetModel, Object data) {
        Relation currentTraceRelation;
        HashMap<Relation, Set> relationToRemovalCandidates = new HashMap<Relation, Set>();
        HashSet<OclAny> elementsToDelete = new HashSet<OclAny>();
        for (Trace currentTrace : traces) {
            currentTraceRelation = currentTrace.getRelation();
            List propertyTemplateItems = QVTDirectedValidation.collectAllPropertyTemplateItemsDependingOnDirection(currentTraceRelation, targetModel, false, data, this.getQvtProcessor());
            for (Map currentBindings : currentTrace.getBindings()) {
                for (PropertyTemplateItem propertyTemplateItem : propertyTemplateItems) {
                    VariableDeclaration refTarget;
                    VariableDeclaration containingVarDecl = propertyTemplateItem.getObjContainer().getBindsTo();
                    OclAnyModelElement sourceElement = (OclAnyModelElement)currentBindings.get(containingVarDecl.getName());
                    if (propertyTemplateItem.getValue() instanceof VariableExp) {
                        refTarget = ((VariableExp)propertyTemplateItem.getValue()).getReferredVariable();
                    } else {
                        if (!(propertyTemplateItem.getValue() instanceof ObjectTemplateExp)) continue;
                        refTarget = ((ObjectTemplateExp)propertyTemplateItem.getValue()).getBindsTo();
                    }
                    OclAny targetElement = (OclAny)currentBindings.get(refTarget.getName());
                    if (targetElement == null) continue;
                    Property prop = propertyTemplateItem.getReferredProperty();
                    if (this.getQvtProcessor().getQvtModelManipulationAdaper().unsetOrRemoveValueForFeauture(sourceElement, prop, targetElement)) {
                        if (!this.getQvtProcessor().logTasks()) continue;
                        QvtSemanticAnalyserThreadPool.getLogger().println("Unset feature " + prop + " which was bound in the current trace of " + currentTraceRelation.getName());
                        continue;
                    }
                    if (!this.getQvtProcessor().logTasks()) continue;
                    OclAny v = QvtSemanticTask.getPropertyValueOf(prop, sourceElement, this.getQvtProcessor());
                    String actualString = Trace.isDefined(v) ? "" + v.asJavaObject() : "undefined";
                    QvtSemanticAnalyserThreadPool.getLogger().println("Failed to unset feature " + prop + " for element " + sourceElement + " which was bound in the current trace of " + currentTraceRelation.getName() + ". Actual value was " + actualString + ". Expected value is " + targetElement);
                }
            }
        }
        for (Trace currentTrace : traces) {
            currentTraceRelation = currentTrace.getRelation();
            Set removalCandidateDecls = (Set)relationToRemovalCandidates.get(currentTraceRelation);
            if (removalCandidateDecls == null) {
                removalCandidateDecls = this.getRemovalCandidateDecls(currentTraceRelation, targetModel, data);
                relationToRemovalCandidates.put(currentTraceRelation, removalCandidateDecls);
            }
            Set removalCandidateElements = this.getElementsForVarDecls(currentTrace, removalCandidateDecls);
            if (this.getQvtProcessor().logTasks()) {
                QvtSemanticAnalyserThreadPool.getLogger().println("Added " + removalCandidateElements.size() + " deletion candidates for relation " + currentTraceRelation.getName());
            }
            for (OclAny element : removalCandidateElements) {
                if (!elementsToDelete.contains(element) && this.getQvtProcessor().getQvtModelManipulationAdaper().areAllReferencesWithin(element, new HashSet())) {
                    elementsToDelete.add(element);
                    if (this.getQvtProcessor().logTasks()) {
                        QvtSemanticAnalyserThreadPool.getLogger().println("Delete " + element + " which was bound in the current trace of " + currentTraceRelation.getName());
                    }
                    this.getQvtProcessor().getQvtModelManipulationAdaper().deleteElementInTarget(element);
                    continue;
                }
                OclAny oclAny = element = element == element ? element : element;
            }
        }
    }

    private Set getElementsForVarDecls(Trace currentTrace, Collection varDecls) {
        HashSet<OclAny> result = new HashSet<OclAny>();
        for (Map currentBindings : currentTrace.getBindings()) {
            for (VariableDeclaration var : varDecls) {
                OclAny val = (OclAny)currentBindings.get(var.getName());
                if (!Trace.isDefined(val)) continue;
                result.add(val);
            }
        }
        return result;
    }

    private Set getRemovalCandidateDecls(Relation relation, TypedModel targetModel, Object data) {
        HashSet<VariableDeclaration> removalCandidateDecls = new HashSet<VariableDeclaration>();
        List templateVariables = QVTDirectedValidation.collectAllObjectTemplatesOfRelationExcludingDirection(relation, targetModel, data);
        for (ObjectTemplateExp template : templateVariables) {
            VariableDeclaration var = template.getBindsTo();
            Domain dom = QVTDirectedValidation.getDomainOf(template);
            if (dom == null || targetModel.equals(dom.getTypedModel()) || this.getDomainCountUsingVarDecl(relation, var) > 1 || !this.varUsagesInSourceDomains(var, targetModel)) continue;
            removalCandidateDecls.add(var);
        }
        return removalCandidateDecls;
    }

    private boolean varUsagesInSourceDomains(VariableDeclaration var, TypedModel targetModel) {
        for (VariableExp varExp : var.getVariableExps()) {
            Domain dom = QVTDirectedValidation.getDomainOf(varExp);
            if (dom == null || !targetModel.equals(dom.getTypedModel())) continue;
            return false;
        }
        return true;
    }

    private int getDomainCountUsingVarDecl(Relation currentTraceRelation, VariableDeclaration bindsTo) {
        int result = 0;
        for (Domain dom : currentTraceRelation.getDomain()) {
            RelationDomain relDomain;
            if (!(dom instanceof RelationDomain) || (relDomain = (RelationDomain)dom).getRootVariable() != bindsTo) continue;
            ++result;
        }
        return result;
    }

    public boolean executeToplevelRelation(Relation relation, TypedModel direction, Object data) {
        return this.executeToplevelRelation(relation, direction, data, 0);
    }

    public boolean executeToplevelRelation(Relation relation, TypedModel direction, Object data, int currentDomain) {
        RuntimeEnvironment orginalEnv = (RuntimeEnvironment)((Map)data).get("env");
        if (currentDomain < relation.getDomain().size()) {
            RuntimeEnvironment env = orginalEnv.newEnvironment();
            ((Map)data).put("env", env);
            RelationDomain currentRelationDomain = (RelationDomain)relation.getDomain().get(currentDomain);
            if (!currentRelationDomain.getTypedModel().equals(direction)) {
                OclSet allInstances = this.processor.getModelEvaluationAdapter().OclType_allInstances(this.processor.getStdLibAdapter().Type(currentRelationDomain.getRootVariable().getType()), this.getQvtProcessor().getModelsForDirection(relation.getTransformation(), currentRelationDomain.getTypedModel()));
                Collection allJavaInstances = (Collection)allInstances.getImplementation();
                if (this.getQvtProcessor().isRandomMode() && !allJavaInstances.isEmpty()) {
                    allJavaInstances = QvtEvaluatorVisitorImpl.getRandomPermutation(allJavaInstances);
                }
                Iterator iter = allJavaInstances.iterator();
                while (iter.hasNext()) {
                    RuntimeEnvironment innerEnv = env.newEnvironment();
                    ((Map)data).put("env", innerEnv);
                    Object currentJavaInstance = iter.next();
                    OclAny currentInstance = this.processor.getStdLibAdapter().OclAny(currentJavaInstance);
                    env.setValue(currentRelationDomain.getRootVariable().getName(), currentInstance);
                    this.executeToplevelRelation(relation, direction, data, currentDomain + 1);
                    if (this.getQvtProcessor().isRandomMode() && this.qvtSemanticAnalyserThreadPool.hasCreatedRandomTask()) break;
                }
                env.setValue(currentRelationDomain.getRootVariable().getName(), null);
                return true;
            }
            return this.executeToplevelRelation(relation, direction, data, currentDomain + 1);
        }
        relation.accept(this, data);
        return true;
    }

    public Object visit(Relation host, Object data) {
        RuntimeEnvironment env = (RuntimeEnvironment)((Map)data).get("env");
        TypedModel targetModel = (TypedModel)((Map)data).get("qvtDirection");
        this.qvtEvaluatorHelper.collectAllTemplateVariablesOfRelationExcludingRootVariableExcludingTargetDomain(host, targetModel, data);
        EList domains = host.getDomain();
        ArrayList<Object> arguments = new ArrayList<Object>(domains.size());
        for (RelationDomain currentRelationDomain : domains) {
            arguments.add(env.getValue(currentRelationDomain.getRootVariable().getName()));
        }
        QvtSemanticTask qvtSemanticTask = new QvtSemanticTask(host, arguments, targetModel, this);
        qvtSemanticTask.setShallBeExecuted(true);
        return this.qvtSemanticAnalyserThreadPool.addTask(qvtSemanticTask, new boolean[1]);
    }

    public QvtProcessorImpl getQvtProcessor() {
        return (QvtProcessorImpl)this.processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visit(RelationCallExp host, Object data) {
        List list = this.relationBindingItemList;
        synchronized (list) {
            boolean isWhere = "where".equals(((Map)data).get("localExecutionMode"));
            TypedModel targetModel = (TypedModel)((Map)data).get("qvtDirection");
            RuntimeEnvironment oldRuntimeEnvironment = (RuntimeEnvironment)((Map)data).get("env");
            EList arguments = host.getArgument();
            ArrayList<OclAny> argValues = new ArrayList<OclAny>();
            Relation relation = host.getReferredRelation();
            EList domains = relation.getDomain();
            Iterator argIter = arguments.iterator();
            Iterator iter = domains.iterator();
            while (iter.hasNext()) {
                OclExpression currentArgExp = (OclExpression)argIter.next();
                OclAny currentValue = (OclAny)currentArgExp.accept(this, data);
                RelationDomain currentRelationDomain = (RelationDomain)iter.next();
                if (!targetModel.equals(currentRelationDomain.getTypedModel()) && currentValue instanceof OclUndefined) {
                    return this.getQvtProcessor().getStdLibAdapter().Boolean(false);
                }
                if (currentValue != null && !(currentValue instanceof OclUndefined) && currentValue.oclType().asJavaObject() == null) {
                    throw new RuntimeException("QvtEvaluationVisitorImpl: cannot retrieve RTTI");
                }
                if (currentValue != null && !(currentValue instanceof OclUndefined) && currentValue.oclType().asJavaObject() != null && !((Classifier)currentValue.oclType().asJavaObject()).conformsTo(currentRelationDomain.getRootVariable().getType()).booleanValue()) {
                    return this.getQvtProcessor().getStdLibAdapter().Boolean(false);
                }
                argValues.add(currentValue);
            }
            boolean[] promotedToBeExecuted = new boolean[1];
            QvtSemanticTask newTask = new QvtSemanticTask(relation, argValues, targetModel, this);
            if (isWhere) {
                newTask.setShallBeExecuted(true);
            }
            QvtSemanticTask qvtSemanticTaskInQueue = this.qvtSemanticAnalyserThreadPool.addTask(newTask, promotedToBeExecuted);
            if (!enableExtendedWhereClauseEvaluation && isWhere) {
                if (qvtSemanticTaskInQueue.isFailed()) {
                    if (qvtSemanticTaskInQueue.getQvtProcessor().logTasks()) {
                        QvtSemanticAnalyserThreadPool.getLogger().print("(reuse already failed task of relation " + qvtSemanticTaskInQueue.getRelation().getName() + ")");
                    }
                    qvtSemanticTaskInQueue.setFailed(false);
                }
                ((Map)data).put("env", oldRuntimeEnvironment);
                return this.getQvtProcessor().getStdLibAdapter().Boolean(this.copyDomainObjectTemplateValues(qvtSemanticTaskInQueue, oldRuntimeEnvironment, host, targetModel, argValues));
            }
            if (qvtSemanticTaskInQueue.isExecutedForWaitingTasks()) {
                ((Map)data).put("env", oldRuntimeEnvironment);
                return this.getQvtProcessor().getStdLibAdapter().Boolean(this.copyDomainObjectTemplateValues(qvtSemanticTaskInQueue, oldRuntimeEnvironment, host, targetModel, argValues));
            }
            if (qvtSemanticTaskInQueue.isFailed()) {
                if (isWhere && promotedToBeExecuted[0]) {
                    if (qvtSemanticTaskInQueue.getQvtProcessor().logTasks()) {
                        QvtSemanticAnalyserThreadPool.getLogger().print("(reuse already failed task of relation " + qvtSemanticTaskInQueue.getRelation().getName() + ")");
                    }
                    qvtSemanticTaskInQueue.setFailed(false);
                    oldRuntimeEnvironment.setValue("SemTask", qvtSemanticTaskInQueue);
                    return OclUndefinedImpl.UNDEFINED;
                }
                ((Map)data).put("env", oldRuntimeEnvironment);
                return this.getQvtProcessor().getStdLibAdapter().Boolean(false);
            }
            oldRuntimeEnvironment.setValue("SemTask", qvtSemanticTaskInQueue);
            return OclUndefinedImpl.UNDEFINED;
        }
    }

    private boolean copyDomainObjectTemplateValues(QvtSemanticTask qvtSemanticTask, RuntimeEnvironment targetRuntimeEnvironment, RelationCallExp relationCallExp, TypedModel targetModel, List argValues) {
        Relation relation = relationCallExp.getReferredRelation();
        EList domains = relation.getDomain();
        Iterator argIter = relationCallExp.getArgument().iterator();
        Iterator argValuesIter = qvtSemanticTask.getTrace().getArguments().iterator();
        Iterator actualParamIter = argValues.iterator();
        int i = 0;
        int targetDomains = 0;
        int targetValuesDiffer = 0;
        for (Domain currentDomain : domains) {
            boolean valuesDiffer;
            OclExpression currentArgExp = (OclExpression)argIter.next();
            OclAny currentArgValue = (OclAny)argValuesIter.next();
            OclAny oldValue = (OclAny)actualParamIter.next();
            String sourceName = currentDomain.getName();
            boolean bl = valuesDiffer = currentArgValue == null || oldValue == null || currentArgValue.equalTo(oldValue) != OclBooleanImpl.TRUE;
            if (targetModel.equals(currentDomain.getTypedModel())) {
                ++targetDomains;
                if (valuesDiffer) {
                    if (Trace.isUndefined(currentArgValue)) {
                        qvtSemanticTask.getTrace().getArguments().set(i, oldValue);
                        valuesDiffer = false;
                    } else if (Trace.isUndefined(oldValue) && currentArgExp instanceof VariableExp) {
                        VariableExp currentVariableExp = (VariableExp)currentArgExp;
                        targetRuntimeEnvironment.setValue(currentVariableExp.getReferredVariable().getName(), currentArgValue);
                        valuesDiffer = false;
                    }
                    if (valuesDiffer) {
                        ++targetValuesDiffer;
                    }
                }
            } else if (valuesDiffer) {
                throw new RuntimeException(this.processor.getAnalyser().getMessage("Double binding for source domain with different values in " + relation.getName() + " '" + sourceName + "' " + currentArgValue + " != " + oldValue + "! ", currentDomain));
            }
            ++i;
        }
        return targetValuesDiffer == 0;
    }

    public Object visit(ObjectTemplateExp host, Object data) {
        RuntimeEnvironment env = (RuntimeEnvironment)((Map)data).get("env");
        Object result = env.getValue(host.getBindsTo().getName());
        Classifier type = host.getBindsTo().getType();
        result = this.wrapJavaObjectAsOclType(type, result);
        return result;
    }

    public Object visit(PropertyTemplateItem host, Object data) {
        throw new RuntimeException();
    }

    public Object visit(OperationCallExp host, Object data) {
        if (host.getReferredOperation() instanceof Function) {
            RuntimeEnvironment oldRuntimeEnvironment = (RuntimeEnvironment)((Map)data).get("env");
            RuntimeEnvironmentImpl newRuntimeEnvironment = new RuntimeEnvironmentImpl();
            EList arguments = host.getArguments();
            ArrayList<Object> argValues = new ArrayList<Object>();
            for (OclExpression currentArgExp : arguments) {
                argValues.add(currentArgExp.accept(this, data));
            }
            Function function = (Function)host.getReferredOperation();
            EList parameters = function.getOwnedParameter();
            Iterator valuesIter = argValues.iterator();
            Iterator iter = parameters.iterator();
            while (iter.hasNext()) {
                if (!valuesIter.hasNext()) {
                    throw new RuntimeException("Illegal state!");
                }
                FunctionParameter currentFunctionParameter = (FunctionParameter)iter.next();
                OclAny currentValue = (OclAny)valuesIter.next();
                if (this.getQvtProcessor().logTasks() && function.getName().startsWith("_debug")) {
                    QvtSemanticAnalyserThreadPool.getLogger().print("[" + currentValue.asJavaObject() + "]");
                }
                newRuntimeEnvironment.setValue(currentFunctionParameter.getName(), currentValue);
            }
            ((Map)data).put("env", newRuntimeEnvironment);
            OclAny result = (OclAny)function.getQueryExpression().accept(this, data);
            if (this.getQvtProcessor().isRandomMode() && QvtEvaluatorVisitorImpl.isRandomStringFunction(host)) {
                result = this.processor.getStdLibAdapter().OclAny(this.getRandomString(this.getIntParam("fromLength", 0, newRuntimeEnvironment), this.getIntParam("toLength", 15, newRuntimeEnvironment), this.getIntParam("fromChar", 65, newRuntimeEnvironment), this.getIntParam("toChar", 90, newRuntimeEnvironment)));
            }
            ((Map)data).put("env", oldRuntimeEnvironment);
            return result;
        }
        return super.visit(host, data);
    }

    public static boolean isRandomStringFunction(OperationCallExp host) {
        return host.getReferredOperation().getName().startsWith("getRandom");
    }

    protected int getIntParam(String paramName, int default_, RuntimeEnvironment runtimeEnvironment) {
        if (runtimeEnvironment.getValue(paramName) instanceof OclIntegerImpl) {
            return ((OclIntegerImpl)runtimeEnvironment.getValue(paramName)).int_impl();
        }
        return default_;
    }

    protected String getRandomString(int fromLength, int toLength, int fromChar, int toChar) {
        long count = QvtEvaluatorVisitorImpl.getRandom(fromLength, toLength);
        String s = "";
        int i = 0;
        while ((long)i < count) {
            s = String.valueOf(s) + this.getRandomChar(fromChar, toChar);
            ++i;
        }
        return s;
    }

    protected char getRandomChar(int fromChar, int toChar) {
        return (char)QvtEvaluatorVisitorImpl.getRandom(fromChar, toChar);
    }

    public static long getRandom(long from, long to) {
        double r = Math.random();
        long ri = Math.round((double)from + r * (double)(to - from));
        return ri;
    }

    public static Object getRandomItemFromList(List list) {
        return list.get((int)QvtEvaluatorVisitorImpl.getRandom(0L, list.size() - 1));
    }

    public static List getRandomPermutation(Collection baseList) {
        ArrayList permutation = new ArrayList(baseList);
        int sourceIndex = 0;
        while (sourceIndex < baseList.size()) {
            int targetIndex = (int)QvtEvaluatorVisitorImpl.getRandom(0L, baseList.size() - 1);
            Object target = permutation.get(targetIndex);
            Object source = permutation.get(sourceIndex);
            permutation.set(sourceIndex, target);
            permutation.set(targetIndex, source);
            ++sourceIndex;
        }
        return permutation;
    }

    public QVTEvaluatorHelper getQvtEvaluatorHelper() {
        return this.qvtEvaluatorHelper;
    }

    public Object getTraces() {
        return this.traces;
    }

    public Collection getOldTraces() {
        return this.oldTraces;
    }

    public void addTrace(Trace trace) {
        if (this.traces.add(trace)) {
            this.tracesOrdered.add(trace);
        }
    }

    public QvtSemanticAnalyserThreadPool getThreadPool() {
        return this.qvtSemanticAnalyserThreadPool;
    }

    public Object visit(RelationDomain host, Object data) {
        throw new RuntimeException("This type of host cannot be evaluated!");
    }

    public Object visit(Constraint host, Object data) {
        throw new RuntimeException("This type of host cannot be evaluated!");
    }

    public Object visit(DomainPattern host, Object data) {
        throw new RuntimeException("This type of host cannot be evaluated!");
    }

    public Object visit(Key host, Object data) {
        throw new RuntimeException("This type of host cannot be evaluated!");
    }

    public Object visit(Predicate host, Object data) {
        throw new RuntimeException("This type of host cannot be evaluated!");
    }

    public Object visit(Pattern host, Object data) {
        throw new RuntimeException("This type of host cannot be evaluated!");
    }

    public Object visit(RelationImplementation host, Object data) {
        throw new RuntimeException("This type of host cannot be evaluated!");
    }

    public Object visit(Tag host, Object data) {
        throw new RuntimeException("This type of host cannot be evaluated!");
    }

    public Object visit(TypedModel host, Object data) {
        throw new RuntimeException("This type of host cannot be evaluated!");
    }

    public Object visit(Function host, Object data) {
        throw new RuntimeException("This type of host cannot be evaluated!");
    }
}

