/*
 * Decompiled with CFR 0.152.
 */
package de.ikv.medini.qvt;

import de.ikv.medini.qvt.QVTSuitableKey;
import de.ikv.medini.qvt.QvtEvaluatorVisitorImpl;
import de.ikv.medini.qvt.QvtProcessorImpl;
import de.ikv.medini.qvt.QvtRelationCallExpressionFinderVisitorImpl;
import de.ikv.medini.qvt.QvtTemplateExpressionFinderVisitorImpl;
import de.ikv.medini.qvt.QvtVariableAccessFinderVisitorImpl;
import de.ikv.medini.qvt.model.qvtbase.Domain;
import de.ikv.medini.qvt.model.qvtbase.Pattern;
import de.ikv.medini.qvt.model.qvtbase.Predicate;
import de.ikv.medini.qvt.model.qvtbase.Transformation;
import de.ikv.medini.qvt.model.qvtbase.TypedModel;
import de.ikv.medini.qvt.model.qvtrelation.DomainPattern;
import de.ikv.medini.qvt.model.qvtrelation.Key;
import de.ikv.medini.qvt.model.qvtrelation.Relation;
import de.ikv.medini.qvt.model.qvtrelation.RelationCallExp;
import de.ikv.medini.qvt.model.qvtrelation.RelationDomain;
import de.ikv.medini.qvt.model.qvtrelation.RelationalTransformation;
import de.ikv.medini.qvt.model.qvttemplate.ColletionTemplateExp;
import de.ikv.medini.qvt.model.qvttemplate.ObjectTemplateExp;
import de.ikv.medini.qvt.model.qvttemplate.PropertyTemplateItem;
import de.ikv.medini.qvt.model.qvttemplate.TemplateExp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.oslo.ocl20.semantics.SemanticsVisitable;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.bridge.Property;
import org.oslo.ocl20.semantics.model.expressions.OclExpression;
import org.oslo.ocl20.semantics.model.expressions.OperationCallExp;
import org.oslo.ocl20.semantics.model.expressions.StringLiteralExp;
import org.oslo.ocl20.semantics.model.expressions.VariableDeclaration;
import org.oslo.ocl20.semantics.model.expressions.VariableExp;
import org.oslo.ocl20.semantics.model.types.CollectionType;
import org.oslo.ocl20.standard.lib.OclAnyModelElement;
import org.oslo.ocl20.syntax.parser.ErrorManager;
import uk.ac.kent.cs.kmf.util.ILog;

public class QVTDirectedValidation {
    public static final boolean enableInverseConcat = true;

    public static List computeOrderedWhenClauses(Relation host, TypedModel targetModel, List currentlyResolvedVariables, Object data, QvtProcessorImpl processor, ILog log, List whenClauses) {
        currentlyResolvedVariables.addAll(QVTDirectedValidation.computeCurrentlyResolvedVariables(host, data, processor, targetModel));
        whenClauses.clear();
        whenClauses.addAll(QVTDirectedValidation.collectAllWhenClauses(host, targetModel, data, processor));
        ArrayList<SemanticsVisitable> orderedWhenClauses = new ArrayList<SemanticsVisitable>();
        boolean goOn = true;
        block0: while (goOn) {
            goOn = false;
            Iterator iter = whenClauses.iterator();
            while (iter.hasNext() && !goOn) {
                boolean[] goOnAndIsAdded;
                SemanticsVisitable semanticsVisitable = (SemanticsVisitable)iter.next();
                List dependsOnVar = QVTDirectedValidation.dependsOn(semanticsVisitable, true, data, processor);
                boolean isAdded = false;
                QVTDirectedValidation.checkBooleanType(semanticsVisitable, log, processor);
                if (QVTDirectedValidation.computeOrderedClauseForRelationCalls(semanticsVisitable, currentlyResolvedVariables, whenClauses, orderedWhenClauses, goOn, isAdded, data, processor, targetModel)) {
                    goOn = true;
                    iter = whenClauses.iterator();
                    continue block0;
                }
                if (semanticsVisitable instanceof OperationCallExp) {
                    OperationCallExp operationCallExp = (OperationCallExp)semanticsVisitable;
                    goOnAndIsAdded = QVTDirectedValidation.computeOrderedWhenClauseForOperationCall(operationCallExp, currentlyResolvedVariables, whenClauses, orderedWhenClauses, goOn, isAdded, data, processor, host, targetModel);
                    goOn = goOnAndIsAdded[0];
                    isAdded = goOnAndIsAdded[1];
                    if (goOn) {
                        iter = whenClauses.iterator();
                    }
                }
                if (!isAdded && semanticsVisitable instanceof PropertyTemplateItem) {
                    PropertyTemplateItem propertyTemplateItem = (PropertyTemplateItem)semanticsVisitable;
                    goOnAndIsAdded = QVTDirectedValidation.computeOrderedWhenClauseForPropertyTemplate(propertyTemplateItem, currentlyResolvedVariables, whenClauses, orderedWhenClauses, goOn, isAdded, processor, log);
                    goOn = goOnAndIsAdded[0];
                    isAdded = goOnAndIsAdded[1];
                    if (goOn) {
                        iter = whenClauses.iterator();
                    }
                }
                if (!isAdded && QVTDirectedValidation.handleEnableInverseConcat(currentlyResolvedVariables, semanticsVisitable, whenClauses, orderedWhenClauses, processor, true)) {
                    goOn = true;
                    iter = whenClauses.iterator();
                    continue block0;
                }
                if (!currentlyResolvedVariables.containsAll(dependsOnVar) || isAdded) continue;
                orderedWhenClauses.add(semanticsVisitable);
                whenClauses.remove(semanticsVisitable);
                iter = whenClauses.iterator();
                goOn = true;
                isAdded = true;
            }
        }
        if (whenClauses.size() > 0) {
            QVTDirectedValidation.handleEnableInverseConcat(currentlyResolvedVariables, whenClauses, orderedWhenClauses, processor);
        }
        orderedWhenClauses.addAll(whenClauses);
        return orderedWhenClauses;
    }

    private static void handleEnableInverseConcat(List currentlyResolvedVariables, List whenClauses, List orderedWhenClauses, QvtProcessorImpl processor) {
        Iterator iter = whenClauses.iterator();
        while (iter.hasNext()) {
            SemanticsVisitable semanticsVisitable = (SemanticsVisitable)iter.next();
            if (!QVTDirectedValidation.handleEnableInverseConcat(currentlyResolvedVariables, semanticsVisitable, whenClauses, orderedWhenClauses, processor, false)) continue;
            iter = whenClauses.iterator();
        }
    }

    private static boolean handleEnableInverseConcat(List currentlyResolvedVariables, SemanticsVisitable semanticsVisitable, List whenClauses, List orderedWhenClauses, QvtProcessorImpl processor, boolean requireUniqueAssignments) {
        if (!(semanticsVisitable instanceof PropertyTemplateItem)) {
            return false;
        }
        ArrayList matchParts = new ArrayList();
        PropertyTemplateItem propertyTemplateItem = (PropertyTemplateItem)semanticsVisitable;
        OclExpression oclExpression = propertyTemplateItem.getValue();
        if (!QVTDirectedValidation.hasStringMatching(matchParts, oclExpression, processor)) {
            return false;
        }
        if (requireUniqueAssignments) {
            int assignedVars = 0;
            for (Object var : matchParts) {
                if (!(var instanceof VariableDeclaration)) continue;
                ++assignedVars;
            }
            if (assignedVars >= 2) {
                return false;
            }
        }
        for (Object var : matchParts) {
            if (!(var instanceof VariableDeclaration)) continue;
            currentlyResolvedVariables.add(var);
            processor.markAsBindingClause(semanticsVisitable, (VariableDeclaration)var);
        }
        orderedWhenClauses.add(semanticsVisitable);
        whenClauses.remove(semanticsVisitable);
        return true;
    }

    private static boolean[] computeOrderedWhenClauseForPropertyTemplate(PropertyTemplateItem propertyTemplateItem, List currentlyResolvedVariables, List whenClauses, List orderedWhenClauses, boolean goOn, boolean isAdded, QvtProcessorImpl processor, ILog log) {
        VariableExp variableExp;
        boolean[] goOnAndIsAdded = new boolean[]{goOn, isAdded};
        OclExpression oclExpression = propertyTemplateItem.getValue();
        if (processor.isParsingMode() && oclExpression instanceof OperationCallExp && QvtEvaluatorVisitorImpl.isRandomStringFunction((OperationCallExp)oclExpression)) {
            whenClauses.remove(propertyTemplateItem);
            goOnAndIsAdded[0] = true;
            goOnAndIsAdded[1] = true;
            return goOnAndIsAdded;
        }
        if (oclExpression instanceof VariableExp && !currentlyResolvedVariables.contains((variableExp = (VariableExp)oclExpression).getReferredVariable())) {
            Property property = propertyTemplateItem.getReferredProperty();
            Classifier valueType = oclExpression.getType();
            if (property.getType() instanceof CollectionType && !(valueType instanceof CollectionType)) {
                ErrorManager.reportError(log, processor.getAnalyser().getSymbol(oclExpression), "SA: Variable '" + variableExp.getReferredVariable().getName() + "' must be collection-typed when being bound by the collection-typed property '" + property.getName() + "'.");
            }
            orderedWhenClauses.add(propertyTemplateItem);
            whenClauses.remove(propertyTemplateItem);
            currentlyResolvedVariables.add(variableExp.getReferredVariable());
            processor.markAsBindingClause((SemanticsVisitable)propertyTemplateItem, variableExp.getReferredVariable());
            goOnAndIsAdded[0] = true;
            goOnAndIsAdded[1] = true;
        }
        return goOnAndIsAdded;
    }

    private static boolean[] computeOrderedWhenClauseForOperationCall(OperationCallExp operationCallExp, List currentlyResolvedVariables, List whenClauses, List orderedWhenClauses, boolean goOn, boolean isAdded, Object data, QvtProcessorImpl processor, Relation host, TypedModel targetModel) {
        VariableDeclaration referredVariable;
        boolean[] goOnAndIsAdded = new boolean[]{goOn, isAdded};
        if (!"=".equals(operationCallExp.getReferredOperation().getName())) {
            return goOnAndIsAdded;
        }
        OclExpression source = operationCallExp.getSource();
        OclExpression arg = (OclExpression)operationCallExp.getArguments().get(0);
        if (!isAdded && source instanceof VariableExp) {
            if (processor.isParsingMode() && arg instanceof OperationCallExp && QvtEvaluatorVisitorImpl.isRandomStringFunction((OperationCallExp)arg)) {
                whenClauses.remove(operationCallExp);
                goOnAndIsAdded[0] = true;
                goOnAndIsAdded[1] = true;
                return goOnAndIsAdded;
            }
            VariableExp sourceVariableExp = (VariableExp)source;
            referredVariable = sourceVariableExp.getReferredVariable();
            if (!currentlyResolvedVariables.contains(referredVariable) && currentlyResolvedVariables.containsAll(QVTDirectedValidation.dependsOn(arg, true, data, processor))) {
                orderedWhenClauses.add(operationCallExp);
                whenClauses.remove(operationCallExp);
                currentlyResolvedVariables.add(referredVariable);
                processor.markAsBindingClause((SemanticsVisitable)operationCallExp, referredVariable);
                goOnAndIsAdded[0] = true;
                goOnAndIsAdded[1] = true;
            }
        }
        if (!isAdded && arg instanceof VariableExp) {
            VariableExp argVariableExp = (VariableExp)arg;
            referredVariable = argVariableExp.getReferredVariable();
            if (currentlyResolvedVariables.containsAll(QVTDirectedValidation.dependsOn(source, true, data, processor)) && (!currentlyResolvedVariables.contains(referredVariable) || QVTDirectedValidation.collectAllTemplateVariablesInDirection(host, targetModel, data).contains(referredVariable))) {
                orderedWhenClauses.add(operationCallExp);
                whenClauses.remove(operationCallExp);
                currentlyResolvedVariables.add(referredVariable);
                processor.markAsBindingClause((SemanticsVisitable)operationCallExp, referredVariable);
                goOnAndIsAdded[0] = true;
                goOnAndIsAdded[1] = true;
                operationCallExp.setSource(arg);
                operationCallExp.getArguments().clear();
                operationCallExp.getArguments().add((Object)source);
            }
        }
        return goOnAndIsAdded;
    }

    private static void checkBooleanType(SemanticsVisitable semanticsVisitable, ILog log, QvtProcessorImpl processor) {
        OclExpression oclExp;
        if (!(!(semanticsVisitable instanceof OclExpression) || semanticsVisitable instanceof ObjectTemplateExp || (oclExp = (OclExpression)semanticsVisitable).getType() != null && oclExp.getType().conformsTo(processor.getTypeFactory().buildBooleanType()).booleanValue())) {
            ErrorManager.reportError(log, processor.getAnalyser().getSymbol(oclExp), "Expression is of type '" + oclExp.getType() + "', but must be of type 'Boolean'");
        }
    }

    public static boolean hasStringMatching(List matchParts, OclExpression pattern, QvtProcessorImpl processor) {
        OperationCallExp operationCallExp;
        if (pattern instanceof OperationCallExp && (operationCallExp = (OperationCallExp)pattern).getType().conformsTo(processor.getTypeFactory().buildStringType()).booleanValue() && ("+".equals(operationCallExp.getReferredOperation().getName()) || "concat".equals(operationCallExp.getReferredOperation().getName()))) {
            OclExpression source = operationCallExp.getSource();
            OclExpression arg = (OclExpression)operationCallExp.getArguments().get(0);
            return QVTDirectedValidation.hasStringMatching(matchParts, source, processor) && QVTDirectedValidation.hasStringMatching(matchParts, arg, processor);
        }
        if (pattern instanceof VariableExp) {
            matchParts.add(((VariableExp)pattern).getReferredVariable());
            return true;
        }
        if (pattern instanceof StringLiteralExp) {
            matchParts.add(pattern);
            return true;
        }
        return false;
    }

    private static List collectAllWhereClauses(Relation relation, TypedModel direction, Object data, QvtProcessorImpl processor, List currentlyResolvedVariables) {
        ArrayList<ObjectTemplateExp> result = new ArrayList<ObjectTemplateExp>();
        List templates = QVTDirectedValidation.collectAllObjectTemplatesOfRelationInDirection(relation, direction, data);
        for (ObjectTemplateExp template : templates) {
            result.add(0, template);
        }
        result.addAll(QVTDirectedValidation.collectAllPropertyTemplateItemsDependingOnDirection(relation, direction, true, data, processor));
        result.addAll(QVTDirectedValidation.collectClauseExpressions(relation, relation.getWhere()));
        return result;
    }

    public static List collectAllPropertyTemplateItemsDependingOnDirection(Relation relation, TypedModel direction, boolean inDirection, Object data, QvtProcessorImpl processor) {
        ArrayList result = new ArrayList();
        EList domains = relation.getDomain();
        for (RelationDomain currentRelationDomain : domains) {
            if (currentRelationDomain.getTypedModel() == null || (!currentRelationDomain.getTypedModel().equals(direction) || !inDirection) && (currentRelationDomain.getTypedModel().equals(direction) || inDirection)) continue;
            result.addAll(QVTDirectedValidation.collectAllPropertyTemplateItemsOfDomain(currentRelationDomain, data, processor));
        }
        return result;
    }

    private static List computeCurrentlyResolvedVariables(Relation host, Object data, QvtProcessorImpl processor, TypedModel targetModel) {
        if (!processor.isCleanMode()) {
            return QVTDirectedValidation.collectAllTemplateVariables(host, data, processor);
        }
        return QVTDirectedValidation.collectAllTemplateVariablesNotInDirection(host, targetModel, data, processor);
    }

    public static boolean shouldBeInstantiatedInThisRelation(Relation relation, VariableDeclaration currentVariable, Map data, TypedModel targetModel, QvtProcessorImpl processor) {
        Collection allWhereClauseRelationCallsHavingVariableInTarget = QVTDirectedValidation.collectAllRelationCallsInWhereClauseWithVariableInTarget(relation, currentVariable.getName(), targetModel, data);
        Collection relationCalls = QVTDirectedValidation.getRelationCallsWithDomainVariableTypeSubtypeOfVariable(currentVariable, allWhereClauseRelationCallsHavingVariableInTarget, !processor.getQvtModelManipulationAdaper().isAbstract(currentVariable.getType()));
        return relationCalls.isEmpty();
    }

    public static List collectAllTemplateVariables(Relation relation, Object data, QvtProcessorImpl processor) {
        EList domains = relation.getDomain();
        ArrayList result = new ArrayList();
        for (RelationDomain currentRelationDomain : domains) {
            result.addAll(QVTDirectedValidation.collectAllTemplateVariables(currentRelationDomain, data));
        }
        return result;
    }

    public static List collectAllTemplateVariables(RelationDomain relationDomain, Object data) {
        ArrayList<VariableDeclaration> result = new ArrayList<VariableDeclaration>();
        if (relationDomain.getTypedModel() != null) {
            QvtTemplateExpressionFinderVisitorImpl qvtTemplateExpressionFinderVisitor = new QvtTemplateExpressionFinderVisitorImpl();
            relationDomain.getPattern().getTemplateExpression().accept(qvtTemplateExpressionFinderVisitor, data);
            List templateExpressions = qvtTemplateExpressionFinderVisitor.getTemplateExpressions();
            for (TemplateExp currentTemplateExp : templateExpressions) {
                if (currentTemplateExp instanceof ObjectTemplateExp) {
                    ObjectTemplateExp currentObjectTemplateExp = (ObjectTemplateExp)currentTemplateExp;
                    VariableDeclaration bindsTo = currentObjectTemplateExp.getBindsTo();
                    result.add(bindsTo);
                    continue;
                }
                if (currentTemplateExp instanceof ColletionTemplateExp) {
                    throw new RuntimeException("NYI");
                }
                throw new RuntimeException("NYI");
            }
        } else {
            result.add(relationDomain.getRootVariable());
        }
        return result;
    }

    public static List collectAllTemplateVariablesInDirection(Relation relation, TypedModel direction, Object data) {
        EList domains = relation.getDomain();
        ArrayList result = new ArrayList();
        for (RelationDomain currentRelationDomain : domains) {
            if (!direction.equals(currentRelationDomain.getTypedModel())) continue;
            result.addAll(QVTDirectedValidation.collectAllTemplateVariables(currentRelationDomain, data));
        }
        return result;
    }

    public static List collectAllTemplateVariablesNotInDirection(Relation relation, TypedModel direction, Object data, QvtProcessorImpl processor) {
        EList domains = relation.getDomain();
        ArrayList result = new ArrayList();
        for (RelationDomain currentRelationDomain : domains) {
            if (direction.equals(currentRelationDomain.getTypedModel())) continue;
            result.addAll(QVTDirectedValidation.collectAllTemplateVariables(currentRelationDomain, data));
        }
        return result;
    }

    private static List collectAllWhenClauses(Relation relation, TypedModel direction, Object data, QvtProcessorImpl processor) {
        List result = QVTDirectedValidation.collectAllPropertyTemplateItemsDependingOnDirection(relation, direction, false, data, processor);
        result.addAll(QVTDirectedValidation.collectClauseExpressions(relation, relation.getWhen()));
        return result;
    }

    private static Collection collectClauseExpressions(Relation relation, Pattern pattern) {
        ArrayList<OclExpression> result = new ArrayList<OclExpression>();
        if (pattern == null) {
            return result;
        }
        EList predicates = pattern.getPredicate();
        for (Predicate currentPredicate : predicates) {
            OclExpression contitionExpression = currentPredicate.getContitionExpression();
            result.add(contitionExpression);
        }
        return result;
    }

    private static Collection collectAllPropertyTemplateItemsOfDomain(RelationDomain currentRelationDomain, Object data, QvtProcessorImpl processor) {
        ArrayList<PropertyTemplateItem> result = new ArrayList<PropertyTemplateItem>();
        DomainPattern domainPattern = currentRelationDomain.getPattern();
        TemplateExp currentTemplateExpression = domainPattern.getTemplateExpression();
        QvtTemplateExpressionFinderVisitorImpl qvtTemplateExpressionFinderVisitor = new QvtTemplateExpressionFinderVisitorImpl();
        currentTemplateExpression.accept(qvtTemplateExpressionFinderVisitor, data);
        List templateExpressions = qvtTemplateExpressionFinderVisitor.getTemplateExpressions();
        for (TemplateExp currentTemplateExp : templateExpressions) {
            if (currentTemplateExp instanceof ObjectTemplateExp) {
                ObjectTemplateExp currentObjectTemplateExp = (ObjectTemplateExp)currentTemplateExp;
                EList propertyTemplateItems = currentObjectTemplateExp.getPart();
                for (PropertyTemplateItem currentPropertyTemplateItem : propertyTemplateItems) {
                    result.add(currentPropertyTemplateItem);
                }
                continue;
            }
            if (currentTemplateExp instanceof ColletionTemplateExp) {
                throw new RuntimeException("Collection Templates are not yet supported.");
            }
            throw new RuntimeException("Unsupported template type: " + currentTemplateExp.getClass().getName());
        }
        return result;
    }

    public static List computeOrderedWhereClauses(Relation host, TypedModel targetModel, List currentlyResolvedVariables, Object data, QvtProcessorImpl processor, ILog log) {
        currentlyResolvedVariables = new ArrayList<VariableDeclaration>(currentlyResolvedVariables);
        if (!processor.isCleanMode()) {
            currentlyResolvedVariables.removeAll(QVTDirectedValidation.collectAllTemplateVariablesInDirection(host, targetModel, data));
        }
        List whereClauses = QVTDirectedValidation.collectAllWhereClauses(host, targetModel, data, processor, currentlyResolvedVariables);
        ArrayList<SemanticsVisitable> orderedWhereClauses = new ArrayList<SemanticsVisitable>();
        boolean goOn = true;
        block0: while (goOn) {
            goOn = false;
            Iterator iter = whereClauses.iterator();
            while (iter.hasNext() && !goOn) {
                SemanticsVisitable semanticsVisitable = (SemanticsVisitable)iter.next();
                List dependsOnVar = QVTDirectedValidation.dependsOn(semanticsVisitable, false, data, processor);
                boolean isAdded = false;
                QVTDirectedValidation.checkBooleanType(semanticsVisitable, log, processor);
                if (QVTDirectedValidation.computeOrderedClauseForRelationCalls(semanticsVisitable, currentlyResolvedVariables, whereClauses, orderedWhereClauses, goOn, isAdded, data, processor, targetModel)) {
                    goOn = true;
                    iter = whereClauses.iterator();
                    continue block0;
                }
                if (semanticsVisitable instanceof OperationCallExp) {
                    OperationCallExp operationCallExp = (OperationCallExp)semanticsVisitable;
                    boolean[] goOnAndIsAdded = QVTDirectedValidation.computeOrderedWhereClauseForOperationCall(operationCallExp, currentlyResolvedVariables, whereClauses, orderedWhereClauses, goOn, isAdded, data, processor);
                    goOn = goOnAndIsAdded[0];
                    isAdded = goOnAndIsAdded[1];
                    if (goOn) {
                        iter = whereClauses.iterator();
                    }
                }
                if (semanticsVisitable instanceof ObjectTemplateExp) {
                    ObjectTemplateExp template = (ObjectTemplateExp)semanticsVisitable;
                    VariableDeclaration referredVariable = template.getBindsTo();
                    ArrayList<VariableDeclaration> currentlyResolvedVariablesWithMe = new ArrayList<VariableDeclaration>(currentlyResolvedVariables);
                    currentlyResolvedVariablesWithMe.add(referredVariable);
                    if (QvtProcessorImpl.respectCheckOnlyFlag() && template.eContainer().eContainer() instanceof RelationDomain && ((RelationDomain)template.eContainer().eContainer()).isIsCheckable()) {
                        if (!host.isIsTopLevel()) {
                            currentlyResolvedVariables.add(template.getBindsTo());
                        } else {
                            currentlyResolvedVariablesWithMe = currentlyResolvedVariables;
                        }
                    } else if (!QVTDirectedValidation.shouldBeInstantiatedInThisRelation(host, template.getBindsTo(), (Map)data, targetModel, processor)) {
                        currentlyResolvedVariablesWithMe = currentlyResolvedVariables;
                    }
                    if (!currentlyResolvedVariables.contains(referredVariable) && currentlyResolvedVariablesWithMe.containsAll(dependsOnVar)) {
                        if (processor.isParsingMode()) {
                            ErrorManager.reportWarning(log, processor.getAnalyser().getSymbol(semanticsVisitable), "In QVT parsing mode, element creation by the object template '" + referredVariable.getName() + "' in relation " + host.getName() + " will not be permitted!");
                        }
                        if (processor.getQvtModelManipulationAdaper().isAbstract(referredVariable.getType())) {
                            ErrorManager.reportWarning(log, processor.getAnalyser().getSymbol(semanticsVisitable), "Instantiation of an abstract metaclass '" + referredVariable.getType() + "' for variable '" + referredVariable.getName() + "' in relation '" + host.getName() + "' will fail!");
                        }
                        orderedWhereClauses.add(semanticsVisitable);
                        whereClauses.remove(semanticsVisitable);
                        currentlyResolvedVariables.add(referredVariable);
                        processor.markAsBindingClause(semanticsVisitable, referredVariable);
                        goOn = true;
                        iter = whereClauses.iterator();
                        continue block0;
                    }
                    if (currentlyResolvedVariablesWithMe.containsAll(dependsOnVar)) {
                        whereClauses.remove(semanticsVisitable);
                        iter = whereClauses.iterator();
                        goOn = true;
                        isAdded = true;
                    }
                }
                if (semanticsVisitable instanceof PropertyTemplateItem) {
                    PropertyTemplateItem propertyTemplateItem = (PropertyTemplateItem)semanticsVisitable;
                    Property prop = propertyTemplateItem.getReferredProperty();
                    if (!processor.getQvtModelManipulationAdaper().isChangeable(prop)) {
                        ErrorManager.reportWarning(log, processor.getAnalyser().getSymbol(semanticsVisitable), "The property '" + prop.getName() + "' is not changeable!");
                    }
                }
                if (!currentlyResolvedVariables.containsAll(dependsOnVar) || isAdded) continue;
                orderedWhereClauses.add(semanticsVisitable);
                whereClauses.remove(semanticsVisitable);
                iter = whereClauses.iterator();
                goOn = true;
                isAdded = true;
            }
        }
        for (SemanticsVisitable clause : whereClauses) {
            String unresolvedVar = QVTDirectedValidation.getUnresolvedVar(clause, currentlyResolvedVariables, data, processor);
            ErrorManager.reportError(log, processor.getAnalyser().getSymbol(clause), "where clause of relation '" + host.getName() + "' could not be resolved" + unresolvedVar + "!");
        }
        orderedWhereClauses.addAll(whereClauses);
        return orderedWhereClauses;
    }

    private static boolean isContainerTemplateVariableResolved(SemanticsVisitable semanticsVisitable, Collection currentlyResolvedVariables) {
        if (!(semanticsVisitable instanceof PropertyTemplateItem)) {
            return true;
        }
        ObjectTemplateExp semanticsVisitableObjectTemplate = ((PropertyTemplateItem)semanticsVisitable).getObjContainer();
        return currentlyResolvedVariables.contains(semanticsVisitableObjectTemplate.getBindsTo());
    }

    private static List getVariablesBoundByRelationCall(RelationCallExp relationCallExp, List currentlyResolvedVariables, TypedModel targetModel) {
        ArrayList<VariableDeclaration> result = new ArrayList<VariableDeclaration>();
        Relation referredRelation = relationCallExp.getReferredRelation();
        Iterator domainIter = referredRelation.getDomain().iterator();
        EList args = relationCallExp.getArgument();
        for (OclExpression currentArg : args) {
            VariableExp currentVariableExp;
            RelationDomain relationDomain = (RelationDomain)domainIter.next();
            if (!targetModel.equals(relationDomain.getTypedModel()) || !(currentArg instanceof VariableExp) || currentlyResolvedVariables.contains((currentVariableExp = (VariableExp)currentArg).getReferredVariable())) continue;
            result.add(currentVariableExp.getReferredVariable());
        }
        return result;
    }

    public static boolean findNestedRelationCalls(List boundVariables, SemanticsVisitable pattern, QvtProcessorImpl processor, List currentlyResolvedVariables, TypedModel targetModel) {
        OperationCallExp operationCallExp;
        if (pattern instanceof OperationCallExp && (operationCallExp = (OperationCallExp)pattern).getType() != null && operationCallExp.getType().conformsTo(processor.getTypeFactory().buildBooleanType()).booleanValue() && "or".equals(operationCallExp.getReferredOperation().getName())) {
            OclExpression source = operationCallExp.getSource();
            OclExpression arg = (OclExpression)operationCallExp.getArguments().get(0);
            return QVTDirectedValidation.findNestedRelationCalls(boundVariables, source, processor, currentlyResolvedVariables, targetModel) && QVTDirectedValidation.findNestedRelationCalls(boundVariables, arg, processor, currentlyResolvedVariables, targetModel);
        }
        if (pattern instanceof RelationCallExp) {
            boundVariables.add(QVTDirectedValidation.getVariablesBoundByRelationCall((RelationCallExp)pattern, currentlyResolvedVariables, targetModel));
            return true;
        }
        return false;
    }

    private static boolean computeOrderedClauseForRelationCalls(SemanticsVisitable pattern, List currentlyResolvedVariables, List whereClauses, List orderedWhereClauses, boolean goOn, boolean isAdded, Object data, QvtProcessorImpl processor, TypedModel targetModel) {
        ArrayList boundVariables = new ArrayList();
        if (QVTDirectedValidation.findNestedRelationCalls(boundVariables, pattern, processor, currentlyResolvedVariables, targetModel)) {
            if (boundVariables.isEmpty()) {
                return false;
            }
            if (boundVariables.contains(new ArrayList())) {
                return false;
            }
            List boundVariablesByOneRelation = (List)boundVariables.get(0);
            for (List boundVariablesByAnotherRelation : boundVariables) {
                if (boundVariablesByOneRelation.equals(boundVariablesByAnotherRelation)) continue;
                return false;
            }
            orderedWhereClauses.add(pattern);
            whereClauses.remove(pattern);
            currentlyResolvedVariables.addAll(boundVariablesByOneRelation);
            processor.markAsBindingClause(pattern, boundVariablesByOneRelation);
            return true;
        }
        return false;
    }

    private static boolean[] computeOrderedWhereClauseForOperationCall(OperationCallExp operationCallExp, List currentlyResolvedVariables, List whereClauses, ArrayList orderedWhereClauses, boolean goOn, boolean isAdded, Object data, QvtProcessorImpl processor) {
        VariableExp sourceVariableExp;
        VariableDeclaration referredVariable;
        boolean[] goOnAndIsAdded = new boolean[]{goOn, isAdded};
        if (!"=".equals(operationCallExp.getReferredOperation().getName())) {
            return goOnAndIsAdded;
        }
        OclExpression source = operationCallExp.getSource();
        OclExpression arg = (OclExpression)operationCallExp.getArguments().get(0);
        if (!isAdded && source instanceof VariableExp && !currentlyResolvedVariables.contains(referredVariable = (sourceVariableExp = (VariableExp)source).getReferredVariable()) && currentlyResolvedVariables.containsAll(QVTDirectedValidation.dependsOn(arg, false, data, processor))) {
            orderedWhereClauses.add(operationCallExp);
            whereClauses.remove(operationCallExp);
            currentlyResolvedVariables.add(referredVariable);
            processor.markAsBindingClause((SemanticsVisitable)operationCallExp, referredVariable);
            goOnAndIsAdded[0] = true;
            goOnAndIsAdded[1] = true;
        }
        if (!isAdded && arg instanceof VariableExp) {
            VariableExp argVariableExp = (VariableExp)arg;
            referredVariable = argVariableExp.getReferredVariable();
            if (currentlyResolvedVariables.containsAll(QVTDirectedValidation.dependsOn(source, false, data, processor)) && !currentlyResolvedVariables.contains(referredVariable)) {
                orderedWhereClauses.add(operationCallExp);
                whereClauses.remove(operationCallExp);
                currentlyResolvedVariables.add(referredVariable);
                processor.markAsBindingClause((SemanticsVisitable)operationCallExp, referredVariable);
                goOnAndIsAdded[0] = true;
                goOnAndIsAdded[1] = true;
                operationCallExp.setSource(arg);
                operationCallExp.getArguments().clear();
                operationCallExp.getArguments().add((Object)source);
            }
        }
        return goOnAndIsAdded;
    }

    public static PropertyTemplateItem getPropertyTemplateItemFor(ObjectTemplateExp template, Property prop) {
        for (PropertyTemplateItem currentPropertyTemplateItem : template.getPart()) {
            if (currentPropertyTemplateItem.getReferredProperty() != prop) continue;
            return currentPropertyTemplateItem;
        }
        return null;
    }

    public static List findSuitableKeys(ObjectTemplateExp template, Transformation transformation, QvtProcessorImpl processor) {
        ArrayList<QVTSuitableKey> result = new ArrayList<QVTSuitableKey>();
        EList keys = ((RelationalTransformation)transformation).getOwnedKey();
        for (Key key : keys) {
            if (!template.getType().conformsTo(key.getIdentifies()).booleanValue()) continue;
            QVTSuitableKey suitableKey = new QVTSuitableKey(key, template);
            for (Property prop : key.getPart()) {
                PropertyTemplateItem currentPropertyTemplateItem = QVTDirectedValidation.getPropertyTemplateItemFor(template, prop);
                if (currentPropertyTemplateItem != null) continue;
                if (template.eContainer() instanceof PropertyTemplateItem) {
                    Property prop2 = ((PropertyTemplateItem)template.eContainer()).getReferredProperty();
                    if (processor.getQvtModelManipulationAdaper().isOpposite(prop, prop2)) {
                        suitableKey.setUseOppositeProperty(true);
                        continue;
                    }
                }
                suitableKey = null;
                break;
            }
            if (suitableKey == null) continue;
            result.add(suitableKey);
        }
        return result;
    }

    public static List findSuitableKeys(ObjectTemplateExp template, QvtProcessorImpl processor) {
        return QVTDirectedValidation.findSuitableKeys(template, QVTDirectedValidation.getTransformationOf(template), processor);
    }

    public static List dependsOn(SemanticsVisitable semanticsVisitable, boolean isWhen, Object data, QvtProcessorImpl processor) {
        if (semanticsVisitable instanceof ObjectTemplateExp) {
            ObjectTemplateExp template = (ObjectTemplateExp)semanticsVisitable;
            ArrayList<VariableDeclaration> result = new ArrayList<VariableDeclaration>();
            result.add(template.getBindsTo());
            List suitableKeys = QVTDirectedValidation.findSuitableKeys(template, processor);
            if (suitableKeys.size() >= 2) {
                String s = "";
                for (QVTSuitableKey suitableKey : suitableKeys) {
                    s = String.valueOf(s) + ("".equals(s) ? "" : ", ") + suitableKey.getKey().getIdentifies().getName();
                }
                ErrorManager.reportWarning(processor.getLog(), processor.getAnalyser().getSymbol(template), "Found " + suitableKeys.size() + " suitable keys for types " + s + " for current object template, they are applied in this order at evaluation time");
            }
            for (QVTSuitableKey suitableKey : suitableKeys) {
                for (Property prop : suitableKey.getKey().getPart()) {
                    PropertyTemplateItem propertyTemplateItem = QVTDirectedValidation.getPropertyTemplateItemFor(template, prop);
                    if (propertyTemplateItem == null) continue;
                    OclExpression valueExp = propertyTemplateItem.getValue();
                    if (valueExp instanceof ObjectTemplateExp) {
                        result.add(((ObjectTemplateExp)valueExp).getBindsTo());
                        continue;
                    }
                    result.addAll(QVTDirectedValidation.dependsOn(valueExp, isWhen, data, processor));
                }
                if (!suitableKey.getUseOppositeProperty()) continue;
                PropertyTemplateItem propertyTemplateItem = (PropertyTemplateItem)template.eContainer();
                VariableDeclaration currentTargetVar = propertyTemplateItem.getObjContainer().getBindsTo();
                result.add(currentTargetVar);
            }
            return result;
        }
        QvtVariableAccessFinderVisitorImpl qvtVariableAccessFinderVisitor = new QvtVariableAccessFinderVisitorImpl(isWhen, processor.getTargetTypedModel());
        semanticsVisitable.accept(qvtVariableAccessFinderVisitor, data);
        ArrayList<VariableDeclaration> result = new ArrayList<VariableDeclaration>(qvtVariableAccessFinderVisitor.getVariables());
        if (semanticsVisitable instanceof PropertyTemplateItem) {
            ObjectTemplateExp semanticsVisitableObjectTemplate = ((PropertyTemplateItem)semanticsVisitable).getObjContainer();
            result.add(semanticsVisitableObjectTemplate.getBindsTo());
        }
        return result;
    }

    public static Relation getRelationOf(SemanticsVisitable node) {
        SemanticsVisitable container = node;
        while (!(container instanceof Relation) && container != null) {
            container = container.eContainer();
        }
        return (Relation)container;
    }

    public static Domain getDomainOf(SemanticsVisitable node) {
        SemanticsVisitable container = node;
        while (!(container instanceof Domain) && container != null) {
            container = container.eContainer();
        }
        return (Domain)container;
    }

    static Transformation getTransformationOf(SemanticsVisitable node) {
        EObject container = node.eContainer();
        while (!(container instanceof Transformation) && container != null) {
            container = container.eContainer();
        }
        return (Transformation)container;
    }

    static String getUnresolvedVar(SemanticsVisitable semanticsVisitable, List currentlyResolvedVariables, Object data, QvtProcessorImpl processor) {
        List dependsOnVar = QVTDirectedValidation.dependsOn(semanticsVisitable, true, data, processor);
        ArrayList unresolvedVariables = new ArrayList(dependsOnVar);
        unresolvedVariables.removeAll(currentlyResolvedVariables);
        if (unresolvedVariables.size() >= 1) {
            return " (variable '" + ((VariableDeclaration)unresolvedVariables.get(0)).getName() + "' is not assigned)";
        }
        return "";
    }

    public static List collectAllNestedObjectTemplatesOfRelationExcludingTargetDomain(Relation relation, TypedModel direction, Object data) {
        ArrayList result = new ArrayList();
        ArrayList domains = new ArrayList(relation.getDomain());
        for (RelationDomain currentRelationDomain : domains) {
            if (direction.equals(currentRelationDomain.getTypedModel())) continue;
            result.addAll(QVTDirectedValidation.collectAllNestedObjectTemplatesOfRelationDomain(currentRelationDomain, data));
        }
        return result;
    }

    public static List collectAllNestedObjectTemplatesOfRelationDomain(RelationDomain relationDomain, Object data) {
        ArrayList<ObjectTemplateExp> result = new ArrayList<ObjectTemplateExp>();
        QvtTemplateExpressionFinderVisitorImpl qvtTemplateExpressionFinderVisitor = new QvtTemplateExpressionFinderVisitorImpl();
        if (relationDomain.getPattern() == null) {
            return result;
        }
        relationDomain.getPattern().getTemplateExpression().accept(qvtTemplateExpressionFinderVisitor, data);
        List templateExpressions = qvtTemplateExpressionFinderVisitor.getTemplateExpressions();
        for (TemplateExp currentTemplateExp : templateExpressions) {
            if (currentTemplateExp instanceof ObjectTemplateExp) {
                ObjectTemplateExp currentObjectTemplateExp = (ObjectTemplateExp)currentTemplateExp;
                if (!(currentObjectTemplateExp.eContainer() instanceof PropertyTemplateItem)) continue;
                result.add(currentObjectTemplateExp);
                continue;
            }
            if (currentTemplateExp instanceof ColletionTemplateExp) {
                throw new RuntimeException("NYI");
            }
            throw new RuntimeException("NYI");
        }
        return result;
    }

    public static List collectAllObjectTemplatesOfRelationExcludingDirection(Relation relation, TypedModel direction, Object data) {
        ArrayList result = new ArrayList();
        ArrayList domains = new ArrayList(relation.getDomain());
        for (RelationDomain currentRelationDomain : domains) {
            if (direction.equals(currentRelationDomain.getTypedModel())) continue;
            result.addAll(QVTDirectedValidation.collectAllObjectTemplatesOfRelationDomain(currentRelationDomain, data));
        }
        return result;
    }

    public static List collectAllObjectTemplatesOfRelationInDirection(Relation relation, TypedModel direction, Object data) {
        ArrayList result = new ArrayList();
        ArrayList domains = new ArrayList(relation.getDomain());
        for (RelationDomain currentRelationDomain : domains) {
            if (!direction.equals(currentRelationDomain.getTypedModel())) continue;
            result.addAll(QVTDirectedValidation.collectAllObjectTemplatesOfRelationDomain(currentRelationDomain, data));
        }
        return result;
    }

    public static List collectAllDomainsInDirection(Relation relation, TypedModel direction) {
        ArrayList<TemplateExp> result = new ArrayList<TemplateExp>();
        ArrayList domains = new ArrayList(relation.getDomain());
        for (RelationDomain currentRelationDomain : domains) {
            TemplateExp x;
            if (!direction.equals(currentRelationDomain.getTypedModel()) || !((x = currentRelationDomain.getPattern().getTemplateExpression()) instanceof ObjectTemplateExp)) continue;
            result.add(x);
        }
        return result;
    }

    public static List collectAllDomainsExcludingDirection(Relation relation, TypedModel direction) {
        ArrayList<TemplateExp> result = new ArrayList<TemplateExp>();
        ArrayList domains = new ArrayList(relation.getDomain());
        for (RelationDomain currentRelationDomain : domains) {
            TemplateExp x;
            if (direction.equals(currentRelationDomain.getTypedModel()) || currentRelationDomain.getPattern() == null || !((x = currentRelationDomain.getPattern().getTemplateExpression()) instanceof ObjectTemplateExp)) continue;
            result.add(x);
        }
        return result;
    }

    public static List collectAllObjectTemplatesOfRelationDomain(RelationDomain relationDomain, Object data) {
        ArrayList result = new ArrayList();
        QvtTemplateExpressionFinderVisitorImpl qvtTemplateExpressionFinderVisitor = new QvtTemplateExpressionFinderVisitorImpl();
        if (relationDomain.getPattern() == null) {
            return result;
        }
        relationDomain.getPattern().getTemplateExpression().accept(qvtTemplateExpressionFinderVisitor, data);
        List templateExpressions = qvtTemplateExpressionFinderVisitor.getTemplateExpressions();
        return templateExpressions;
    }

    public static Collection collectAllRelationCallsInWhereClauseWithVariableInTarget(Relation relation, String variableName, TypedModel targetModel, Map data) {
        ArrayList result = new ArrayList();
        Collection whereClauseExpressions = QVTDirectedValidation.collectClauseExpressions(relation, relation.getWhere());
        result = QVTDirectedValidation.getRelationCallsWithVariableInTarget(whereClauseExpressions, variableName, targetModel, data);
        return result;
    }

    private static ArrayList getRelationCallsWithVariableInTarget(Collection whereClauseExpressions, String variableName, TypedModel targetModel, Map data) {
        ArrayList<RelationCallExp> result = new ArrayList<RelationCallExp>();
        for (OclExpression currentExpression : whereClauseExpressions) {
            QvtRelationCallExpressionFinderVisitorImpl relationCallFinderVisitor = new QvtRelationCallExpressionFinderVisitorImpl();
            currentExpression.accept(relationCallFinderVisitor, data);
            Collection relationCallExpressions = relationCallFinderVisitor.getRelationCallExpressions();
            for (RelationCallExp currentRelationCall : relationCallExpressions) {
                if (!QVTDirectedValidation.hasVariableInTarget(currentRelationCall, variableName, targetModel)) continue;
                result.add(currentRelationCall);
            }
        }
        return result;
    }

    private static boolean hasVariableInTarget(RelationCallExp relationCall, String variableName, TypedModel targetModel) {
        int indexOfVariable = QVTDirectedValidation.getIndexOfVariable(relationCall, variableName);
        if (indexOfVariable == -1) {
            return false;
        }
        Relation relation = relationCall.getReferredRelation();
        Domain relationDomains = (Domain)relation.getDomain().get(indexOfVariable);
        return relationDomains.getTypedModel() != null && relationDomains.getTypedModel().equals(targetModel);
    }

    public static Collection getRelationCallsWithDomainVariableTypeSubtypeOfVariable(VariableDeclaration variableDeclaration, Collection relationCalls, boolean requireStrictSubtype) {
        ArrayList<RelationCallExp> result = new ArrayList<RelationCallExp>();
        for (RelationCallExp currentRelationCall : relationCalls) {
            Relation relation = currentRelationCall.getReferredRelation();
            int indexOfVariable = QVTDirectedValidation.getIndexOfVariable(currentRelationCall, variableDeclaration.getName());
            if (indexOfVariable == -1) continue;
            RelationDomain relationDomain = (RelationDomain)relation.getDomain().get(indexOfVariable);
            if (QvtProcessorImpl.respectCheckOnlyFlag() && relationDomain.isIsCheckable() || !QVTDirectedValidation.isSubTypeOf(variableDeclaration.getType(), relationDomain.getRootVariable().getType(), requireStrictSubtype)) continue;
            result.add(currentRelationCall);
        }
        return result;
    }

    private static boolean isSubTypeOf(Classifier superType, Classifier subType, boolean requireStrictSubtype) {
        if (requireStrictSubtype) {
            return subType.conformsTo(superType) != false && superType.conformsTo(subType) == false;
        }
        return subType.conformsTo(superType);
    }

    private static int getIndexOfVariable(RelationCallExp relationCall, String variableName) {
        EList argumentList = relationCall.getArgument();
        int index = 0;
        for (OclExpression currentExpression : argumentList) {
            if (!(currentExpression instanceof VariableExp)) {
                ++index;
                continue;
            }
            VariableExp currentVariableExpression = (VariableExp)currentExpression;
            if (currentVariableExpression.getReferredVariable().getName().equals(variableName)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static List getValueList(Object element, Property prop, QvtProcessorImpl processor) {
        ArrayList<Object> vals;
        Object sourceValue = element instanceof OclAnyModelElement ? ((OclAnyModelElement)element).asJavaObject() : element;
        if (sourceValue == null) {
            throw new RuntimeException("Internal error in QVTDirectedValidation.getValueList(): parent object template not assigned");
        }
        Object javaValue = processor.getModelEvaluationAdapter().getValueForFeauture(sourceValue, prop);
        if (javaValue instanceof Collection) {
            vals = new ArrayList((Collection)javaValue);
        } else {
            vals = new ArrayList<Object>();
            if (javaValue != null) {
                vals.add(javaValue);
            }
        }
        return vals;
    }
}

