/*
 * Decompiled with CFR 0.152.
 */
package de.ikv.emf.qvt;

import de.ikv.emf.qvt.EMFQvtProcessorImpl;
import de.ikv.medini.qvt.QvtProcessorImpl;
import de.ikv.medini.qvt.QvtTraceAdapter;
import de.ikv.medini.qvt.Trace;
import de.ikv.medini.qvt.model.qvtbase.Domain;
import de.ikv.medini.qvt.model.qvtbase.Transformation;
import de.ikv.medini.qvt.model.qvtrelation.Relation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.oslo.ocl20.bridge4emf.OclModelElementTypeImpl;
import org.oslo.ocl20.semantics.bridge.Classifier;
import org.oslo.ocl20.semantics.bridge.Enumeration;
import org.oslo.ocl20.semantics.bridge.OclModelElementType;
import org.oslo.ocl20.semantics.bridge.Primitive;
import org.oslo.ocl20.semantics.model.expressions.VariableDeclaration;
import org.oslo.ocl20.semantics.model.types.BooleanType;
import org.oslo.ocl20.semantics.model.types.IntegerType;
import org.oslo.ocl20.semantics.model.types.RealType;
import org.oslo.ocl20.semantics.model.types.StringType;
import org.oslo.ocl20.standard.lib.OclAny;

public class EMFQvtTraceAdapter
implements QvtTraceAdapter {
    protected QvtProcessorImpl qvtProcessor;
    public static final String TRACE_FILE_NAME = "trace";
    protected Collection allTransformations;
    protected Transformation transformation;
    protected boolean allTracesInOneFile = true;
    protected Collection traceMetamodelResources = new HashSet();

    public void setQvtProcessor(QvtProcessorImpl qvtProcessor) {
        this.qvtProcessor = qvtProcessor;
    }

    public void setTransormation(Transformation transformation) {
        this.transformation = transformation;
    }

    public void setAllTransormations(Collection allTransformations) {
        this.allTransformations = allTransformations;
    }

    public void storeTraces(Collection traces) {
        Date x = new Date();
        if (this.qvtProcessor.isDebugMode()) {
            System.out.println("Begin storing traces");
        }
        this.buildTraceMM();
        ResourceSet resourceSet = this.getResourceSetForTraces();
        HashMap traceResourceMap = new HashMap();
        for (Trace currentTrace : traces) {
            Relation currentRelation = currentTrace.getRelation();
            String currentTransformationName = currentRelation.getTransformation().getName();
            Resource traceResource = this.getTraceResource(currentTransformationName, traceResourceMap, resourceSet);
            this.storeTrace(currentTrace, currentRelation, resourceSet, traceResource);
        }
        if (this.qvtProcessor.isDebugMode()) {
            System.out.println("Saving traces to disk");
        }
        this.saveTraceResources(traceResourceMap, resourceSet);
        if (this.qvtProcessor.isDebugMode()) {
            System.out.println("Stopped saving traces to disk");
        }
        Date y = new Date();
        if (this.qvtProcessor.isDebugMode()) {
            System.out.println("(Storing traces done in in " + (y.getTime() - x.getTime()) + " ms )");
        }
    }

    private void saveTraceResources(Map traceResourceMap, ResourceSet resourceSet) {
        Set transformationNames = traceResourceMap.keySet();
        for (String currentTransformationName : transformationNames) {
            Resource currentResource = (Resource)traceResourceMap.get(currentTransformationName);
            URI traceMMFileUri = ((EMFQvtProcessorImpl)this.qvtProcessor).getWorkingLoactaion().appendSegment(currentTransformationName).appendFileExtension("ecore");
            Resource traceMMResource = resourceSet.getResource(traceMMFileUri, false);
            String nsURI = "urn:" + currentTransformationName + ".ecore";
            resourceSet.getPackageRegistry().remove((Object)nsURI);
            try {
                try {
                    currentResource.save(Collections.EMPTY_MAP);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                traceMMResource.unload();
                currentResource.unload();
                resourceSet.getResources().remove((Object)currentResource);
                resourceSet.getResources().remove((Object)traceMMResource);
            }
        }
    }

    private void storeTrace(Trace trace, Relation relation, ResourceSet resourceSet, Resource traceResource) {
        EClass relationMetaClass = this.lookupRelation(resourceSet, relation);
        List bindings = trace.getBindings();
        bindings.size();
        for (Map currentBinding : bindings) {
            Set keys = currentBinding.keySet();
            EObject traceModelElement = relationMetaClass.getEPackage().getEFactoryInstance().create(relationMetaClass);
            this.restoreTraceIdentifier(trace, currentBinding, traceModelElement);
            traceResource.getContents().add((Object)traceModelElement);
            for (String currentKey : keys) {
                OclAny currentOclValue = (OclAny)currentBinding.get(currentKey);
                this.storeBindingVariable(currentKey, currentOclValue, relationMetaClass, traceModelElement, relation);
            }
        }
    }

    private void storeBindingVariable(String bindingVariable, OclAny bindingValue, EClass relationMetaClass, EObject bindingModelElement, Relation relation) {
        EStructuralFeature currentStructuralFeature = relationMetaClass.getEStructuralFeature(bindingVariable);
        Object currentJavaValue = bindingValue.asJavaObject();
        bindingModelElement.eSet(currentStructuralFeature, currentJavaValue);
        this.setQvtTraceFiles(currentJavaValue, bindingModelElement.eResource().getURI());
    }

    protected void setQvtTraceFiles(Object modelElement, URI traceResourceURI) {
    }

    protected void restoreTraceIdentifier(Trace trace, Map binding, EObject bindingModelElement) {
    }

    private Resource getTraceResource(String currentTransformationName, Map traceResourceMap, ResourceSet resourceSet) {
        Resource traceResource;
        if (this.allTracesInOneFile && this.allTransformations.iterator().hasNext()) {
            currentTransformationName = ((Transformation)this.allTransformations.iterator().next()).getName();
        }
        if ((traceResource = (Resource)traceResourceMap.get(currentTransformationName)) != null) {
            return traceResource;
        }
        if (traceResource != null) {
            return traceResource;
        }
        URI traceFileUri = ((EMFQvtProcessorImpl)this.qvtProcessor).getWorkingLoactaion().appendSegment(TRACE_FILE_NAME).appendFileExtension(currentTransformationName);
        try {
            traceResource = resourceSet.getResource(traceFileUri, false);
        }
        catch (Exception exception) {}
        if (traceResource == null) {
            traceResource = resourceSet.createResource(traceFileUri);
        } else {
            traceResource.getContents().clear();
        }
        traceResourceMap.put(currentTransformationName, traceResource);
        return traceResource;
    }

    private boolean isDomainVariable(String variable, Collection domains) {
        for (Domain currentDomain : domains) {
            if (!variable.equals(currentDomain.getName())) continue;
            return true;
        }
        return false;
    }

    private String getImportingTransformationName(String transformationName) {
        return ((Transformation)this.allTransformations.iterator().next()).getName();
    }

    public Collection loadTraces() {
        String currentTransformationName;
        this.loadTraceMM();
        HashSet<Trace> traces = new HashSet<Trace>();
        ResourceSet resourceSet = this.getResourceSetForTraces();
        for (Transformation currentTransformation : this.allTransformations) {
            currentTransformationName = currentTransformation.getName();
            URI traceFileUri = ((EMFQvtProcessorImpl)this.qvtProcessor).getWorkingLoactaion().appendSegment(TRACE_FILE_NAME).appendFileExtension(currentTransformationName);
            Resource traceResource = null;
            try {
                traceResource = resourceSet.getResource(traceFileUri, true);
            }
            catch (Exception exception) {
                URI traceMMFileUri = ((EMFQvtProcessorImpl)this.qvtProcessor).getWorkingLoactaion().appendSegment(currentTransformationName).appendFileExtension("ecore");
                Resource traceMMResource = resourceSet.getResource(traceMMFileUri, false);
                String nsURI = "urn:" + currentTransformationName + ".ecore";
                resourceSet.getPackageRegistry().remove((Object)nsURI);
                traceMMResource.unload();
                if (traceResource != null) {
                    traceResource.unload();
                }
                if (traceResource != null) {
                    resourceSet.getResources().remove((Object)traceResource);
                }
                resourceSet.getResources().remove((Object)traceMMResource);
                if (traceResource != null) {
                    resourceSet.getResources().remove((Object)traceResource);
                }
                if (!this.allTracesInOneFile) continue;
                break;
            }
            EList traceResourceContent = traceResource.getContents();
            for (EObject currentBindingObject : traceResourceContent) {
                EClass currentBindingClass = currentBindingObject.eClass();
                Relation relation = this.lookupRelation(currentBindingClass);
                if (relation == null) continue;
                ArrayList<OclAny> args = new ArrayList<OclAny>(relation.getDomain().size());
                EList domains = relation.getDomain();
                boolean isValidTrace = true;
                for (Domain currentDomain : domains) {
                    EObject evalue;
                    EStructuralFeature structuralFeature = currentBindingClass.getEStructuralFeature(currentDomain.getName());
                    if (structuralFeature == null) {
                        isValidTrace = false;
                        break;
                    }
                    Object value = currentBindingObject.eGet(structuralFeature);
                    if (value instanceof EObject && (evalue = (EObject)value).eResource() == null) {
                        value = null;
                    }
                    args.add(this.qvtProcessor.getStdLibAdapter().OclAny(value));
                }
                if (!isValidTrace) continue;
                Trace trace = new Trace(relation, args);
                if (traces.contains(trace)) {
                    for (Trace currentTrace : traces) {
                        if (!currentTrace.equals(trace)) continue;
                        trace = currentTrace;
                        break;
                    }
                } else {
                    try {
                        traces.add(trace);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                boolean isValidBinding = true;
                HashMap<String, OclAny> binding = new HashMap<String, OclAny>();
                for (VariableDeclaration currentVariableDeclaration : relation.getVariable()) {
                    EObject evalue;
                    EStructuralFeature structuralFeature = currentBindingClass.getEStructuralFeature(currentVariableDeclaration.getName());
                    if (structuralFeature == null) continue;
                    Object value = currentBindingObject.eGet(structuralFeature);
                    if (value instanceof EObject && (evalue = (EObject)value).eResource() == null) {
                        value = null;
                    }
                    binding.put(currentVariableDeclaration.getName(), this.qvtProcessor.getStdLibAdapter().OclAny(value));
                }
                if (!isValidBinding) continue;
                trace.addBinding(binding);
                this.postAddBindingHook(trace, currentBindingObject, binding);
            }
            String nsURI = "urn:" + currentTransformationName + ".ecore";
            resourceSet.getPackageRegistry().remove((Object)nsURI);
            traceResource.unload();
            resourceSet.getResources().remove((Object)traceResource);
            if (this.allTracesInOneFile) break;
        }
        for (Transformation currentTransformation : this.allTransformations) {
            currentTransformationName = currentTransformation.getName();
            URI traceMMFileUri = ((EMFQvtProcessorImpl)this.qvtProcessor).getWorkingLoactaion().appendSegment(currentTransformationName).appendFileExtension("ecore");
            Resource traceMMResource = resourceSet.getResource(traceMMFileUri, false);
            if (traceMMResource == null) continue;
            traceMMResource.unload();
            resourceSet.getResources().remove((Object)traceMMResource);
        }
        return traces;
    }

    protected void postAddBindingHook(Trace trace, EObject currentBindingObject, Map binding) {
    }

    private Transformation lookupTransformation(EPackage package1) {
        for (Transformation currenTransformation : this.allTransformations) {
            if (package1.getName() == null || !package1.getName().equals(currenTransformation.getName())) continue;
            return currenTransformation;
        }
        return null;
    }

    private Relation lookupRelation(EClass relataion) {
        Transformation transformation = this.lookupTransformation(relataion.getEPackage());
        if (transformation == null) {
            return null;
        }
        EList relations = transformation.getRule();
        for (Relation currentRelation : relations) {
            if (currentRelation.getName() == null || !currentRelation.getName().equals(relataion.getName())) continue;
            return currentRelation;
        }
        return null;
    }

    private EPackage lookupTransformation(Resource resource, Transformation transformation) {
        EList rootPackages = resource.getContents();
        for (EPackage currentPackage : rootPackages) {
            if (currentPackage.getName() == null || !currentPackage.getName().equals(transformation.getName())) continue;
            return currentPackage;
        }
        return null;
    }

    private EClass lookupRelation(ResourceSet resourceSet, Relation relataion) {
        String nsURI = "urn:" + relataion.getTransformation().getName() + ".ecore";
        EPackage currentETransformation = (EPackage)resourceSet.getPackageRegistry().get((Object)nsURI);
        if (currentETransformation == null) {
            throw new RuntimeException();
        }
        return (EClass)currentETransformation.getEClassifier(relataion.getName());
    }

    private void loadTraceMM() {
        ResourceSet resourceSet = this.getResourceSetForTraces();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        this.fillPackageRegistry(resourceSet);
        for (Transformation currentTransformation : this.allTransformations) {
            String currentTransformationName = currentTransformation.getName();
            URI traceMMFileUri = ((EMFQvtProcessorImpl)this.qvtProcessor).getWorkingLoactaion().appendSegment(currentTransformationName).appendFileExtension("ecore");
            String nsURI = "urn:" + currentTransformationName + ".ecore";
            Resource traceMMResource = null;
            try {
                traceMMResource = resourceSet.getResource(traceMMFileUri, true);
                this.traceMetamodelResources.add(traceMMResource);
                resourceSet.getPackageRegistry().put((Object)nsURI, traceMMResource.getContents().get(0));
            }
            catch (Exception exception) {
                if (traceMMResource != null) {
                    resourceSet.getResources().remove((Object)traceMMResource);
                }
                this.buildTraceMMForTransformation(resourceSet, currentTransformation);
            }
        }
    }

    protected void fillPackageRegistry(ResourceSet resourceSet) {
        resourceSet.getPackageRegistry().put((Object)EcorePackage.eINSTANCE.getNsURI(), (Object)EcorePackage.eINSTANCE);
    }

    private void buildTraceMM() {
        ResourceSet resourceSet = this.getResourceSetForTraces();
        resourceSet.getPackageRegistry().put((Object)EcorePackage.eINSTANCE.getNsURI(), (Object)EcorePackage.eINSTANCE);
        for (Transformation currentTransformation : this.allTransformations) {
            this.buildTraceMMForTransformation(resourceSet, currentTransformation);
        }
    }

    private ResourceSet getResourceSetForTraces() {
        return ((EMFQvtProcessorImpl)this.qvtProcessor).getResourceSetForTraces();
    }

    private void buildTraceMMForTransformation(ResourceSet resourceSet, Transformation currentTransformation) {
        String currentTransformationName = currentTransformation.getName();
        URI traceMMFileUri = ((EMFQvtProcessorImpl)this.qvtProcessor).getWorkingLoactaion().appendSegment(currentTransformationName).appendFileExtension("ecore");
        Resource traceMMResource = resourceSet.createResource(traceMMFileUri);
        EPackage currentTransformationPackage = EcoreFactory.eINSTANCE.createEPackage();
        currentTransformationPackage.setNsPrefix(currentTransformationName);
        String nsURI = "urn:" + currentTransformationName + ".ecore";
        currentTransformationPackage.setNsURI("urn:" + currentTransformationName + ".ecore");
        resourceSet.getPackageRegistry().put((Object)nsURI, (Object)currentTransformationPackage);
        traceMMResource.getContents().add((Object)currentTransformationPackage);
        currentTransformationPackage.setName(currentTransformation.getName());
        EList relationList = currentTransformation.getRule();
        for (Relation currentRelation : relationList) {
            EClass currentRelationClass = EcoreFactory.eINSTANCE.createEClass();
            this.setSuperTypes(currentRelationClass);
            currentTransformationPackage.getEClassifiers().add((Object)currentRelationClass);
            currentRelationClass.setName(currentRelation.getName());
            EList currentRelataionVariables = currentRelation.getVariable();
            for (VariableDeclaration currentVariableDeclaration : currentRelataionVariables) {
                Classifier currentVariableType = currentVariableDeclaration.getType();
                if (currentVariableType instanceof Primitive || currentVariableType instanceof Enumeration) {
                    EAttribute currentAttribute = EcoreFactory.eINSTANCE.createEAttribute();
                    currentRelationClass.getEStructuralFeatures().add((Object)currentAttribute);
                    currentAttribute.setName(currentVariableDeclaration.getName());
                    currentAttribute.setLowerBound(0);
                    currentAttribute.setUpperBound(1);
                    if (currentVariableType instanceof Enumeration) {
                        currentAttribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEEnumerator());
                        continue;
                    }
                    if (currentVariableType instanceof IntegerType) {
                        currentAttribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEIntegerObject());
                        continue;
                    }
                    if (currentVariableType instanceof BooleanType) {
                        currentAttribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEIntegerObject());
                        continue;
                    }
                    if (currentVariableType instanceof RealType) {
                        currentAttribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEDoubleObject());
                        continue;
                    }
                    if (currentVariableType instanceof StringType) {
                        currentAttribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
                        continue;
                    }
                    throw new RuntimeException();
                }
                if (!(currentVariableType instanceof OclModelElementType)) continue;
                OclModelElementTypeImpl currentOclModelElementType = (OclModelElementTypeImpl)currentVariableType;
                EClassifier eType = currentOclModelElementType.getImplementation();
                EReference currentReference = EcoreFactory.eINSTANCE.createEReference();
                currentRelationClass.getEStructuralFeatures().add((Object)currentReference);
                currentReference.setName(currentVariableDeclaration.getName());
                currentReference.setEType(eType);
                currentReference.setLowerBound(0);
                currentReference.setUpperBound(1);
            }
        }
        this.traceMetamodelResources.add(traceMMResource);
        try {
            traceMMResource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void setSuperTypes(EClass currentRelationClass) {
    }

    private static String getPathFromProject(String projectName, URI uri) {
        String uriString = uri.toString();
        int projectIndex = uriString.indexOf(projectName);
        return uriString.substring(projectIndex);
    }

    private static String getPathRelativeToProject(URI modelURI, URI traceURI) {
        String projectName = EMFQvtTraceAdapter.getProjectName(modelURI);
        String pathFromProject = EMFQvtTraceAdapter.getPathFromProject(projectName, traceURI);
        return pathFromProject.substring(projectName.length() + 1);
    }

    private static String getProjectName(URI modelURI) {
        return modelURI.trimSegments(1).lastSegment();
    }

    protected Collection getTraceMetamodelResources() {
        return this.traceMetamodelResources;
    }
}

