/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.TransformerException;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.UAElement;
import org.eclipse.help.internal.dynamic.DocumentWriter;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.internal.toc.TocContribution;
import org.eclipse.help.internal.webapp.data.UrlUtil;

public class TocServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private Map responseByLocale;
    private DocumentWriter writer;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String response;
        String locale = UrlUtil.getLocale(req, resp);
        req.setCharacterEncoding("UTF-8");
        resp.setContentType("application/xml; charset=UTF-8");
        if (this.responseByLocale == null) {
            this.responseByLocale = new WeakHashMap();
        }
        if ((response = (String)this.responseByLocale.get(locale)) == null) {
            TocContribution[] contributions = HelpPlugin.getTocManager().getTocContributions(locale);
            try {
                response = this.serialize(contributions, locale);
            }
            catch (TransformerException e) {
                throw new ServletException((Throwable)e);
            }
            this.responseByLocale.put(locale, response);
        }
        resp.getWriter().write(response);
    }

    private String serialize(TocContribution[] contributions, String locale) throws TransformerException {
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buf.append("<tocContributions>\n");
        if (this.writer == null) {
            this.writer = new DocumentWriter();
        }
        int i = 0;
        while (i < contributions.length) {
            TocContribution contrib = contributions[i];
            buf.append("<tocContribution");
            if (contrib.getCategoryId() != null) {
                buf.append("\n      categoryId=\"" + contrib.getCategoryId() + '\"');
            }
            if (contrib.getContributorId() != null) {
                buf.append("\n      contributorId=\"" + contrib.getContributorId() + '\"');
            }
            buf.append("\n      id=\"" + contrib.getId() + '\"');
            buf.append("\n      locale=\"" + contrib.getLocale() + '\"');
            buf.append("\n      isPrimary=\"" + contrib.isPrimary() + "\">\n");
            buf.append(this.writer.writeString((UAElement)((Toc)contrib.getToc()), false));
            String[] hrefs = contrib.getExtraDocuments();
            int j = 0;
            while (j < hrefs.length) {
                buf.append("   <extraDocument href=\"" + hrefs[j] + "\"/>\n");
                ++j;
            }
            buf.append("</tocContribution>\n");
            ++i;
        }
        buf.append("</tocContributions>\n");
        return buf.toString();
    }
}

