/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.kent.cs.kmf.util.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import uk.ac.kent.cs.kmf.util.reflection.ClassUtilities;

public final class BetterMethodFinder {
    private final Class clazz;
    private final Map methodMap = new HashMap();
    private final List ctorList = new ArrayList();
    private final Map paramMap = new HashMap();
    static /* synthetic */ Class class$0;

    public BetterMethodFinder(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("null Class parameter");
        }
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException("primitive Class parameter");
        }
        if (clazz.isArray()) {
            throw new IllegalArgumentException("array Class parameter");
        }
        this.clazz = clazz;
        this.loadMethods();
        this.loadConstructors();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BetterMethodFinder other = (BetterMethodFinder)o;
        return this.clazz.equals(other.clazz);
    }

    public Constructor findConstructor(Class[] parameterTypes) throws NoSuchMethodException {
        if (parameterTypes == null) {
            parameterTypes = new Class[]{};
        }
        return (Constructor)this.findMemberIn(this.ctorList, parameterTypes);
    }

    private Member findMemberIn(List memberList, Class[] parameterTypes) throws NoSuchMethodException {
        ArrayList<Member> matchingMembers = new ArrayList<Member>();
        Iterator it = memberList.iterator();
        while (it.hasNext()) {
            Member member = (Member)it.next();
            Object[] methodParamTypes = (Class[])this.paramMap.get(member);
            if (Arrays.equals(methodParamTypes, parameterTypes)) {
                return member;
            }
            if (!ClassUtilities.compatibleClasses((Class[])methodParamTypes, parameterTypes)) continue;
            matchingMembers.add(member);
        }
        if (matchingMembers.isEmpty()) {
            throw new NoSuchMethodException("no member in " + this.clazz.getName() + " matching given args");
        }
        if (matchingMembers.size() == 1) {
            return (Member)matchingMembers.get(0);
        }
        return this.findMostSpecificMemberIn(matchingMembers);
    }

    public Method findMethod(String methodName, Class[] parameterTypes) throws NoSuchMethodException {
        List methodList = (List)this.methodMap.get(methodName);
        if (methodList == null) {
            throw new NoSuchMethodException("no method named " + this.clazz.getName() + "." + methodName);
        }
        if (parameterTypes == null) {
            parameterTypes = new Class[]{};
        }
        return (Method)this.findMemberIn(methodList, parameterTypes);
    }

    private Member findMostSpecificMemberIn(List memberList) throws NoSuchMethodException {
        ArrayList<Member> mostSpecificMembers = new ArrayList<Member>();
        Iterator memberIt = memberList.iterator();
        while (memberIt.hasNext()) {
            Member member = (Member)memberIt.next();
            if (mostSpecificMembers.isEmpty()) {
                mostSpecificMembers.add(member);
                continue;
            }
            boolean moreSpecific = true;
            boolean lessSpecific = false;
            Iterator specificIt = mostSpecificMembers.iterator();
            while (specificIt.hasNext()) {
                Member moreSpecificMember = (Member)specificIt.next();
                if (this.memberIsMoreSpecific(member, moreSpecificMember)) continue;
                moreSpecific = false;
                lessSpecific = this.memberIsMoreSpecific(moreSpecificMember, member);
                break;
            }
            if (moreSpecific) {
                mostSpecificMembers.clear();
                mostSpecificMembers.add(member);
                continue;
            }
            if (lessSpecific) continue;
            mostSpecificMembers.add(member);
        }
        if (mostSpecificMembers.size() > 1) {
            throw new NoSuchMethodException("Ambiguous request for member in " + this.clazz.getName() + " matching given args");
        }
        return (Member)mostSpecificMembers.get(0);
    }

    public static Class[] getParameterTypesFrom(Object[] args) {
        Class[] argTypes = null;
        if (args != null) {
            argTypes = new Class[args.length];
            int i = 0;
            while (i < args.length) {
                argTypes[i] = args[i] == null ? Void.TYPE : args[i].getClass();
                ++i;
            }
        } else {
            argTypes = new Class[]{};
        }
        return argTypes;
    }

    public static Class[] getParameterTypesFrom(String[] classNames) throws ClassNotFoundException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("uk.ac.kent.cs.kmf.util.reflection.BetterMethodFinder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return BetterMethodFinder.getParameterTypesFrom(classNames, clazz.getClassLoader());
    }

    public static Class[] getParameterTypesFrom(String[] classNames, ClassLoader loader) throws ClassNotFoundException {
        Class[] types = null;
        if (classNames != null) {
            types = new Class[classNames.length];
            int i = 0;
            while (i < classNames.length) {
                types[i] = ClassUtilities.classForNameOrPrimitive(classNames[i], loader);
                ++i;
            }
        } else {
            types = new Class[]{};
        }
        return types;
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }

    private void loadConstructors() {
        Constructor<?>[] ctors = this.clazz.getConstructors();
        int i = 0;
        while (i < ctors.length) {
            this.ctorList.add(ctors[i]);
            this.paramMap.put(ctors[i], ctors[i].getParameterTypes());
            ++i;
        }
    }

    private void loadMethods() {
        Method[] methods = this.clazz.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method m = methods[i];
            String methodName = m.getName();
            Class[] paramTypes = m.getParameterTypes();
            ArrayList<Method> list = (ArrayList<Method>)this.methodMap.get(methodName);
            if (list == null) {
                list = new ArrayList<Method>();
                this.methodMap.put(methodName, list);
            }
            if (!ClassUtilities.classIsAccessible(this.clazz)) {
                m = ClassUtilities.getAccessibleMethodFrom(this.clazz, methodName, paramTypes);
            }
            if (m != null) {
                list.add(m);
                this.paramMap.put(m, paramTypes);
            }
            ++i;
        }
    }

    private boolean memberIsMoreSpecific(Member first, Member second) {
        Class[] firstParamTypes = (Class[])this.paramMap.get(first);
        Class[] secondParamTypes = (Class[])this.paramMap.get(second);
        return ClassUtilities.compatibleClasses(secondParamTypes, firstParamTypes);
    }
}

