/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.kent.cs.kmf.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Naming {
    protected static Set keywords = new HashSet();
    protected static Map UMLPath;

    static {
        keywords.add("abstract");
        keywords.add("boolean");
        keywords.add("break");
        keywords.add("byte");
        keywords.add("case");
        keywords.add("catch");
        keywords.add("char");
        keywords.add("class");
        keywords.add("const");
        keywords.add("continue");
        keywords.add("default");
        keywords.add("do");
        keywords.add("double");
        keywords.add("else");
        keywords.add("extends");
        keywords.add("final");
        keywords.add("finally");
        keywords.add("float");
        keywords.add("for");
        keywords.add("goto");
        keywords.add("if");
        keywords.add("implements");
        keywords.add("import");
        keywords.add("instanceof");
        keywords.add("int");
        keywords.add("interface");
        keywords.add("long");
        keywords.add("native");
        keywords.add("new");
        keywords.add("package");
        keywords.add("private");
        keywords.add("protected");
        keywords.add("public");
        keywords.add("return");
        keywords.add("short");
        keywords.add("public");
        keywords.add("static");
        keywords.add("strictfp");
        keywords.add("super");
        keywords.add("switch");
        keywords.add("synchronized");
        keywords.add("this");
        keywords.add("throw");
        keywords.add("throws");
        keywords.add("transient");
        keywords.add("try");
        keywords.add("void");
        keywords.add("volatile");
        keywords.add("while");
        keywords.add("Object");
        keywords.add("Enumeration");
        keywords.add("Integer");
        keywords.add("Boolean");
        keywords.add("Double");
        keywords.add("String");
        keywords.add("Collection");
        keywords.add("Set");
        keywords.add("Class");
        keywords.add("namespace");
        keywords.add("internal");
        UMLPath = new HashMap();
        UMLPath.put("Action", "Behavioral Elements.State Machines");
        UMLPath.put("Guard", "Behavioral Elements.State Machines");
        UMLPath.put("Pseudostate", "Behavioral Elements.State Machines");
        UMLPath.put("State", "Behavioral Elements.State Machines");
        UMLPath.put("StateMachine", "Behavioral Elements.State Machines");
        UMLPath.put("StateVertex", "Behavioral Elements.State Machines");
        UMLPath.put("StubState", "Behavioral Elements.State Machines");
        UMLPath.put("SynchState", "Behavioral Elements.State Machines");
        UMLPath.put("Transition", "Behavioral Elements.State Machines");
        UMLPath.put("CallEvent", "Behavioral Elements.State Machines");
        UMLPath.put("CallEvent", "Behavioral Elements.State Machines");
        UMLPath.put("CompositeState", "Behavioral Elements.State Machines");
        UMLPath.put("Abstraction", "Foundation.Core");
        UMLPath.put("Association", "Foundation.Core");
        UMLPath.put("AssociationClass", "Foundation.Core");
        UMLPath.put("AssociationEnd", "Foundation.Core");
        UMLPath.put("Attribute", "Foundation.Core");
        UMLPath.put("BehavioralFeature", "Foundation.Core");
        UMLPath.put("Bindind", "Foundation.Core");
        UMLPath.put("CallAction", "Foundation.Core");
        UMLPath.put("Class", "Foundation.Core");
        UMLPath.put("Classifier", "Foundation.Core");
        UMLPath.put("Comment", "Foundation.Core");
        UMLPath.put("Component", "Foundation.Core");
        UMLPath.put("Constraint", "Foundation.Core");
        UMLPath.put("DataType", "Foundation.Core");
        UMLPath.put("Dependency", "Foundation.Core");
        UMLPath.put("Element", "Foundation.Core");
        UMLPath.put("EnumLiteral", "Foundation.Core");
        UMLPath.put("Enumeration", "Foundation.Core");
        UMLPath.put("Feature", "Foundation.Core");
        UMLPath.put("Flow", "Foundation.Core");
        UMLPath.put("GeneralizableElement", "Foundation.Core");
        UMLPath.put("Generalization", "Foundation.Core");
        UMLPath.put("Interface", "Foundation.Core");
        UMLPath.put("Method", "Foundation.Core");
        UMLPath.put("ModelElement", "Foundation.Core");
        UMLPath.put("Namespace", "Foundation.Core");
        UMLPath.put("Node", "Foundation.Core");
        UMLPath.put("Operation", "Foundation.Core");
        UMLPath.put("Parameter", "Foundation.Core");
        UMLPath.put("Permission", "Foundation.Core");
        UMLPath.put("PresentationElement", "Foundation.Core");
        UMLPath.put("Primitive", "Foundation.Core");
        UMLPath.put("Relationship", "Foundation.Core");
        UMLPath.put("SendAction", "Foundation.Core");
        UMLPath.put("Signal", "Foundation.Core");
        UMLPath.put("StructuralFeature", "Foundation.Core");
        UMLPath.put("TemplateParameter", "Foundation.Core");
        UMLPath.put("Tie", "Foundation.Core");
        UMLPath.put("Usage", "Foundation.Core");
        UMLPath.put("ActionExpression", "Foundation.Data Types");
        UMLPath.put("AggregationKind", "Foundation.Data Types");
        UMLPath.put("ArgListsExpression", "Foundation.Data Types");
        UMLPath.put("Boolean", "Foundation.Data Types");
        UMLPath.put("BooleanExpression", "Foundation.Data Types");
        UMLPath.put("CallConcurrencyKind", "Foundation.Data Types");
        UMLPath.put("ChangebilityKind", "Foundation.Data Types");
        UMLPath.put("Expression", "Foundation.Data Types");
        UMLPath.put("Geometry", "Foundation.Data Types");
        UMLPath.put("Integer", "Foundation.Data Types");
        UMLPath.put("IterationExpression", "Foundation.Data Types");
        UMLPath.put("LocationReference", "Foundation.Data Types");
        UMLPath.put("MappingExpression", "Foundation.Data Types");
        UMLPath.put("MessageDirectionKind", "Foundation.Data Types");
        UMLPath.put("Multiplicity", "Foundation.Data Types");
        UMLPath.put("MultiplicityRange", "Foundation.Data Types");
        UMLPath.put("Name", "Foundation.Data Types");
        UMLPath.put("ObjectSetExpression", "Foundation.Data Types");
        UMLPath.put("OrderingKind", "Foundation.Data Types");
        UMLPath.put("ParameterDirectionKind", "Foundation.Data Types");
        UMLPath.put("ProcedureExpression", "Foundation.Data Types");
        UMLPath.put("PseudostateKind", "Foundation.Data Types");
        UMLPath.put("ScopeKind", "Foundation.Data Types");
        UMLPath.put("String", "Foundation.Data Types");
        UMLPath.put("Time", "Foundation.Data Types");
        UMLPath.put("TimeExpression", "Foundation.Data Types");
        UMLPath.put("TypeExpression", "Foundation.Data Types");
        UMLPath.put("UnlimitedInteger", "Foundation.Data Types");
        UMLPath.put("VisibilityKind", "Foundation.Data Types");
        UMLPath.put("Stereotype", "Foundation.Extension Mechanisms");
        UMLPath.put("StringArray", "Foundation.Extension Mechanisms");
        UMLPath.put("TagDefinition", "Foundation.Extension Mechanisms");
        UMLPath.put("TaggedValue", "Foundation.Extension Mechanisms");
        UMLPath.put("Model", "Model Management");
        UMLPath.put("Package", "Model Management");
        UMLPath.put("Subsystem", "Model Management");
    }

    public static boolean isKeyword(String name) {
        return keywords.contains(name);
    }

    public static boolean isAlpha(char ch) {
        if ('a' <= ch && ch <= 'z') {
            return true;
        }
        if ('A' <= ch && ch <= 'Z') {
            return true;
        }
        if ('0' <= ch && ch <= '9') {
            return true;
        }
        return ch == '_';
    }

    public static String getCleanName(String name) {
        String res = new String();
        name = name.trim();
        int i = 0;
        while (i < name.length()) {
            char ch = name.charAt(i);
            if (ch != '\t' && ch != '\n' && ch != '\r' && ch != '/') {
                res = Naming.isAlpha(ch) || ch == '.' ? String.valueOf(res) + ch : String.valueOf(res) + '_';
            }
            ++i;
        }
        int pos = res.lastIndexOf(".");
        String lastName = res.substring(pos + 1, res.length());
        if (Naming.isKeyword(lastName)) {
            lastName = String.valueOf(lastName) + "_";
        }
        return String.valueOf(res.substring(0, pos + 1)) + lastName;
    }

    public static String getGetter(String name) {
        if (name.length() == 0) {
            return "get_";
        }
        return "get" + name.substring(0, 1).toUpperCase() + name.substring(1, name.length());
    }

    public static String getSetter(String name) {
        if (name.length() == 0) {
            return "set_";
        }
        return "set" + name.substring(0, 1).toUpperCase() + name.substring(1, name.length());
    }

    public static String getUMLPathName(String name) {
        String pathName = (String)UMLPath.get(name);
        return pathName == null ? name : String.valueOf(pathName) + "." + name;
    }
}

