/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.remote;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.remote.RemoteHelp;
import org.eclipse.help.internal.base.remote.RemoteSearchParser;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.QueryTooComplexException;
import org.eclipse.help.internal.util.URLCoder;

public class RemoteSearchManager {
    private static final String PATH_SEARCH = "/search";
    private static final String PARAM_PHRASE = "phrase";
    private static final String PARAM_LANG = "lang";
    private RemoteSearchParser parser;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void search(ISearchQuery searchQuery, ISearchHitCollector collector, IProgressMonitor pm) throws QueryTooComplexException {
        pm.beginTask("", 100);
        try {
            if (!RemoteHelp.isEnabled()) return;
            InputStream in = null;
            try {
                URL url = RemoteHelp.getURL("/search?phrase=" + URLCoder.encode((String)searchQuery.getSearchWord()) + '&' + PARAM_LANG + '=' + searchQuery.getLocale());
                in = url.openStream();
                if (this.parser == null) {
                    this.parser = new RemoteSearchParser();
                }
                List hits = this.parser.parse(in, (IProgressMonitor)new SubProgressMonitor(pm, 100));
                collector.addHits(hits, null);
            }
            catch (IOException e) {
                String msg = "I/O error while trying to contact the remote help server";
                HelpBasePlugin.logError(msg, e);
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (Throwable t) {
                try {
                    String msg = "Internal error while reading search results from remote server";
                    HelpBasePlugin.logError(msg, t);
                    if (in == null) return;
                }
                catch (Throwable throwable) {
                    if (in == null) throw throwable;
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    in.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            if (in == null) return;
            try {
                in.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        finally {
            pm.done();
        }
    }
}

