/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import org.apache.catalina.Container;
import org.apache.catalina.DefaultContext;
import org.apache.catalina.Engine;
import org.apache.catalina.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.StringManager;

public abstract class ManagerBase
implements Manager {
    protected static final String DEFAULT_ALGORITHM = "MD5";
    protected static final int SESSION_ID_BYTES = 16;
    protected String algorithm = "MD5";
    protected Container container;
    protected int debug = 0;
    protected DefaultContext defaultContext = null;
    protected MessageDigest digest = null;
    protected boolean distributable;
    protected String entropy = null;
    private static final String info = "ManagerBase/1.0";
    protected int maxInactiveInterval = 60;
    protected static String name = "ManagerBase";
    protected Random random = null;
    protected String randomClass = "java.security.SecureRandom";
    protected ArrayList recycled = new ArrayList();
    protected HashMap sessions = new HashMap();
    protected int sessionCounter = 0;
    protected int maxActive = 0;
    protected int duplicates = 0;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.session");
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        String oldAlgorithm = this.algorithm;
        this.algorithm = algorithm;
        this.support.firePropertyChange("algorithm", oldAlgorithm, this.algorithm);
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    public DefaultContext getDefaultContext() {
        return this.defaultContext;
    }

    public void setDefaultContext(DefaultContext defaultContext) {
        DefaultContext oldDefaultContext = this.defaultContext;
        this.defaultContext = defaultContext;
        this.support.firePropertyChange("defaultContext", oldDefaultContext, this.defaultContext);
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public synchronized MessageDigest getDigest() {
        if (this.digest == null) {
            if (this.debug >= 1) {
                this.log(sm.getString("managerBase.getting", this.algorithm));
            }
            try {
                this.digest = MessageDigest.getInstance(this.algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                this.log(sm.getString("managerBase.digest", this.algorithm), e);
                try {
                    this.digest = MessageDigest.getInstance(DEFAULT_ALGORITHM);
                }
                catch (NoSuchAlgorithmException f) {
                    this.log(sm.getString("managerBase.digest", DEFAULT_ALGORITHM), e);
                    this.digest = null;
                }
            }
            if (this.debug >= 1) {
                this.log(sm.getString("managerBase.gotten"));
            }
        }
        return this.digest;
    }

    public boolean getDistributable() {
        return this.distributable;
    }

    public void setDistributable(boolean distributable) {
        boolean oldDistributable = this.distributable;
        this.distributable = distributable;
        this.support.firePropertyChange("distributable", new Boolean(oldDistributable), new Boolean(this.distributable));
    }

    public String getEntropy() {
        if (this.entropy == null) {
            this.setEntropy(this.toString());
        }
        return this.entropy;
    }

    public void setEntropy(String entropy) {
        String oldEntropy = entropy;
        this.entropy = entropy;
        this.support.firePropertyChange("entropy", oldEntropy, this.entropy);
    }

    public String getInfo() {
        return info;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int interval) {
        int oldMaxInactiveInterval = this.maxInactiveInterval;
        this.maxInactiveInterval = interval;
        this.support.firePropertyChange("maxInactiveInterval", new Integer(oldMaxInactiveInterval), new Integer(this.maxInactiveInterval));
    }

    public String getName() {
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Random getRandom() {
        if (this.random == null) {
            ManagerBase managerBase = this;
            synchronized (managerBase) {
                if (this.random == null) {
                    this.log(sm.getString("managerBase.seeding", this.randomClass));
                    long seed = System.currentTimeMillis();
                    char[] entropy = this.getEntropy().toCharArray();
                    for (int i = 0; i < entropy.length; ++i) {
                        long update = (byte)entropy[i] << i % 8 * 8;
                        seed ^= update;
                    }
                    try {
                        Class<?> clazz = Class.forName(this.randomClass);
                        this.random = (Random)clazz.newInstance();
                        this.random.setSeed(seed);
                    }
                    catch (Exception e) {
                        this.log(sm.getString("managerBase.random", this.randomClass), e);
                        this.random = new Random();
                        this.random.setSeed(seed);
                    }
                    this.log(sm.getString("managerBase.complete", this.randomClass));
                }
            }
        }
        return this.random;
    }

    public String getRandomClass() {
        return this.randomClass;
    }

    public void setRandomClass(String randomClass) {
        String oldRandomClass = this.randomClass;
        this.randomClass = randomClass;
        this.support.firePropertyChange("randomClass", oldRandomClass, this.randomClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Session session) {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.put(session.getId(), session);
            if (this.sessions.size() > this.maxActive) {
                this.maxActive = this.sessions.size();
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session createSession() {
        Session session = this.createEmptySession();
        session.setNew(true);
        session.setValid(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this.maxInactiveInterval);
        String sessionId = this.generateSessionId();
        String jvmRoute = this.getJvmRoute();
        if (jvmRoute != null) {
            sessionId = sessionId + '.' + jvmRoute;
        }
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            while (this.sessions.get(sessionId) != null) {
                sessionId = this.generateSessionId();
                ++this.duplicates;
                if (jvmRoute == null) continue;
                sessionId = sessionId + '.' + jvmRoute;
            }
        }
        session.setId(sessionId);
        ++this.sessionCounter;
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session createEmptySession() {
        Session session = null;
        ArrayList arrayList = this.recycled;
        synchronized (arrayList) {
            int size = this.recycled.size();
            if (size > 0) {
                session = (Session)this.recycled.get(size - 1);
                this.recycled.remove(size - 1);
            }
        }
        if (session != null) {
            session.setManager(this);
        } else {
            session = new StandardSession(this);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session findSession(String id) throws IOException {
        if (id == null) {
            return null;
        }
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            Session session = (Session)this.sessions.get(id);
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session[] findSessions() {
        Session[] results = null;
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            results = new Session[this.sessions.size()];
            results = this.sessions.values().toArray(results);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Session session) {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.remove(session.getId());
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    protected synchronized String generateSessionId() {
        Random random = this.getRandom();
        byte[] bytes = new byte[16];
        this.getRandom().nextBytes(bytes);
        bytes = this.getDigest().digest(bytes);
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            byte b1 = (byte)((bytes[i] & 0xF0) >> 4);
            byte b2 = (byte)(bytes[i] & 0xF);
            if (b1 < 10) {
                result.append((char)(48 + b1));
            } else {
                result.append((char)(65 + (b1 - 10)));
            }
            if (b2 < 10) {
                result.append((char)(48 + b2));
                continue;
            }
            result.append((char)(65 + (b2 - 10)));
        }
        return result.toString();
    }

    public Engine getEngine() {
        Engine e = null;
        for (Container c = this.getContainer(); e == null && c != null; c = c.getParent()) {
            if (c == null || !(c instanceof Engine)) continue;
            e = (Engine)c;
        }
        return e;
    }

    public String getJvmRoute() {
        Engine e = this.getEngine();
        return e == null ? null : e.getJvmRoute();
    }

    void log(String message) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log(this.getName() + "[" + this.container.getName() + "]: " + message);
        } else {
            String containerName = null;
            if (this.container != null) {
                containerName = this.container.getName();
            }
            System.out.println(this.getName() + "[" + containerName + "]: " + message);
        }
    }

    void log(String message, Throwable throwable) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log(this.getName() + "[" + this.container.getName() + "] " + message, throwable);
        } else {
            String containerName = null;
            if (this.container != null) {
                containerName = this.container.getName();
            }
            System.out.println(this.getName() + "[" + containerName + "]: " + message);
            throwable.printStackTrace(System.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recycle(Session session) {
        ArrayList arrayList = this.recycled;
        synchronized (arrayList) {
            this.recycled.add(session);
        }
    }

    public void setSessionCounter(int sessionCounter) {
        this.sessionCounter = sessionCounter;
    }

    public int getSessionCounter() {
        return this.sessionCounter;
    }

    public int getDuplicates() {
        return this.duplicates;
    }

    public void setDuplicates(int duplicates) {
        this.duplicates = duplicates;
    }

    public int getActiveSessions() {
        return this.sessions.size();
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public String listSessionIds() {
        StringBuffer sb = new StringBuffer();
        Iterator keys = this.sessions.keySet().iterator();
        while (keys.hasNext()) {
            sb.append(keys.next()).append(" ");
        }
        return sb.toString();
    }

    public String getSessionAttribute(String sessionId, String key) {
        Session s = (Session)this.sessions.get(sessionId);
        if (s == null) {
            this.log("Session not found " + sessionId);
            return null;
        }
        Object o = s.getSession().getAttribute(key);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public void expireSession(String sessionId) {
        Session s = (Session)this.sessions.get(sessionId);
        if (s == null) {
            this.log("Session not found " + sessionId);
            return;
        }
        s.expire();
    }

    public String getLastAccessedTime(String sessionId) {
        Session s = (Session)this.sessions.get(sessionId);
        if (s == null) {
            this.log("Session not found " + sessionId);
            return "";
        }
        return new Date(s.getLastAccessedTime()).toString();
    }
}

