/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.moment.intergenomics.cpntools.projector;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import es.upv.dsic.issi.moment.intergenomics.cpn.Annot;
import es.upv.dsic.issi.moment.intergenomics.cpn.Arc;
import es.upv.dsic.issi.moment.intergenomics.cpn.Block;
import es.upv.dsic.issi.moment.intergenomics.cpn.ColorSet;
import es.upv.dsic.issi.moment.intergenomics.cpn.ColorSetElement;
import es.upv.dsic.issi.moment.intergenomics.cpn.Cpnet;
import es.upv.dsic.issi.moment.intergenomics.cpn.Declaration;
import es.upv.dsic.issi.moment.intergenomics.cpn.DiagramElement;
import es.upv.dsic.issi.moment.intergenomics.cpn.Enumerated;
import es.upv.dsic.issi.moment.intergenomics.cpn.Globbox;
import es.upv.dsic.issi.moment.intergenomics.cpn.Initmark;
import es.upv.dsic.issi.moment.intergenomics.cpn.Mark;
import es.upv.dsic.issi.moment.intergenomics.cpn.Page;
import es.upv.dsic.issi.moment.intergenomics.cpn.Place;
import es.upv.dsic.issi.moment.intergenomics.cpn.Product;
import es.upv.dsic.issi.moment.intergenomics.cpn.SimpleColorSet;
import es.upv.dsic.issi.moment.intergenomics.cpn.Trans;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CpnToolsProjector {
    private static final String TOOL_NAME = "CPN Tools";
    private static final String TOOL_VERSION = "2.0.0";
    private static final Float TOKEN_POS_Y = new Float(0.0f);
    private static final Float TOKEN_POS_X = new Float(-10.0f);
    private static final Float MARKING_POS_X = new Float(0.0f);
    private static final Float MARKING_POS_Y = new Float(0.0f);
    private static final Float ELLIPSE_WIDTH = new Float(60.0f);
    private static final Float ELLIPSE_HEIGHT = new Float(40.0f);
    private static final Float BOX_WIDTH = new Float(60.0f);
    private static final Float BOX_HEIGHT = new Float(40.0f);
    private static final Float BINDING_POS_X = new Float(7.2);
    private static final Float BINDING_POS_Y = new Float(-3.0f);
    private Float BINDER_POS_X = new Float(150.0f);
    private Float BINDER_POS_Y = new Float(100.0f);
    private Float BINDER_WIDTH = new Float(700.0f);
    private Float BINDER_HEIGHT = new Float(500.0f);
    MessageConsole console = new MessageConsole("XML Projector", null);
    MessageConsoleStream consoleStream = this.console.newMessageStream();

    public CpnToolsProjector() {
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.console});
    }

    public void saveCpnetForCpnTools(Cpnet cpnet, IFile file, boolean reLayout, IProgressMonitor monitor) throws ParserConfigurationException, IOException, CoreException {
        this.BINDER_POS_X = new Float(cpnet.getPage().getPosx());
        this.BINDER_POS_Y = new Float(cpnet.getPage().getPosy());
        this.BINDER_WIDTH = new Float(cpnet.getPage().getWidth());
        this.BINDER_HEIGHT = new Float(cpnet.getPage().getHeight());
        if (reLayout) {
            cpnet.getPage().performLayout(Integer.valueOf(new Float((double)this.BINDER_WIDTH.floatValue() * 0.9).intValue()), Integer.valueOf(new Float((double)this.BINDER_HEIGHT.floatValue() * 0.9).intValue()), Integer.valueOf(5000));
        }
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element root = document.createElement("workspaceElements");
        document.appendChild(root);
        Element generatorNode = document.createElement("generator");
        generatorNode.setAttribute("tool", TOOL_NAME);
        generatorNode.setAttribute("version", TOOL_VERSION);
        generatorNode.setAttribute("format", "5");
        root.appendChild(generatorNode);
        root.appendChild(this.createCpnet(document, cpnet));
        OutputFormat format = new OutputFormat(document);
        format.setEncoding("iso-8859-1");
        format.setDoctype("-//CPN//DTD CPNXML 1.0//EN", "http://www.daimi.au.dk/~cpntools/bin/DTD/5/cpn.dtd");
        format.setIndenting(true);
        format.setIndent(2);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        XMLSerializer serializer = new XMLSerializer(outputStream, format);
        serializer.serialize(document);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        if (file.exists()) {
            file.setContents((InputStream)inputStream, 2, monitor);
        } else {
            file.create((InputStream)inputStream, 2, monitor);
        }
    }

    private Node createCpnet(Document document, Cpnet cpnet) {
        Element element = document.createElement("cpnet");
        element.appendChild(this.createGlobbox(document, cpnet.getGlobbox()));
        element.appendChild(this.createPage(document, cpnet.getPage()));
        Object obj = new Object();
        element.appendChild(this.createInstances(document, cpnet.getPage(), this.getModelElementId(obj)));
        element.appendChild(this.createBinders(document, this.getModelElementId(obj)));
        return element;
    }

    private Node createBinders(Document document, String instanceId) {
        Element element = document.createElement("binders");
        Element cpnbinder = document.createElement("cpnbinder");
        cpnbinder.setAttribute("id", this.getModelElementId(cpnbinder));
        cpnbinder.setAttribute("x", this.BINDER_POS_X.toString());
        cpnbinder.setAttribute("y", this.BINDER_POS_Y.toString());
        cpnbinder.setAttribute("width", this.BINDER_WIDTH.toString());
        cpnbinder.setAttribute("height", this.BINDER_HEIGHT.toString());
        Element sheets = document.createElement("sheets");
        cpnbinder.appendChild(sheets);
        Element cpnsheet = document.createElement("cpnsheet");
        cpnsheet.setAttribute("id", this.getModelElementId(cpnsheet));
        cpnsheet.setAttribute("instance", instanceId);
        cpnsheet.setAttribute("zoom", "1.0");
        sheets.appendChild(cpnsheet);
        element.appendChild(cpnbinder);
        return element;
    }

    private Node createInstances(Document document, Page page, String instanceId) {
        Element element = document.createElement("instances");
        Element instance = document.createElement("instance");
        instance.setAttribute("id", instanceId);
        instance.setAttribute("page", this.getModelElementId(page));
        element.appendChild(instance);
        return element;
    }

    private Node createPage(Document document, Page page) {
        Element element = document.createElement("page");
        element.setAttribute("id", this.getModelElementId(page));
        Element pageattr = document.createElement("pageattr");
        pageattr.setAttribute("name", page.getName());
        element.appendChild(pageattr);
        for (Place place : page.getPlaces()) {
            element.appendChild(this.createPlace(document, place));
        }
        for (Trans transition : page.getTranss()) {
            element.appendChild(this.createTransition(document, transition));
        }
        for (Arc arc : page.getArcs()) {
            element.appendChild(this.createArc(document, arc));
        }
        return element;
    }

    private Node createArc(Document document, Arc arc) {
        Element element = document.createElement("arc");
        element.setAttribute("id", this.getModelElementId(arc));
        element.setAttribute("orientation", arc.getOrientation());
        element.setAttribute("order", String.valueOf(arc.getOrder()));
        this.fillElementAttributesFromDiagramElement(document, element, (DiagramElement)arc);
        Element arrowattr = document.createElement("arrowattr");
        arrowattr.setAttribute("headsize", String.valueOf(arc.getHeadsize()));
        arrowattr.setAttribute("currentcyckle", arc.getCurrentcyckle());
        element.appendChild(arrowattr);
        Element transend = document.createElement("transend");
        transend.setAttribute("idref", this.getModelElementId(arc.getTrans()));
        element.appendChild(transend);
        Element placeend = document.createElement("placeend");
        placeend.setAttribute("idref", this.getModelElementId(arc.getPlace()));
        element.appendChild(placeend);
        element.appendChild(this.createAnnot(document, arc.getAnnot()));
        return element;
    }

    private Node createAnnot(Document document, Annot annot) {
        Element element = document.createElement("annot");
        element.setAttribute("id", this.getModelElementId(element));
        this.fillElementAttributesFromDiagramElement(document, element, (DiagramElement)annot);
        Element text = (Element)this.createText(document, annot.getText());
        text.setAttribute("tool", TOOL_NAME);
        text.setAttribute("version", TOOL_VERSION);
        element.appendChild(text);
        return element;
    }

    private Node createTransition(Document document, Trans transition) {
        Element element = document.createElement("trans");
        element.setAttribute("id", this.getModelElementId(transition));
        element.setAttribute("explicit", "false");
        this.fillElementAttributesFromDiagramElement(document, element, (DiagramElement)transition);
        element.appendChild(this.createText(document, transition.getText().replaceAll(" ", "\n")));
        element.appendChild(this.createBox(document, BOX_WIDTH, BOX_HEIGHT));
        Element binding = document.createElement("binding");
        binding.setAttribute("x", BINDING_POS_X.toString());
        binding.setAttribute("y", BINDING_POS_Y.toString());
        element.appendChild(binding);
        return element;
    }

    private Node createPlace(Document document, Place place) {
        Element element = document.createElement("place");
        element.setAttribute("id", this.getModelElementId(place));
        this.fillElementAttributesFromDiagramElement(document, element, (DiagramElement)place);
        element.appendChild(this.createText(document, place.getText()));
        element.appendChild(this.createEllipse(document, ELLIPSE_WIDTH, ELLIPSE_HEIGHT));
        Element token = document.createElement("token");
        token.setAttribute("x", TOKEN_POS_X.toString());
        token.setAttribute("y", TOKEN_POS_Y.toString());
        element.appendChild(token);
        Element marking = document.createElement("marking");
        marking.setAttribute("x", MARKING_POS_X.toString());
        marking.setAttribute("y", MARKING_POS_Y.toString());
        element.appendChild(marking);
        element.appendChild(this.createPlaceType(document, place));
        if (place.getInitmark() != null) {
            place.getInitmark().setPosx(place.getPosx() + ELLIPSE_WIDTH.intValue());
            place.getInitmark().setPosy(place.getPosy() + ELLIPSE_HEIGHT.intValue());
            element.appendChild(this.createInitmark(document, place.getInitmark()));
        }
        return element;
    }

    private Node createInitmark(Document document, Initmark initmark) {
        Element element = document.createElement("initmark");
        element.setAttribute("id", this.getModelElementId(initmark));
        this.fillElementAttributesFromDiagramElement(document, element, (DiagramElement)initmark);
        String initMarkText = "";
        for (Mark mark : initmark.getMarks()) {
            initMarkText = initMarkText.concat(String.valueOf(mark.getValue()) + "`" + mark.getColorSetElement().getName() + "++\n");
        }
        initMarkText = initMarkText.substring(0, initMarkText.length() - 3);
        Element text = (Element)this.createText(document, initMarkText);
        text.setAttribute("tool", TOOL_NAME);
        text.setAttribute("version", TOOL_VERSION);
        element.appendChild(text);
        return element;
    }

    private Node createPlaceType(Document document, Place place) {
        Element element = document.createElement("type");
        element.setAttribute("id", this.getModelElementId(element));
        this.fillElementAttributesFromDiagramElement(document, element, (DiagramElement)place);
        ((Element)element.getElementsByTagName("posattr").item(0)).setAttribute("x", Float.toString(place.getPosx() + place.getWidth() / 2));
        ((Element)element.getElementsByTagName("posattr").item(0)).setAttribute("y", Float.toString(place.getPosy() - place.getHight() / 2));
        Element text = (Element)this.createText(document, place.getType().getIdname());
        text.setAttribute("tool", TOOL_NAME);
        text.setAttribute("version", TOOL_VERSION);
        element.appendChild(text);
        return element;
    }

    private Node createEllipse(Document document, Float width, Float height) {
        Element element = document.createElement("ellipse");
        element.setAttribute("w", width.toString());
        element.setAttribute("h", height.toString());
        return element;
    }

    private Node createBox(Document document, Float width, Float height) {
        Element element = document.createElement("box");
        element.setAttribute("w", width.toString());
        element.setAttribute("h", height.toString());
        return element;
    }

    private Node createText(Document document, String text) {
        Element element = document.createElement("text");
        element.setTextContent(text);
        return element;
    }

    private Node fillElementAttributesFromDiagramElement(Document document, Element element, DiagramElement diagramElement) {
        Element posattr = document.createElement("posattr");
        posattr.setAttribute("x", String.format(null, "%.6f", new Float(diagramElement.getPosx())));
        posattr.setAttribute("y", String.format(null, "%.6f", new Float(diagramElement.getPosy())));
        Element fillattr = document.createElement("fillattr");
        fillattr.setAttribute("colour", diagramElement.getFillColour());
        fillattr.setAttribute("pattern", diagramElement.getFillPattern());
        fillattr.setAttribute("filled", String.valueOf(diagramElement.isFillFilled()));
        Element lineattr = document.createElement("lineattr");
        lineattr.setAttribute("colour", diagramElement.getLineColour());
        lineattr.setAttribute("thick", String.valueOf(diagramElement.getLineThick()));
        lineattr.setAttribute("type", diagramElement.getLineType());
        Element textattr = document.createElement("textattr");
        textattr.setAttribute("colour", diagramElement.getLineColour());
        textattr.setAttribute("bold", "false");
        element.appendChild(posattr);
        element.appendChild(fillattr);
        element.appendChild(lineattr);
        element.appendChild(textattr);
        return element;
    }

    private Node createGlobbox(Document document, Globbox globbox) {
        Element element = document.createElement("globbox");
        for (Declaration declaration : globbox.getDeclarations()) {
            if (!(declaration instanceof Block)) continue;
            Block block = (Block)declaration;
            element.appendChild(this.createBlock(document, block));
        }
        return element;
    }

    private Node createBlock(Document document, Block block) {
        Element element = document.createElement("block");
        element.setAttribute("id", this.getModelElementId(block));
        element.appendChild(this.createElementId(document, block.getIdname()));
        for (Declaration declaration : block.getDeclarations()) {
            if (!(declaration instanceof ColorSet)) continue;
            ColorSet colorSet = (ColorSet)declaration;
            element.appendChild(this.createColorSet(document, colorSet));
        }
        return element;
    }

    private Node createColorSet(Document document, ColorSet colorSet) {
        Element element = document.createElement("color");
        element.setAttribute("id", this.getModelElementId(colorSet));
        element.appendChild(this.createElementId(document, colorSet.getIdname()));
        if (colorSet instanceof Enumerated) {
            element.appendChild(this.createEnumerated(document, (Enumerated)colorSet));
            element.appendChild(this.createLayoutForEnumeratedColorset(document, (Enumerated)colorSet));
        } else if (colorSet instanceof Product) {
            element.appendChild(this.createProduct(document, (Product)colorSet));
            element.appendChild(this.createLayoutForProductColorset(document, (Product)colorSet));
        }
        return element;
    }

    private Node createLayoutForEnumeratedColorset(Document document, Enumerated enumerated) {
        Element element = document.createElement("layout");
        String text = "colset " + enumerated.getIdname() + " = with ";
        for (ColorSetElement colorSetElement : enumerated.getColorElements()) {
            text = text.concat(colorSetElement.getName()).concat(" | ");
        }
        text = text.substring(0, text.length() - 3).concat(";");
        element.setTextContent(text);
        return element;
    }

    private Node createLayoutForProductColorset(Document document, Product product) {
        Element element = document.createElement("layout");
        String text = "colset " + product.getIdname() + " = product ";
        for (SimpleColorSet simpleColorSet : product.getSimpleColors()) {
            text = text.concat(simpleColorSet.getIdname()).concat("*");
        }
        text = text.substring(0, text.length() - 1).concat(";");
        element.setTextContent(text);
        return element;
    }

    private Node createEnumerated(Document document, Enumerated enumerated) {
        Element element = document.createElement("enum");
        for (ColorSetElement colorSetElement : enumerated.getColorElements()) {
            element.appendChild(this.createElementId(document, colorSetElement.getName()));
        }
        return element;
    }

    private Node createProduct(Document document, Product product) {
        Element element = document.createElement("product");
        for (SimpleColorSet simpleColorSet : product.getSimpleColors()) {
            element.appendChild(this.createElementId(document, simpleColorSet.getIdname()));
        }
        return element;
    }

    private Node createElementId(Document document, String id) {
        Element element = document.createElement("id");
        element.setTextContent(id);
        return element;
    }

    private String getModelElementId(Object object) {
        return "ID" + object.hashCode();
    }
}

