/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.validation.internal.EMFModelValidationDebugOptions;
import org.eclipse.emf.validation.internal.EMFModelValidationStatusCodes;
import org.eclipse.emf.validation.internal.util.Log;
import org.eclipse.emf.validation.internal.util.Trace;
import org.eclipse.emf.validation.internal.util.XmlConstraintDescriptor;
import org.eclipse.emf.validation.service.ConstraintChangeEvent;
import org.eclipse.emf.validation.service.ConstraintChangeEventType;
import org.eclipse.emf.validation.service.ConstraintExistsException;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.IConstraintListener;

public class ConstraintRegistry {
    private static final ConstraintRegistry INSTANCE;
    private final Map descriptors = new HashMap();
    private volatile IConstraintListener[] constraintListeners;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.validation.service.ConstraintRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        INSTANCE = new ConstraintRegistry();
    }

    private ConstraintRegistry() {
    }

    public static ConstraintRegistry getInstance() {
        return INSTANCE;
    }

    public IConstraintDescriptor getDescriptor(String id) {
        return (IConstraintDescriptor)this.descriptors.get(id);
    }

    public IConstraintDescriptor getDescriptor(String pluginId, String id) {
        return (IConstraintDescriptor)this.descriptors.get(XmlConstraintDescriptor.normalizedId(pluginId, id));
    }

    public Collection getAllDescriptors() {
        return this.descriptors.values();
    }

    public void register(IConstraintDescriptor descriptor) throws ConstraintExistsException {
        if (!$assertionsDisabled && descriptor == null) {
            throw new AssertionError();
        }
        if (this.descriptors.containsKey(descriptor.getId())) {
            throw new ConstraintExistsException(descriptor.getId());
        }
        this.descriptors.put(descriptor.getId(), descriptor);
        this.broadcastConstraintChangeEvent(new ConstraintChangeEvent(descriptor, ConstraintChangeEventType.REGISTERED));
    }

    public void unregister(IConstraintDescriptor descriptor) {
        if (!$assertionsDisabled && descriptor == null) {
            throw new AssertionError();
        }
        this.descriptors.remove(descriptor.getId());
        this.broadcastConstraintChangeEvent(new ConstraintChangeEvent(descriptor, ConstraintChangeEventType.UNREGISTERED));
    }

    public synchronized void addConstraintListener(IConstraintListener listener) {
        if (this.indexOf(listener) < 0) {
            if (this.constraintListeners == null) {
                this.constraintListeners = new IConstraintListener[]{listener};
            } else {
                IConstraintListener[] newListeners = new IConstraintListener[this.constraintListeners.length + 1];
                System.arraycopy(this.constraintListeners, 0, newListeners, 0, this.constraintListeners.length);
                newListeners[this.constraintListeners.length] = listener;
                this.constraintListeners = newListeners;
            }
            if (Trace.shouldTrace(EMFModelValidationDebugOptions.LISTENERS)) {
                Trace.trace(EMFModelValidationDebugOptions.LISTENERS, "Registered constraint listener: " + listener.getClass().getName());
            }
        }
    }

    public synchronized void removeConstraintListener(IConstraintListener listener) {
        int index = this.indexOf(listener);
        if (index >= 0) {
            IConstraintListener[] newListeners = new IConstraintListener[this.constraintListeners.length - 1];
            System.arraycopy(this.constraintListeners, 0, newListeners, 0, index);
            System.arraycopy(this.constraintListeners, index + 1, newListeners, index, this.constraintListeners.length - index - 1);
            this.constraintListeners = newListeners;
            if (Trace.shouldTrace(EMFModelValidationDebugOptions.LISTENERS)) {
                Trace.trace(EMFModelValidationDebugOptions.LISTENERS, "Deregistered constraint listener: " + listener.getClass().getName());
            }
        }
    }

    private int indexOf(IConstraintListener listener) {
        int result = -1;
        if (this.constraintListeners != null) {
            int i = 0;
            while (i < this.constraintListeners.length) {
                if (this.constraintListeners[i] == listener) {
                    result = i;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public void broadcastConstraintChangeEvent(ConstraintChangeEvent event) {
        if (this.constraintListeners == null) {
            return;
        }
        IConstraintListener[] array = this.constraintListeners;
        int i = 0;
        while (i < array.length) {
            try {
                array[i].constraintChanged(event);
            }
            catch (Exception e) {
                Trace.catching(this.getClass(), "broadcastConstraintChangeEvent", e);
                if (Trace.shouldTrace(EMFModelValidationDebugOptions.LISTENERS)) {
                    Trace.trace(EMFModelValidationDebugOptions.LISTENERS, "Uncaught exception in constraint listener: " + array[i].getClass().getName());
                }
                Log.l7dWarning(130, EMFModelValidationStatusCodes.LISTENER_UNCAUGHT_EXCEPTION_MSG, e);
            }
            ++i;
        }
    }
}

