/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.snippeteditor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaJRETab;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.VMArgumentsBlock;
import org.eclipse.jdt.internal.debug.ui.launcher.WorkingDirectoryBlock;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.ScrapbookLauncher;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.SnippetMessages;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;

public class SnippetEditorPropertyPage
extends PropertyPage {
    private WorkingDirectoryBlock fWorkingDirBlock = new WorkingDirectoryBlock();
    private JavaJRETab fJRETab = new JavaJRETab();
    private VMArgumentsBlock fVMArgumentsBlock = new VMArgumentsBlock();
    private ILaunchConfiguration fConfig;
    private ILaunchConfigurationWorkingCopy fWorkingCopy;
    private Proxy fProxy;

    protected Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 1;
        comp.setLayout((Layout)topLayout);
        comp.setFont(parent.getFont());
        this.fProxy = new Proxy();
        try {
            this.fConfig = ScrapbookLauncher.getLaunchConfigurationTemplate(this.getFile());
            if (this.fConfig != null) {
                this.fWorkingCopy = this.fConfig.getWorkingCopy();
            }
        }
        catch (CoreException e) {
            this.fConfig = null;
            this.fWorkingCopy = null;
            JDIDebugUIPlugin.statusDialog(SnippetMessages.getString("ScrapbookLauncher.Unable_to_retrieve_settings"), e.getStatus());
        }
        if (this.fConfig == null) {
            try {
                this.fConfig = ScrapbookLauncher.createLaunchConfigurationTemplate(this.getFile());
                this.fWorkingCopy = this.fConfig.getWorkingCopy();
            }
            catch (CoreException e) {
                JDIDebugUIPlugin.statusDialog(SnippetMessages.getString("ScrapbookLauncher.Unable_to_retrieve_settings"), e.getStatus());
            }
        }
        this.fWorkingDirBlock.setLaunchConfigurationDialog(this.fProxy);
        this.fWorkingDirBlock.createControl(comp);
        this.fWorkingDirBlock.initializeFrom(this.fConfig);
        this.fVMArgumentsBlock.setLaunchConfigurationDialog(this.fProxy);
        this.fVMArgumentsBlock.createControl(comp);
        this.fVMArgumentsBlock.initializeFrom(this.fConfig);
        this.fJRETab.setLaunchConfigurationDialog(this.fProxy);
        this.fJRETab.setVMSpecificArgumentsVisible(false);
        this.fJRETab.createControl(comp);
        this.fJRETab.initializeFrom(this.fConfig);
        return comp;
    }

    protected IFile getFile() {
        return (IFile)this.getElement();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.fWorkingDirBlock.setDefaults(this.fWorkingCopy);
        this.fJRETab.setDefaults(this.fWorkingCopy);
        this.fVMArgumentsBlock.setDefaults(this.fWorkingCopy);
        this.fWorkingDirBlock.initializeFrom((ILaunchConfiguration)this.fWorkingCopy);
        this.fJRETab.initializeFrom((ILaunchConfiguration)this.fWorkingCopy);
        this.fVMArgumentsBlock.initializeFrom((ILaunchConfiguration)this.fWorkingCopy);
    }

    public boolean isValid() {
        return this.fWorkingDirBlock.isValid(this.fConfig);
    }

    public String getErrorMessage() {
        String message = this.fWorkingDirBlock.getErrorMessage();
        if (message == null) {
            return this.fJRETab.getErrorMessage();
        }
        return message;
    }

    public String getMessage() {
        String message = this.fWorkingDirBlock.getMessage();
        if (message == null) {
            return this.fJRETab.getMessage();
        }
        return message;
    }

    public boolean performOk() {
        this.fWorkingDirBlock.performApply(this.fWorkingCopy);
        this.fJRETab.performApply(this.fWorkingCopy);
        this.fVMArgumentsBlock.performApply(this.fWorkingCopy);
        try {
            if (!this.fWorkingCopy.contentsEqual(this.fConfig)) {
                this.fConfig = this.fWorkingCopy.doSave();
                this.fWorkingCopy = this.fConfig.getWorkingCopy();
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.statusDialog(e.getStatus());
        }
        return super.performOk();
    }

    class Proxy
    implements ILaunchConfigurationDialog {
        Proxy() {
        }

        public String generateName(String name) {
            return null;
        }

        public String getMode() {
            return "debug";
        }

        public ILaunchConfigurationTab[] getTabs() {
            return new ILaunchConfigurationTab[]{SnippetEditorPropertyPage.this.fWorkingDirBlock};
        }

        public ILaunchConfigurationTab getActiveTab() {
            return SnippetEditorPropertyPage.this.fWorkingDirBlock;
        }

        public void setName(String name) {
        }

        public void updateButtons() {
        }

        public void updateMessage() {
            SnippetEditorPropertyPage.this.setValid(SnippetEditorPropertyPage.this.isValid());
            SnippetEditorPropertyPage.this.setMessage(SnippetEditorPropertyPage.this.getMessage());
            SnippetEditorPropertyPage.this.setErrorMessage(SnippetEditorPropertyPage.this.getErrorMessage());
        }

        public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) {
        }

        public void setActiveTab(ILaunchConfigurationTab tab) {
        }

        public void setActiveTab(int index) {
        }
    }
}

